/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.choice.list_builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.jsdl.action.ActionBuilder;
import com.jgoodies.common.jsdl.list.FilteredListViewModel;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.dialogs.core.CoreDialogResources;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;

public abstract class AbstractListBuilderModel<E>
extends Bean {
    private final FilteredListViewModel<E> builtListModel = new BuiltListModel();
    private final Action addAction;
    private final Action addAllAction;
    private final Action removeAction;
    private final Action removeAllAction;
    private final Action moveDownAction;
    private final Action moveUpAction;
    private Predicate<E> addOperationFilter;

    public AbstractListBuilderModel() {
        this.setBuiltListSelectionMode(2);
        this.addOperationFilter = new RejectDuplicatesFilter<E>(this);
        this.addAction = AbstractListBuilderModel.buildAction(this::onAddPerformed, "common.add.list_builder");
        this.addAllAction = AbstractListBuilderModel.buildAction(this::onAddAllPerformed, "common.add_all.list_builder");
        this.removeAction = AbstractListBuilderModel.buildAction(this::onRemovePerformed, "common.remove.list_builder");
        this.removeAllAction = AbstractListBuilderModel.buildAction(this::onRemoveAllPerformed, "common.remove_all.list_builder");
        this.moveUpAction = AbstractListBuilderModel.buildAction(this::onMoveUpPerformed, "common.move_up");
        this.moveDownAction = AbstractListBuilderModel.buildAction(this::onMoveDownPerformed, "common.move_down");
    }

    public final List<E> getBuiltListItems() {
        return this.builtListModel.getItems();
    }

    public final void setBuiltListItems(E ... builtListItems) {
        this.setBuiltListItems(builtListItems == null ? Collections.EMPTY_LIST : Arrays.asList(builtListItems));
    }

    public final void setBuiltListItems(List<E> builtListItems) {
        Preconditions.checkNotNull(builtListItems, "The %s must not be null.", "built list items");
        this.builtListModel.setItems(builtListItems);
    }

    public final List<E> getSelectedBuiltListItems() {
        return this.builtListModel.getSelectedItems();
    }

    public final void setBuiltListSelectionMode(int selectionMode) {
        this.builtListModel.setSelectionMode(selectionMode);
    }

    public final void setBuiltListFilter(Predicate<E> listFilter) {
        this.builtListModel.setFilter(listFilter);
    }

    public final void filterBuiltList() {
        this.builtListModel.filter();
    }

    public final ListModel<E> getBuiltListDataModel() {
        return this.builtListModel.getDataModel();
    }

    public final ListSelectionModel getBuiltListSelectionModel() {
        return this.builtListModel.getSelectionModel();
    }

    public final Predicate<E> getAddOperationFilter() {
        return this.addOperationFilter;
    }

    public final void setAddOperationFilter(Predicate<E> predicate) {
        this.addOperationFilter = Preconditions.checkNotNull(predicate, "The %s must not be null.", "add operation filter");
    }

    public final Action getAddAction() {
        return this.addAction;
    }

    public final Action getAddAllAction() {
        return this.addAllAction;
    }

    public final Action getRemoveAction() {
        return this.removeAction;
    }

    public final Action getRemoveAllAction() {
        return this.removeAllAction;
    }

    public final Action getMoveUpAction() {
        return this.moveUpAction;
    }

    public final Action getMoveDownAction() {
        return this.moveDownAction;
    }

    public final void onOptionsMouseDoubleClicked(MouseEvent evt) {
        if (this.getOptionsHasSelection()) {
            this.addSelectedOptionsToBuiltList();
        }
    }

    protected final void onBuiltListListDataChanged(ListDataEvent evt) {
        this.removeAllAction.setEnabled(!this.builtListModel.filteredIsEmpty());
    }

    protected void onBuiltListListSelectionChanged(ListSelectionEvent evt) {
        this.removeAction.setEnabled(this.builtListModel.hasSelection());
        this.moveDownAction.setEnabled(this.builtListModel.isSingleSelection() && !this.builtListModel.isSelectedLast());
        this.moveUpAction.setEnabled(this.builtListModel.isSingleSelection() && !this.builtListModel.isSelectedFirst());
    }

    protected final void onBuiltListMouseDoubleClicked(MouseEvent evt) {
        if (this.builtListModel.hasSelection()) {
            this.removeSelectionFromBuiltList();
        }
    }

    private void onAddPerformed(ActionEvent evt) {
        this.addSelectedOptionsToBuiltList();
    }

    private void onRemovePerformed(ActionEvent evt) {
        this.removeSelectionFromBuiltList();
    }

    private void onAddAllPerformed(ActionEvent evt) {
        this.builtListModel.setItems(this.getAllOptions());
    }

    private void onRemoveAllPerformed(ActionEvent evt) {
        this.removeAllFromBuiltList();
    }

    private void onMoveDownPerformed(ActionEvent evt) {
        this.builtListModel.moveSelectedItemDown();
    }

    private void onMoveUpPerformed(ActionEvent evt) {
        this.builtListModel.moveSelectedItemUp();
    }

    protected void handleOptionsDataChanged() {
        this.addAllAction.setEnabled(this.getOptionsNotEmpty());
    }

    protected void handleOptionsSelectionChange() {
        this.addAction.setEnabled(this.getOptionsHasSelection());
    }

    protected final void addSelectedOptionsToBuiltList() {
        this.addOptionsToBuiltList(this.getSelectedOptions());
    }

    protected final void addAllOptionsToBuiltList() {
        this.addOptionsToBuiltList(this.getAllOptions());
    }

    protected void addOptionsToBuiltList(List<E> options) {
        List<E> filteredOptions = this.filterOptionsForAdd(options);
        if (filteredOptions.isEmpty()) {
            return;
        }
        if (this.builtListModel.isSingleSelection()) {
            this.builtListModel.addAll(this.builtListModel.getSelectedIndex(), filteredOptions);
        } else {
            this.builtListModel.addAll(filteredOptions);
        }
        this.builtListModel.setSelectedItems(filteredOptions);
    }

    protected void removeSelectionFromBuiltList() {
        List selectedElements = this.builtListModel.getSelectedItems();
        List<Integer> selectedIndices = this.builtListModel.getSelectedIndices();
        int builtListMinSelectionIndex = this.builtListModel.getMinSelectionIndex();
        for (int i = selectedIndices.size() - 1; i >= 0; --i) {
            int index = selectedIndices.get(i);
            this.builtListModel.remove(index);
        }
        if (builtListMinSelectionIndex < this.builtListModel.size()) {
            this.builtListModel.setSelectedIndex(builtListMinSelectionIndex);
        }
        this.selectOptions(selectedElements);
    }

    protected void removeAllFromBuiltList() {
        List selectedElements = this.builtListModel.getSelectedItems();
        this.builtListModel.clear();
        this.selectOptions(selectedElements);
    }

    protected abstract boolean getOptionsHasSelection();

    protected abstract boolean getOptionsNotEmpty();

    public abstract List<E> getAllOptions();

    public abstract List<E> getSelectedOptions();

    protected abstract void selectOptions(List<E> var1);

    private List<E> filterOptionsForAdd(List<E> optionsToAdd) {
        return optionsToAdd.stream().filter(this.addOperationFilter).collect(Collectors.toList());
    }

    private static Action buildAction(Consumer<ActionEvent> handler, String resourceKey) {
        return new ActionBuilder().handler(handler).text(CoreDialogResources.getString(resourceKey), new Object[0]).disabled().build();
    }

    public static final class AcceptDuplicatesFilter<T>
    implements Predicate<T> {
        @Override
        public boolean test(T t) {
            return true;
        }
    }

    private final class BuiltListModel
    extends FilteredListViewModel<E> {
        private BuiltListModel() {
            this.getDataModel().addListDataListener(Listeners.listData(AbstractListBuilderModel.this::onBuiltListListDataChanged));
        }

        @Override
        protected void onListSelectionChanged(ListSelectionEvent evt) {
            AbstractListBuilderModel.this.onBuiltListListSelectionChanged(evt);
        }
    }

    public static final class RejectDuplicatesFilter<T>
    implements Predicate<T> {
        private final AbstractListBuilderModel<T> model;

        public RejectDuplicatesFilter(AbstractListBuilderModel<T> model) {
            this.model = model;
        }

        @Override
        public boolean test(T element) {
            return !((AbstractListBuilderModel)this.model).builtListModel.contains(element);
        }
    }
}

