/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.internal;

import com.jgoodies.common.jsdl.JSDLCommonSetup;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.common.swing.focus.FocusTraversalUtils;
import com.jgoodies.components.JGButton;
import com.jgoodies.components.JGMenuButton;
import com.jgoodies.components.util.ComponentUtils;
import com.jgoodies.fluent.Theme;
import com.jgoodies.fluent.internal.FluentResources;
import com.jgoodies.fluent.internal.IFluentResources;
import com.jgoodies.layout.factories.Paddings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicBorders;

public class FluentButtonFactory {
    protected static final Paddings.Padding DEFAULT_BUTTON_PADDING = Paddings.createPadding("0, 6epx, 0, 6epx", new Object[0]);
    protected static final int ICON_TEXT_GAP_TOP = ScreenScaling.toPhysical(8);
    protected final IFluentResources fluentResources = FluentResources.getInstance();
    private Theme theme;
    private static final int EPX0 = ScreenScaling.physicalInteger(0);

    public FluentButtonFactory(Theme theme) {
        this.theme = theme != null ? theme : this.fluentResources.getTheme();
    }

    public final Theme getTheme() {
        return this.theme;
    }

    public final void setTheme(Theme theme) {
        this.theme = theme;
    }

    public JButton createButton(Action action) {
        NavigationButton button = new NavigationButton(action, this.getTheme());
        this.configureButton(button);
        ComponentUtils.registerKeyboardAction((JComponent)button, action, 2);
        return button;
    }

    public JButton createButton(Icon icon) {
        NavigationButton button = new NavigationButton(icon, this.getTheme());
        this.configureButton(button);
        return button;
    }

    public JButton createButton(String text) {
        NavigationButton button = new NavigationButton(text, this.getTheme());
        MnemonicUtils.configure(button, text);
        this.configureButton(button);
        return button;
    }

    public JButton createButton(String text, Icon icon) {
        NavigationButton button = new NavigationButton(text, icon, this.getTheme());
        MnemonicUtils.configure(button, text);
        this.configureButton(button);
        return button;
    }

    protected NavigationToggleButton createToggleButton(Action action, SelectionMarkerMode mode) {
        NavigationToggleButton button = new NavigationToggleButton(action, this.getTheme(), mode);
        this.configureButton(button);
        ComponentUtils.registerKeyboardAction((JComponent)button, action, 2);
        return button;
    }

    public JButton createMenuButton(JMenu menu) {
        NavigationMenuButton button = new NavigationMenuButton(menu.getAction(), menu.getPopupMenu(), this.getTheme());
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        this.configureButton(button);
        ComponentUtils.registerKeyboardAction((JComponent)button, button.getAction(), 2);
        return button;
    }

    protected void configureButton(AbstractButton button) {
        button.setRolloverEnabled(true);
        button.setFont(this.fluentResources.getAppBarButtonFont());
        button.setIconTextGap(ICON_TEXT_GAP_TOP);
        button.setBorder(new CompoundBorder(new BasicBorders.MarginBorder(), DEFAULT_BUTTON_PADDING));
        button.setFocusPainted(true);
        button.setRequestFocusEnabled(false);
        button.setFocusable(JSDLCommonSetup.isOptimizedForScreenReader());
        FocusTraversalUtils.markAsPoorDefaultFocusOwner(button);
        button.putClientProperty("ControlList.exclude", Boolean.TRUE);
    }

    protected static Color getForegroundFor(Theme theme, ButtonModel m) {
        if (m.isArmed() && m.isPressed()) {
            return theme.pressedForeground();
        }
        if (m.isRollover()) {
            return theme.rolloverForeground();
        }
        if (m.isSelected()) {
            return theme.selectedForeground();
        }
        return theme.foreground();
    }

    public static final class NavigationButton
    extends JGButton {
        private final Theme theme;

        public NavigationButton(Action action, Theme theme) {
            super(action);
            this.theme = theme;
            this.setup();
        }

        public NavigationButton(Icon icon, Theme theme) {
            this(null, icon, theme);
        }

        public NavigationButton(String text, Theme theme) {
            this(text, null, theme);
        }

        public NavigationButton(String text, Icon icon, Theme theme) {
            super(text, icon);
            this.theme = theme;
            this.setup();
        }

        private void setup() {
            this.setContentAreaFilled(false);
            this.setOpaque(false);
            this.setForeground(this.theme.selectedForeground());
        }

        @Override
        protected void paintComponent(Graphics g) {
            ButtonModel m = this.getModel();
            if (m.isArmed() && m.isPressed()) {
                this.fillBackground(g, this.theme.pressed_background);
            } else if (m.isRollover()) {
                this.fillBackground(g, this.theme.rollover_background);
            }
            g.setColor(FluentButtonFactory.getForegroundFor(this.theme, m));
            g.translate(0, -EPX0);
            super.paintComponent(g);
            g.translate(0, EPX0);
        }

        @Override
        public Color getForeground() {
            if (this.theme == null || this.theme.foreground() == null) {
                return super.getForeground();
            }
            ButtonModel m = this.getModel();
            if (!m.isEnabled()) {
                return Color.GRAY;
            }
            return this.theme.selectedForeground() != null ? this.theme.selectedForeground() : super.getForeground();
        }

        private void fillBackground(Graphics g, Color c) {
            if (c == null) {
                return;
            }
            Color oldColor = g.getColor();
            g.setColor(c);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(oldColor);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension minSize = super.getMinimumSize();
            return new Dimension(Math.max(minSize.width, ScreenScaling.toPhysical(48)), minSize.height);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension prefSize = super.getPreferredSize();
            return new Dimension(Math.max(prefSize.width, ScreenScaling.toPhysical(48)), prefSize.height);
        }
    }

    public static final class NavigationMenuButton
    extends JGMenuButton {
        private final Theme theme;

        public NavigationMenuButton(Action action, JPopupMenu popupMenu, Theme theme) {
            super(action, popupMenu);
            this.theme = theme;
            this.setMargin(new Insets(0, 0, 0, ScreenScaling.physicalInteger(6)));
            this.setContentAreaFilled(false);
            this.setOpaque(false);
            this.setForeground(theme.selectedForeground());
        }

        @Override
        protected void paintComponent(Graphics g) {
            ButtonModel m = this.getModel();
            if (m.isArmed() && m.isPressed()) {
                this.fillBackground(g, this.theme.pressed_background);
            } else if (m.isRollover()) {
                this.fillBackground(g, this.theme.rollover_background);
            }
            g.setColor(FluentButtonFactory.getForegroundFor(this.theme, m));
            g.translate(0, -EPX0);
            super.paintComponent(g);
            g.translate(0, EPX0);
        }

        @Override
        public Color getForeground() {
            if (this.theme == null || this.theme.foreground() == null) {
                return super.getForeground();
            }
            ButtonModel m = this.getModel();
            if (!m.isEnabled()) {
                return Color.GRAY;
            }
            return this.theme.selectedForeground() != null ? this.theme.selectedForeground() : super.getForeground();
        }

        private void fillBackground(Graphics g, Color c) {
            if (c == null) {
                return;
            }
            Color oldColor = g.getColor();
            g.setColor(c);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(oldColor);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension minSize = super.getMinimumSize();
            return new Dimension(Math.max(minSize.width, ScreenScaling.toPhysical(48)), minSize.height);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension prefSize = super.getPreferredSize();
            return new Dimension(Math.max(prefSize.width, ScreenScaling.toPhysical(48)), prefSize.height);
        }

        @Override
        protected Icon getPopupIcon() {
            return FluentResources.getInstance().getAppBarMenuIcon();
        }
    }

    public static final class NavigationToggleButton
    extends JToggleButton {
        private final Theme theme;
        private final SelectionMarkerMode selectionMarkerMode;
        private Font deselectedFont;
        private Font selectedFont;

        public NavigationToggleButton(Action action, Theme theme, SelectionMarkerMode selectionMarkerMode) {
            super(action);
            this.theme = theme;
            this.selectionMarkerMode = selectionMarkerMode;
            this.setContentAreaFilled(false);
            this.setOpaque(false);
            this.setForeground(theme.foreground());
        }

        public void setSelectedFont(Font f) {
            this.selectedFont = f;
        }

        public void setDeselectedFont(Font f) {
            this.deselectedFont = f;
        }

        @Override
        protected void paintComponent(Graphics g) {
            ButtonModel m = this.getModel();
            if (m.isArmed() && m.isPressed()) {
                this.fillBackground(g, this.theme.pressed_background);
            } else if (m.isRollover()) {
                this.fillBackground(g, this.theme.rollover_background);
            }
            if (m.isSelected()) {
                if (this.selectionMarkerMode != SelectionMarkerMode.HORIZONTAL) {
                    this.fillBackground(g, this.theme.selected_background);
                }
                this.paintSelection(g);
            }
            g.setColor(FluentButtonFactory.getForegroundFor(this.theme, m));
            this.setFont(this.getActiveFont());
            if (this.selectionMarkerMode == SelectionMarkerMode.HORIZONTAL) {
                g.translate(0, -EPX0);
            }
            super.paintComponent(g);
            if (this.selectionMarkerMode == SelectionMarkerMode.HORIZONTAL) {
                g.translate(0, EPX0);
            }
        }

        protected Font getActiveFont() {
            if (this.selectedFont == null || this.deselectedFont == null) {
                return this.getFont();
            }
            return this.getModel().isSelected() ? this.selectedFont : this.deselectedFont;
        }

        @Override
        public Color getForeground() {
            if (this.theme == null || this.theme.foreground() == null) {
                return super.getForeground();
            }
            ButtonModel m = this.getModel();
            if (!m.isEnabled()) {
                return Color.GRAY;
            }
            return FluentButtonFactory.getForegroundFor(this.theme, m);
        }

        private void fillBackground(Graphics g, Color c) {
            if (c == null) {
                return;
            }
            Color oldColor = g.getColor();
            g.setColor(c);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(oldColor);
        }

        protected void paintSelection(Graphics g) {
            if (this.theme.selected_background == null || this.selectionMarkerMode == SelectionMarkerMode.OFF) {
                return;
            }
            Color oldColor = g.getColor();
            g.setColor(this.theme.accent());
            if (this.selectionMarkerMode == SelectionMarkerMode.VERTICAL) {
                g.fillRect(ScreenScaling.toPhysical(4), ScreenScaling.toPhysical(12), ScreenScaling.toPhysical(3), this.getHeight() - ScreenScaling.toPhysical(24));
            } else {
                g.fillRect(ScreenScaling.toPhysical(11), this.getHeight() - ScreenScaling.toPhysical(8), this.getWidth() - ScreenScaling.toPhysical(20), ScreenScaling.toPhysical(3));
            }
            g.setColor(oldColor);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension selectedFontMinSize;
            Dimension deselectedFontMinSize = selectedFontMinSize = super.getMinimumSize();
            Font oldFont = this.getFont();
            if (this.selectedFont != null) {
                this.setFont(this.selectedFont);
                selectedFontMinSize = super.getMinimumSize();
            }
            if (this.deselectedFont != null) {
                this.setFont(this.deselectedFont);
                deselectedFontMinSize = super.getMinimumSize();
            }
            this.setFont(oldFont);
            int width = Math.max(selectedFontMinSize.width, deselectedFontMinSize.width);
            int height = Math.max(selectedFontMinSize.height, deselectedFontMinSize.height);
            return new Dimension(Math.max(width, ScreenScaling.toPhysical(48)), height);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension selectedFontPrefSize;
            Dimension deselectedFontPrefSize = selectedFontPrefSize = super.getPreferredSize();
            Font oldFont = this.getFont();
            if (this.selectedFont != null) {
                this.setFont(this.selectedFont);
                selectedFontPrefSize = super.getPreferredSize();
            }
            if (this.deselectedFont != null) {
                this.setFont(this.deselectedFont);
                deselectedFontPrefSize = super.getPreferredSize();
            }
            this.setFont(oldFont);
            int width = Math.max(selectedFontPrefSize.width, deselectedFontPrefSize.width);
            int height = Math.max(selectedFontPrefSize.height, deselectedFontPrefSize.height);
            return new Dimension(Math.max(width, ScreenScaling.toPhysical(48)), height);
        }
    }

    public static enum SelectionMarkerMode {
        OFF,
        VERTICAL,
        HORIZONTAL;

    }
}

