/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tiles;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.fluent.tiles.HubSection;
import com.jgoodies.fluent.tiles.Tile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public final class Hub
extends Bean {
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_HEADER = "header";
    public static final String PROPERTY_SECTIONS = "sections";
    private final List<HubSection> sections = new ArrayList<HubSection>();
    private Orientation orientation = Orientation.HORIZONTAL;
    private String header;

    private Hub() {
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation newValue) {
        Preconditions.checkNotNull(newValue, "The %s must not be null.", PROPERTY_ORIENTATION);
        this.orientation = newValue;
        this.firePropertyChange(PROPERTY_ORIENTATION, (Object)this.orientation, (Object)this.orientation);
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String newValue) {
        this.header = newValue;
        this.firePropertyChange(PROPERTY_HEADER, this.header, this.header);
    }

    public List<HubSection> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    public Hub addSection(HubSection section) {
        Preconditions.checkNotNull(section, "The %s must not be null.", "section");
        this.sections.add(section);
        this.firePropertyChange(PROPERTY_SECTIONS, null, this.getSections());
        return this;
    }

    public void addSection(int index, HubSection section) {
        Preconditions.checkNotNull(section, "The %s must not be null.", "section");
        this.sections.add(index, section);
        this.firePropertyChange(PROPERTY_SECTIONS, null, this.getSections());
    }

    public void removeSection(HubSection section) {
        Preconditions.checkNotNull(section, "The %s must not be null.", "section");
        this.sections.remove(section);
        this.firePropertyChange(PROPERTY_SECTIONS, null, this.getSections());
    }

    public void clearSections() {
        this.sections.clear();
        this.firePropertyChange(PROPERTY_SECTIONS, null, this.getSections());
    }

    public void moveSectionUp(int oldIndex) {
        int newIndex = oldIndex - 1;
        HubSection section = this.sections.remove(oldIndex);
        this.addSection(newIndex, section);
    }

    public void moveSectionDown(int oldIndex) {
        int newIndex = oldIndex + 1;
        HubSection section = this.sections.remove(oldIndex);
        this.addSection(newIndex, section);
    }

    public Stream<Tile> tiles() {
        return this.sections.stream().flatMap(HubSection::tiles);
    }

    public static final class Builder {
        private final Hub target = new Hub();

        public Builder orientation(Orientation value) {
            this.target.setOrientation(value);
            return this;
        }

        public Builder horizontal() {
            return this.orientation(Orientation.HORIZONTAL);
        }

        public Builder vertical() {
            return this.orientation(Orientation.VERTICAL);
        }

        public Builder header(String text, Object ... args) {
            this.target.setHeader(String.format(text, args));
            return this;
        }

        public HubSection.Adder<Builder> beginSection() {
            return new HubSection.Adder<Builder>(this::add);
        }

        public Builder add(HubSection section) {
            Preconditions.checkNotNull(section, "The %s must not be null.", "section");
            this.target.addSection(section);
            return this;
        }

        public Builder addAll(HubSection ... sections) {
            Preconditions.checkNotNull(sections, "The %s must not be null.", Hub.PROPERTY_SECTIONS);
            return this.addAll(Arrays.asList(sections));
        }

        public Builder addAll(List<HubSection> sections) {
            Preconditions.checkNotNull(sections, "The %s must not be null.", Hub.PROPERTY_SECTIONS);
            for (HubSection section : sections) {
                this.add(section);
            }
            return this;
        }

        public <E> Builder addEach(Iterable<E> elements, Function<E, HubSection> elementToSection) {
            elements.forEach(element -> this.add((HubSection)elementToSection.apply(element)));
            return this;
        }

        public <E> Builder addEach(Stream<E> stream, Function<E, HubSection> elementToSection) {
            stream.forEach(element -> this.add((HubSection)elementToSection.apply(element)));
            return this;
        }

        public Hub build() {
            return this.target;
        }
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;


        public Orientation reversed() {
            return this == VERTICAL ? HORIZONTAL : VERTICAL;
        }
    }
}

