/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.node;

import com.jgoodies.jdiskreport.domain.DirectorySnapshot;
import com.jgoodies.jdiskreport.domain.FileTreeSnapshot;
import com.jgoodies.jdiskreport.gui.node.DirectoryNode;
import com.jgoodies.jdiskreport.gui.node.FileNode;
import com.jgoodies.jdiskreport.gui.settings.GUISettings;
import java.io.File;

public final class RootNode
extends DirectoryNode {
    public static RootNode empty() {
        RootNode root = new RootNode(new DirectorySnapshot("empty"), 0L, 0L, 0L, new DirectoryNode[0], new FileNode[0]);
        root.computeAndSetStatistics();
        return root;
    }

    private RootNode(DirectorySnapshot root, long size, long directoryCount, long fileCount, DirectoryNode[] childDirectories, FileNode[] childFiles) {
        super(root, size, directoryCount, fileCount, childDirectories, childFiles);
    }

    public static RootNode createFrom(FileTreeSnapshot root) {
        DirectoryNode directoryNode = DirectoryNode.createFrom(root.getDirectorySnapshot());
        return new RootNode(root.getDirectorySnapshot(), directoryNode.getSize(), directoryNode.getDirectoryCount(), directoryNode.getFileCount(), directoryNode.getChildDirectories(), directoryNode.getChildFiles());
    }

    @Override
    public File getFile() {
        return new File(this.getNodeName());
    }

    @Override
    public String getNodeName() {
        return this.getPathName();
    }

    @Override
    public double getAbsoluteSize() {
        return 1.0;
    }

    @Override
    public double getRelativeSize() {
        return 1.0;
    }

    @Override
    public RootNode getRoot() {
        return this;
    }

    public void computeAndSetStatistics() {
        this.computeAndSetStatistics(3);
        this.getStatistics().getTypeDistribution().replaceMapByArrays();
    }

    public DirectoryNode.FileTreeModel getTreeModel(GUISettings.SortMode sortMode) {
        return new DirectoryNode.FileTreeModel(this, sortMode);
    }
}

