/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.internal.BuilderSupport;
import com.jgoodies.layout.FormsSetup;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.ComponentFactory;
import com.jgoodies.layout.factories.Forms;
import com.jgoodies.layout.factories.Paddings;
import com.jgoodies.layout.internal.InternalFocusSetupUtils;
import com.jgoodies.layout.util.FocusTraversalType;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;

public final class ListViewBuilder {
    private final BuilderSupport support = new BuilderSupport();
    private ComponentFactory factory;
    private JComponent label;
    private JComponent filterView;
    private JComponent listView;
    private JComponent listBarView;
    private JComponent listExtrasView;
    private JComponent detailsView;
    private JComponent listStackView;
    private Border border;
    private boolean honorsVisibility = true;
    private boolean consistentHeaderHeight = false;
    private Component initialComponent;
    private FocusTraversalType focusTraversalType;
    private FocusTraversalPolicy focusTraversalPolicy;
    private String namePrefix = "ListView";
    private String filterViewColSpec = "[100dlu, p]";
    private String listViewRowSpec = "fill:[100dlu, d]:grow";
    private int verticalScrollBarPolicy = -1;
    private int horizontalScrollBarPolicy = -1;
    private JComponent panel;

    public ListViewBuilder border(Border border) {
        this.support.checkNotCalledTwice("border or #padding");
        this.border = border;
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder padding(Paddings.Padding padding) {
        this.border(padding);
        return this;
    }

    public ListViewBuilder padding(String paddingSpec, Object ... args) {
        this.padding(Paddings.createPadding(paddingSpec, args));
        return this;
    }

    public ListViewBuilder initialComponent(JComponent initialComponent) {
        this.support.checkNotCalledTwice("initialComponent");
        Preconditions.checkNotNull(initialComponent, "The %s must not be null.", "initial component");
        this.checkValidFocusTraversalSetup();
        this.initialComponent = initialComponent;
        return this;
    }

    public ListViewBuilder focusTraversalType(FocusTraversalType focusTraversalType) {
        this.support.checkNotCalledTwice("focusTraversalType or #focusTraversalPolicy");
        Preconditions.checkNotNull(focusTraversalType, "The %s must not be null.", "focus traversal type");
        this.checkValidFocusTraversalSetup();
        this.focusTraversalType = focusTraversalType;
        return this;
    }

    public ListViewBuilder focusTraversalPolicy(FocusTraversalPolicy policy) {
        this.support.checkNotCalledTwice("focusTraversalType or #focusTraversalPolicy");
        Preconditions.checkNotNull(policy, "The %s must not be null.", "focus traversal policy");
        this.checkValidFocusTraversalSetup();
        this.focusTraversalPolicy = policy;
        return this;
    }

    public ListViewBuilder honorVisibility(boolean b) {
        this.support.checkNotCalledTwice("honorsVisibility");
        this.honorsVisibility = b;
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder consistentHeaderHeight(boolean b) {
        this.support.checkNotCalledTwice("consistentHeaderHeight");
        this.consistentHeaderHeight = b;
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder namePrefix(String namePrefix) {
        this.support.checkNotCalledTwice("namePrefix");
        this.namePrefix = namePrefix;
        return this;
    }

    public ListViewBuilder factory(ComponentFactory factory) {
        this.support.checkNotCalledTwice("factory");
        this.factory = factory;
        return this;
    }

    public ListViewBuilder label(JComponent labelView) {
        this.support.checkNotCalledTwice("label, #labelText, or #headerText");
        this.label = labelView;
        this.overrideNameIfBlank(labelView, "label");
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder labelText(String markedText, Object ... args) {
        this.label(this.getFactory().createLabel(Strings.get(markedText, args)));
        return this;
    }

    public ListViewBuilder headerText(String markedText, Object ... args) {
        this.label(this.getFactory().createHeaderLabel(Strings.get(markedText, args)));
        return this;
    }

    public ListViewBuilder filterView(JComponent filterView) {
        this.support.checkNotCalledTwice("filterView");
        this.filterView = filterView;
        this.overrideNameIfBlank(filterView, "filter");
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder filterViewColumn(String colSpec, Object ... args) {
        this.support.checkNotCalledTwice("filterViewColumn");
        Preconditions.checkNotNull(colSpec, "The %s must not be null, empty, or whitespace.", "filter view column specification");
        this.filterViewColSpec = Strings.get(colSpec, args);
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder listView(JComponent listView) {
        this.support.checkNotCalledTwice("listView");
        Preconditions.checkNotNull(listView, "The %s must not be null, empty, or whitespace.", "list view");
        this.listView = listView;
        this.overrideNameIfBlank(listView, "listView");
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder listViewRow(String rowSpec, Object ... args) {
        this.support.checkNotCalledTwice("listViewRow");
        Preconditions.checkNotNull(rowSpec, "The %s must not be null, empty, or whitespace.", "list view row specification");
        this.listViewRowSpec = Strings.get(rowSpec, args);
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder listVerticalScrollBarPolicy(int policy) {
        this.verticalScrollBarPolicy = policy;
        return this;
    }

    public ListViewBuilder listHorizontalScrollBarPolicy(int policy) {
        this.horizontalScrollBarPolicy = policy;
        return this;
    }

    public ListViewBuilder listBarView(JComponent listBarView) {
        this.support.checkNotCalledTwice("listBar or #listBarView");
        this.listBarView = listBarView;
        this.overrideNameIfBlank(listBarView, "listBarView");
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder listBar(JComponent ... buttons) {
        this.listBarView(Forms.buttonBar(buttons));
        return this;
    }

    public ListViewBuilder listStackView(JComponent listStackView) {
        this.support.checkNotCalledTwice("listStack or #listStackView");
        this.listStackView = listStackView;
        this.overrideNameIfBlank(listStackView, "listStackView");
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder listStack(JComponent ... buttons) {
        this.listStackView(Forms.buttonStack(buttons));
        return this;
    }

    public ListViewBuilder listExtrasView(JComponent listExtrasView) {
        this.support.checkNotCalledTwice("listExtrasView");
        this.listExtrasView = listExtrasView;
        this.overrideNameIfBlank(listExtrasView, "listExtrasView");
        this.invalidatePanel();
        return this;
    }

    public ListViewBuilder detailsView(JComponent detailsView) {
        this.support.checkNotCalledTwice("detailsView");
        this.detailsView = detailsView;
        this.overrideNameIfBlank(detailsView, "detailsView");
        this.invalidatePanel();
        return this;
    }

    public JComponent build() {
        if (this.panel == null) {
            this.panel = this.buildPanel();
        }
        return this.panel;
    }

    private ComponentFactory getFactory() {
        if (this.factory == null) {
            this.factory = FormsSetup.getComponentFactoryDefault();
        }
        return this.factory;
    }

    private void invalidatePanel() {
        this.panel = null;
    }

    private JComponent buildPanel() {
        JLabel theLabel;
        Preconditions.checkNotNull(this.listView, "The list view must be set before #build is invoked.");
        String stackGap = this.hasStack() ? "$rg" : "0";
        String detailsGap = this.hasDetails() ? "8dlu" : "0";
        FormBuilder builder = (FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:default:grow, %s, p", stackGap)).rows("p, %1$s, p, %2$s, p", this.listViewRowSpec, detailsGap)).honorsVisibility(this.honorsVisibility)).border(this.border)).add(this.hasHeader(), this.buildHeader()).xy(1, 1)).add(true, this.getListView()).xy(1, 2)).add(this.hasOperations(), this.buildOperations()).xy(1, 3)).add(this.hasStack(), this.listStackView).xy(3, 2)).add(this.hasDetails(), this.detailsView).xy(1, 5);
        if (this.label instanceof JLabel && (theLabel = (JLabel)this.label).getLabelFor() == null) {
            theLabel.setLabelFor(this.listView);
        }
        InternalFocusSetupUtils.setupFocusTraversalPolicyAndProvider(builder.getPanel(), this.focusTraversalPolicy, this.focusTraversalType, this.initialComponent);
        return builder.build();
    }

    private JComponent buildHeader() {
        if (!this.hasHeader()) {
            return null;
        }
        String columnSpec = this.hasFilter() ? "default:grow, 9dlu, %s" : "default:grow, 0,    0";
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns(columnSpec, this.filterViewColSpec)).rows("%s, $lcg", this.consistentHeaderHeight || this.hasFilter() ? "[14dlu, p]" : "p")).labelForFeatureEnabled(false)).add(this.hasLabel(), this.label).xy(1, 1)).add(this.hasFilter(), this.filterView).xy(3, 1)).build();
    }

    private JScrollPane buildScrollPane(Component view) {
        JScrollPane scrollPane = new JScrollPane(view);
        if (this.verticalScrollBarPolicy != -1) {
            scrollPane.setVerticalScrollBarPolicy(this.verticalScrollBarPolicy);
        }
        if (this.horizontalScrollBarPolicy != -1) {
            scrollPane.setHorizontalScrollBarPolicy(this.horizontalScrollBarPolicy);
        }
        return scrollPane;
    }

    private JComponent buildOperations() {
        if (!this.hasOperations()) {
            return null;
        }
        String gap = this.hasListExtras() ? "9dlu" : "0";
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("left:default, %s:grow, right:pref", gap)).rows("$rgap, p", new Object[0])).honorsVisibility(this.honorsVisibility)).add(this.hasListBar(), this.listBarView).xy(1, 2)).add(this.hasListExtras(), this.listExtrasView).xy(3, 2)).build();
    }

    private JComponent getListView() {
        return this.listView instanceof JTable || this.listView instanceof JList || this.listView instanceof JTree ? this.buildScrollPane(this.listView) : this.listView;
    }

    private boolean hasLabel() {
        return this.label != null;
    }

    private boolean hasFilter() {
        return this.filterView != null;
    }

    private boolean hasHeader() {
        return this.hasLabel() || this.hasFilter();
    }

    private boolean hasListBar() {
        return this.listBarView != null;
    }

    private boolean hasListExtras() {
        return this.listExtrasView != null;
    }

    private boolean hasOperations() {
        return this.hasListBar() || this.hasListExtras();
    }

    private boolean hasStack() {
        return this.listStackView != null;
    }

    private boolean hasDetails() {
        return this.detailsView != null;
    }

    private void overrideNameIfBlank(JComponent component, String suffix) {
        if (component != null && Strings.isBlank(component.getName())) {
            component.setName(this.namePrefix + '.' + suffix);
        }
    }

    private void checkValidFocusTraversalSetup() {
        InternalFocusSetupUtils.checkValidFocusTraversalSetup(this.focusTraversalPolicy, this.focusTraversalType, this.initialComponent);
    }
}

