/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.text.NumberFormatter;
import plugin.initiative.DiceRollModel;
import plugin.initiative.gui.DiceRollDialog;

public class CheckDialog
extends DiceRollDialog {
    private static int m_defaultDC = 15;
    private JFormattedTextField m_dc;

    public CheckDialog(DiceRollModel model) throws HeadlessException {
        super(model);
    }

    protected void initDC(String labelText) {
        NumberFormatter formatter = new NumberFormatter(new DecimalFormat("##"));
        formatter.setValueClass(Integer.class);
        this.m_dc = new JFormattedTextField(formatter);
        this.m_dc.setFocusLostBehavior(1);
        this.m_dc.setValue(m_defaultDC);
        JLabel label = new JLabel("DC:");
        label.setAlignmentX(1.0f);
        this.addComponent(this.m_dc, label);
    }

    @Override
    protected void initComponents() {
        this.initDC("DC:");
        super.initComponents();
    }

    @Override
    protected void setResult(int result) {
        this.m_result.setText("<html><body><b>" + result + (result >= (Integer)this.m_dc.getValue() ? " (passed)" : "") + "</b></body></html>");
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.m_dc.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("value".equals(evt.getPropertyName())) {
                    m_defaultDC = (Integer)CheckDialog.this.m_dc.getValue();
                }
            }
        });
    }
}

