/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.GMGenSystem;
import gmgen.gui.FlippingSplitPane;
import gmgen.io.SimpleFileFilter;
import gmgen.plugin.Combatant;
import gmgen.plugin.Dice;
import gmgen.plugin.Event;
import gmgen.plugin.InfoCharacterDetails;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.plugin.PcgCombatant;
import gmgen.plugin.Spell;
import gmgen.plugin.State;
import gmgen.plugin.SystemHP;
import gmgen.plugin.SystemInitiative;
import gmgen.pluginmgr.messages.CombatantHasBeenUpdatedMessage;
import gmgen.util.LogUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.NumberFormatter;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.PluginManager;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;
import plugin.initiative.AttackModel;
import plugin.initiative.CheckModel;
import plugin.initiative.DiceRollModel;
import plugin.initiative.InitOutputter;
import plugin.initiative.PObjectModel;
import plugin.initiative.SaveModel;
import plugin.initiative.SpellModel;
import plugin.initiative.XMLCombatant;
import plugin.initiative.gui.AddCombatant;
import plugin.initiative.gui.AttackDialog;
import plugin.initiative.gui.CastSpell;
import plugin.initiative.gui.CheckDialog;
import plugin.initiative.gui.DamageDialog;
import plugin.initiative.gui.DiceRollDialog;
import plugin.initiative.gui.OpposedCheckDialog;
import plugin.initiative.gui.SavingThrowDialog;
import plugin.initiative.gui.StartEvent;

public class Initiative
extends JPanel {
    public InitHolderList initList = new InitHolderList();
    private Combatant copyCombatant;
    private JButton bAddCombatant;
    private JButton bCast = new JButton();
    private JButton bOpposedSkill = new JButton();
    private JButton bCombatantReRoll;
    private JButton bDamage = new JButton();
    private JButton bDelete;
    private JButton bEvent = new JButton();
    private JButton bHeal = new JButton();
    private JButton bKill = new JButton();
    private JButton bNextInit;
    private JButton bRaise = new JButton();
    private JButton bRefocus;
    private JButton bRoll;
    private JButton bRefresh = new JButton();
    private JButton bDuplicateCombatant = new JButton();
    private JButton bSave = new JButton();
    private JButton bStabilize = new JButton();
    private JCheckBox showDead = new JCheckBox();
    private JCheckBox showEvents = new JCheckBox();
    private JCheckBoxMenuItem tablePopupCBDuration;
    private JCheckBoxMenuItem tablePopupCBHP;
    private JCheckBoxMenuItem tablePopupCBHPMax;
    private JCheckBoxMenuItem tablePopupCBInitiative;
    private JCheckBoxMenuItem tablePopupCBName;
    private JCheckBoxMenuItem tablePopupCBNumber;
    private JCheckBoxMenuItem tablePopupCBPlayer;
    private JCheckBoxMenuItem tablePopupCBPlus;
    private JCheckBoxMenuItem tablePopupCBStatus;
    private JCheckBoxMenuItem tablePopupCBType;
    private JLabel lCounter;
    private JPanel buttonPanelTop;
    private JPanel jPanel2;
    private JPopupMenu tablePopup;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollEvents;
    private FlippingSplitPane jSplitPane1;
    private JTabbedPane tpaneInfo;
    private JTable combatantTable;
    private JTextArea tpCombatInfo;
    private JToolBar topToolbar;
    private JToolBar bottomToolbar;
    private List columnList = new ArrayList();
    private LogUtilities log;
    private int currentCombat = 1;
    private int currentInit = -1;
    private int round = 0;
    private PCGenMessageHandler messageHandler = PluginManager.getInstance().getPostbox();

    public Initiative() {
        this.initComponents();
        this.initDynamicComponents();
        this.initPrefs();
        this.initTable();
        this.initLast();
        this.addTableListener();
        this.jSplitPane1.setOneTouchExpandable(true);
    }

    public void setCurrentInit(int init) {
        this.currentInit = init;
        if (this.currentInit > 0) {
            this.lCounter.setText(LanguageBundle.getFormattedString((String)"in_plugin_initiative_round", (Object[])new Object[]{this.round, init}));
        } else {
            this.lCounter.setText("");
        }
        this.refreshTable();
    }

    public void setExitPrefs() {
        SettingsHandler.setGMGenOption((String)"Initiative.ShowDead", (boolean)this.showDead.isSelected());
        SettingsHandler.setGMGenOption((String)"Initiative.ShowEvents", (boolean)this.showEvents.isSelected());
        SettingsHandler.setGMGenOption((String)"Initiative.DividerLocation", (int)this.jSplitPane1.getDividerLocation());
    }

    public void setLog(LogUtilities log) {
        this.log = log;
        if (this.tpaneInfo.getTitleAt(0).equals("Combat")) {
            this.tpaneInfo.remove(0);
        }
    }

    public boolean isPastable() {
        return this.copyCombatant != null;
    }

    public List<InitHolder> getSelected() {
        ArrayList<InitHolder> retList = new ArrayList<InitHolder>();
        int j = -1;
        for (int i = 0; i < this.combatantTable.getRowCount(); ++i) {
            InitHolder iH;
            if ((iH = (InitHolder)this.initList.get(++j)).getStatus() == State.Dead && !this.showDead.isSelected()) {
                --i;
                continue;
            }
            if (iH instanceof Event && !this.showEvents.isSelected()) {
                --i;
                continue;
            }
            if (!this.combatantTable.isRowSelected(i)) continue;
            retList.add(iH);
        }
        return retList;
    }

    public List<InitHolder> getUnSelected() {
        ArrayList<InitHolder> retList = new ArrayList<InitHolder>();
        int j = -1;
        for (int i = 0; i < this.combatantTable.getRowCount(); ++i) {
            InitHolder iH;
            if ((iH = (InitHolder)this.initList.get(++j)).getStatus() == State.Dead && !this.showDead.isSelected()) {
                --i;
                continue;
            }
            if (iH instanceof Event && !this.showEvents.isSelected()) {
                --i;
                continue;
            }
            if (this.combatantTable.isRowSelected(i)) continue;
            retList.add(iH);
        }
        return retList;
    }

    public int getSelectedCount() {
        return this.getSelected().size();
    }

    public boolean isXMLCombatantSelected() {
        List<InitHolder> selectedList = this.getSelected();
        if (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            return iH instanceof XMLCombatant;
        }
        return false;
    }

    public void addCombatant() {
        AddCombatant dialog = new AddCombatant(JOptionPane.getFrameForComponent(this), true, this);
        dialog.setVisible(true);
        this.refreshTable();
    }

    public void addInitHolder(InitHolder iH) {
        if (iH instanceof Combatant) {
            Combatant cbt = (Combatant)iH;
            if (!this.initList.isUniqueName(cbt.getName())) {
                cbt.setName(this.initList.getUniqueName(cbt.getName()));
            }
            this.addTab(cbt);
        }
        this.initList.add(iH);
    }

    public void addPcgCombatant(PlayerCharacter pc, String type) {
        String name = this.initList.getUniqueName(pc.getDisplay().getName());
        if (!name.equals(pc.getDisplay().getName())) {
            pc.setName(name);
            pc.setFileName("");
        }
        PcgCombatant pcgcbt = new PcgCombatant(pc, type, this.messageHandler);
        this.initList.add((InitHolder)pcgcbt);
        this.addTab((Combatant)pcgcbt);
    }

    public void addTab(final Combatant cbt) {
        JTextPane lp = new JTextPane();
        lp.setContentType("text/html");
        InfoCharacterDetails ic = new InfoCharacterDetails(cbt, lp);
        this.tpaneInfo.addTab(cbt.getName(), ic.getScrollPane());
        lp.setEditable(false);
        lp.addHyperlinkListener(new HyperlinkListener(){
            private Combatant combatant;
            {
                this.combatant = cbt;
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                Initiative.this.hyperLinkSelected(e, this.combatant);
            }
        });
    }

    public void applyPrefs() {
        if (SettingsHandler.getGMGenOption((String)"Initiative.doCombat", (boolean)true) && !this.bottomToolbar.isAncestorOf(this.bSave)) {
            this.bottomToolbar.add(this.bSave);
        }
        if (!SettingsHandler.getGMGenOption((String)"Initiative.doCombat", (boolean)true) && this.bottomToolbar.isAncestorOf(this.bSave)) {
            this.bottomToolbar.remove(this.bSave);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doSpells", (boolean)true) && !this.bottomToolbar.isAncestorOf(this.bCast)) {
            this.bottomToolbar.add(this.bCast);
            this.bottomToolbar.add(this.bEvent);
        }
        if (!SettingsHandler.getGMGenOption((String)"Initiative.doSpells", (boolean)true) && this.bottomToolbar.isAncestorOf(this.bCast)) {
            this.bottomToolbar.remove(this.bCast);
            this.bottomToolbar.remove(this.bEvent);
            this.bottomToolbar.add(this.showEvents);
        }
        this.checkAndFixColumns(SettingsHandler.getGMGenOption((String)"Initiative.doSpells", (boolean)true), "Dur");
        this.checkAndFixColumns(SettingsHandler.getGMGenOption((String)"Initiative.doSpells", (boolean)true) || SettingsHandler.getGMGenOption((String)"Initiative.doDeath", (boolean)true), "Status");
        if (SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true) && !this.bottomToolbar.isAncestorOf(this.bDamage)) {
            this.bottomToolbar.add(this.bDamage);
            this.bottomToolbar.add(this.bHeal);
            this.bottomToolbar.add(this.bStabilize);
        }
        if (!SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true) && this.bottomToolbar.isAncestorOf(this.bDamage)) {
            this.bottomToolbar.remove(this.bDamage);
            this.bottomToolbar.remove(this.bHeal);
            this.bottomToolbar.remove(this.bStabilize);
        }
        this.checkAndFixColumns(SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true), "HP");
        this.checkAndFixColumns(SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true), "HP Max");
        this.checkAndFixColumns(SettingsHandler.getGMGenOption((String)"Initiative.doNumber", (boolean)true), "#");
        if (SettingsHandler.getGMGenOption((String)"Initiative.doDeath", (boolean)true) && !this.bottomToolbar.isAncestorOf(this.bKill)) {
            this.bottomToolbar.add(this.bKill);
            this.bottomToolbar.add(this.showDead);
        }
        if (!SettingsHandler.getGMGenOption((String)"Initiative.doDeath", (boolean)true) && this.bottomToolbar.isAncestorOf(this.bKill)) {
            this.bottomToolbar.remove(this.bKill);
            this.bottomToolbar.remove(this.showDead);
        }
        this.initTable();
        this.refreshTable();
        this.repaint();
    }

    public void castSpell() {
        this.castSpell("");
    }

    public void castSpell(String name) {
        List<InitHolder> selectedList = this.getSelected();
        if (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            this.castSpell(name, iH, null);
            return;
        }
        this.initList.sort();
        this.refreshTable();
        this.castSpell(name, null, null);
    }

    public void castSpell(String name, InitHolder iH, SpellModel model) {
        CastSpell dialog = iH == null ? new CastSpell(JOptionPane.getFrameForComponent(this), true, this) : new CastSpell(JOptionPane.getFrameForComponent(this), true, this, iH.getPlayer(), iH.getInitiative().getCurrentInitiative());
        if (name != null) {
            dialog.setSpellName(name);
        }
        if (model != null) {
            dialog.setSpellModel(model);
        }
        dialog.setVisible(true);
        this.refreshTable();
    }

    public void checkDeadTabs() {
        for (int i = 0; i < this.initList.size(); ++i) {
            InitHolder iH = (InitHolder)this.initList.get(i);
            if (iH.getStatus() != State.Dead) continue;
            if (this.showDead.isSelected() && iH instanceof Combatant && this.tpaneInfo.indexOfTab(iH.getName()) == -1) {
                Combatant cbt = (Combatant)iH;
                this.addTab(cbt);
                continue;
            }
            this.removeTab(iH);
        }
    }

    public void combatantDied(InitHolder deadIH) {
        this.writeToCombatTabWithRound(deadIH.getName() + " (" + deadIH.getPlayer() + ") Killed");
        for (int i = 0; i < this.initList.size(); ++i) {
            InitHolder iH = (InitHolder)this.initList.get(i);
            String cbtType = "";
            if (iH instanceof Combatant) {
                Combatant cbt = (Combatant)iH;
                cbtType = cbt.getCombatantType();
            }
            if (!cbtType.equals("Enemy") || iH.getStatus() == State.Dead) continue;
            return;
        }
        this.writeToCombatTabWithRound("Combat finished, all enemies killed");
        this.checkDeadTabs();
    }

    public void copy() {
        List<InitHolder> selectedList = this.getSelected();
        while (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            if (!(iH instanceof Combatant)) continue;
            this.copyCombatant = (Combatant)iH;
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void damageCombatant() {
        int subdualType = SettingsHandler.getGMGenOption((String)"Initiative.Damage.Subdual", (int)1);
        DamageDialog dialog = new DamageDialog((Frame)GMGenSystem.inst, true);
        dialog.setVisible(true);
        dialog.dispose();
        int returnVal = dialog.getReturn();
        if (returnVal == 0) {
            int damage = dialog.getDamage();
            if (dialog.getSubdual()) {
                if (subdualType == 1) {
                    this.doSubdual(damage);
                } else if (subdualType == 2) {
                    this.doNonLethal(damage);
                }
            } else {
                this.doDamage(damage);
            }
        }
    }

    public void deleteCombatant() {
        List<InitHolder> selectedList = this.getSelected();
        while (!selectedList.isEmpty()) {
            try {
                InitHolder iH = selectedList.remove(0);
                this.initList.remove((Object)iH);
                this.removeTab(iH);
            }
            catch (Exception exception) {}
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void doDamage(int damage) {
        List<InitHolder> selectedList = this.getSelected();
        while (!selectedList.isEmpty()) {
            this.doDamage(damage, selectedList.remove(0));
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void doDamage(int damage, InitHolder iH) {
        if (iH instanceof Combatant) {
            Combatant cbt = (Combatant)iH;
            State oldStatus = cbt.getStatus();
            cbt.damage(damage);
            State newStatus = cbt.getStatus();
            this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") Took " + damage + " Damage: " + cbt.getHP().getCurrent() + "/" + cbt.getHP().getMax());
            this.doMassiveDamage(cbt, damage);
            if (!oldStatus.equals((Object)newStatus) && newStatus == State.Dead) {
                this.combatantDied((InitHolder)cbt);
            }
        }
    }

    public void doHeal(int heal) {
        List<InitHolder> selectedList = this.getSelected();
        while (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            if (!(iH instanceof Combatant)) continue;
            Combatant cbt = (Combatant)iH;
            cbt.heal(heal);
            this.combatantUpdated(cbt);
            this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") Gained " + heal + " Healing: " + cbt.getHP().getCurrent() + "/" + cbt.getHP().getMax());
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void doMassiveDamage(Combatant cbt, int damage) {
        int massiveType = SettingsHandler.getGMGenOption((String)"Initiative.Damage.Massive.Type", (int)2);
        boolean isMassive = false;
        if (massiveType == 2) {
            isMassive = SystemHP.isDndMassive((Combatant)cbt, (int)damage);
        } else if (massiveType == 3) {
            isMassive = SystemHP.isD20ModernMassive((Combatant)cbt, (int)damage);
        } else if (massiveType == 4) {
            isMassive = SystemHP.isHouseHalfMassive((Combatant)cbt, (int)damage);
        }
        if (isMassive) {
            StringBuilder sb = new StringBuilder();
            SavingThrowDialog dialog = new SavingThrowDialog((Frame)GMGenSystem.inst, true, cbt, 15, 1);
            dialog.setVisible(true);
            dialog.dispose();
            int returnVal = dialog.getReturnValue();
            int roll = dialog.getRoll();
            int total = dialog.getTotal();
            int dc = dialog.getDC();
            sb.append(dialog.getSaveAbbrev(dialog.getSaveType()));
            sb.append(" save DC " + dc);
            if (roll > 0) {
                sb.append(" with a roll of " + (roll + total));
                sb.append(" (" + total + " + Roll: " + roll + ")");
            }
            if (returnVal == 1) {
                this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") Passed a " + sb + " to avoid massive damage effects");
            } else if (returnVal == 2) {
                this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") Failed a " + sb + " to avoid massive damage effects");
                int massiveEffect = SettingsHandler.getGMGenOption((String)"Initiative.Damage.Massive.Effect", (int)1);
                if (massiveEffect == 1) {
                    cbt.kill();
                    this.combatantDied((InitHolder)cbt);
                } else if (massiveEffect == 2) {
                    SystemHP hp = cbt.getHP();
                    int current = hp.getCurrent();
                    cbt.damage(current + 1);
                } else if (massiveEffect == 3) {
                    SystemHP hp = cbt.getHP();
                    int max = hp.getMax();
                    cbt.damage(max / 2);
                } else if (massiveEffect == 4) {
                    SystemHP hp = cbt.getHP();
                    int current = hp.getCurrent();
                    cbt.damage(current / 2);
                }
            }
        }
        this.combatantUpdated(cbt);
    }

    public void doNonLethal(int damage) {
        List<InitHolder> selectedList = this.getSelected();
        while (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            this.doNonLethal(damage, iH);
        }
    }

    public void doNonLethal(int damage, InitHolder iH) {
        if (iH instanceof Combatant) {
            PCStat stat;
            PcgCombatant pcgcbt;
            PlayerCharacter pc;
            XMLCombatant xmlcbt;
            Combatant cbt = (Combatant)iH;
            boolean isEnough = false;
            if (cbt instanceof XMLCombatant && damage > (xmlcbt = (XMLCombatant)cbt).getHP().getAttribute().getValue()) {
                isEnough = true;
            }
            if (cbt instanceof PcgCombatant && damage > (pc = (pcgcbt = (PcgCombatant)cbt).getPC()).getTotalStatFor(stat = (PCStat)Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, "CON"))) {
                isEnough = true;
            }
            if (isEnough) {
                StringBuilder sb = new StringBuilder();
                SavingThrowDialog dialog = new SavingThrowDialog((Frame)GMGenSystem.inst, true, cbt, 15, 1);
                dialog.setVisible(true);
                dialog.dispose();
                int returnVal = dialog.getReturnValue();
                int roll = dialog.getRoll();
                int total = dialog.getTotal();
                int dc = dialog.getDC();
                sb.append(dialog.getSaveAbbrev(dialog.getSaveType()));
                sb.append(" save DC " + dc);
                if (roll > 0) {
                    sb.append(" with a roll of " + (roll + total));
                    sb.append(" (" + total + " + Roll: " + roll + ")");
                }
                if (returnVal == 1) {
                    this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") Passed a " + sb + " to avoid unconsiousness");
                    cbt.nonLethalDamage(false);
                } else if (returnVal == 2) {
                    this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") Failed a " + sb + " to avoid unconsiousness");
                    cbt.nonLethalDamage(true);
                }
            }
            this.combatantUpdated(cbt);
        }
    }

    public void doSetCombatantType(String comType) {
        List<InitHolder> selectedList = this.getSelected();
        while (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            if (!(iH instanceof Combatant)) continue;
            Combatant cbt = (Combatant)iH;
            cbt.setCombatantType(comType);
            this.combatantUpdated(cbt);
        }
        this.refreshTable();
    }

    public void doSubdual(int damage) {
        List<InitHolder> selectedList = this.getSelected();
        while (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            this.doSubdual(damage, iH);
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void doSubdual(int damage, InitHolder iH) {
        if (iH instanceof Combatant) {
            Combatant cbt = (Combatant)iH;
            cbt.subdualDamage(damage);
            this.combatantUpdated(cbt);
            this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") Took " + damage + " Subdual Damage: " + cbt.getHP().getCurrent() + "(" + cbt.getHP().getSubdual() + "s)/" + cbt.getHP().getMax());
        }
    }

    public void focusNextInit() {
        this.bNextInit.grabFocus();
    }

    public void focusRoll() {
        this.bRoll.grabFocus();
    }

    public void healCombatant() {
        String inputValue = JOptionPane.showInputDialog(this, "Heal", Integer.toString(1));
        if (inputValue != null) {
            try {
                this.doHeal(Integer.parseInt(inputValue));
            }
            catch (NumberFormatException e) {
                this.healCombatant();
            }
        }
    }

    public void initLast() {
        int iDividerLocation = SettingsHandler.getGMGenOption((String)"Initiative.DividerLocation", (int)400);
        this.jSplitPane1.setDividerLocation(iDividerLocation);
        if (SettingsHandler.getGMGenOption((String)"Initiative.doSpells", (boolean)true)) {
            this.bottomToolbar.add(this.bCast);
            this.bottomToolbar.add(this.bEvent);
            this.bottomToolbar.add(this.showEvents);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doCombat", (boolean)true)) {
            this.bottomToolbar.add(this.bSave);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true)) {
            this.bottomToolbar.add(this.bDamage);
            this.bottomToolbar.add(this.bHeal);
            this.bottomToolbar.add(this.bStabilize);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doDeath", (boolean)true)) {
            this.bottomToolbar.add(this.bKill);
            this.bottomToolbar.add(this.bRaise);
            this.bottomToolbar.add(this.showDead);
        }
        boolean bShowDead = SettingsHandler.getGMGenOption((String)"Initiative.ShowDead", (boolean)false);
        this.showDead.setSelected(bShowDead);
        boolean bShowEvents = SettingsHandler.getGMGenOption((String)"Initiative.ShowEvents", (boolean)true);
        this.showEvents.setSelected(bShowEvents);
    }

    public void initPrefs() {
        Double version;
        boolean prefsSet = SettingsHandler.getGMGenOption((String)"Initiative.arePrefsSet", (boolean)false);
        if (!prefsSet) {
            SettingsHandler.setGMGenOption((String)"Initiative.arePrefsSet", (boolean)true);
        }
        if ((version = SettingsHandler.getGMGenOption((String)"Initiative.Version", (double)0.0)) < 1.0 || !prefsSet) {
            SettingsHandler.setGMGenOption((String)"Initiative.doSpells", (boolean)true);
            SettingsHandler.setGMGenOption((String)"Initiative.doDeath", (boolean)true);
            SettingsHandler.setGMGenOption((String)"Initiative.doHP", (boolean)true);
            SettingsHandler.setGMGenOption((String)"Initiative.doMaxHP", (int)100);
            SettingsHandler.setGMGenOption((String)"Initiative.doMaxNum", (int)20);
            SettingsHandler.setGMGenOption((String)"Initiative.doNum", (int)20);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.0", (String)"#");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.0", (int)25);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.1", (String)"Name");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.1", (int)100);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.2", (String)"Player");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.2", (int)100);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.3", (String)"Status");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.3", (int)75);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.4", (String)"+");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.4", (int)25);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.5", (String)"Init");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.5", (int)25);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.6", (String)"Dur");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.6", (int)25);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.7", (String)"HP");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.7", (int)25);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.8", (String)"HP Max");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.8", (int)50);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.9", (String)"Type");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.9", (int)50);
            SettingsHandler.setGMGenOption((String)"Initiative.NumberOfColumns", (int)10);
            SettingsHandler.setGMGenOption((String)"Initiative.DividerLocation", (int)450);
            SettingsHandler.setGMGenOption((String)"Initiative.SubVersion", (double)1.0);
            SettingsHandler.setGMGenOption((String)"Initiative.Version", (double)1.0);
        }
    }

    public void killCombatant() {
        List<InitHolder> selectedList = this.getSelected();
        while (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            if (!(iH instanceof Combatant)) continue;
            Combatant cbt = (Combatant)iH;
            cbt.kill();
            this.combatantDied((InitHolder)cbt);
            this.combatantUpdated(cbt);
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void loadFromDocument(Document character, PCGenMessageHandler comp) {
        if (character.getRootElement().getName().equals("Party")) {
            Element party = character.getRootElement();
            List xmlList = party.getChildren("Character");
            for (int i = 0; i < xmlList.size(); ++i) {
                Element eCharacter = (Element)xmlList.get(i);
                XMLCombatant combatant = new XMLCombatant(eCharacter);
                this.initList.add((InitHolder)combatant);
            }
            List pcgList = party.getChildren("PcgCombatant");
            for (int i = 0; i < pcgList.size(); ++i) {
                Element eCharacter = (Element)pcgList.get(i);
                PcgCombatant combatant = new PcgCombatant(eCharacter, comp, this.messageHandler);
                this.initList.add((InitHolder)combatant);
                this.addTab((Combatant)combatant);
            }
            List eventList = party.getChildren("Event");
            for (int i = 0; i < eventList.size(); ++i) {
                Element eCharacter = (Element)eventList.get(i);
                Event combatant = new Event(eCharacter);
                this.initList.add((InitHolder)combatant);
            }
            List spellList = party.getChildren("Spell");
            for (int i = 0; i < spellList.size(); ++i) {
                Element eCharacter = (Element)spellList.get(i);
                Spell combatant = new Spell(eCharacter);
                this.initList.add((InitHolder)combatant);
            }
            this.initList.calculateNumberField();
        } else if (character.getRootElement().getName().equals("Character")) {
            Element eCharacter = character.getRootElement();
            XMLCombatant combatant = new XMLCombatant(eCharacter);
            this.initList.add((InitHolder)combatant);
        }
    }

    public void loadINIT(File initFile, PCGenMessageHandler comp) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document character = builder.build(initFile);
            this.loadFromDocument(character, comp);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), "File load error: " + initFile.getName());
            Logging.errorPrint((String)("File Load Error" + initFile.getName()));
            Logging.errorPrint((String)e.getMessage(), (Throwable)e);
        }
    }

    public void nextInit() {
        int oldInit = this.currentInit;
        this.setCurrentInit(this.currentInit - 1);
        int bleedingTime = SettingsHandler.getGMGenOption((String)"Initiative.Damage.Dying", (int)1);
        for (int i = 0; i < this.initList.size(); ++i) {
            Combatant cbt;
            int cInit;
            InitHolder iH = (InitHolder)this.initList.get(i);
            if (iH instanceof Event) {
                int duration;
                Event e = (Event)iH;
                int eInit = e.getInitiative().getCurrentInitiative();
                if (oldInit != eInit || (duration = e.decDuration()) >= 0) continue;
                this.writeToCombatTabWithRound(e.getPlayer() + "'s " + e.getName() + " ended");
                if (e.isAlert()) {
                    JOptionPane.showMessageDialog(this, e.getEndText());
                }
                this.initList.remove(i);
                continue;
            }
            if (!(iH instanceof Combatant) || oldInit != (cInit = (cbt = (Combatant)iH).getInitiative().getCurrentInitiative())) continue;
            cbt.decDuration();
            if (bleedingTime != 2) continue;
            this.bleed((Combatant)iH);
        }
        if (this.currentInit <= 0) {
            int maxInit = this.initList.getMaxInit();
            this.setCurrentInit(maxInit);
            for (int i = 0; i < this.initList.size(); ++i) {
                InitHolder iH = (InitHolder)this.initList.get(i);
                if (bleedingTime == 1 && iH instanceof Combatant) {
                    this.bleed((Combatant)iH);
                }
                iH.endRound();
            }
            ++this.round;
            this.writeToCombatTab("Round " + this.round);
            this.setCurrentInit(maxInit);
        } else if (!this.initList.initValid(this.currentInit)) {
            this.nextInit();
        }
        this.refreshTable();
    }

    public void pasteNew(Combatant toPaste) {
        if (toPaste instanceof XMLCombatant) {
            XMLCombatant cb = (XMLCombatant)toPaste;
            SystemInitiative init = cb.getInitiative();
            SystemHP hitPoints = cb.getHP();
            String name = this.initList.getUniqueName(cb.getName());
            XMLCombatant newCbt = new XMLCombatant(name, toPaste.getPlayer(), init.getAttribute().getValue(), hitPoints.getAttribute().getValue(), hitPoints.getMax(), hitPoints.getCurrent(), hitPoints.getSubdual(), init.getBonus(), cb.getCombatantType(), cb.getCR());
            this.initList.add((InitHolder)newCbt);
        }
        if (toPaste instanceof PcgCombatant) {
            // empty if block
        }
        this.refreshTable();
    }

    public void pasteNew(Combatant toPaste, int num) {
        for (int i = 0; i < num; ++i) {
            this.pasteNew(toPaste);
        }
    }

    public void pasteNew(int num) {
        this.pasteNew(this.copyCombatant, num);
    }

    public void pasteNew() {
        this.pasteNew(this.copyCombatant);
    }

    public void performAttack(AttackModel attack, PcgCombatant combatant) {
        Vector<Object> combatants = new Vector<Object>(this.initList.size());
        for (int i = 0; i < this.initList.size(); ++i) {
            if (!(this.initList.get(i) instanceof PcgCombatant) || this.initList.get(i) == combatant || ((InitHolder)this.initList.get(i)).getStatus() == State.Dead && !this.showDead.isSelected()) continue;
            combatants.add(this.initList.get(i));
        }
        AttackDialog dlg = new AttackDialog(attack, combatants);
        dlg.setModal(true);
        dlg.setVisible(true);
        List<Integer> dmgList = dlg.getDamageList();
        List targetList = dlg.getDamagedCombatants();
        if (dmgList != null && targetList != null && dmgList.size() > 0 && targetList.size() > 0) {
            this.writeToCombatTabWithRound(combatant.getName() + " successfully attacks using " + attack);
            for (int i = 0; i < dmgList.size() && i < targetList.size(); ++i) {
                if (dlg.isSubdual()) {
                    int subdualType = SettingsHandler.getGMGenOption((String)"Initiative.Damage.Subdual", (int)1);
                    if (subdualType == 1) {
                        this.doSubdual(dmgList.get(i), (InitHolder)((PcgCombatant)targetList.get(i)));
                        continue;
                    }
                    if (subdualType != 2) continue;
                    this.doNonLethal(dmgList.get(i), (InitHolder)((PcgCombatant)targetList.get(i)));
                    continue;
                }
                this.doDamage(dmgList.get(i), (InitHolder)((PcgCombatant)targetList.get(i)));
            }
            this.initList.sort();
            this.refreshTable();
        } else if (dmgList != null && dmgList.size() > 0) {
            this.writeToCombatTabWithRound(combatant.getName() + " successfully attacks using " + attack);
        } else {
            this.writeToCombatTabWithRound(combatant.getName() + " fails with attack using " + attack);
        }
        dlg.dispose();
    }

    public void raiseCombatant() {
        List<InitHolder> selectedList = this.getSelected();
        while (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            if (!(iH instanceof Combatant)) continue;
            Combatant cbt = (Combatant)iH;
            this.writeToCombatTabWithRound(iH.getName() + " (" + cbt.getPlayer() + ") Raised");
            cbt.raise();
            this.combatantUpdated(cbt);
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void refocusCombatant() {
        List<InitHolder> selectedList = this.getSelected();
        while (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            if (!(iH instanceof Combatant)) continue;
            Combatant cbt = (Combatant)iH;
            cbt.init.refocus();
            this.combatantUpdated(cbt);
            this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") Refocused");
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void refreshTable() {
        this.combatantTable.clearSelection();
        DefaultTableModel model = (DefaultTableModel)this.combatantTable.getModel();
        model.setNumRows(0);
        int startSelect = -1;
        int rowNum = 0;
        for (int i = 0; i < this.initList.size(); ++i) {
            InitHolder c = (InitHolder)this.initList.get(i);
            if (c.getStatus() == State.Dead && !this.showDead.isSelected() || c instanceof Event && !this.showEvents.isSelected()) continue;
            Vector rowVector = this.initList.getRowVector(i, this.columnList);
            model.addRow(rowVector);
            int cInit = c.getInitiative().getCurrentInitiative();
            if (cInit == this.currentInit) {
                if (startSelect == -1) {
                    startSelect = rowNum;
                }
                this.combatantTable.setRowSelectionInterval(startSelect, rowNum);
            }
            ++rowNum;
        }
        this.refreshEventTab();
    }

    public void refreshTabs() {
        for (int i = 0; i < this.initList.size(); ++i) {
            InitHolder iH = (InitHolder)this.initList.get(i);
            if (iH.getStatus() == State.Dead && !this.showDead.isSelected() || !(iH instanceof Combatant)) continue;
            Combatant cbt = (Combatant)iH;
            this.removeTab((InitHolder)cbt);
            this.addTab(cbt);
        }
    }

    public void removePcgCombatant(PlayerCharacter pc) {
        for (int i = 0; i < this.initList.size(); ++i) {
            PcgCombatant c;
            InitHolder iH = (InitHolder)this.initList.get(i);
            if (!(iH instanceof PcgCombatant) || (c = (PcgCombatant)iH).getPC() != pc) continue;
            this.initList.remove((Object)iH);
            this.removeTab(iH);
        }
    }

    public void removeTab(InitHolder iH) {
        try {
            this.tpaneInfo.removeTabAt(this.tpaneInfo.indexOfTab(iH.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeTab(String name) {
        try {
            this.tpaneInfo.removeTabAt(this.tpaneInfo.indexOfTab(name));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void rerollCombatant() {
        List<InitHolder> selectedList = this.getSelected();
        while (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            if (!(iH instanceof Combatant)) continue;
            Combatant cbt = (Combatant)iH;
            cbt.init.check();
            this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") Rerolled");
            this.combatantUpdated(cbt);
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void roll() {
        this.round = 0;
        this.initList.check();
        int maxInit = this.initList.getMaxInit();
        this.writeToCombatTab("Combat Number " + this.currentCombat + ": ");
        this.writeToCombatTab("Round 1");
        ++this.currentCombat;
        this.round = 1;
        this.setCurrentInit(maxInit);
    }

    public void rollSave() {
        List<InitHolder> selectedList = this.getSelected();
        SaveModel model = new SaveModel();
        while (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            if (!(iH instanceof Combatant)) continue;
            model = this.performSave(model, iH);
        }
        this.refreshTable();
    }

    private SaveModel performSave(SaveModel model, InitHolder iH) {
        Combatant cbt = (Combatant)iH;
        SavingThrowDialog dialog = new SavingThrowDialog((Frame)GMGenSystem.inst, true, cbt, model);
        dialog.setVisible(true);
        dialog.dispose();
        int returnVal = dialog.getReturnValue();
        int roll = dialog.getRoll();
        int total = dialog.getTotal();
        model = dialog.getSaveModel();
        StringBuilder sb = new StringBuilder();
        sb.append(dialog.getSaveAbbrev(dialog.getSaveType()));
        sb.append(" save DC " + model.getDc());
        if (roll > 0) {
            sb.append(" with a roll of " + (roll + total));
            sb.append(" (" + total + " + Roll: " + roll + ")");
        }
        if (returnVal == 1) {
            this.writeToCombatTabWithRound(iH.getName() + " (" + iH.getPlayer() + ") Passed a " + sb);
        } else if (returnVal == 2) {
            this.writeToCombatTabWithRound(iH.getName() + " (" + iH.getPlayer() + ") Failed a " + sb);
        }
        return model;
    }

    public void saveToDocument(File xml) throws Exception {
        Element party = new Element("Party");
        party.setAttribute("filever", "1.0");
        party.setAttribute("filetype", "initsave");
        for (int i = 0; i < this.initList.size(); ++i) {
            InitHolder iH = (InitHolder)this.initList.get(i);
            party.addContent((Content)iH.getSaveElement());
        }
        Document saveDocument = new Document(party);
        InitOutputter xmlOut = new InitOutputter();
        xmlOut.setFormat(Format.getRawFormat().setEncoding("US-ASCII"));
        FileWriter fr = new FileWriter(xml);
        xmlOut.output(saveDocument, fr);
        fr.flush();
        fr.close();
    }

    public void saveToFile() {
        JFileChooser fLoad = new JFileChooser();
        File defaultFile = new File(PCGenSettings.getPcgDir());
        if (defaultFile.exists()) {
            fLoad.setCurrentDirectory(defaultFile);
        }
        String[] fileExt = new String[]{"gmi", "init"};
        SimpleFileFilter ff = new SimpleFileFilter(fileExt, "GMGen Initiative/Encounter Export");
        fLoad.addChoosableFileFilter((FileFilter)ff);
        fLoad.setFileFilter((FileFilter)ff);
        int returnVal = fLoad.showSaveDialog(this);
        try {
            if (returnVal == 0) {
                File xml;
                String fileName = fLoad.getSelectedFile().getName();
                String ext = "";
                if (!fileName.endsWith(".gmi")) {
                    ext = ".gmi";
                }
                if ((xml = new File(fLoad.getSelectedFile().getParent() + File.separator + fileName + ext)).exists()) {
                    int choice = JOptionPane.showConfirmDialog(this, "File Exists, Overwrite?", "File Exists", 0, 3);
                    if (choice == 0) {
                        SettingsHandler.ensurePathExists((File)xml.getParentFile());
                        this.saveToDocument(xml);
                    }
                } else {
                    SettingsHandler.ensurePathExists((File)xml.getParentFile());
                    this.saveToDocument(xml);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error Writing File");
            Logging.errorPrint((String)"Error Writing File");
            Logging.errorPrint((String)e.getMessage(), (Throwable)e);
        }
    }

    public void showPreferences() {
    }

    public void stabilizeCombatant() {
        List<InitHolder> selectedList = this.getSelected();
        while (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            if (!(iH instanceof Combatant)) continue;
            Combatant cbt = (Combatant)iH;
            this.writeToCombatTabWithRound(iH.getName() + " (" + cbt.getPlayer() + ") Stabilized");
            cbt.stabilize();
            this.combatantUpdated(cbt);
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void startEvent() {
        List<InitHolder> selectedList = this.getSelected();
        if (!selectedList.isEmpty()) {
            InitHolder iH = selectedList.remove(0);
            StartEvent dialog = new StartEvent(JOptionPane.getFrameForComponent(this), true, this, iH.getPlayer(), iH.getInitiative().getCurrentInitiative());
            dialog.setVisible(true);
            this.refreshTable();
            return;
        }
        this.initList.sort();
        this.refreshTable();
        StartEvent dialog = new StartEvent(JOptionPane.getFrameForComponent(this), true, this);
        dialog.setVisible(true);
        this.refreshTable();
    }

    public void writeToCombatTab(String message) {
        this.log.logMessage("Initiative", message);
    }

    public void writeToCombatTabWithRound(String message) {
        this.writeToCombatTab(" (Round: " + this.round + ", Init: " + this.currentInit + "): " + message);
    }

    protected void hyperLinkSelected(HyperlinkEvent e, Combatant cbt) {
        PObjectModel model;
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (model = PObjectModel.Factory(e.getDescription())) != null) {
            if (model instanceof AttackModel && cbt instanceof PcgCombatant) {
                PcgCombatant pcgcbt = (PcgCombatant)cbt;
                this.performAttack((AttackModel)model, pcgcbt);
            } else if (model instanceof CheckModel) {
                this.performCheck((CheckModel)model);
            } else if (model instanceof SpellModel) {
                this.castSpell((SpellModel)model, cbt);
            } else if (model instanceof SaveModel) {
                this.performSave((SaveModel)model, (InitHolder)cbt);
            } else if (model instanceof DiceRollModel && cbt instanceof PcgCombatant) {
                this.performDiceRoll((DiceRollModel)model);
            }
        }
    }

    private void performDiceRoll(DiceRollModel model) {
        DiceRollDialog dlg = new DiceRollDialog(model);
        dlg.setModal(true);
        dlg.setVisible(true);
        dlg.dispose();
    }

    protected void listSelectionChaned(ListSelectionEvent e) {
        String name;
        int row = this.combatantTable.getSelectedRow();
        if (row >= 0 && (name = (String)this.combatantTable.getValueAt(row, this.combatantTable.getColumnModel().getColumnIndex("Name"))) != null && name.length() > 0 && this.tpaneInfo.indexOfTab(name) >= 0) {
            this.tpaneInfo.setSelectedIndex(this.tpaneInfo.indexOfTab(name));
        }
    }

    private List getColumnOrder() {
        TableColumnModel colModel = this.combatantTable.getColumnModel();
        ArrayList<Object> colOrder = new ArrayList<Object>();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            colOrder.add(colModel.getColumn(i).getHeaderValue());
        }
        return colOrder;
    }

    private void setColumnWidths(int[] widths) {
        TableColumnModel colModel = this.combatantTable.getColumnModel();
        for (int i = 0; i < widths.length; ++i) {
            TableColumn col = colModel.getColumn(i);
            col.setPreferredWidth(widths[i]);
        }
    }

    private void TablePopupActionPerformed(ActionEvent evt) {
        this.checkAndFixColumns(this.tablePopupCBName.getState(), "Name");
        this.checkAndFixColumns(this.tablePopupCBPlayer.getState(), "Player");
        this.checkAndFixColumns(this.tablePopupCBStatus.getState(), "Status");
        this.checkAndFixColumns(this.tablePopupCBPlus.getState(), "+");
        this.checkAndFixColumns(this.tablePopupCBInitiative.getState(), "Init");
        this.checkAndFixColumns(this.tablePopupCBDuration.getState(), "Dur");
        this.checkAndFixColumns(this.tablePopupCBHP.getState(), "HP");
        this.checkAndFixColumns(this.tablePopupCBHPMax.getState(), "HP Max");
        this.checkAndFixColumns(this.tablePopupCBNumber.getState(), "#");
        this.checkAndFixColumns(this.tablePopupCBType.getState(), "Type");
        this.refreshTable();
    }

    private void addColumn(String name, int width) {
        DefaultTableModel tabModel = (DefaultTableModel)this.combatantTable.getModel();
        TableColumnModel colModel = this.combatantTable.getColumnModel();
        tabModel.addColumn(name);
        TableColumn column = colModel.getColumn(colModel.getColumnCount() - 1);
        column.setPreferredWidth(width);
        column.setWidth(width);
        column.setIdentifier(name);
        this.columnList = this.getColumnOrder();
    }

    private void addTableListener() {
        TableColumnModel colModel = this.combatantTable.getColumnModel();
        colModel.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent evt) {
                Initiative.this.colModAdded(evt);
            }

            @Override
            public void columnMarginChanged(ChangeEvent evt) {
                Initiative.this.colModMarginChanged(evt);
            }

            @Override
            public void columnMoved(TableColumnModelEvent evt) {
                Initiative.this.colModMoved(evt);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent evt) {
                Initiative.this.colModRemoved(evt);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent evt) {
                Initiative.this.colModSelectionChanged(evt);
            }
        });
    }

    private void bAddCombatantActionPerformed(ActionEvent evt) {
        this.addCombatant();
    }

    private void bCastActionPerformed(ActionEvent evt) {
        this.castSpell();
        this.focusNextInit();
    }

    private void bCombatantReRollActionPerformed(ActionEvent evt) {
        this.rerollCombatant();
        this.focusNextInit();
    }

    private void bDamageActionPerformed(ActionEvent evt) {
        this.damageCombatant();
        this.focusNextInit();
    }

    private void bDeleteActionPerformed(ActionEvent evt) {
        this.deleteCombatant();
        this.focusNextInit();
    }

    private void bEventActionPerformed(ActionEvent evt) {
        this.startEvent();
        this.focusNextInit();
    }

    private void bHealActionPerformed(ActionEvent evt) {
        this.healCombatant();
        this.focusNextInit();
    }

    private void bKillActionPerformed(ActionEvent evt) {
        this.killCombatant();
        this.focusNextInit();
    }

    private void bNextInitActionPerformed(ActionEvent evt) {
        this.nextInit();
    }

    private void bRaiseActionPerformed(ActionEvent evt) {
        this.raiseCombatant();
        this.refreshTable();
        this.focusNextInit();
    }

    private void bRefocusActionPerformed(ActionEvent evt) {
        this.refocusCombatant();
        this.focusNextInit();
    }

    private void bRollActionPerformed(ActionEvent evt) {
        this.roll();
        this.focusNextInit();
    }

    private void bSaveActionPerformed(ActionEvent evt) {
        this.rollSave();
    }

    private void bStabilizeActionPerformed(ActionEvent evt) {
        this.stabilizeCombatant();
        this.refreshTable();
        this.focusNextInit();
    }

    private void bleed(Combatant cbt) {
        if (cbt.getStatus() == State.Bleeding) {
            int stableType = SettingsHandler.getGMGenOption((String)"Initiative.Damage.Stable", (int)1);
            if (stableType == 1) {
                int roll = new Dice(1, 100).roll();
                if (roll <= 10) {
                    cbt.stabilize();
                    this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") auto-stabilized  (" + roll + "%)");
                } else {
                    this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") failed to auto-stabilize (" + roll + "%)");
                }
            } else if (stableType == 2) {
                SavingThrowDialog dialog = new SavingThrowDialog((Frame)GMGenSystem.inst, true, cbt, 20, 1);
                dialog.setVisible(true);
                dialog.dispose();
                int returnVal = dialog.getReturnValue();
                int roll = dialog.getRoll();
                int total = dialog.getTotal();
                int dc = dialog.getDC();
                if (dialog.getReturnValue() == 1) {
                    cbt.stabilize();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(dialog.getSaveAbbrev(dialog.getSaveType()));
                sb.append(" save DC " + dc);
                if (roll > 0) {
                    sb.append(" with a roll of " + (roll + total));
                    sb.append(" (" + total + " + Roll: " + roll + ")");
                }
                if (returnVal == 1) {
                    this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") Passed a " + sb + " to auto-stabilize");
                } else if (returnVal == 2) {
                    this.writeToCombatTabWithRound(cbt.getName() + " (" + cbt.getPlayer() + ") Failed a " + sb + " to auto-stabilize");
                }
            }
            State oldStatus = cbt.getStatus();
            cbt.bleed();
            this.combatantUpdated(cbt);
            State newStatus = cbt.getStatus();
            if (!oldStatus.equals((Object)newStatus) && newStatus == State.Dead) {
                this.combatantDied((InitHolder)cbt);
            }
        }
    }

    private void castSpell(SpellModel model, Combatant combatant) {
        this.castSpell(model.getName(), (InitHolder)combatant, model);
    }

    private void checkAndFixColumns(boolean shouldExist, String colName) {
        if (shouldExist && !this.getColumnOrder().contains(colName)) {
            this.addColumn(colName, 100);
            this.trackTable();
        } else if (!shouldExist && this.getColumnOrder().contains(colName)) {
            this.removeColumn(colName);
        }
    }

    private void performCheck(CheckModel model) {
        CheckDialog dlg = new CheckDialog(model);
        dlg.setModal(true);
        dlg.setVisible(true);
        dlg.dispose();
    }

    private void colModAdded(TableColumnModelEvent evt) {
    }

    private void colModMarginChanged(ChangeEvent evt) {
        this.trackTable();
    }

    private void colModMoved(TableColumnModelEvent evt) {
        this.trackTable();
    }

    private void colModRemoved(TableColumnModelEvent evt) {
    }

    private void colModSelectionChanged(ListSelectionEvent evt) {
    }

    private void combatantTableMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.initTablePopup();
            this.tablePopup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void combatantTableMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.initTablePopup();
            this.tablePopup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void combatantTablePropertyChange(PropertyChangeEvent evt) {
        this.editTableRow();
        this.refreshTable();
    }

    private void editTable(int row, int column) {
        InitHolder iH = (InitHolder)this.initList.get(row);
        String oldName = iH.getName();
        Object data = this.combatantTable.getValueAt(row, column);
        boolean atTop = this.currentInit == this.initList.getMaxInit();
        iH.editRow(this.columnList, column, data);
        if (!iH.getName().equals(oldName) && iH instanceof Combatant) {
            this.removeTab(oldName);
            this.addTab((Combatant)iH);
        }
        this.initHolderUpdated(iH);
        this.initList.sort();
        if (atTop) {
            this.setCurrentInit(this.initList.getMaxInit());
        }
        this.refreshTable();
    }

    private void editTableRow() {
        int row = this.combatantTable.getEditingRow();
        int column = this.combatantTable.getEditingColumn();
        if (row > -1 && column > -1) {
            this.editTable(row, column);
        }
    }

    private void initComponents() {
        this.tablePopup = new JPopupMenu();
        this.tablePopupCBNumber = new JCheckBoxMenuItem();
        this.tablePopupCBName = new JCheckBoxMenuItem();
        this.tablePopupCBPlayer = new JCheckBoxMenuItem();
        this.tablePopupCBStatus = new JCheckBoxMenuItem();
        this.tablePopupCBPlus = new JCheckBoxMenuItem();
        this.tablePopupCBInitiative = new JCheckBoxMenuItem();
        this.tablePopupCBDuration = new JCheckBoxMenuItem();
        this.tablePopupCBHP = new JCheckBoxMenuItem();
        this.tablePopupCBHPMax = new JCheckBoxMenuItem();
        this.tablePopupCBType = new JCheckBoxMenuItem();
        this.topToolbar = new JToolBar();
        this.buttonPanelTop = new JPanel();
        this.bRoll = new JButton();
        this.bAddCombatant = new JButton();
        this.bNextInit = new JButton();
        this.bRefocus = new JButton();
        this.bCombatantReRoll = new JButton();
        this.bDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.lCounter = new JLabel();
        this.jSplitPane1 = new FlippingSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollEvents = new JScrollPane();
        this.combatantTable = new JTable();
        this.tpaneInfo = new JTabbedPane();
        this.tpCombatInfo = new JTextArea();
        this.tpCombatInfo.setName("Events");
        this.bottomToolbar = new JToolBar();
        this.tablePopupCBNumber.setText("#");
        this.tablePopupCBNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.TablePopupActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tablePopupCBNumber);
        this.tablePopupCBName.setText("Name");
        this.tablePopupCBName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.TablePopupActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tablePopupCBName);
        this.tablePopupCBPlayer.setText("Player");
        this.tablePopupCBPlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.TablePopupActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tablePopupCBPlayer);
        this.tablePopupCBStatus.setText("Status");
        this.tablePopupCBStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.TablePopupActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tablePopupCBStatus);
        this.tablePopupCBPlus.setText("Plus");
        this.tablePopupCBPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.TablePopupActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tablePopupCBPlus);
        this.tablePopupCBInitiative.setText("Initiative");
        this.tablePopupCBInitiative.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.TablePopupActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tablePopupCBInitiative);
        this.tablePopupCBDuration.setText("Duration");
        this.tablePopupCBDuration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.TablePopupActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tablePopupCBDuration);
        this.tablePopupCBHP.setText("HP");
        this.tablePopupCBHP.setEnabled(false);
        this.tablePopupCBHP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.TablePopupActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tablePopupCBHP);
        this.tablePopupCBHPMax.setText("HP Max");
        this.tablePopupCBHPMax.setEnabled(false);
        this.tablePopupCBHPMax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.TablePopupActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tablePopupCBHPMax);
        this.tablePopupCBType.setText("Type");
        this.tablePopupCBType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.TablePopupActionPerformed(evt);
            }
        });
        this.tablePopup.add(this.tablePopupCBType);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(700, 600));
        this.buttonPanelTop.setLayout(new BoxLayout(this.buttonPanelTop, 0));
        this.bAddCombatant.setText("Add Combatant");
        this.bAddCombatant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bAddCombatantActionPerformed(evt);
            }
        });
        this.buttonPanelTop.add(this.bAddCombatant);
        this.bDuplicateCombatant.setText("Duplicate");
        this.bDuplicateCombatant.setEnabled(false);
        this.bDuplicateCombatant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bDuplicateCombatantActionPerformed(evt);
            }
        });
        this.bDelete.setText("Delete");
        this.bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bDeleteActionPerformed(evt);
            }
        });
        this.buttonPanelTop.add(this.bDelete);
        this.buttonPanelTop.add(this.bDuplicateCombatant);
        this.buttonPanelTop.add(new JSeparator());
        this.bRoll.setText("Start Combat");
        this.bRoll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bRollActionPerformed(evt);
            }
        });
        this.buttonPanelTop.add(this.bRoll);
        this.bCombatantReRoll.setText("Roll");
        this.bCombatantReRoll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bCombatantReRollActionPerformed(evt);
            }
        });
        this.buttonPanelTop.add(this.bCombatantReRoll);
        this.bNextInit.setText("Next Initiative");
        this.bNextInit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bNextInitActionPerformed(evt);
            }
        });
        this.buttonPanelTop.add(this.bNextInit);
        this.buttonPanelTop.add(new JSeparator());
        this.bRefocus.setText("Refocus");
        this.bRefocus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bRefocusActionPerformed(evt);
            }
        });
        this.buttonPanelTop.add(this.bRefocus);
        this.buttonPanelTop.add(new JSeparator());
        this.bRefresh.setText("Refresh Tabs");
        this.bRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.refreshTable();
                Initiative.this.refreshTabs();
            }
        });
        this.buttonPanelTop.add(this.bRefresh);
        this.topToolbar.add(this.buttonPanelTop);
        this.topToolbar.add(this.jPanel2);
        this.topToolbar.add(this.lCounter);
        this.add((Component)this.topToolbar, "North");
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setPreferredSize(new Dimension(800, 405));
        this.combatantTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Initiative.this.combatantTableMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                Initiative.this.combatantTableMouseReleased(evt);
            }
        });
        this.combatantTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Initiative.this.combatantTablePropertyChange(evt);
            }
        });
        this.combatantTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean hasSelection = Initiative.this.combatantTable.getSelectedRow() > -1;
                Initiative.this.bDuplicateCombatant.setEnabled(hasSelection);
                Initiative.this.bDelete.setEnabled(hasSelection);
                Initiative.this.bCombatantReRoll.setEnabled(hasSelection);
            }
        });
        this.jScrollPane1.setViewportView(this.combatantTable);
        this.jScrollEvents.setViewportView(this.tpCombatInfo);
        this.jSplitPane1.setLeftComponent((Component)this.jScrollPane1);
        this.tpaneInfo.addTab("Events", this.jScrollEvents);
        this.jSplitPane1.setRightComponent((Component)this.tpaneInfo);
        this.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.bottomToolbar, "South");
        this.bottomToolbar.add(this.bOpposedSkill);
    }

    protected void bDuplicateCombatantActionPerformed(ActionEvent evt) {
        NumberFormatter formatter = new NumberFormatter();
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        formatter.setValueClass(Integer.class);
        JFormattedTextField field = new JFormattedTextField(formatter);
        field.setValue(1);
        int choice = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, field, "How many copies?", 2);
        if (choice == 2) {
            return;
        }
        int count = ((Number)field.getValue()).intValue();
        for (InitHolder holderToCopy : this.getSelected()) {
            if (holderToCopy instanceof XMLCombatant || holderToCopy instanceof PcgCombatant) {
                if (holderToCopy instanceof PcgCombatant) {
                    if (((PcgCombatant)holderToCopy).getPC().getFileName() != null && ((PcgCombatant)holderToCopy).getPC().getFileName().length() > 0) {
                        this.pasteNew((Combatant)holderToCopy, count);
                        continue;
                    }
                    JOptionPane.showMessageDialog((Component)GMGenSystem.inst, "Combatant " + holderToCopy.getName() + " cannot be duplicated because it has not been saved to a valid .pcg file.", "Cannot Duplicate", 2);
                    continue;
                }
                this.pasteNew((Combatant)holderToCopy, count);
                continue;
            }
            JOptionPane.showMessageDialog((Component)GMGenSystem.inst, "Combatant " + holderToCopy.getName() + " cannot be duplicated because it is not a PCGen or XML combatant.", "Cannot Duplicate", 2);
        }
    }

    private void initDynamicComponents() {
        this.bSave.setText("Roll Save");
        this.bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bSaveActionPerformed(evt);
            }
        });
        this.bCast.setText("Cast Spell");
        this.bCast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bCastActionPerformed(evt);
            }
        });
        this.bEvent.setText("Start Event");
        this.bEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bEventActionPerformed(evt);
            }
        });
        this.bKill.setText("Kill");
        this.bKill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bKillActionPerformed(evt);
            }
        });
        this.bDamage.setText("Damage");
        this.bDamage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bDamageActionPerformed(evt);
            }
        });
        this.bHeal.setText("Heal");
        this.bHeal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bHealActionPerformed(evt);
            }
        });
        this.bStabilize.setText("Stabilize");
        this.bStabilize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bStabilizeActionPerformed(evt);
            }
        });
        this.bRaise.setText("Raise");
        this.bRaise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.bRaiseActionPerformed(evt);
            }
        });
        this.showDead.setSelected(true);
        this.showDead.setText("Show Dead");
        this.showDead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.showDeadActionPerformed(evt);
            }
        });
        this.showEvents.setSelected(true);
        this.showEvents.setText("Show Events");
        this.showEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Initiative.this.showEventsActionPerformed(evt);
            }
        });
        this.bOpposedSkill.setText("Mass Skill Check");
        this.bOpposedSkill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Initiative.this.opposedSkillActionPerformed(e);
            }
        });
    }

    protected void opposedSkillActionPerformed(ActionEvent e) {
        List<InitHolder> selected = this.getSelected();
        List<InitHolder> notSelected = this.getUnSelected();
        OpposedCheckDialog dlg = new OpposedCheckDialog((Frame)GMGenSystem.inst, selected, notSelected);
        dlg.setModal(true);
        dlg.setVisible(true);
        dlg.dispose();
    }

    private void initTable() {
        this.initTableColumns();
        JTableHeader header = this.combatantTable.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Initiative.this.combatantTableMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                Initiative.this.combatantTableMouseReleased(evt);
            }
        });
        this.columnList = this.getColumnOrder();
        this.combatantTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Initiative.this.listSelectionChaned(e);
            }
        });
        TableColumn typeColumn = this.combatantTable.getColumn("Type");
        String[] values = new String[]{"PC", "Enemy", "Ally", "Non Combatant"};
        typeColumn.setCellEditor(new TypeEditor(values));
    }

    private void initTableColumns() {
        DefaultTableModel tabModel = (DefaultTableModel)this.combatantTable.getModel();
        tabModel.setColumnCount(0);
        int colNo = SettingsHandler.getGMGenOption((String)"Initiative.NumberOfColumns", (int)0);
        int[] widths = new int[colNo];
        for (int i = 0; i < colNo; ++i) {
            String name = SettingsHandler.getGMGenOption((String)("Initiative.ColumnName." + i), (String)"");
            int width = SettingsHandler.getGMGenOption((String)("Initiative.ColumnWidth." + i), (int)100);
            this.addColumn(name, width);
            widths[i] = width;
        }
        this.setColumnWidths(widths);
    }

    private void initTablePopup() {
        TableColumnModel colModel = this.combatantTable.getColumnModel();
        int numCols = colModel.getColumnCount();
        this.tablePopupCBName.setSelected(false);
        this.tablePopupCBPlayer.setSelected(false);
        this.tablePopupCBStatus.setSelected(false);
        this.tablePopupCBPlus.setSelected(false);
        this.tablePopupCBInitiative.setSelected(false);
        this.tablePopupCBDuration.setSelected(false);
        this.tablePopupCBHP.setSelected(false);
        this.tablePopupCBHPMax.setSelected(false);
        this.tablePopupCBNumber.setSelected(false);
        this.tablePopupCBType.setSelected(false);
        for (int i = 0; i < numCols; ++i) {
            TableColumn col = colModel.getColumn(i);
            String name = col.getIdentifier().toString();
            if (name.equals("Name")) {
                this.tablePopupCBName.setSelected(true);
                continue;
            }
            if (name.equals("Player")) {
                this.tablePopupCBPlayer.setSelected(true);
                continue;
            }
            if (name.equals("Status")) {
                this.tablePopupCBStatus.setSelected(true);
                continue;
            }
            if (name.equals("+")) {
                this.tablePopupCBPlus.setSelected(true);
                continue;
            }
            if (name.equals("Init")) {
                this.tablePopupCBInitiative.setSelected(true);
                continue;
            }
            if (name.equals("Dur")) {
                this.tablePopupCBDuration.setSelected(true);
                continue;
            }
            if (name.equals("HP")) {
                this.tablePopupCBHP.setSelected(true);
                continue;
            }
            if (name.equals("HP Max")) {
                this.tablePopupCBHPMax.setSelected(true);
                continue;
            }
            if (name.equals("#")) {
                this.tablePopupCBNumber.setSelected(true);
                continue;
            }
            if (!name.equals("Type")) continue;
            this.tablePopupCBType.setSelected(true);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doSpells", (boolean)true) || SettingsHandler.getGMGenOption((String)"Initiative.doDeath", (boolean)true) || SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true)) {
            this.tablePopupCBDuration.setEnabled(true);
        } else {
            this.tablePopupCBDuration.setEnabled(false);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true)) {
            this.tablePopupCBHP.setEnabled(true);
            this.tablePopupCBHPMax.setEnabled(true);
        } else {
            this.tablePopupCBHP.setEnabled(false);
            this.tablePopupCBHPMax.setEnabled(false);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doNumber", (boolean)true)) {
            this.tablePopupCBNumber.setEnabled(true);
        }
    }

    private void refreshEventTab() {
        this.tpCombatInfo.setText("");
        for (int i = 0; i < this.initList.size(); ++i) {
            InitHolder iH = (InitHolder)this.initList.get(i);
            StringBuilder sb = new StringBuilder();
            if (iH instanceof Event) {
                Event evt = (Event)iH;
                sb.append(evt.getName() + " (" + evt.getPlayer() + ")\n");
                sb.append("Duration: " + evt.getDuration() + "\n");
                if (evt.getEffect().length() > 0) {
                    sb.append(evt.getEffect() + "\n\n");
                } else {
                    sb.append("\n");
                }
            }
            this.tpCombatInfo.setText(this.tpCombatInfo.getText() + sb);
        }
    }

    private void removeColumn(String name) {
        TableColumnModel colModel = this.combatantTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (!col.getHeaderValue().toString().equals(name)) continue;
            colModel.removeColumn(col);
        }
        this.trackTable();
        this.initTable();
        this.columnList = this.getColumnOrder();
    }

    private void showDeadActionPerformed(ActionEvent evt) {
        this.checkDeadTabs();
        this.refreshTable();
        this.focusNextInit();
    }

    private void showEventsActionPerformed(ActionEvent evt) {
        this.refreshTable();
        this.focusNextInit();
        SettingsHandler.setGMGenOption((String)"Initiative.ShowEvents", (boolean)this.showEvents.isSelected());
    }

    private void trackTable() {
        TableColumnModel colModel = this.combatantTable.getColumnModel();
        int numCols = colModel.getColumnCount();
        SettingsHandler.setGMGenOption((String)"Initiative.NumberOfColumns", (int)numCols);
        for (int i = 0; i < numCols; ++i) {
            TableColumn col = colModel.getColumn(i);
            String name = col.getIdentifier().toString();
            SettingsHandler.setGMGenOption((String)("Initiative.ColumnName." + i), (String)name);
            SettingsHandler.setGMGenOption((String)("Initiative.ColumnWidth." + i), (int)col.getWidth());
        }
    }

    public void initHolderUpdated(InitHolder iH) {
        if (iH instanceof Combatant) {
            this.combatantUpdated((Combatant)iH);
        }
    }

    public void combatantUpdated(Combatant cbt) {
        this.messageHandler.handleMessage((PCGenMessage)new CombatantHasBeenUpdatedMessage((Object)GMGenSystem.inst, cbt));
    }

    public static class TypeRenderer
    extends JComboBox
    implements TableCellRenderer {
        public TypeRenderer(String[] items) {
            super(items);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }

    public static class TypeEditor
    extends DefaultCellEditor {
        public TypeEditor(String[] items) {
            super(new JComboBox<String>(items));
        }
    }
}

