/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CategorizedCDOMReference;
import pcgen.cdom.reference.Qualifier;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Campaign;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.StringPClassUtil;

public class ForwardRefToken
extends AbstractTokenWithSeparator<Campaign>
implements CDOMPrimaryToken<Campaign> {
    public String getTokenName() {
        return "FORWARDREF";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Campaign obj, String value) {
        int pipeLoc = value.indexOf(124);
        if (pipeLoc == -1) {
            return new ParseResult.Fail(this.getTokenName() + " requires at least two arguments, " + "ReferenceType and Key: " + value, context);
        }
        if (value.lastIndexOf(124) != pipeLoc) {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage(this.getTokenName() + " requires at only two pipe separated arguments, " + "ReferenceType and Keys: " + value);
            cpr.addErrorMessage("  keys are comma separated");
            return cpr;
        }
        String firstToken = value.substring(0, pipeLoc);
        ReferenceManufacturer rm = context.getManufacturer(firstToken);
        if (rm == null) {
            return new ParseResult.Fail(this.getTokenName() + " unable to generate manufacturer for type: " + value, context);
        }
        String rest = value.substring(pipeLoc + 1);
        if (this.hasIllegalSeparator(',', rest)) {
            return new ParseResult.Fail(this.getTokenName() + " keys are comma separated", context);
        }
        StringTokenizer st = new StringTokenizer(rest, ",");
        while (st.hasMoreTokens()) {
            CDOMSingleRef ref = rm.getReference(st.nextToken());
            context.getObjectContext().addToList((CDOMObject)obj, ListKey.FORWARDREF, (Object)new Qualifier(rm.getReferenceClass(), ref));
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Campaign obj) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)obj, ListKey.FORWARDREF);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection quals = changes.getAdded();
        HashMapToList map = new HashMapToList();
        for (Qualifier qual : quals) {
            Class cl = qual.getQualifiedClass();
            String s = StringPClassUtil.getStringFor((Class)cl);
            CDOMSingleRef ref = qual.getQualifiedReference();
            String key = s;
            if (ref instanceof CategorizedCDOMReference) {
                String cat = ((CategorizedCDOMReference)ref).getLSTCategory();
                key = "FEAT".equals(cat) ? "FEAT" : key + '=' + cat;
            }
            map.addToListFor((Object)key, (Object)ref);
        }
        TreeSet set = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        TreeSet<String> returnSet = new TreeSet<String>();
        for (String key : map.getKeySet()) {
            set.clear();
            set.addAll(map.getListFor((Object)key));
            StringBuilder sb = new StringBuilder();
            sb.append(key).append("|").append(ReferenceUtilities.joinLstFormat(set, (String)","));
            returnSet.add(sb.toString());
        }
        return returnSet.toArray(new String[returnSet.size()]);
    }

    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

