/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.Collection;
import java.util.List;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.BonusCheckingFacet;
import pcgen.cdom.facet.base.AbstractStorageFacet;

public class BonusChangeFacet
extends AbstractStorageFacet<CharID> {
    private final BonusChangeSupport support = new BonusChangeSupport();
    private BonusCheckingFacet bonusCheckingFacet;

    public void reset(CharID id) {
        DoubleKeyMap<String, String, Double> map = this.getConstructingInfo(id);
        for (String type : this.support.getBonusTypes()) {
            for (String name : this.support.getBonusNames(type)) {
                Double oldValue;
                Double newValue = this.bonusCheckingFacet.getBonus(id, type, name);
                if (newValue.equals(oldValue = (Double)map.get((Object)type, (Object)name))) continue;
                map.put((Object)type, (Object)name, (Object)newValue);
                this.support.fireBonusChange(id, type, name, oldValue, newValue);
            }
        }
    }

    private DoubleKeyMap<String, String, Double> getConstructingInfo(CharID id) {
        DoubleKeyMap map = this.getInfo(id);
        if (map == null) {
            map = new DoubleKeyMap();
            this.setCache(id, map);
        }
        return map;
    }

    private DoubleKeyMap<String, String, Double> getInfo(CharID id) {
        return (DoubleKeyMap)this.getCache(id);
    }

    public void addBonusChangeListener(BonusChangeListener listener, String type, String name) {
        this.support.addBonusChangeListener(listener, type, name);
    }

    public void removeBonusChangeListener(BonusChangeListener listener, String type, String name) {
        this.support.removeBonusChangeListener(listener, type, name);
    }

    public void setBonusCheckingFacet(BonusCheckingFacet bonusCheckingFacet) {
        this.bonusCheckingFacet = bonusCheckingFacet;
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        DoubleKeyMap<String, String, Double> map = this.getInfo(source);
        if (map != null) {
            this.getConstructingInfo(copy).putAll(map);
        }
    }

    public static class BonusChangeSupport {
        private DoubleKeyMapToList<String, String, BonusChangeListener> listeners = new DoubleKeyMapToList();

        public synchronized void addBonusChangeListener(BonusChangeListener listener, String type, String name) {
            this.listeners.addToListFor((Object)type, (Object)name, (Object)listener);
        }

        public Collection<String> getBonusTypes() {
            return this.listeners.getKeySet();
        }

        public Collection<String> getBonusNames(String type) {
            return this.listeners.getSecondaryKeySet((Object)type);
        }

        public synchronized void removeBonusChangeListener(BonusChangeListener listener, String type, String name) {
            this.listeners.removeFromListFor((Object)type, (Object)name, (Object)listener);
        }

        public synchronized BonusChangeListener[] getBonusChangeListeners(String type, String name) {
            return this.listeners.getListFor((Object)type, (Object)name).toArray(new BonusChangeListener[0]);
        }

        public void fireBonusChange(CharID id, String type, String name, Number oldValue, Number newValue) {
            BonusChangeEvent bce = new BonusChangeEvent(id, type, name, oldValue, newValue);
            List localListeners = this.listeners.getListFor((Object)type, (Object)name);
            if (localListeners != null) {
                for (BonusChangeListener target : localListeners) {
                    target.bonusChange(bce);
                }
            }
        }
    }

    public static class BonusChangeEvent {
        private final CharID charID;
        private final String bonusType;
        private final String bonusName;
        private final Number oldVal;
        private final Number newVal;

        public BonusChangeEvent(CharID id, String type, String name, Number oldValue, Number newValue) {
            this.charID = id;
            this.bonusType = type;
            this.bonusName = name;
            this.oldVal = oldValue;
            this.newVal = newValue;
        }

        public CharID getCharID() {
            return this.charID;
        }

        public String getBonusType() {
            return this.bonusType;
        }

        public String getBonusName() {
            return this.bonusName;
        }

        public Number getOldVal() {
            return this.oldVal;
        }

        public Number getNewVal() {
            return this.newVal;
        }
    }

    public static interface BonusChangeListener {
        public void bonusChange(BonusChangeEvent var1);
    }
}

