/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.helper.ProfProvider;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Equipment;

public abstract class AbstractProfProvider<T extends CDOMObject>
extends ConcretePrereqObject
implements ProfProvider<T> {
    private final Set<CDOMReference<T>> direct = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
    private final Set<CDOMReference<Equipment>> byEquipType;

    public AbstractProfProvider(List<CDOMReference<T>> profs, List<CDOMReference<Equipment>> equipTypes) {
        this.direct.addAll(profs);
        this.byEquipType = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        this.byEquipType.addAll(equipTypes);
    }

    @Override
    public abstract boolean providesProficiencyFor(Equipment var1);

    @Override
    public boolean providesProficiency(T proficiency) {
        for (CDOMReference<T> ref : this.direct) {
            if (!ref.contains(proficiency)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean providesEquipmentType(String typeString) {
        if (typeString == null || typeString.length() == 0) {
            return false;
        }
        TreeSet<String> types = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String s : typeString.split("\\.")) {
            types.add(s);
        }
        block1: for (CDOMReference<Equipment> ref : this.byEquipType) {
            StringTokenizer tok = new StringTokenizer(ref.getLSTformat(false).substring(5), ".");
            while (tok.hasMoreTokens()) {
                if (types.contains(tok.nextToken())) continue;
                continue block1;
            }
            return true;
        }
        return false;
    }

    protected abstract String getSubType();

    @Override
    public String getLstFormat() {
        StringBuilder sb = new StringBuilder();
        boolean typeEmpty = this.byEquipType.isEmpty();
        if (!this.direct.isEmpty()) {
            sb.append(ReferenceUtilities.joinLstFormat(this.direct, "|"));
            if (!typeEmpty) {
                sb.append("|");
            }
        }
        if (!typeEmpty) {
            boolean needPipe = false;
            String subType = this.getSubType();
            String dot = ".";
            for (CDOMReference<Equipment> ref : this.byEquipType) {
                if (needPipe) {
                    sb.append("|");
                }
                needPipe = true;
                String lstFormat = ref.getLSTformat(false);
                if (!lstFormat.startsWith("TYPE=")) continue;
                sb.append(subType).append("TYPE=");
                StringTokenizer st = new StringTokenizer(lstFormat.substring(5), dot);
                boolean needDot = false;
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (tok.equals(subType)) continue;
                    if (needDot) {
                        sb.append(dot);
                    }
                    needDot = true;
                    sb.append(tok);
                }
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractProfProvider) {
            AbstractProfProvider other = (AbstractProfProvider)obj;
            if (!other.getSubType().equals(this.getSubType())) {
                return false;
            }
            if (this.direct == null ? other.direct != null : !this.direct.equals(other.direct)) {
                return false;
            }
            if (this.byEquipType == null ? other.byEquipType != null : !this.byEquipType.equals(other.byEquipType)) {
                return false;
            }
            return this.equalsPrereqObject(other);
        }
        return false;
    }

    public int hashCode() {
        return (this.direct == null ? 0 : this.direct.hashCode() * 29) + (this.byEquipType == null ? 0 : this.byEquipType.hashCode());
    }
}

