/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.meta;

import java.util.Collection;
import java.util.HashMap;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.QualifyingObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.base.AbstractItemConvertingFacet;
import pcgen.cdom.facet.base.AbstractQualifiedListFacet;
import pcgen.cdom.facet.base.AbstractSingleSourceListFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.meta.ConvertingFacetView;
import pcgen.cdom.meta.CorePerspective;
import pcgen.cdom.meta.FacetBehavior;
import pcgen.cdom.meta.FacetView;
import pcgen.cdom.meta.ListFacetView;
import pcgen.cdom.meta.PerspectiveLocation;
import pcgen.cdom.meta.QualifiedFacetView;
import pcgen.cdom.meta.SingleSourceListFacetView;

public final class CorePerspectiveDB {
    private static DoubleKeyMap<CorePerspective, Object, FacetView<?>> map = new DoubleKeyMap();
    private static HashMap<CorePerspective, FacetView<?>> rootmap = new HashMap();
    private static HashMap<Object, FacetView<?>> facetToView = new HashMap();
    private static HashMap<Object, CorePerspective> facetToPerspective = new HashMap();
    private static HashMapToList<Object, Object> virtualParents = new HashMapToList();

    private CorePerspectiveDB() {
    }

    public static <S, D> Object register(CorePerspective perspective, FacetBehavior behavior, AbstractItemConvertingFacet<S, D> facet) {
        ConvertingFacetView<S, D> view = new ConvertingFacetView<S, D>(facet);
        CorePerspectiveDB.finishRegistration(perspective, behavior, view, facet);
        return view;
    }

    public static <T> Object register(CorePerspective perspective, FacetBehavior behavior, AbstractSourcedListFacet<CharID, T> facet) {
        ListFacetView<T> view = new ListFacetView<T>(facet);
        CorePerspectiveDB.finishRegistration(perspective, behavior, view, facet);
        return view;
    }

    public static <T> Object register(CorePerspective perspective, FacetBehavior behavior, AbstractSingleSourceListFacet<T, ?> facet) {
        SingleSourceListFacetView<T> view = new SingleSourceListFacetView<T>(facet);
        CorePerspectiveDB.finishRegistration(perspective, behavior, view, facet);
        return view;
    }

    public static <T extends QualifyingObject> Object register(CorePerspective perspective, FacetBehavior behavior, AbstractQualifiedListFacet<T> facet) {
        QualifiedFacetView<T> view = new QualifiedFacetView<T>(facet);
        CorePerspectiveDB.finishRegistration(perspective, behavior, view, facet);
        return view;
    }

    private static void finishRegistration(CorePerspective perspective, FacetBehavior behavior, FacetView<?> view, Object f) {
        Object location = behavior;
        if (f instanceof PerspectiveLocation) {
            location = new Location(behavior, ((PerspectiveLocation)f).getIdentity());
        }
        map.put((Object)perspective, location, view);
        facetToView.put(f, view);
        facetToPerspective.put(f, perspective);
        if (FacetBehavior.MODEL.equals(behavior)) {
            rootmap.put(perspective, view);
        }
    }

    public static Collection<CorePerspective> getPerspectives() {
        return map.getKeySet();
    }

    public static Collection<Object> getLocations(CorePerspective perspective) {
        return map.getSecondaryKeySet((Object)perspective);
    }

    public static <T> FacetView<T> getView(CorePerspective perspective, Object location) {
        FacetView facetView = (FacetView)map.get((Object)perspective, location);
        return facetView;
    }

    public static <T> FacetView<T> getRootFacet(CorePerspective perspective) {
        FacetView<?> facetView = rootmap.get(perspective);
        return facetView;
    }

    public static <T> FacetView<T> getViewOfFacet(Object o) {
        FacetView<?> facetView = facetToView.get(o);
        return facetView;
    }

    public static <T> CorePerspective getPerspectiveOfFacet(Object o) {
        return facetToPerspective.get(o);
    }

    public static void registerVirtualParent(Object obj, Object parent) {
        FacetView<?> view = facetToView.get(obj);
        if (view == null) {
            throw new IllegalStateException("Cannot register virtual parent when object is not yet registered");
        }
        virtualParents.addToListFor(view, parent);
    }

    public static Collection<Object> getVirtualParents(Object obj) {
        return virtualParents.getListFor(obj);
    }

    private static class Location {
        private final String location;

        public Location(FacetBehavior behavior, String source) {
            this.location = new StringBuilder(40).append(behavior).append(" (").append(source).append(")").toString();
        }

        public String toString() {
            return this.location;
        }
    }
}

