/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.processor;

import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.Processor;

public class HitDieStep
implements Processor<HitDie> {
    private final int numSteps;
    private final HitDie dieLimit;

    public HitDieStep(int steps, HitDie stopAt) {
        if (steps == 0) {
            throw new IllegalArgumentException();
        }
        this.numSteps = steps;
        this.dieLimit = stopAt;
    }

    @Override
    public HitDie applyProcessor(HitDie origHD, Object context) {
        int steps = this.numSteps;
        HitDie currentDie = origHD;
        while (steps != 0) {
            if (currentDie.equals(this.dieLimit)) {
                return currentDie;
            }
            if (steps > 0) {
                currentDie = currentDie.getNext();
                --steps;
                continue;
            }
            assert (steps < 0);
            currentDie = currentDie.getPrevious();
            ++steps;
        }
        return currentDie;
    }

    @Override
    public String getLSTformat() {
        StringBuilder sb = new StringBuilder();
        sb.append('%');
        if (this.dieLimit == null) {
            sb.append('H');
        }
        if (this.numSteps > 0) {
            sb.append("up");
        } else {
            sb.append("down");
        }
        sb.append(Math.abs(this.numSteps));
        return sb.toString();
    }

    @Override
    public Class<HitDie> getModifiedClass() {
        return HitDie.class;
    }

    public int hashCode() {
        return this.dieLimit == null ? this.numSteps : this.numSteps + this.dieLimit.hashCode() * 29;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HitDieStep) {
            HitDieStep other = (HitDieStep)obj;
            return other.numSteps == this.numSteps && (this.dieLimit == null && other.dieLimit == null || this.dieLimit != null && this.dieLimit.equals(other.dieLimit));
        }
        return false;
    }
}

