/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.facet.EquipmentTypeFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.ChooseActivation;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.SignedInteger;
import pcgen.util.enumeration.Visibility;

public final class EquipmentChoice {
    private EquipmentTypeFacet equipmentTypeFacet = FacetLibrary.getFacet(EquipmentTypeFacet.class);
    private boolean allowDuplicates = false;
    private boolean noSign = false;
    private boolean bAdd = false;
    private boolean skipZero = false;
    private int minValue = 0;
    private int maxValue = 0;
    private int incValue = 1;
    private int maxSelect = 0;
    private int pool = 0;
    private String title = null;
    private List<Object> availableList = new ArrayList<Object>();

    public EquipmentChoice(boolean bAdd, int pool) {
        this.bAdd = bAdd;
        this.pool = pool;
    }

    EquipChoiceIterator getChoiceIterator(boolean neverEmpty) {
        List<Object> finalList;
        if (neverEmpty && this.availableList.isEmpty()) {
            ArrayList<Object> temp = new ArrayList<Object>();
            temp.add("");
            return new EquipChoiceIterator(temp);
        }
        if (this.getMinValue() < this.getMaxValue()) {
            finalList = new ArrayList<Object>();
            for (int i = 0; i < this.availableList.size(); ++i) {
                String choice = String.valueOf(this.availableList.get(i));
                if (choice.indexOf(124) < 0) {
                    for (int j = this.getMinValue(); j <= this.getMaxValue(); j += this.getIncValue()) {
                        if (this.skipZero && j == 0) continue;
                        finalList.add(choice + '|' + Delta.toString(j));
                    }
                    continue;
                }
                finalList.add(choice);
            }
        } else {
            finalList = this.availableList;
        }
        return new EquipChoiceIterator(finalList);
    }

    final int getPool() {
        return this.pool;
    }

    final void setPool(int pool) {
        this.pool = pool;
    }

    public final boolean isBAdd() {
        return this.bAdd;
    }

    final void setBAdd(boolean add) {
        this.bAdd = add;
    }

    public final List<Object> getAvailableList() {
        return this.availableList;
    }

    public final boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    final void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public final int getIncValue() {
        return this.incValue;
    }

    final void setIncValue(int incValue) {
        this.incValue = incValue;
    }

    public final int getMaxSelect() {
        return this.maxSelect;
    }

    final void setMaxSelect(int maxSelect) {
        this.maxSelect = maxSelect;
    }

    public final int getMaxValue() {
        return this.maxValue;
    }

    final void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public final int getMinValue() {
        return this.minValue;
    }

    final void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    final boolean isNoSign() {
        return this.noSign;
    }

    final void setNoSign(boolean noSign) {
        this.noSign = noSign;
    }

    public final String getTitle() {
        return this.title;
    }

    final void setTitle(String title) {
        this.title = title;
    }

    public void addSkills() {
        for (Skill skill : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Skill.class)) {
            this.getAvailableList().add(skill.getKeyName());
        }
    }

    public void setMinValueFromString(String minString) {
        try {
            this.setMinValue(Delta.parseInt(minString.substring(4)));
        }
        catch (NumberFormatException e) {
            Logging.errorPrint("Bad MIN= value: " + minString);
        }
    }

    public void setMaxValueFromString(String maxString) {
        try {
            this.setMaxValue(Delta.parseInt(maxString.substring(4)));
        }
        catch (NumberFormatException e) {
            Logging.errorPrint("Bad MAX= value: " + maxString);
        }
    }

    public void setIncrementValueFromString(String incString) {
        try {
            this.setIncValue(Delta.parseInt(incString.substring(10)));
            if (this.getIncValue() < 1) {
                this.setIncValue(1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void addSelectableAbilities(String typeString, String aCategory) {
        AbstractReferenceContext ref = Globals.getContext().getReferenceContext();
        AbilityCategory cat = ref.silentlyGetConstructedCDOMObject(AbilityCategory.class, aCategory);
        for (Ability anAbility : ref.getManufacturer(Ability.class, cat).getAllObjects()) {
            boolean matchesType;
            boolean bl = matchesType = typeString.equalsIgnoreCase("ALL") || anAbility.isType(typeString);
            if (anAbility.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT || this.getAvailableList().contains(anAbility.getKeyName()) || !matchesType || ChooseActivation.hasNewChooseToken(anAbility)) continue;
            this.getAvailableList().add(anAbility.getKeyName());
        }
    }

    public void addSelectableEquipment(String typeString) {
        for (Equipment aEquip : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Equipment.class)) {
            if (!aEquip.isType(typeString) || this.getAvailableList().contains(aEquip.getName())) continue;
            this.getAvailableList().add(aEquip.getName());
        }
    }

    public void addSelectableSkills(String typeString) {
        for (Skill skill : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Skill.class)) {
            if (!typeString.equalsIgnoreCase("ALL") && !skill.isType(typeString) || this.getAvailableList().contains(skill.getKeyName())) continue;
            this.getAvailableList().add(skill.getKeyName());
        }
    }

    public void addParentsExistingEquipmentModifiersToChooser(Equipment parent, String choiceType) {
        for (EquipmentModifier sibling : parent.getEqModifierList(true)) {
            if (sibling.equals(this) || !sibling.getSafe(StringKey.CHOICE_STRING).startsWith(choiceType)) continue;
            this.getAvailableList().addAll(parent.getAssociationList(sibling));
        }
    }

    public void addChoicesByType(Equipment parent, int numOfChoices, int numChosen, String filterBy, String kindToAdd, String category) {
        String type;
        if (numOfChoices > 0 && this.getMaxSelect() == 0) {
            this.setPool(numOfChoices - numChosen);
        }
        if ((type = filterBy.substring(5)).startsWith("LASTCHOICE")) {
            this.addParentsExistingEquipmentModifiersToChooser(parent, kindToAdd);
        } else if ("SKILL".equalsIgnoreCase(kindToAdd)) {
            this.addSelectableSkills(type);
        } else if ("EQUIPMENT".equalsIgnoreCase(kindToAdd)) {
            this.addSelectableEquipment(type);
        } else if ("ABILITY".equalsIgnoreCase(kindToAdd)) {
            this.addSelectableAbilities(type, category);
        } else if ("FEAT".equalsIgnoreCase(kindToAdd)) {
            this.addSelectableAbilities(type, "FEAT");
        } else if ("EQTYPES".equalsIgnoreCase(type)) {
            Collection types = this.equipmentTypeFacet.getSet(Globals.getContext().getDataSetID());
            List<Object> list = this.getAvailableList();
            for (Type t : types) {
                list.add(t.toString());
            }
        } else {
            Logging.errorPrint("Unknown option in CHOOSE '" + filterBy + "'");
        }
    }

    public void addStats() {
        for (PCStat stat : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(PCStat.class)) {
            this.getAvailableList().add(stat.getKeyName());
        }
    }

    public void adjustPool(int available, int numSelected) {
        if (available > 0 && this.getMaxSelect() > 0 && this.getMaxSelect() != Integer.MAX_VALUE) {
            this.setPool(this.getMaxSelect() - numSelected);
        }
    }

    public void constructFromChoiceString(String choiceString, Equipment parent, int available, int numSelected, boolean forEqBuilder, PlayerCharacter pc) {
        StringTokenizer titleTok = new StringTokenizer(choiceString, "|", false);
        while (!forEqBuilder && titleTok.hasMoreTokens()) {
            String workingkind = titleTok.nextToken();
            if (!workingkind.startsWith("TITLE=")) continue;
            this.setTitle(workingkind.substring(6));
        }
        int select = parent.getSafe(FormulaKey.SELECT).resolve(parent, true, pc, "").intValue();
        this.setMaxSelect(select);
        String originalkind = null;
        StringTokenizer aTok = new StringTokenizer(choiceString, "|", false);
        boolean needStats = false;
        boolean needSkills = false;
        String category = null;
        while (!forEqBuilder && aTok.hasMoreTokens()) {
            String kind = aTok.nextToken();
            if (category == null) {
                category = kind.equals("ABILITY") ? aTok.nextToken() : "FEAT";
            }
            this.adjustPool(available, numSelected);
            if (kind.startsWith("TITLE=") || kind.startsWith("COUNT=")) continue;
            if (originalkind == null) {
                originalkind = kind;
                needStats = originalkind.equals("STATBONUS");
                needSkills = originalkind.equals("SKILLBONUS");
                continue;
            }
            if (kind.startsWith("TYPE=") || kind.startsWith("TYPE.")) {
                if (originalkind.equals("SKILLBONUS") || originalkind.equals("SKILL")) {
                    needSkills = false;
                    this.addChoicesByType(parent, available, numSelected, kind, "SKILL", "");
                    continue;
                }
                if (originalkind.equals("EQUIPMENT") || originalkind.equals("FEAT") || originalkind.equals("ABILITY")) {
                    this.addChoicesByType(parent, available, numSelected, kind, originalkind, category);
                    continue;
                }
                this.addChoicesByType(parent, available, numSelected, kind, this.getTitle(), category);
                continue;
            }
            if ("STAT".equals(kind)) {
                this.addStats();
                continue;
            }
            if ("SKILL".equals(kind) || originalkind.equals("SKILL") && "ANY".equals("SKILL")) {
                this.addSkills();
                continue;
            }
            if ("SKILL".equals(kind)) {
                this.addSkills();
                continue;
            }
            if ("SKIPZERO".equals(kind)) {
                this.skipZero = originalkind.equals("NUMBER");
                continue;
            }
            if ("MULTIPLE".equals(kind)) {
                this.setAllowDuplicates(true);
                continue;
            }
            if ("NOSIGN".equals(kind)) {
                this.setNoSign(true);
                continue;
            }
            if (kind.startsWith("MIN=")) {
                this.setMinValueFromString(kind);
                continue;
            }
            if (kind.startsWith("MAX=")) {
                this.setMaxValueFromString(kind);
                continue;
            }
            if (kind.startsWith("INCREMENT=")) {
                this.setIncrementValueFromString(kind);
                continue;
            }
            needStats = false;
            needSkills = false;
            if (this.getAvailableList().contains(kind)) continue;
            this.getAvailableList().add(kind);
        }
        if (needStats) {
            this.addStats();
        } else if (needSkills) {
            this.addSkills();
        }
        if (this.getTitle() == null) {
            this.setTitle(originalkind);
        }
        if (this.getMaxSelect() == Integer.MAX_VALUE) {
            this.setPool(this.getAvailableList().size() - numSelected);
            this.setBAdd(true);
        }
        if (this.getAvailableList().size() == 0 && this.getMinValue() < this.getMaxValue()) {
            for (int j = this.getMinValue(); j <= this.getMaxValue(); j += this.getIncValue()) {
                if (this.skipZero && j == 0) continue;
                if (this.isNoSign()) {
                    this.getAvailableList().add(j);
                    continue;
                }
                this.getAvailableList().add(new SignedInteger(j));
            }
            this.setMinValue(this.getMaxValue());
        }
    }

    private static class EquipChoiceIterator
    implements Iterator<Object> {
        List<Object> choiceList;
        int currPos;

        EquipChoiceIterator(List<Object> list) {
            this.choiceList = list;
            this.currPos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currPos < this.choiceList.size();
        }

        @Override
        public Object next() {
            return this.choiceList.get(this.currPos++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

