/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.OutputNameFormatting;

public class QualifiedName {
    public static String qualifiedName(PlayerCharacter pc, List<CNAbility> list) {
        Ability a = AbilityUtilities.validateCNAList(list);
        String outputName = OutputNameFormatting.getOutputName(a);
        if ("[BASE]".equalsIgnoreCase(outputName)) {
            return a.getDisplayName();
        }
        StringBuilder aStrBuf = new StringBuilder(outputName);
        ChooseInformation<?> chooseInfo = a.get(ObjectKey.CHOOSE_INFO);
        if (chooseInfo != null) {
            QualifiedName.processChooseInfo(aStrBuf, pc, chooseInfo, list);
        }
        return aStrBuf.toString();
    }

    private static <T> void processChooseInfo(StringBuilder aStrBuf, PlayerCharacter pc, ChooseInformation<T> chooseInfo, List<CNAbility> list) {
        ArrayList allSelections = new ArrayList();
        for (CNAbility cna : list) {
            if (!pc.hasAssociations(cna)) continue;
            List<?> selections = pc.getDetailedAssociations(cna);
            allSelections.addAll(selections);
        }
        String choiceInfo = chooseInfo.composeDisplay(allSelections).toString();
        if (choiceInfo.length() > 0) {
            aStrBuf.append(" (");
            aStrBuf.append(choiceInfo);
            aStrBuf.append(")");
        }
    }

    public static String qualifiedName(PlayerCharacter pc, Skill s) {
        String outputName = OutputNameFormatting.getOutputName(s);
        if (!pc.hasAssociations(s)) {
            return outputName;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append(outputName).append("(");
        List<String> associationList = pc.getAssociationList(s);
        Collections.sort(associationList);
        buffer.append((CharSequence)StringUtil.joinToStringBuilder(associationList, (String)", "));
        buffer.append(")");
        return buffer.toString();
    }
}

