/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.display;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SkillsOutputOrder;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.SkillComparator;
import pcgen.util.enumeration.View;
import pcgen.util.enumeration.Visibility;

public class SkillDisplay {
    public static List<Skill> getSkillListInOutputOrder(final PlayerCharacter pc, List<Skill> skills) {
        Collections.sort(skills, new Comparator<Skill>(){

            @Override
            public int compare(Skill skill1, Skill skill2) {
                Integer obj1Index = pc.getSkillOrder(skill1);
                Integer obj2Index = pc.getSkillOrder(skill2);
                if (obj1Index == null || obj1Index == 0) {
                    obj1Index = 999;
                }
                if (obj2Index == null || obj2Index == 0) {
                    obj2Index = 999;
                }
                if (obj1Index > obj2Index) {
                    return 1;
                }
                if (obj1Index < obj2Index) {
                    return -1;
                }
                return skill1.getOutputName().compareToIgnoreCase(skill2.getOutputName());
            }
        });
        Iterator<Skill> i = skills.iterator();
        while (i.hasNext()) {
            Skill bSkill = i.next();
            Visibility skVis = bSkill.getSafe(ObjectKey.VISIBILITY);
            Integer outputIndex = pc.getSkillOrder(bSkill);
            if ((outputIndex == null || outputIndex != -1) && !skVis.isVisibleTo(View.HIDDEN_EXPORT) && bSkill.qualifies(pc, null)) continue;
            i.remove();
        }
        return skills;
    }

    public static List<Skill> getSkillListInOutputOrder(PlayerCharacter pc) {
        return SkillDisplay.getSkillListInOutputOrder(pc, new ArrayList<Skill>(pc.getSkillSet()));
    }

    public static void updateSkillsOutputOrder(PlayerCharacter pc, Skill aSkill) {
        if (pc.getSkillsOutputOrder() != SkillsOutputOrder.MANUAL) {
            SkillDisplay.resortSelected(pc, pc.getSkillsOutputOrder());
        } else {
            Integer outputIndex = pc.getSkillOrder(aSkill);
            if (outputIndex == null || outputIndex == 0) {
                pc.setSkillOrder(aSkill, SkillDisplay.getHighestOutputIndex(pc) + 1);
            }
        }
    }

    public static void resortSelected(PlayerCharacter pc, SkillsOutputOrder sortSelection) {
        int sort = -1;
        boolean sortOrder = false;
        switch (sortSelection) {
            case NAME_ASC: {
                sort = 0;
                sortOrder = true;
                break;
            }
            case NAME_DSC: {
                sort = 0;
                sortOrder = false;
                break;
            }
            case TRAINED_ASC: {
                sort = 1;
                sortOrder = true;
                break;
            }
            case TRAINED_DSC: {
                sort = 1;
                sortOrder = false;
                break;
            }
            default: {
                return;
            }
        }
        SkillDisplay.resortSelected(pc, sort, sortOrder);
    }

    private static void resortSelected(PlayerCharacter pc, int sort, boolean sortOrder) {
        if (pc == null) {
            return;
        }
        SkillComparator comparator = new SkillComparator(pc, sort, sortOrder);
        int nextOutputIndex = 1;
        ArrayList<Skill> skillList = new ArrayList<Skill>(pc.getSkillSet());
        Collections.sort(skillList, comparator);
        for (Skill aSkill : skillList) {
            Integer outputIndex = pc.getSkillOrder(aSkill);
            if (outputIndex != null && outputIndex < 0) continue;
            pc.setSkillOrder(aSkill, nextOutputIndex++);
        }
    }

    private static int getHighestOutputIndex(PlayerCharacter pc) {
        int maxOutputIndex = 0;
        ArrayList<Skill> skillList = new ArrayList<Skill>(pc.getSkillSet());
        for (Skill bSkill : skillList) {
            Integer outputIndex = pc.getSkillOrder(bSkill);
            if (outputIndex == null || outputIndex <= maxOutputIndex) continue;
            maxOutputIndex = outputIndex;
        }
        return maxOutputIndex;
    }
}

