/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.base.util.NamedFormula;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.EqModRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.EquipmentUtilities;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.SizeAdjustment;
import pcgen.core.character.EquipSet;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitTable;

public final class KitGear
extends BaseKit {
    private Formula quantity;
    private Integer maxCost;
    private CDOMReference<Equipment> equip;
    private List<EqModRef> mods;
    private String theLocationStr = null;
    private Boolean sizeToPC;
    private CDOMSingleRef<SizeAdjustment> size;
    private transient Formula actingQuantity;
    private transient Integer actingCost;
    private transient List<EqModRef> actingMods;
    private transient String actingLocation;
    private transient SizeAdjustment actingSize;
    private transient Equipment theEquipment = null;
    private transient int theQty = 0;
    private transient String theLocation = "";
    private transient BigDecimal theCost = BigDecimal.ZERO;
    private List<NamedFormula> lookupList;

    public void setLocation(String aLocation) {
        this.theLocationStr = aLocation;
    }

    public String getLocation() {
        return this.theLocationStr;
    }

    public String toString() {
        String qtyStr;
        StringBuilder info = new StringBuilder(100);
        if (this.quantity != null && !"1".equals(qtyStr = String.valueOf(this.quantity))) {
            info.append(this.quantity).append('x');
        }
        info.append(this.equip == null ? "null" : this.equip.getLSTformat(false));
        if (this.mods != null) {
            info.append(" (");
            boolean needsSlash = false;
            for (EqModRef modRef : this.mods) {
                if (needsSlash) {
                    info.append('/');
                }
                needsSlash = true;
                info.append(modRef.getRef().getLSTformat(false));
                for (String s : modRef.getChoices()) {
                    info.append("|").append(s);
                }
            }
            info.append(')');
        }
        return info.toString();
    }

    private void processLookups(Kit aKit, PlayerCharacter aPC) {
        Collection<NamedFormula> lookups = this.getLookups();
        if (lookups == null) {
            return;
        }
        for (NamedFormula lookup : lookups) {
            KitTable kt = aKit.getTable(lookup.getName());
            KitGear gear = kt.getEntry(aPC, lookup.getFormula().resolve(aPC, "").intValue());
            gear.processLookups(aKit, aPC);
            this.overlayGear(gear);
        }
    }

    private void overlayGear(KitGear gear) {
        if (gear.quantity != null) {
            this.actingQuantity = gear.quantity;
        }
        if (gear.maxCost != null) {
            this.actingCost = gear.maxCost;
        }
        if (gear.mods != null) {
            this.actingMods.addAll(gear.mods);
        }
        if (gear.theLocationStr != null) {
            this.actingLocation = gear.theLocationStr;
        }
        if (gear.size != null) {
            this.actingSize = gear.size.resolvesTo();
        }
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        this.actingQuantity = this.quantity;
        this.actingCost = this.maxCost;
        this.actingMods = this.mods == null ? null : new ArrayList<EqModRef>(this.mods);
        this.actingLocation = this.theLocationStr;
        if (this.size != null) {
            this.actingSize = this.size.resolvesTo();
        }
        this.theEquipment = null;
        this.theQty = 0;
        this.theLocation = "";
        this.theCost = BigDecimal.ZERO;
        this.processLookups(aKit, aPC);
        int aBuyRate = aKit.getBuyRate(aPC);
        BigDecimal pcGold = aPC.getGold();
        BigDecimal fixedTotalCost = aKit.getTotalCost(aPC);
        if (fixedTotalCost != null) {
            aBuyRate = 0;
        }
        ArrayList<Equipment> eqList = new ArrayList<Equipment>(this.equip.getContainedObjects());
        if (this.actingCost != null) {
            BigDecimal bdMaxCost = new BigDecimal(Integer.toString(this.actingCost));
            Iterator i = eqList.iterator();
            while (i.hasNext()) {
                if (((Equipment)i.next()).getCost(aPC).compareTo(bdMaxCost) <= 0) continue;
                i.remove();
            }
        }
        if (eqList.size() == 1) {
            this.theEquipment = (Equipment)eqList.get(0);
        } else {
            List<Object> selected = new ArrayList(1);
            if ((selected = Globals.getChoiceFromList("Choose equipment", eqList, selected, 1, aPC)).size() == 1) {
                this.theEquipment = (Equipment)selected.get(0);
            }
        }
        this.theEquipment = this.theEquipment.clone();
        boolean tryResize = false;
        SizeAdjustment sizeToSet = aPC.getSizeAdjustment();
        if (this.actingSize == null) {
            if (this.theEquipment.isType("Natural") || this.sizeToPC != null && this.sizeToPC.booleanValue() || !this.theEquipment.isWeapon() && !this.theEquipment.isAmmunition()) {
                tryResize = Globals.canResizeHaveEffect(aPC, this.theEquipment, null);
            }
        } else if (this.sizeToPC != null && this.sizeToPC.booleanValue()) {
            tryResize = Globals.canResizeHaveEffect(aPC, this.theEquipment, null);
        } else {
            sizeToSet = this.actingSize;
            tryResize = true;
        }
        if (tryResize) {
            this.theEquipment.resizeItem(aPC, sizeToSet);
        } else {
            this.theEquipment.resizeItem(aPC, this.theEquipment.getSafe(ObjectKey.SIZE).resolvesTo());
        }
        if (this.actingMods != null) {
            for (EqModRef modref : this.actingMods) {
                StringBuilder sb = new StringBuilder(50);
                EquipmentModifier eqMod = modref.getRef().resolvesTo();
                sb.append(eqMod.getKeyName());
                for (String assoc : modref.getChoices()) {
                    sb.append("|").append(KitGear.eval(aPC, assoc));
                }
                this.theEquipment.addEqModifiers(sb.toString(), true);
            }
        }
        if (tryResize || this.actingMods != null) {
            this.theEquipment.nameItemFromModifiers(aPC);
        }
        this.theQty = this.actingQuantity == null ? 1 : this.actingQuantity.resolve(aPC, "").intValue();
        int origQty = this.theQty;
        BigDecimal eqCost = this.theEquipment.getCost(aPC);
        if (aBuyRate != 0) {
            if (fixedTotalCost == null) {
                BigDecimal bdBuyRate = new BigDecimal(Integer.toString(aBuyRate)).multiply(new BigDecimal("0.01"));
                this.theCost = eqCost.multiply(new BigDecimal(Integer.toString(this.theQty))).multiply(bdBuyRate);
                while (this.theQty > 0 && this.theCost.compareTo(pcGold) > 0) {
                    this.theCost = eqCost.multiply(new BigDecimal(Integer.toString(--this.theQty))).multiply(bdBuyRate);
                }
            }
            aPC.setGold(aPC.getGold().subtract(this.theCost));
        }
        boolean outOfFunds = false;
        if (this.theQty != origQty) {
            outOfFunds = true;
        }
        if (outOfFunds) {
            warnings.add("GEAR: Could not purchase " + (origQty - this.theQty) + " " + this.theEquipment.getName() + ". Not enough funds.");
        }
        if (this.theQty == 0) {
            return false;
        }
        Equipment testApplyEquipment = this.theEquipment.clone();
        testApplyEquipment.setQty(new Float(this.theQty));
        aPC.addEquipment(testApplyEquipment);
        Equipment theTarget = null;
        if (this.actingLocation != null) {
            this.theLocation = this.actingLocation;
            if (!(this.theLocation.equalsIgnoreCase("DEFAULT") || this.theLocation.equalsIgnoreCase("Carried") || this.theLocation.equalsIgnoreCase("Not Carried") || this.theLocation.equalsIgnoreCase("Equipped"))) {
                theTarget = EquipmentUtilities.findEquipmentByBaseKey(aPC.getEquipmentMasterList(), this.theLocation);
            } else if (this.theLocation.equalsIgnoreCase("DEFAULT")) {
                this.theLocation = "";
            }
            EquipSet eSet = null;
            if (theTarget != null) {
                eSet = aPC.getEquipSetForItem(aPC.getEquipSetByIdPath(EquipSet.DEFAULT_SET_PATH), theTarget);
            }
            if (eSet == null) {
                eSet = aPC.getEquipSetByIdPath(EquipSet.DEFAULT_SET_PATH);
            }
            if (eSet == null) {
                warnings.add("GEAR: Could not find location " + this.theLocation + " for gear " + testApplyEquipment.getName() + ".");
                return false;
            }
            EquipSet eqSet = aPC.addEquipToTarget(eSet, theTarget, this.theLocation, testApplyEquipment, new Float(-1.0f));
            if (eqSet == null) {
                warnings.add("GEAR: Could not equip " + testApplyEquipment.getName() + " to " + this.theLocation);
            }
        }
        return true;
    }

    @Override
    public void apply(PlayerCharacter aPC) {
        Equipment existing = aPC.getEquipmentNamed(this.theEquipment.getName());
        if (existing == null) {
            this.theEquipment.setQty(new Float(this.theQty));
            aPC.addEquipment(this.theEquipment);
            Globals.getContext().getReferenceContext().importObject(this.theEquipment);
        } else {
            existing.setQty(existing.qty() + (double)this.theQty);
        }
        Equipment theTarget = null;
        if (!(this.theLocation.equalsIgnoreCase("Carried") || this.theLocation.equalsIgnoreCase("Not Carried") || this.theLocation.equalsIgnoreCase("Equipped") || (theTarget = EquipmentUtilities.findEquipmentByBaseKey(aPC.getEquipmentMasterList(), this.theLocation)) != null)) {
            this.theLocation = "Carried";
        }
        EquipSet eSet = theTarget == null ? aPC.getEquipSetByIdPath(EquipSet.DEFAULT_SET_PATH) : aPC.getEquipSetForItem(aPC.getEquipSetByIdPath(EquipSet.DEFAULT_SET_PATH), theTarget);
        aPC.addEquipToTarget(eSet, theTarget, this.theLocation, this.theEquipment, new Float(this.theQty));
        aPC.setGold(aPC.getGold().subtract(this.theCost));
    }

    @Override
    public String getObjectName() {
        return "Gear";
    }

    public void setQuantity(Formula formula) {
        this.quantity = formula;
    }

    public Formula getQuantity() {
        return this.quantity;
    }

    public void setMaxCost(Integer quan) {
        this.maxCost = quan;
    }

    public Integer getMaxCost() {
        return this.maxCost;
    }

    public void setEquipment(CDOMReference<Equipment> reference) {
        this.equip = reference;
    }

    public CDOMReference<Equipment> getEquipment() {
        return this.equip;
    }

    public void setSizeToPC(Boolean b) {
        this.sizeToPC = b;
    }

    public Boolean getSizeToPC() {
        return this.sizeToPC;
    }

    public void setSize(CDOMSingleRef<SizeAdjustment> sa) {
        this.size = sa;
    }

    public CDOMSingleRef<SizeAdjustment> getSize() {
        return this.size;
    }

    public void loadLookup(String tableEntry, Formula f) {
        if (this.lookupList == null) {
            this.lookupList = new LinkedList<NamedFormula>();
        }
        this.lookupList.add(new NamedFormula(tableEntry, f));
    }

    public Collection<NamedFormula> getLookups() {
        return this.lookupList;
    }

    public void addModRef(EqModRef modRef) {
        if (this.mods == null) {
            this.mods = new LinkedList<EqModRef>();
        }
        this.mods.add(modRef);
    }

    public boolean hasEqMods() {
        return this.mods != null && !this.mods.isEmpty();
    }

    public List<EqModRef> getEqMods() {
        return Collections.unmodifiableList(this.mods);
    }
}

