/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pcgen.core.VariableProcessor;
import pcgen.facade.core.CharacterFacade;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.tools.Utility;
import pcgen.system.LanguageBundle;

public class CalculatorDialog
extends JDialog {
    private final PCGenFrame pcgenFrame;
    private final FormulaPanel formulaPanel;
    private final JTextArea outputText;

    public CalculatorDialog(PCGenFrame parent) {
        super(parent);
        this.pcgenFrame = parent;
        this.setTitle(LanguageBundle.getString("in_mnuToolsCalculator"));
        this.outputText = new JTextArea();
        this.formulaPanel = new FormulaPanel(this.outputText);
        this.initComponents();
        this.pack();
        this.setSize(700, 500);
        Utility.installEscapeCloseOperation(this);
    }

    private void initComponents() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.outputText.setEditable(false);
        contentPane.add((Component)this.formulaPanel, "North");
        contentPane.add((Component)this.outputText, "Center");
        this.setDefaultCloseOperation(1);
    }

    private class FormulaPanel
    extends JPanel {
        private final JTextField formulaText = new JTextField();
        private final ButtonPanel buttonPanel;

        public FormulaPanel(JTextArea outputText) {
            this.buttonPanel = new ButtonPanel(this.formulaText, outputText);
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.formulaText, "Center");
            this.add((Component)this.buttonPanel, "East");
        }
    }

    private class ButtonPanel
    extends JPanel
    implements ActionListener {
        private final JButton calcButton = new JButton(LanguageBundle.getString("in_calculate"));
        private final JButton clearButton = new JButton(LanguageBundle.getString("in_clear"));
        private JTextField formulaText;
        private JTextArea outputText;

        public ButtonPanel(JTextField formulaText, JTextArea outputText) {
            this.formulaText = formulaText;
            this.outputText = outputText;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.calcButton.setActionCommand("CALCULATE");
            this.calcButton.addActionListener(this);
            this.clearButton.setActionCommand("CLEAR");
            this.clearButton.addActionListener(this);
            this.add((Component)this.calcButton, "West");
            this.add((Component)this.clearButton, "East");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("CALCULATE".equals(e.getActionCommand())) {
                String formula = this.formulaText.getText();
                CharacterFacade currentPC = CalculatorDialog.this.pcgenFrame.getSelectedCharacterRef().getReference();
                if (currentPC != null) {
                    VariableProcessor vp = currentPC.getVariableProcessor();
                    vp.pauseCache();
                    this.outputText.append(currentPC.getNameRef() + ": " + formula + " = " + currentPC.getVariable(formula, true) + "\n");
                    vp.restartCache();
                } else {
                    this.outputText.append("No character currently selected.\n");
                }
                this.formulaText.requestFocus();
            } else if ("CLEAR".equals(e.getActionCommand())) {
                this.outputText.setText("");
            }
        }
    }
}

