/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.summary;

import javax.swing.JEditorPane;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterLevelFacade;
import pcgen.facade.core.GameModeFacade;
import pcgen.facade.core.StatFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.tabs.models.HtmlSheetSupport;
import pcgen.system.LanguageBundle;

public class InfoPaneHandler
implements ReferenceListener<Object>,
ListListener<CharacterLevelFacade> {
    private boolean installed = false;
    private HtmlSheetSupport support;
    private String currentInfoTemplateFile;
    private CharacterFacade character;

    public InfoPaneHandler(CharacterFacade character, JEditorPane htmlPane) {
        this.character = character;
        GameModeFacade game = character.getDataSet().getGameMode();
        this.support = new HtmlSheetSupport(character, htmlPane, game.getInfoSheet());
        this.support.setMissingSheetMsg(LanguageBundle.getFormattedString("in_sumNoInfoSheet", character.getDataSet().getGameMode().getName()));
        this.registerListeners();
    }

    public static void initializeEditorPane(JEditorPane htmlPane) {
        htmlPane.setOpaque(false);
        htmlPane.setEditable(false);
        htmlPane.setFocusable(false);
        htmlPane.setContentType("text/html");
    }

    public void install() {
        this.support.install();
        this.installed = true;
        this.scheduleRefresh();
    }

    private void registerListeners() {
        this.character.getRaceRef().addReferenceListener(this);
        this.character.getGenderRef().addReferenceListener(this);
        this.character.getAlignmentRef().addReferenceListener(this);
        for (StatFacade stat : this.character.getDataSet().getStats()) {
            this.character.getScoreBaseRef(stat).addReferenceListener(this);
        }
        this.character.getCharacterLevelsFacade().addListListener(this);
        this.character.getHandedRef().addReferenceListener(this);
        this.character.getAgeRef().addReferenceListener(this);
    }

    public void scheduleRefresh() {
        this.support.refresh();
    }

    public void uninstall() {
        this.support.uninstall();
        this.installed = false;
    }

    @Override
    public void referenceChanged(ReferenceEvent<Object> e) {
        this.scheduleRefresh();
    }

    @Override
    public void elementAdded(ListEvent<CharacterLevelFacade> e) {
        this.scheduleRefresh();
    }

    @Override
    public void elementRemoved(ListEvent<CharacterLevelFacade> e) {
        this.scheduleRefresh();
    }

    @Override
    public void elementModified(ListEvent<CharacterLevelFacade> e) {
        this.scheduleRefresh();
    }

    @Override
    public void elementsChanged(ListEvent<CharacterLevelFacade> e) {
        this.scheduleRefresh();
    }
}

