/*
 * Decompiled with CFR 0.152.
 */
package plugin.primitive.spell;

import pcgen.cdom.enumeration.DataSetID;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.MasterAvailableSpellFacet;
import pcgen.cdom.helper.AvailableSpell;
import pcgen.cdom.list.DomainSpellList;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractRestrictedSpellPrimitive;

public class DomainListToken
extends AbstractRestrictedSpellPrimitive {
    private CDOMSingleRef<DomainSpellList> spelllist;
    private MasterAvailableSpellFacet masterAvailableSpellFacet;

    @Override
    public boolean initialize(LoadContext context, Class<Spell> cl, String value, String args) {
        if (value == null) {
            return false;
        }
        this.spelllist = context.getReferenceContext().getCDOMReference(DomainSpellList.class, value);
        this.masterAvailableSpellFacet = FacetLibrary.getFacet(MasterAvailableSpellFacet.class);
        return this.initialize(context, args);
    }

    @Override
    public String getTokenName() {
        return "DOMAINLIST";
    }

    @Override
    public boolean allow(PlayerCharacter pc, Spell spell) {
        DomainSpellList list = this.spelllist.resolvesTo();
        DataSetID datasetID = pc.getCharID().getDatasetID();
        for (AvailableSpell availSpell : this.masterAvailableSpellFacet.getMatchingSpellsInList(list, datasetID, spell)) {
            int level = availSpell.getLevel();
            if (level < 0 || !this.allow(pc, level, "", spell, list)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DomainListToken) {
            DomainListToken other = (DomainListToken)obj;
            if (this.spelllist == null) {
                return other.spelllist == null;
            }
            return this.spelllist.equals(other.spelllist) && this.equalsRestrictedPrimitive(other);
        }
        return false;
    }

    public int hashCode() {
        return this.spelllist == null ? -7 : this.spelllist.hashCode();
    }

    @Override
    public CharSequence getPrimitiveLST() {
        return new StringBuilder().append(this.getTokenName()).append('=').append(this.spelllist.getLSTformat(false)).append(this.getRestrictionLST());
    }
}

