/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.testng.IDataProviderMethod;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.annotations.CustomAttribute;
import org.testng.annotations.ITestAnnotation;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlTest;

public class TestNGMethod
extends BaseTestMethod {
    private int m_threadPoolSize = 0;
    private int m_invocationCount = 1;
    private int m_successPercentage = 100;
    private boolean isDataDriven = false;
    private CustomAttribute[] m_attributes = new CustomAttribute[0];
    private IDataProviderMethod dataProviderMethod = null;

    public TestNGMethod(ITestObjectFactory objectFactory, Method method, IAnnotationFinder finder, XmlTest xmlTest, Object instance) {
        this(objectFactory, method, finder, true, xmlTest, instance);
    }

    private TestNGMethod(ITestObjectFactory objectFactory, Method method, IAnnotationFinder finder, boolean initialize, XmlTest xmlTest, Object instance) {
        super(objectFactory, method.getName(), new ConstructorOrMethod(method), finder, instance);
        this.setXmlTest(xmlTest);
        if (initialize) {
            this.init(xmlTest);
        }
    }

    @Override
    public int getInvocationCount() {
        return this.m_invocationCount;
    }

    @Override
    public int getSuccessPercentage() {
        return this.m_successPercentage;
    }

    @Override
    public boolean isTest() {
        return true;
    }

    private void init(XmlTest xmlTest) {
        this.setXmlTest(xmlTest);
        String className = this.m_method.getDeclaringClass().getName();
        Object obj = this.getInstance();
        if (obj != null) {
            className = obj.getClass().getName();
        }
        this.setInvocationNumbers(xmlTest.getInvocationNumbers(className + "." + this.m_method.getName()));
        ITestAnnotation testAnnotation = AnnotationHelper.findTest(this.getAnnotationFinder(), this.m_method.getMethod());
        if (testAnnotation == null) {
            testAnnotation = AnnotationHelper.findTest(this.getAnnotationFinder(), this.m_method.getDeclaringClass());
        }
        if (null != testAnnotation) {
            this.setTimeOut(testAnnotation.getTimeOut());
            this.m_successPercentage = testAnnotation.getSuccessPercentage();
            this.isDataDriven = TestNGMethod.doesTestAnnotationHaveADataProvider(testAnnotation);
            this.setInvocationCount(testAnnotation.getInvocationCount());
            this.setThreadPoolSize(testAnnotation.getThreadPoolSize());
            this.setAlwaysRun(testAnnotation.getAlwaysRun());
            this.setDescription(this.findDescription(testAnnotation, xmlTest));
            this.setEnabled(testAnnotation.getEnabled());
            this.setRetryAnalyzerClass(testAnnotation.getRetryAnalyzerClass());
            this.setSkipFailedInvocations(testAnnotation.skipFailedInvocations());
            this.setInvocationTimeOut(testAnnotation.invocationTimeOut());
            this.setIgnoreMissingDependencies(testAnnotation.ignoreMissingDependencies());
            this.setPriority(testAnnotation.getPriority());
            this.m_attributes = testAnnotation.getAttributes();
        }
        this.initGroups(ITestAnnotation.class);
    }

    private static boolean doesTestAnnotationHaveADataProvider(ITestAnnotation testAnnotation) {
        return !testAnnotation.getDataProvider().trim().isEmpty() || testAnnotation.getDataProviderClass() != null;
    }

    private String findDescription(ITestAnnotation testAnnotation, XmlTest xmlTest) {
        String result = testAnnotation.getDescription();
        if (result != null) {
            return result;
        }
        List<XmlClass> classes = xmlTest.getXmlClasses();
        return classes.stream().filter(this::classNameMatcher).flatMap(xmlClass -> xmlClass.getIncludedMethods().stream()).filter(this::methodNameMatcher).map(XmlInclude::getDescription).filter(Objects::nonNull).findFirst().orElse("");
    }

    private boolean classNameMatcher(XmlClass xmlClass) {
        return xmlClass.getName().equals(this.m_method.getMethod().getDeclaringClass().getName());
    }

    private boolean methodNameMatcher(XmlInclude xmlInclude) {
        return xmlInclude.getName().equals(this.m_method.getName());
    }

    @Override
    public int getThreadPoolSize() {
        return this.m_threadPoolSize;
    }

    @Override
    public void setThreadPoolSize(int threadPoolSize) {
        this.m_threadPoolSize = threadPoolSize;
    }

    @Override
    public void setInvocationCount(int counter) {
        this.m_invocationCount = counter;
    }

    @Override
    public BaseTestMethod clone() {
        TestNGMethod clone = new TestNGMethod(this.m_objectFactory, this.getConstructorOrMethod().getMethod(), this.getAnnotationFinder(), false, this.getXmlTest(), this.getInstance());
        ITestClass tc = this.getTestClass();
        NoOpTestClass testClass = new NoOpTestClass(tc);
        testClass.setBeforeTestMethods(TestNGMethod.clone(tc.getBeforeTestMethods()));
        testClass.setAfterTestMethod(TestNGMethod.clone(tc.getAfterTestMethods()));
        clone.m_testClass = testClass;
        clone.setDate(this.getDate());
        clone.setGroups(this.getGroups());
        clone.setGroupsDependedUpon(this.getGroupsDependedUpon(), Collections.emptyList());
        clone.setMethodsDependedUpon(this.getMethodsDependedUpon());
        clone.setAlwaysRun(this.isAlwaysRun());
        clone.m_beforeGroups = this.getBeforeGroups();
        clone.m_afterGroups = this.getAfterGroups();
        clone.m_currentInvocationCount = this.m_currentInvocationCount;
        clone.setMissingGroup(this.getMissingGroup());
        clone.setThreadPoolSize(this.getThreadPoolSize());
        clone.setDescription(this.getDescription());
        clone.setEnabled(this.getEnabled());
        clone.setParameterInvocationCount(this.getParameterInvocationCount());
        clone.setInvocationCount(this.getInvocationCount());
        clone.m_successPercentage = this.getSuccessPercentage();
        clone.setTimeOut(this.getTimeOut());
        clone.setRetryAnalyzerClass(this.getRetryAnalyzerClass());
        clone.setSkipFailedInvocations(this.skipFailedInvocations());
        clone.setInvocationNumbers(this.getInvocationNumbers());
        clone.setPriority(this.getPriority());
        return clone;
    }

    private static ITestNGMethod[] clone(ITestNGMethod[] sources) {
        return (ITestNGMethod[])Arrays.stream(sources).map(ITestNGMethod::clone).toArray(ITestNGMethod[]::new);
    }

    @Override
    public boolean isDataDriven() {
        return this.isDataDriven;
    }

    @Override
    public CustomAttribute[] getAttributes() {
        return this.m_attributes;
    }

    @Override
    public IDataProviderMethod getDataProviderMethod() {
        return this.dataProviderMethod;
    }

    public void setDataProviderMethod(IDataProviderMethod dataProviderMethod) {
        this.dataProviderMethod = dataProviderMethod;
    }
}

