/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.wire;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jetbrains.kotlin.com.google.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.sisu.Parameters;

@Singleton
final class StringProperties
extends AbstractMap<String, String> {
    private final Map<?, ?> delegate;

    @Inject
    StringProperties(@Parameters Map delegate) {
        this.delegate = delegate;
    }

    @Override
    public String get(Object key) {
        Object value = this.delegate.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        Object value = this.delegate.get(key);
        if (null == value) {
            return this.delegate.containsKey(key);
        }
        return value instanceof String;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>();
        for (Map.Entry<?, ?> e : this.delegate.entrySet()) {
            Object value;
            if (!(e.getKey() instanceof String) || null != (value = e.getValue()) && !(value instanceof String)) continue;
            entries.add(e);
        }
        return entries;
    }
}

