/* 
    TowBowlTactics: Adaptation of the tabletop game Blood Bowl

    Copyright (C) 2001-2003 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef FORMATION_H
#define FORMATION_H

#include "global.h"
#include "Square.h"

/**
 * Classe representant une formation type pour une equipe, histoire de pouvoir se placer rapidement 
 * @author Toweld
 * @version 0.5
 */

class Formation{
public:
	/** Constructeur par defaut*/
	Formation(void);
	/** Constructeur a 1 param
	* @param i id de la formation
	*/
	Formation(int);
	/** Destructeur par defaut
	*/
	~Formation();
	/** Donner un id a une formation
	* @param i id de la formation
	*/
	void set_id(int);
	/** Obtenir l'id d'une formation
	* @return id de la formation
	*/
	int get_id();

	map<int, Square*> * get_placement(void);

	void add_element(int,Square*);

	void add_element(int,int,int);

protected:
	int id; 
	map<int, Square*> *placement;
};

#endif
