// bootentry.h - Boot Entry
// Copyright (C) 2014  Konrad Twardowski
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#pragma once

#include "../plugins.h"

#include <QComboBox>
#include <QMenu>

class BootEntry final {
public:
	static QStringList getEntryList() { return m_entryList; }
	static QStringList getProblemList() { return m_problemList; }
	static void initFromConfig();
	static bool setDefault(const QString &name);
	static void showProblemList(QWidget *parent);
private:
	Q_DISABLE_COPY(BootEntry)
	explicit BootEntry() { }
	inline static QStringList m_entryList = QStringList();
	inline static QStringList m_problemList = QStringList();
};

class BootEntryAction final: public Action {
public:
	explicit BootEntryAction(const QString &entry);
	virtual void initContainerWidget() override { }
	virtual bool onAction() override;
private:
	Q_DISABLE_COPY(BootEntryAction)
	QString m_entry;
};

class BootEntryComboBox final: public QComboBox {
public:
	explicit BootEntryComboBox();
	void updateBootEntryList();
private:
	Q_DISABLE_COPY(BootEntryComboBox)
};

class BootEntryMenu final: public QMenu {
public:
	explicit BootEntryMenu(QWidget *parent);
private:
	Q_DISABLE_COPY(BootEntryMenu)
	void onUpdate();
};
