// commandline.h - Command Line
// Copyright (C) 2009  Konrad Twardowski
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

// TODO: merge all command line related APIs

#pragma once

#include "kshutdown.h"

#include <QCommandLineParser>

class CLI final {
public:
	static QCommandLineOption confirmOption() { return m_confirmOption; }
	static QCommandLineOption hideUIOption() { return m_hideUIOption; }
	static QCommandLineOption initOption() { return m_initOption; }
	static QCommandLineOption scaleOption() { return m_scaleOption; }

	static bool check();
	static QString formatName(const QCommandLineOption &option, const QString &value = QString());
	static QCommandLineParser *getArgs() { return m_args; }
	static QString getOption(const QString &name);
	static QString getTimeOption();
	static QStringList getUILayoutOption(const QString &name);
	static void init(const QString &appDescription);
	static void initBeforeApp(int argc, char **argv);
	static void initOptions();
	static bool isArg(const QString &name);
	static bool isConfirm();
	static bool matches(const QString &arg, const QString &name);
	static void showHelp(QWidget *parent);
private:
	Q_DISABLE_COPY(CLI)
	explicit CLI() { }
	inline static QCommandLineOption m_confirmOption = QCommandLineOption("DUMMY");
	inline static QCommandLineOption m_hideUIOption = QCommandLineOption("DUMMY");
	inline static QCommandLineOption m_initOption = QCommandLineOption("DUMMY");
	inline static QCommandLineOption m_scaleOption = QCommandLineOption("DUMMY");
	inline static QCommandLineParser *m_args = nullptr;
	inline static const QString SCALE_NAME = "scale";
};

class TimeOption final {
public:
	static Action *action() { return m_action; }
	static void setAction(Action *action) { m_action = action; }
	static void init();
	static bool isError();
	static bool isValid();
	static QTime parseTime(const QString &time);
	static QString formatDateTime(const QDateTime &dateTime);
	static QString formatTime(const QTime &time);
	static QString value() { return m_option; }
	static void setupMainWindow();
private:
	Q_DISABLE_COPY(TimeOption)
	explicit TimeOption() { }
	inline static Action *m_action = nullptr;
	inline static bool m_absolute = false;
	inline static bool m_relative = false;
	inline static QString m_option = "";
	inline static QTime m_time = QTime();
};
