// fileshortcut.h - File Shortcut Creator
// Copyright (C) 2024  Konrad Twardowski
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#pragma once

#include <QCheckBox>
#include <QComboBox>
#include <QLineEdit>
#include <QPlainTextEdit>
#include <QRadioButton>
#include <QWizard>

class Action;
class Trigger;

class FileShortcutDialog final: public QWizard {
public:
	explicit FileShortcutDialog(QWidget *parent);
	virtual bool validateCurrentPage() override;
private:
	Q_DISABLE_COPY(FileShortcutDialog)
	enum class LocationType { AUTOSTART_MINIMIZED, AUTOSTART, MENU, DESKTOP };
	enum class ScaleType { DEFAULT, X15, X2 };

	Action *m_action;
	Trigger *m_trigger;

	bool m_triggerOptionSupported;
	QCheckBox *m_confirm;
	QCheckBox *m_hideUI;
	QCheckBox *m_init;
	QComboBox *m_location;
	QComboBox *m_scale;
	QLineEdit *m_file;
	QLineEdit *m_name;
	QPlainTextEdit *m_commandLine;
	QRadioButton *m_selectedAction;
	QRadioButton *m_selectedTrigger;
	QRadioButton *m_noAction;
	QRadioButton *m_noTrigger;
	QWizardPage *m_namePage;

	void createActionPage();
	void createAdvancedPage();
	void createNamePage();
	void createTriggerPage();

	void createFile();
	QString getCommandLine();
	UPath getFile();
	UPath getLocationDir();
};
