/*
 * Decompiled with CFR 0.152.
 */
package waba.applet;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import waba.applet.Applet;
import waba.applet.UffUserFont;
import waba.applet.UserFont;
import waba.applet.WinCanvas;
import waba.fx.Font;
import waba.fx.ISurface;
import waba.io.Catalog;
import waba.io.DataStream;
import waba.io.NativeMethods4JDK;
import waba.io.ResizeRecord;
import waba.sys.Convert;
import waba.sys.Settings;
import waba.sys.Time;

public final class JavaBridge {
    public static boolean showMsgs = true;
    private static boolean nonGUIApp;
    public static int scale;
    static boolean useSonyFonts;
    static Class _class;
    static Hashtable htLoadedFonts;
    static Graphics _g;
    static int lastColor;
    static ISurface lastSurface;
    private static Hashtable htColors;
    private static IntColor ic;
    public static Hashtable htOpenedAt;

    static {
        scale = 2;
        htLoadedFonts = new Hashtable(10);
        lastColor = -1;
        htColors = new Hashtable(100);
        ic = new IntColor();
        htOpenedAt = new Hashtable(10);
    }

    public static void GraphicsLine(ISurface surface, int x1, int y1, int x2, int y2, int color) {
        if (_g != null) {
            if (color != lastColor || lastSurface != surface) {
                _g.setColor(JavaBridge.getColor(color));
                lastColor = color;
                lastSurface = surface;
            }
            if (scale == 1) {
                _g.drawLine(x1, y1, x2, y2);
            } else {
                JavaBridge.drawQuadLine(_g, x1, y1, x2, y2);
            }
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    static void drawQuadLine(Graphics g, int Ax, int Ay, int Bx, int By) {
        int dX = Math.abs(Bx - Ax);
        int dY = Math.abs(By - Ay);
        int CurrentX = Ax * scale;
        int CurrentY = Ay * scale;
        if (dX == 0 && dY == 0) {
            g.fillRect(CurrentX, CurrentY, scale, scale);
        } else if (dY == 0) {
            g.fillRect(Math.min(Ax, Bx) * scale, Math.min(Ay, By) * scale, (dX + 1) * scale, scale);
        } else if (dX == 0) {
            g.fillRect(Math.min(Ax, Bx) * scale, Math.min(Ay, By) * scale, scale, (dY + 1) * scale);
        } else {
            int Xincr = Ax > Bx ? -scale : scale;
            int Yincr = Ay > By ? -scale : scale;
            if (dX >= dY) {
                int dPr = dY << 1;
                int dPru = dPr - (dX << 1);
                int P = dPr - dX;
                while (dX >= 0) {
                    g.fillRect(CurrentX, CurrentY, scale, scale);
                    CurrentX += Xincr;
                    if (P > 0) {
                        CurrentY += Yincr;
                        P += dPru;
                    } else {
                        P += dPr;
                    }
                    --dX;
                }
            } else {
                int dPr = dX << 1;
                int dPru = dPr - (dY << 1);
                int P = dPr - dY;
                while (dY >= 0) {
                    g.fillRect(CurrentX, CurrentY, scale, scale);
                    CurrentY += Yincr;
                    if (P > 0) {
                        CurrentX += Xincr;
                        P += dPru;
                    } else {
                        P += dPr;
                    }
                    --dY;
                }
            }
        }
    }

    public static void fillSettings() {
        Calendar cal = Calendar.getInstance();
        cal.set(2002, 11, 25, 20, 0, 0);
        DateFormat df = DateFormat.getDateInstance(3);
        String d = df.format(cal.getTime());
        Settings.dateFormat = (byte)(d.startsWith("25") ? 2 : (d.startsWith("12") ? 1 : 3));
        Settings.dateSeparator = JavaBridge.getFirstSymbol(d);
        df = DateFormat.getTimeInstance(3);
        d = df.format(cal.getTime());
        Settings.is24Hour = d.toLowerCase().indexOf("am") == -1 && d.toLowerCase().indexOf("pm") == -1;
        Settings.timeSeparator = JavaBridge.getFirstSymbol(d);
        TimeZone tz = TimeZone.getDefault();
        Settings.daylightSavings = tz.useDaylightTime();
        Settings.timeZone = tz.getRawOffset() / 3600000;
        Settings.weekStart = (byte)(cal.getFirstDayOfWeek() - 1);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        Settings.thousandsSeparator = dfs.getGroupingSeparator();
        Settings.decimalSeparator = dfs.getDecimalSeparator();
        Settings.isColor = Applet.currentApplet.isColor;
        Settings.maxColors = 1 << Applet.bpp;
        Settings.romVersion = 0x2000000;
        Settings.uiStyle = 0;
        Settings.screenWidth = Applet.currentApplet.width;
        Settings.screenHeight = Applet.currentApplet.height;
        Settings.onDevice = false;
        Settings.platform = "Java";
        Settings.appCreatorId = Applet.creatorId != null ? Applet.creatorId : JavaBridge.getDefaultCrid(Applet.currentApplet.className);
        Settings.virtualKeyboard = false;
        Settings.isHighColor = Applet.bpp > 8;
        Settings.deviceId = "Desktop";
        JavaBridge.getAppSettings(Settings.appCreatorId);
        try {
            Settings.appPath = System.getProperty("user.dir");
            if (Settings.appPath != null) {
                if (Settings.appPath.indexOf(47) >= 0 && !Settings.appPath.endsWith("/")) {
                    Settings.appPath = String.valueOf(Settings.appPath) + "/";
                } else if (Settings.appPath.indexOf(92) >= 0 && !Settings.appPath.endsWith("\\")) {
                    Settings.appPath = String.valueOf(Settings.appPath) + "\\";
                }
            }
            Settings.userName = !Applet.currentApplet.isApplication ? null : System.getProperty("user.name");
        }
        catch (SecurityException securityException) {
            Settings.userName = null;
        }
    }

    public static void fillTime(Time t) {
        Date d = new Date();
        t.year = d.getYear() + 1900;
        t.month = d.getMonth() + 1;
        t.day = d.getDate();
        t.hour = d.getHours();
        t.minute = d.getMinutes();
        t.second = d.getSeconds();
        t.millis = (int)(d.getTime() % 1000L);
    }

    private static void getAppSettings(String crid) {
        block7: {
            showMsgs = false;
            try {
                Catalog cat = new Catalog("Settings4" + crid + ".SWVM." + crid, 1);
                DataStream ds = new DataStream(cat);
                if (!cat.isOpen() || !cat.setRecordPos(0)) break block7;
                String s = ds.readString();
                if (!"".equals(s)) {
                    Settings.appSettings = s;
                }
                try {
                    s = ds.readString();
                    if (!"".equals(s)) {
                        Settings.appSecretKey = s;
                    }
                }
                catch (Throwable throwable) {
                    System.out.println("Reading an old settings file; no appSecretKey available.");
                }
                if (cat.setRecordPos(1)) {
                    byte[] buf = new byte[cat.getRecordSize()];
                    cat.readBytes(buf, 0, buf.length);
                    Settings.appSettingsBin = buf;
                }
                cat.close();
            }
            catch (Throwable throwable) {}
        }
        showMsgs = true;
    }

    private static File[] getClassPathDirectories() throws Exception {
        char dirSeparator = File.pathSeparatorChar;
        String pathstr = System.getProperty("java.class.path");
        int i = 0;
        int n = 0;
        int j = 0;
        while ((i = pathstr.indexOf(dirSeparator, i)) != -1) {
            ++n;
            ++i;
        }
        File[] path = new File[n + 1];
        int len = pathstr.length();
        n = 0;
        i = 0;
        while (i < len) {
            File file;
            j = pathstr.indexOf(dirSeparator, i);
            if (j == -1) {
                j = len;
            }
            if (i != j && (file = new File(pathstr.substring(i, j))).isDirectory()) {
                path[n++] = file;
            }
            i = j + 1;
        }
        File[] classPath = new File[n];
        System.arraycopy(path, 0, classPath, 0, n);
        return classPath;
    }

    public static Color getColor(int color) {
        JavaBridge.ic.color = color;
        Color c = (Color)htColors.get(ic);
        if (c != null) {
            return c;
        }
        c = new Color(color);
        htColors.put(ic, c);
        return c;
    }

    public static String getDataPath() {
        String path = Settings.dataPath;
        if (path != null && !(path = path.replace('\\', '/')).endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    public static String getDefaultCrid(String name) {
        if (name.equalsIgnoreCase("waba.ui.Welcome")) {
            return "SWAB";
        }
        if (name.indexOf(46) != -1) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        int n = name.length();
        int hash = 0;
        byte[] creat = new byte[4];
        int i = 0;
        while (i < n) {
            hash += (byte)name.charAt(i);
            ++i;
        }
        i = 0;
        while (i < 4) {
            creat[i] = (byte)(hash % 26 + 97);
            if ((hash & 0x40) > 0) {
                int n2 = i;
                creat[n2] = (byte)(creat[n2] + -32);
            }
            hash /= 2;
            ++i;
        }
        return new String(creat);
    }

    private static char getFirstSymbol(String s) {
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (c[i] != ' ' && (c[i] < '0' || c[i] > '9')) {
                return c[i];
            }
            ++i;
        }
        return ' ';
    }

    public static UserFont getFont(Font f) {
        UserFont uf = null;
        String sf = (String.valueOf(f.name) + "," + f.size + "," + f.style).toLowerCase();
        uf = (UserFont)htLoadedFonts.get(sf);
        if (uf != null) {
            return uf;
        }
        boolean bold = f.style == 1;
        boolean large = f.size >= 14;
        String fontName = f.name;
        if (fontName.equalsIgnoreCase("SW")) {
            fontName = JavaBridge.getFontPrefix();
        }
        String sufix = (large ? "Large" : "Small") + (bold ? "Bold" : "");
        uf = JavaBridge.getUserFont(fontName, sufix);
        if (!uf.loaded) {
            uf = JavaBridge.getUserFont(fontName, "");
            if (!uf.loaded) {
                fontName = JavaBridge.getFontPrefix();
                uf = JavaBridge.getUserFont(fontName, sufix);
                f.name = "sw";
            }
        }
        if (!uf.loaded) {
            if (Applet.appletInitialized) {
                JavaBridge.print("No fonts found! be sure to place the file " + JavaBridge.getFontPrefix() + ".pdb in the same directory from where youre running your application or in your applet's codebase or in a jar file!\nTHE EMULATION COULD NOT BE INITIALIZED!");
                System.exit(2);
            }
            uf = null;
        } else {
            htLoadedFonts.put(sf, uf);
        }
        return uf;
    }

    public static UserFont getFontMetrics(Font f) {
        return JavaBridge.getFont(f);
    }

    static String getFontPrefix() {
        int w = Settings.screenWidth;
        return w == 320 ? (useSonyFonts ? "HSW" : "5SW") : (w == 160 ? "LSW" : (w == 176 ? "6SW" : "MSW"));
    }

    private static String getPathOf(String pathAndFileName) {
        char[] chars = pathAndFileName.toCharArray();
        int i = chars.length - 1;
        while (i >= 0) {
            if (chars[i] == '\\' || chars[i] == '/') {
                return new String(chars, 0, i);
            }
            --i;
        }
        return "";
    }

    public static long getTime() {
        return new Date().getTime();
    }

    static UserFont getUserFont(String fontName, String sufix) {
        if (fontName.toUpperCase().startsWith("UFF")) {
            return new UffUserFont(fontName);
        }
        return new UserFont(fontName, sufix);
    }

    public static boolean isOk(String s) {
        return s != null && s.length() > 0;
    }

    public static InputStream openInputStream(String path) {
        JavaBridge.print("\nopening for read " + path);
        String dataPath = JavaBridge.getDataPath();
        if (Applet.currentApplet == null && !nonGUIApp) {
            JavaBridge.print("Applet.currentApplet is null. This can be caused by trying to run waba.applet.Applet with files both in directory/classpath and inside a jar");
            return null;
        }
        InputStream stream = null;
        try {
            if (nonGUIApp) {
                stream = new FileInputStream(JavaBridge.isOk(dataPath) ? String.valueOf(dataPath) + path : path);
            } else if (Applet.currentApplet.isApplication) {
                try {
                    String p = JavaBridge.isOk(dataPath) ? String.valueOf(dataPath) + path : path;
                    JavaBridge.print("#1 - dataPath");
                    stream = new FileInputStream(p);
                    htOpenedAt.put(path, JavaBridge.getPathOf(p));
                    JavaBridge.print("found in " + p);
                }
                catch (Exception exception) {
                    stream = null;
                }
                if (stream == null) {
                    JavaBridge.print("#2 - classpath");
                    File[] dirs = JavaBridge.getClassPathDirectories();
                    File f = null;
                    int i = 0;
                    while (i < dirs.length) {
                        try {
                            f = new File(dirs[i], path);
                            if (f.isFile()) {
                                htOpenedAt.put(path, dirs[i].getAbsolutePath());
                                JavaBridge.print("found in " + dirs[i].getAbsolutePath());
                                break;
                            }
                            f = null;
                        }
                        catch (Exception exception) {
                            f = null;
                        }
                        ++i;
                    }
                    if (f != null) {
                        stream = new FileInputStream(f);
                    }
                }
                if (stream == null && _class != null) {
                    JavaBridge.print("#3 - jar file");
                    try {
                        InputStream is = _class.getResourceAsStream("/" + path);
                        if (is != null) {
                            stream = JavaBridge.readJavaInputStream(is);
                            JavaBridge.print("found in " + is);
                        }
                    }
                    catch (Throwable tt) {
                        if (tt.getMessage() != null) {
                            System.out.println(tt.getMessage());
                        }
                    }
                }
            } else {
                URL url;
                InputStream is;
                block42: {
                    is = null;
                    try {
                        is = _class.getResourceAsStream("/" + path);
                    }
                    catch (Throwable tt) {
                        if (tt.getMessage() == null) break block42;
                        System.out.println(tt.getMessage());
                    }
                }
                JavaBridge.print("#0 - resource: " + is);
                if (is != null) {
                    stream = JavaBridge.readJavaInputStream(is);
                }
                if (stream == null) {
                    String archive = Applet.currentApplet.getParameter("archive");
                    JavaBridge.print("#1 - archive: " + archive);
                    if (JavaBridge.isOk(archive) && !archive.equals("null")) {
                        String[] archives = Convert.tokenizeString(archive, ',');
                        int i = 0;
                        while (i < archives.length) {
                            block43: {
                                archive = archives[i];
                                if (archive.startsWith("null")) {
                                    archive = archive.substring(4);
                                }
                                URL codeBase = Applet.currentApplet.getCodeBase();
                                url = new URL(String.valueOf(String.valueOf(codeBase)) + "/" + archive);
                                try {
                                    ZipInputStream zIn = new ZipInputStream(url.openStream());
                                    ZipEntry zEntry = zIn.getNextEntry();
                                    while (!zEntry.getName().equals(path)) {
                                        zEntry = zIn.getNextEntry();
                                        if (zEntry != null) continue;
                                        throw new Exception("doh");
                                    }
                                    JavaBridge.print("found under zip entry.");
                                    stream = JavaBridge.readJavaInputStream(zIn);
                                }
                                catch (Exception e) {
                                    if (e.getMessage().equals("doh")) break block43;
                                    e.printStackTrace();
                                }
                            }
                            ++i;
                        }
                    }
                }
                if (stream == null) {
                    try {
                        URL codeBase = Applet.currentApplet.getCodeBase();
                        JavaBridge.print("#2 - codeBase: " + codeBase);
                        String cb = codeBase.toString();
                        char lastc = cb.charAt(cb.length() - 1);
                        char firstc = path.charAt(0);
                        if (lastc != '/' && firstc != '/') {
                            cb = String.valueOf(cb) + "/";
                        }
                        url = new URL(String.valueOf(cb) + path);
                        stream = url.openStream();
                        JavaBridge.print("found under codebase: " + url + ". bytes: " + stream.available());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (stream == null) {
                    try {
                        JavaBridge.print("#3- url: file://localhost/" + dataPath + path);
                        url = new URL("file://localhost/" + dataPath + path);
                        stream = url.openStream();
                        JavaBridge.print("found under localhost: " + url);
                    }
                    catch (Exception exception) {}
                }
            }
            if (stream == null) {
                JavaBridge.print("file not found");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JavaBridge.print("file not found");
        }
        catch (Exception e) {
            if (JavaBridge.isOk(e.getMessage())) {
                JavaBridge.print("error in JavaBridge.openInputStream: " + e.getMessage());
            }
            return null;
        }
        return stream;
    }

    public static OutputStream openOutputStream(String path) {
        JavaBridge.print("\nopening for write " + path);
        String dataPath = JavaBridge.getDataPath();
        if (Applet.currentApplet == null && !nonGUIApp) {
            JavaBridge.print("Applet.currentApplet is null. This can occur when running waba.applet.Applet with files both in directory/classpath and inside a jar");
            return null;
        }
        OutputStream stream = null;
        try {
            if (nonGUIApp) {
                stream = new FileOutputStream(JavaBridge.isOk(dataPath) ? String.valueOf(dataPath) + path : path);
            } else if (Applet.currentApplet.isApplication) {
                String read = (String)htOpenedAt.get(path);
                if (read != null) {
                    try {
                        JavaBridge.print("#0 - read path");
                        stream = new FileOutputStream(new File(read, path));
                        JavaBridge.print("found in " + read);
                    }
                    catch (Exception exception) {
                        stream = null;
                    }
                }
                if (stream != null) {
                    return stream;
                }
                try {
                    String p = JavaBridge.isOk(dataPath) ? String.valueOf(dataPath) + path : path;
                    JavaBridge.print("#1 - Settings.dataPath");
                    stream = new FileOutputStream(p);
                    JavaBridge.print("found in " + p);
                }
                catch (Exception exception) {
                    stream = null;
                }
                if (stream == null) {
                    JavaBridge.print("#2 - classpath");
                    File[] dirs = JavaBridge.getClassPathDirectories();
                    File f = null;
                    int i = 0;
                    while (i < dirs.length) {
                        try {
                            f = new File(dirs[i], path);
                            if (f.isFile()) {
                                JavaBridge.print("found in " + dirs[i]);
                                break;
                            }
                        }
                        catch (Exception exception) {
                            f = null;
                        }
                        ++i;
                    }
                    if (f == null) {
                        JavaBridge.print("could not find file in the classpath");
                    } else {
                        stream = new FileOutputStream(f);
                    }
                }
            } else {
                URL url;
                if (stream == null) {
                    try {
                        URL codeBase = Applet.currentApplet.getCodeBase();
                        JavaBridge.print("#1- codeBase: " + codeBase);
                        String cb = codeBase.toString();
                        char lastc = cb.charAt(cb.length() - 1);
                        char firstc = path.charAt(0);
                        if (lastc != '/' && firstc != '/') {
                            cb = String.valueOf(cb) + "/";
                        }
                        url = new URL(String.valueOf(cb) + path);
                        stream = JavaBridge.openOutputUrl(url);
                        JavaBridge.print("found under codebase: " + url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (stream == null) {
                    try {
                        JavaBridge.print("#2- url: file://localhost/" + dataPath + path);
                        url = new URL("file://localhost/" + dataPath + path);
                        stream = JavaBridge.openOutputUrl(url);
                        JavaBridge.print("found under localhost: " + url);
                    }
                    catch (Exception exception) {}
                }
            }
            if (stream == null) {
                JavaBridge.print("file not found");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JavaBridge.print("file not found");
        }
        catch (Exception e) {
            JavaBridge.print("error in Vm.openOutputStream: " + e.getMessage());
            return null;
        }
        return stream;
    }

    private static OutputStream openOutputUrl(URL url) {
        try {
            URLConnection con = url.openConnection();
            con.setUseCaches(false);
            con.setDoOutput(true);
            con.setDoInput(false);
            return con.getOutputStream();
        }
        catch (Exception exception) {
            try {
                String path = String.valueOf(String.valueOf(url));
                return new FileOutputStream(JavaBridge.isOk(Settings.dataPath) ? String.valueOf(JavaBridge.getDataPath()) + path : path);
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static void print(String s) {
        if (showMsgs) {
            System.err.println(s);
        }
    }

    public static byte[] readBytes(String path) {
        byte[] bytes = null;
        try {
            InputStream is = JavaBridge.openInputStream(path);
            if (is != null) {
                int n = is.available();
                bytes = new byte[n];
                is.read(bytes);
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    private static InputStream readJavaInputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        byte[] buf = new byte[128];
        while (true) {
            int len;
            try {
                len = is.read(buf);
            }
            catch (IOException iOException) {
                break;
            }
            if (len <= 0) break;
            baos.write(buf, 0, len);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    static void resetGraphics(WinCanvas wc) {
        _g = wc.getGraphics();
        lastColor = -1;
        lastSurface = null;
    }

    public static void resetNonGUIApp() {
        nonGUIApp = false;
    }

    public static void setNonGUIApp() {
        nonGUIApp = true;
        new waba.sys.NativeMethods4JDK();
        new NativeMethods4JDK();
    }

    public static void storeSettings() {
        try {
            boolean saveSettings;
            String crid = Settings.appCreatorId;
            showMsgs = false;
            Catalog cat = new Catalog("Settings4" + crid + ".SWVM." + crid, 3);
            boolean bl = saveSettings = Settings.appSettings != null || Settings.appSecretKey != null || Settings.appSettingsBin != null;
            if (cat.isOpen() && !saveSettings) {
                cat.delete();
            } else if (saveSettings) {
                if (!cat.isOpen()) {
                    cat = new Catalog("Settings4" + crid + ".SWVM." + crid, 4);
                }
                if (cat.isOpen()) {
                    ResizeRecord rs = new ResizeRecord(cat, 256);
                    DataStream ds = new DataStream(rs);
                    if (cat.setRecordPos(1)) {
                        cat.deleteRecord();
                    }
                    if (cat.setRecordPos(0)) {
                        cat.deleteRecord();
                    }
                    rs.startRecord();
                    ds.writeString(Settings.appSettings);
                    ds.writeString(Settings.appSecretKey);
                    rs.endRecord();
                    if (Settings.appSettingsBin != null) {
                        int len = Settings.appSettingsBin.length;
                        cat.addRecord(len);
                        cat.writeBytes(Settings.appSettingsBin, 0, len);
                    }
                    cat.close();
                }
            }
            showMsgs = true;
        }
        catch (Throwable throwable) {
            System.out.println("Settings can't be stored!");
        }
    }

    public static boolean writeBytes(String path, byte[] buf, int len) {
        boolean ret = true;
        try {
            OutputStream os = JavaBridge.openOutputStream(path);
            if (os != null) {
                if (buf != null) {
                    os.write(buf, 0, len);
                    os.close();
                } else {
                    JavaBridge.print("ATT: you sent to stream.writeBytes a null buffer!");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = false;
        }
        return ret;
    }

    private static class IntColor {
        public int color;

        IntColor() {
        }

        public int hashCode() {
            return this.color;
        }
    }
}

