/*
 * Decompiled with CFR 0.152.
 */
package waba.applet;

import java.awt.Canvas;
import java.awt.Event;
import java.awt.Graphics;
import waba.applet.Applet;
import waba.applet.JavaBridge;
import waba.applet.SWEventThread;
import waba.sys.Vm;
import waba.ui.MainWindow;

public class WinCanvas
extends Canvas {
    MainWindow win;
    public static WinCanvas currentCanvas;
    protected static SWEventThread _eventThread;
    private static Event tabEv;
    public int currentKeysState = 0;

    public WinCanvas(MainWindow win) {
        currentCanvas = this;
        this.win = win;
        WinCanvas.createEventThread(win);
    }

    private int actionKeyValue(int action) {
        int key = 0;
        switch (action) {
            case 1002: {
                key = 75000;
                break;
            }
            case 1003: {
                key = 75001;
                break;
            }
            case 1000: {
                key = 75002;
                break;
            }
            case 1001: {
                key = 75003;
                break;
            }
            case 1004: {
                key = 75004;
                break;
            }
            case 1005: {
                key = 75005;
                break;
            }
            case 1006: {
                key = 75006;
                break;
            }
            case 1007: {
                key = 75007;
                break;
            }
            case 1025: {
                key = 75008;
                break;
            }
            case 10: {
                key = 75009;
                break;
            }
            case 9: {
                key = 75010;
                break;
            }
            case 8: {
                key = 75011;
                break;
            }
            case 27: {
                key = 75012;
                break;
            }
            case 127: {
                key = 75013;
                break;
            }
            case 1008: {
                if ((Vm.interceptSystemKey & 8) == 0) break;
                key = 76003;
                break;
            }
            case 1009: {
                if ((Vm.interceptSystemKey & 0x10) == 0) break;
                key = 76004;
                break;
            }
            case 1010: {
                if ((Vm.interceptSystemKey & 0x20) == 0) break;
                key = 76005;
                break;
            }
            case 1011: {
                if ((Vm.interceptSystemKey & 0x40) == 0) break;
                key = 76006;
                break;
            }
            case 1012: {
                key = 75015;
                break;
            }
            case 1013: {
                key = 75014;
                break;
            }
            case 1014: {
                if ((Vm.interceptSystemKey & 0x4000000) == 0) break;
                key = 76007;
                break;
            }
            case 1015: {
                if ((Vm.interceptSystemKey & 0x2000000) == 0) break;
                key = 76008;
                break;
            }
            case 1016: {
                if ((Vm.interceptSystemKey & 0x1000000) == 0) break;
                key = 76009;
                break;
            }
            case 1017: {
                key = 76000;
                break;
            }
            case 1018: {
                key = 76001;
                break;
            }
            case 1019: {
                key = 76010;
                break;
            }
        }
        return key;
    }

    public static void createEventThread(MainWindow win) {
        if (_eventThread == null) {
            _eventThread = new SWEventThread(win);
            Thread thread = new Thread((Runnable)_eventThread, "SW Event Thread");
            thread.setDaemon(true);
            _eventThread.setThread(thread);
            thread.start();
        }
    }

    public static boolean eventIsAvailable() {
        return _eventThread.eventAvailable();
    }

    public boolean handleEvent(Event event) {
        int type = 0;
        int key = 0;
        int x = 0;
        int y = 0;
        int modifiers = 0;
        if ((event.modifiers & 1) > 0) {
            modifiers |= 4;
        }
        if ((event.modifiers & 2) > 0) {
            modifiers |= 2;
        }
        boolean doPostEvent = false;
        switch (event.id) {
            case 506: {
                type = 203;
                x = event.x;
                y = event.y;
                doPostEvent = true;
                break;
            }
            case 501: {
                type = 200;
                x = event.x;
                y = event.y;
                doPostEvent = true;
                break;
            }
            case 502: {
                type = 202;
                x = event.x;
                y = event.y;
                doPostEvent = true;
                break;
            }
            case 401: {
                type = 100;
                key = WinCanvas.keyValue(event.key, modifiers);
                doPostEvent = true;
                break;
            }
            case 403: {
                key = this.actionKeyValue(event.key);
                if (key != 0) {
                    type = 100;
                    doPostEvent = true;
                }
                this.setKeysState(event.id, event.key);
                break;
            }
            case 404: {
                this.setKeysState(event.id, event.key);
                break;
            }
        }
        if (doPostEvent) {
            int timestamp = (int)event.when;
            _eventThread.pushEvent(type, key, x /= JavaBridge.scale, y /= JavaBridge.scale, modifiers, timestamp);
        }
        return super.handleEvent(event);
    }

    public static void invokeInEventThread(boolean wait, Runnable runnable) {
        _eventThread.invokeInEventThread(wait, runnable);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public static int keyValue(int key, int mod) {
        switch (key) {
            case 8: {
                key = 75011;
                break;
            }
            case 10: {
                key = 75009;
                break;
            }
            case 127: {
                key = 75013;
                break;
            }
        }
        return key;
    }

    public void paint(Graphics g) {
        JavaBridge.resetGraphics(this);
        if (!Applet.currentApplet.started) {
            Applet.currentApplet.startApp();
        }
        WinCanvas.invokeInEventThread(false, new Runnable(){

            public void run() {
                try {
                    MainWindow.getMainWindow()._doPaint(-5000, 0, 0, 0);
                }
                catch (Exception e) {
                    System.out.println("Exception in WinCanvas.paint");
                    e.printStackTrace();
                }
            }
        });
    }

    public static void pumpEvents() {
        _eventThread.handleOneEvent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setKeysState(int javaType, int javaKey) {
        if (javaType == 403) {
            switch (javaKey) {
                case 1008: {
                    this.currentKeysState |= 8;
                    return;
                }
                case 1009: {
                    this.currentKeysState |= 0x10;
                    return;
                }
                case 1010: {
                    this.currentKeysState |= 0x20;
                    return;
                }
                case 1011: {
                    this.currentKeysState |= 0x40;
                    return;
                }
                case 1002: {
                    if ((this.currentKeysState & 4) != 0) return;
                    this.currentKeysState |= 2;
                    return;
                }
                case 1003: {
                    if ((this.currentKeysState & 2) != 0) return;
                    this.currentKeysState |= 4;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        switch (javaKey) {
            case 1008: {
                this.currentKeysState &= 0xFFFFFFF7;
                break;
            }
            case 1009: {
                this.currentKeysState &= 0xFFFFFFEF;
                break;
            }
            case 1010: {
                this.currentKeysState &= 0xFFFFFFDF;
                break;
            }
            case 1011: {
                this.currentKeysState &= 0xFFFFFFBF;
                break;
            }
            case 1002: {
                this.currentKeysState &= 0xFFFFFFFD;
                break;
            }
            case 1003: {
                this.currentKeysState &= 0xFFFFFFFB;
            }
        }
    }

    public void transferFocus() {
        super.transferFocus();
        if (tabEv == null) {
            tabEv = new Event(this, 403, null);
            WinCanvas.tabEv.key = 9;
        }
        this.handleEvent(tabEv);
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

