/*
 * Decompiled with CFR 0.152.
 */
package waba.fx;

import waba.fx.Font;
import waba.fx.NativeMethods4JDK;

public final class FontMetrics {
    protected Font font;
    public int ascent;
    public int descent;
    public int leading;
    public int height;

    public FontMetrics(Font font) {
        this(font, true);
    }

    FontMetrics(Font font, boolean dummy) {
        this.font = font;
        NativeMethods4JDK.fontMetricsCreate(this);
        this.height = this.ascent + this.descent;
    }

    public int getCharWidth(char c) {
        return NativeMethods4JDK.fontMetricsGetCharWidth(this, c);
    }

    public int getMaxWidth(String[] names, int start, int count) {
        int w = 0;
        while (count-- > 0) {
            int v;
            if ((v = this.getTextWidth(names[start++])) <= w) continue;
            w = v;
        }
        return w;
    }

    public int getTextWidth(String s) {
        return NativeMethods4JDK.fontMetricsGetTextWidth(this, s);
    }

    public int getTextWidth(char[] chars, int start, int count) {
        return NativeMethods4JDK.fontMetricsGetTextWidth(this, chars, start, count);
    }

    public int stringWidth(String s) {
        return NativeMethods4JDK.fontMetricsGetTextWidth(this, s);
    }
}

