/*
 * Decompiled with CFR 0.152.
 */
package waba.sys;

import waba.fx.FontMetrics;
import waba.sys.CharacterConverter;
import waba.sys.NativeMethods4JDK;
import waba.sys.Vm;
import waba.util.Date;
import waba.util.ElementNotFoundError;
import waba.util.Hashtable;
import waba.util.Vector;

public final class Convert {
    public static CharacterConverter charConverter = new CharacterConverter();
    private static Hashtable htConvs = new Hashtable(10);
    public static final long MIN_LONG_VALUE = Long.MIN_VALUE;
    public static final long MAX_LONG_VALUE = Long.MAX_VALUE;
    private static Vector vtok = new Vector();
    public static final int SORT_AUTODETECT = -1;
    public static final int SORT_OBJECT = 0;
    public static final int SORT_STRING = 1;
    public static final int SORT_INT = 2;
    public static final int SORT_DOUBLE = 3;
    public static final int SORT_DATE = 4;

    private Convert() {
    }

    public static int chars2int(String fourChars) {
        char[] chars = fourChars.toCharArray();
        return chars[0] << 24 | chars[1] << 16 | chars[2] << 8 | chars[3];
    }

    public static String[] cloneStringArray(String[] strs) {
        String[] ret = null;
        if (strs != null) {
            int n = strs.length;
            ret = new String[n];
            Vm.copyArray(strs, 0, ret, 0, n);
        }
        return ret;
    }

    public static int detectSortType(Object item) {
        int sortType;
        if (!(item instanceof String)) {
            sortType = 0;
        } else {
            String s = (String)item;
            sortType = 1;
            if (s.equals("0") || Convert.toInt(s) != 0) {
                sortType = 2;
            } else if (s.startsWith("0.0") || Convert.toDouble(s) != 0.0) {
                sortType = 3;
            } else if (new Date((String)s).wasDateValid) {
                sortType = 4;
            }
        }
        return sortType;
    }

    public static int digitOf(char ch, int radix) {
        int value = -1;
        if (radix >= 2 && radix <= 16) {
            value = ch >= '0' && ch <= '9' ? ch - 48 : (ch >= 'A' && ch <= 'F' ? ch - 65 + 10 : ch - 97 + 10);
        }
        return value >= 0 && value < radix ? value : -1;
    }

    public static long doubleToLongBits(double value) {
        return NativeMethods4JDK.convertDoubleToLongBits(value);
    }

    public static String dup(char c, int count) {
        char[] buf = new char[count];
        while (--count >= 0) {
            buf[count] = c;
        }
        return new String(buf);
    }

    public static char forDigit(int digit, int radix) {
        if (digit >= radix || digit < 0 || radix < 2 || radix > 16) {
            return '?';
        }
        if (digit < 10) {
            return (char)(48 + digit);
        }
        return (char)(87 + digit);
    }

    public static String getStackTrace(Throwable t) {
        return NativeMethods4JDK.convertGetStackTrace(t);
    }

    public static String insertLineBreak(int maxWidth, char separator, FontMetrics fm, String text) {
        String[] words = Convert.tokenizeString(text, ' ');
        StringBuffer sb = new StringBuffer(text.length() + 20);
        String s = "";
        int n = words.length;
        int i = 0;
        while (i < n) {
            if (fm.getTextWidth(String.valueOf(s) + ' ' + words[i]) > maxWidth) {
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                sb.append(s);
                s = "";
            }
            if (s.length() > 0) {
                s = String.valueOf(s) + ' ';
            }
            s = String.valueOf(s) + words[i];
            ++i;
        }
        if (s.length() > 0) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static double longBitsToDouble(long bits) {
        return NativeMethods4JDK.convertDoubleFromLongBits(bits);
    }

    public static void qsort(Object[] items, int first, int last) {
        Convert.qsort(items, first, last, -1);
    }

    public static void qsort(Object[] items, int first, int last, int sortType) {
        if (first >= last) {
            return;
        }
        if (sortType == -1) {
            sortType = Convert.detectSortType(items[first]);
        }
        int low = first;
        int high = last;
        block0 : switch (sortType) {
            case 0: {
                String mid = items[first + last >> 1].toString();
                while (true) {
                    if (high >= low && mid.compareTo(items[low].toString()) > 0) {
                        ++low;
                        continue;
                    }
                    while (high >= low && mid.compareTo(items[high].toString()) < 0) {
                        --high;
                    }
                    if (low > high) break block0;
                    Object temp = items[low];
                    items[low++] = items[high];
                    items[high--] = temp;
                }
            }
            case 1: {
                String mid = (String)items[first + last >> 1];
                while (true) {
                    if (high >= low && mid.compareTo((String)items[low]) > 0) {
                        ++low;
                        continue;
                    }
                    while (high >= low && mid.compareTo((String)items[high]) < 0) {
                        --high;
                    }
                    if (low > high) break block0;
                    Object temp = items[low];
                    items[low++] = items[high];
                    items[high--] = temp;
                }
            }
            case 2: {
                int mid = Convert.toInt((String)items[first + last >> 1]);
                while (true) {
                    if (high >= low && mid > Convert.toInt((String)items[low])) {
                        ++low;
                        continue;
                    }
                    while (high >= low && mid < Convert.toInt((String)items[high])) {
                        --high;
                    }
                    if (low > high) break block0;
                    Object temp = items[low];
                    items[low++] = items[high];
                    items[high--] = temp;
                }
            }
            case 3: {
                double mid = Convert.toDouble((String)items[first + last >> 1]);
                while (true) {
                    if (high >= low && mid > Convert.toDouble((String)items[low])) {
                        ++low;
                        continue;
                    }
                    while (high >= low && mid < Convert.toDouble((String)items[high])) {
                        --high;
                    }
                    if (low > high) break block0;
                    Object temp = items[low];
                    items[low++] = items[high];
                    items[high--] = temp;
                }
            }
            case 4: {
                int mid = new Date((String)items[first + last >> 1]).getDateInt();
                while (true) {
                    if (high >= low && mid > new Date((String)items[low]).getDateInt()) {
                        ++low;
                        continue;
                    }
                    while (high >= low && mid < new Date((String)items[high]).getDateInt()) {
                        --high;
                    }
                    if (low > high) break block0;
                    Object temp = items[low];
                    items[low++] = items[high];
                    items[high--] = temp;
                }
            }
        }
        if (first < high) {
            Convert.qsort(items, first, high, sortType);
        }
        if (low < last) {
            Convert.qsort(items, low, last, sortType);
        }
    }

    public static long rol(long i, int n, int bits) {
        long mask = (1L << bits) - 1L;
        if (mask > 0L) {
            i &= mask;
        }
        i = i >>> bits - n | i << n;
        if (mask > 0L) {
            i &= mask;
        }
        return i;
    }

    public static long ror(long i, int n, int bits) {
        if (bits <= 0) {
            return 0L;
        }
        long mask = (1L << bits) - 1L;
        if (mask > 0L) {
            i &= mask;
        }
        i = i >>> n | i << bits - n;
        if (mask > 0L) {
            i &= mask;
        }
        return i;
    }

    public static boolean setDefaultConverter(String name) {
        boolean ok = true;
        CharacterConverter cc = null;
        try {
            cc = (CharacterConverter)htConvs.get(name);
        }
        catch (ElementNotFoundError elementNotFoundError) {}
        if (cc == null) {
            try {
                cc = (CharacterConverter)Class.forName("waba.sys." + name + "CharacterConverter").newInstance();
            }
            catch (Exception exception) {
                cc = new CharacterConverter();
                ok = false;
            }
            htConvs.put(name, cc);
        }
        charConverter = cc;
        return ok;
    }

    public static double toDouble(String s) {
        return NativeMethods4JDK.convertToDouble(s);
    }

    public static float toFloat(String s) {
        return NativeMethods4JDK.convertToFloat(s);
    }

    public static float toFloatBitwise(int i) {
        return NativeMethods4JDK.convertToFloatBitwise(i);
    }

    public static int toInt(String s) {
        return NativeMethods4JDK.convertToInt(s);
    }

    public static int toIntBitwise(float f) {
        return NativeMethods4JDK.convertToIntBitwise(f);
    }

    public static long toLong(String s) {
        if (s == null) {
            return 0L;
        }
        long r = 0L;
        long m = 1L;
        char[] ac = s.toCharArray();
        int i = ac.length - 1;
        while (i >= 0) {
            char c = ac[i];
            if (c == '+') break;
            if (c == '-') {
                r = -r;
                break;
            }
            if (c < '0' || c > '9') {
                return 0L;
            }
            int digit = c - 48;
            if (digit < 0) {
                return 0L;
            }
            r += m * (long)(c - 48);
            m = m == 1L ? 10L : (m *= 10L);
            --i;
        }
        return r;
    }

    public static long toLong(String s, int radix) {
        if (s == null || radix < 2 || radix > 16) {
            return 0L;
        }
        long r = 0L;
        long m = 1L;
        char[] ac = s.toCharArray();
        int i = ac.length - 1;
        while (i >= 0) {
            char c = ac[i];
            if (c == '+') break;
            if (c == '-') {
                r = -r;
                break;
            }
            int digit = Convert.digitOf(c, radix);
            if (digit < 0) {
                return 0L;
            }
            r += m * (long)digit;
            m = m == 1L ? (long)radix : (m *= (long)radix);
            --i;
        }
        return r;
    }

    public static char toLowerCase(char c) {
        return NativeMethods4JDK.convertToLowerCase(c);
    }

    public static String toString(char c) {
        return NativeMethods4JDK.convertToString(c);
    }

    public static String toString(double d) {
        return Convert.toString(d, -1);
    }

    public static String toString(double d, int precision) {
        return NativeMethods4JDK.convertToString(d, precision);
    }

    public static String toString(float f) {
        return NativeMethods4JDK.convertToString(f);
    }

    public static String toString(float f, int d) {
        return NativeMethods4JDK.convertToString(f, d);
    }

    public static String toString(int i) {
        return NativeMethods4JDK.convertToString(i);
    }

    public static String toString(long l) {
        return Convert.toString(l, 10);
    }

    public static String toString(long i, int radix) {
        boolean negative;
        if (i == 0L) {
            return "0";
        }
        if (radix < 2 || radix > 16) {
            radix = 10;
        }
        StringBuffer buf = new StringBuffer(radix >= 8 ? 23 : 65);
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= (long)(-radix)) {
            char c = Convert.forDigit((int)(-(i % (long)radix)), radix);
            buf.append(c);
            i /= (long)radix;
        }
        buf.append(Convert.forDigit((int)(-i), radix));
        if (negative) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString(String doubleValue, int n) {
        return NativeMethods4JDK.convertToString(doubleValue, n);
    }

    public static String toString(boolean b) {
        return b ? "true" : "false";
    }

    public static String[] toStringArray(Object[] objs) {
        String[] as = null;
        if (objs != null) {
            as = new String[objs.length];
            int i = objs.length - 1;
            while (i >= 0) {
                as[i] = objs[i] != null ? objs[i].toString() : null;
                --i;
            }
        }
        return as;
    }

    public static char toUpperCase(char c) {
        return NativeMethods4JDK.convertToUpperCase(c);
    }

    public static String[] tokenizeString(String input, char delim) {
        int newPosition;
        int position = 0;
        int count = 1;
        while ((newPosition = input.indexOf(delim, position)) >= 0) {
            ++count;
            position = newPosition + 1;
        }
        if (count == 1) {
            return new String[]{input};
        }
        String[] as = new String[count];
        as[count - 1] = input.substring(position, input.length());
        position = 0;
        int i = 0;
        while (--count > 0) {
            newPosition = input.indexOf(delim, position);
            as[i++] = input.substring(position, newPosition);
            position = newPosition + 1;
        }
        return as;
    }

    public static String[] tokenizeString(String input, String delim) {
        vtok.removeAllElements();
        int inc = delim.length();
        if (inc == 0 || input.length() == 0) {
            return new String[]{input};
        }
        int position = 0;
        boolean loop = true;
        while (loop) {
            int newPosition = input.indexOf(delim, position);
            if (newPosition == -1) {
                newPosition = input.length();
                loop = false;
            }
            if (position != newPosition) {
                vtok.addElement(input.substring(position, newPosition));
            }
            position = newPosition + inc;
        }
        return (String[])vtok.toObjectArray();
    }

    public static String unsigned2hex(int b, int places) {
        return NativeMethods4JDK.convertUnsigned2hex(b, places);
    }

    public static String zeroPad(String s, int size) {
        int i = size - s.length();
        while (i > 0) {
            s = String.valueOf('0') + s;
            --i;
        }
        return s;
    }
}

