/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.Image;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Event;
import waba.ui.PenEvent;
import waba.ui.Window;

public class Button
extends Control {
    public static final byte BORDER_NONE = 0;
    public static final byte BORDER_SIMPLE = 1;
    public static final byte BORDER_3D = 2;
    protected String text;
    protected Image img;
    protected boolean armed;
    protected boolean isText;
    protected int gap;
    protected byte border = (byte)2;
    protected int ww;
    protected int hh;
    protected Color fColor;
    protected Color imgColor;
    protected Color aColor;
    protected Graphics myg;
    protected Color[] fourColors = new Color[4];
    protected boolean ignoreEvents;
    public boolean cutText = true;
    public static int commonGap;

    public Button(String text) {
        this.text = text;
        this.isText = true;
    }

    public Button(Image img) {
        this.img = img;
        this.imgColor = img.getTransparentColor();
    }

    public static Button createArrowButton(byte type, int h, Color fore) {
        boolean rotate = type == 4 || type == 3;
        int w = (h << 1) - 1;
        Image img = rotate ? new Image(h, w) : new Image(w, h);
        Graphics g = img.getGraphics();
        g.setBackColor(Color.WHITE);
        if (rotate) {
            g.fillRect(0, 0, h, w);
        } else {
            g.fillRect(0, 0, w, h);
        }
        g.drawArrow(0, 0, h, type, false, true, fore);
        return new Button(img);
    }

    public Image getImage() {
        return this.isText ? null : this.img;
    }

    public int getPreferredHeight() {
        return this.isText ? (Control.uiVista ? 1 : 0) + this.fmH + (commonGap + this.gap << 1) : this.img.getHeight() + (this.border + this.gap + commonGap << 1);
    }

    public int getPreferredWidth() {
        return (this.isText ? this.fm.getTextWidth(this.text) : this.img.getWidth()) + (this.border + this.gap + commonGap << 1);
    }

    public String getText() {
        return this.isText ? this.text : "image";
    }

    protected void onBoundsChanged() {
        if (this.isText) {
            if (this.text != null) {
                this.ww = this.width - this.fm.getTextWidth(this.text) >> 1;
                this.hh = this.height - this.fmH >> 1;
            }
        } else if (this.img != null) {
            this.ww = this.width - this.img.getWidth() >> 1;
            this.hh = this.height - this.img.getHeight() >> 1;
        }
        this.myg = this.createGraphics();
    }

    protected void onColorsChanged(boolean colorsChanged) {
        this.fColor = this.getForeColor();
        Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.fourColors);
        if (this.aColor == null) {
            this.aColor = this.backColor.getCursorColor();
        }
        if (!Control.uiCE) {
            this.fourColors[1] = this.aColor;
        }
    }

    public void onEvent(Event event) {
        if (this.ignoreEvents) {
            return;
        }
        switch (event.type) {
            case 101: {
                this.simulatePress();
                this.postEvent(new ControlEvent(300, this));
                break;
            }
            case 498: {
                if (this.myg != null) {
                    this.myg.free();
                }
                this.myg = this.createGraphics();
                break;
            }
            case 200: {
                this.armed = true;
                this.repaint();
                break;
            }
            case 202: {
                this.armed = false;
                this.repaint();
                PenEvent pe = (PenEvent)event;
                if (pe.x < 0 || pe.x >= this.width || pe.y < 0 || pe.y >= this.height) break;
                this.postEvent(new ControlEvent(300, this));
                break;
            }
            case 203: {
                PenEvent pe = (PenEvent)event;
                boolean lArmed = false;
                if (pe.x >= 0 && pe.x < this.width && pe.y >= 0 && pe.y < this.height) {
                    lArmed = true;
                }
                if (this.armed == lArmed) break;
                this.armed = lArmed;
                this.repaint();
                break;
            }
            case 302: {
                this.armed = false;
            }
        }
    }

    protected void onFontChanged() {
        this.onBoundsChanged();
    }

    public void onPaint(Graphics g) {
        if (this.myg == null) {
            this.myg = this.createGraphics();
        }
        this.paintButton(g, this.armed);
    }

    public void onlyShowImage() {
        this.border = 0;
        this.ignoreEvents = true;
        this.enabled = false;
    }

    protected void paintButton(Graphics g, boolean armed) {
        int xx = this.ww;
        int yy = this.hh;
        if (!this.ignoreEvents || this.img == null) {
            switch (Settings.uiStyle) {
                case 0: {
                    g.setBackColor(this.backColor);
                    g.fillRect(0, 0, this.width, this.height);
                    break;
                }
                case 1: {
                    g.setBackColor(armed ? this.aColor : this.backColor);
                    if (this.border == 0) {
                        g.fillRect(0, 0, this.width, this.height);
                        break;
                    }
                    if (armed) break;
                    g.fillHatchedRect(0, 0, this.width, this.height, true, true);
                    break;
                }
                case 2: {
                    g.setBackColor(armed ? this.aColor : this.backColor);
                    g.fillRect(0, 0, this.width, this.height);
                    break;
                }
                case 3: {
                    if (this.border == 0) {
                        g.setBackColor(this.backColor);
                        g.fillRect(0, 0, this.width, this.height);
                        break;
                    }
                    if (this.enabled) {
                        g.fill3dRect(0, 0, this.width, this.height, this.backColor, armed, false);
                        break;
                    }
                    g.setBackColor(this.backColor);
                    g.fillRect(0, 0, this.width, this.height);
                    g.drawVistaRect(0, 0, this.width, this.height, this.fColor, this.fColor, this.fColor, this.fColor);
                    break;
                }
            }
            if (this.border != 0 && (!Control.uiVista || this.enabled)) {
                g.draw3dRect(0, 0, this.width, this.height, armed ? (byte)2 : 3, false, this.border == 1, this.fourColors);
            }
            if (this.cutText) {
                g.setClip(this.border, this.border, this.width - (this.border << 1), this.height - (this.border << 1));
            }
            if (armed && (Control.uiCE || Control.uiVista)) {
                ++xx;
                ++yy;
            }
            g.setForeColor(this.fColor);
            if (this.isText) {
                g.drawText(this.text, xx, yy);
            }
        }
        if (!this.isText) {
            boolean isEnabled;
            boolean bl = isEnabled = this.enabled || this.ignoreEvents;
            if (this.imgColor != null) {
                g.setBackColor(this.imgColor);
                g.setDrawOp(isEnabled ? 6 : 7);
            } else {
                g.setDrawOp(isEnabled ? 0 : 7);
            }
            g.drawImage(this.img, xx, yy);
            g.setDrawOp(0);
        }
    }

    public void press(boolean pressed) {
        this.myg.clearClip();
        this.paintButton(this.myg, pressed);
        Window.updateScreen();
    }

    public void setBorder(byte border) {
        this.border = border;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public void setImage(Image img) {
        this.text = null;
        this.img = img;
        this.imgColor = img.getTransparentColor();
        this.isText = false;
        this.repaint();
    }

    public Color setPressedColor(Color newColour) {
        Color retVal = this.aColor;
        this.aColor = newColour;
        return retVal;
    }

    public void setText(String text) {
        this.text = text;
        this.isText = true;
        this.img = null;
        this.repaint();
    }

    public void simulatePress() {
        if (Settings.keyboardFocusTraversable) {
            this.myg = this.createGraphics();
        }
        this.press(true);
        Vm.sleep(100);
        this.press(false);
    }
}

