/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Font;
import waba.fx.Graphics;
import waba.fx.Rect;
import waba.sys.Convert;
import waba.sys.Settings;
import waba.ui.Button;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.Label;
import waba.ui.PushButtonGroup;
import waba.ui.UIColors;
import waba.ui.Window;
import waba.util.Date;
import waba.util.Vector;

public class Calendar
extends Window {
    private int day = -1;
    private int month;
    private int year;
    private int sentDay;
    private int sentMonth;
    private int sentYear;
    private Button btnToday;
    private Button btnClear;
    private Button btnCancel;
    private Button btnMonthNext;
    private Button btnMonthPrev;
    private Button btnYearNext;
    private Button btnYearPrev;
    private PushButtonGroup pbgDays;
    private String[] tempDays = new String[42];
    public boolean canceled;
    public static String[] weekNames = new String[]{"S", "M", "T", "W", "T", "F", "S"};
    public static String[] todayClearCancel = new String[]{"Today", "Clear", "Cancel"};

    public Calendar() {
        super("", (byte)1);
        this.highResPrepared = true;
        Color yearColor = Color.BRIGHT;
        Color monthColor = Color.BRIGHT;
        this.started = true;
        if (Settings.isColor) {
            yearColor = UIColors.calendarAction;
            monthColor = UIColors.calendarAction;
            this.setBackForeColors(UIColors.calendarBack, UIColors.calendarFore);
        }
        String[] defCaps = new String[42];
        int i = 0;
        while (i < 42) {
            defCaps[i] = Convert.toString(i + 10);
            ++i;
        }
        Font bold = this.font.asBold();
        int labH = bold.fm.height;
        Button.commonGap = 2;
        this.btnToday = new Button(todayClearCancel[0]);
        this.btnClear = new Button(todayClearCancel[1]);
        this.btnCancel = new Button(todayClearCancel[2]);
        int btnH = this.btnCancel.getPreferredHeight();
        Button.commonGap = 0;
        this.pbgDays = new PushButtonGroup(defCaps, false, -1, -1, this.fm.getCharWidth('@') - 2, 6, true, 0);
        int pbgW = this.pbgDays.getPreferredWidth();
        int cellWH = pbgW / 7;
        this.setRect(120000, 120000, pbgW + 10, 18 + labH * 2 + cellWH * 6 + btnH);
        int arrowW = labH / 2;
        this.btnYearPrev = Button.createArrowButton((byte)3, arrowW, yearColor);
        this.btnYearNext = Button.createArrowButton((byte)4, arrowW, yearColor);
        this.btnMonthPrev = Button.createArrowButton((byte)3, arrowW, monthColor);
        this.btnMonthNext = Button.createArrowButton((byte)4, arrowW, monthColor);
        this.btnYearPrev.setBorder((byte)0);
        this.btnYearNext.setBorder((byte)0);
        this.btnMonthPrev.setBorder((byte)0);
        this.btnMonthNext.setBorder((byte)0);
        this.add(this.btnYearPrev, 110002, 140000);
        this.add(this.btnYearNext, 190004, 140000);
        this.add(this.btnMonthNext, 129998, 140000);
        this.add(this.btnMonthPrev, 169996, 140000);
        int labY = labH + 5;
        this.add(this.pbgDays);
        this.pbgDays.setSimpleBorder(true);
        this.pbgDays.setRect(110004, 190000 + labY + 2, 100000, 6 * cellWH + 1);
        this.pbgDays.setCursorColor(yearColor.brighter());
        int i2 = 0;
        while (i2 < 7) {
            Label l = new Label(weekNames[i2]);
            l.setFont(bold);
            Rect r = this.pbgDays.rects[i2];
            this.add(l, r.x + 4 + (r.width - l.getPreferredWidth()) / 2, labY);
            ++i2;
        }
        Button.commonGap = 2;
        this.add(this.btnToday, 110004, 149996);
        this.add(this.btnClear, 120000, 180000);
        this.add(this.btnCancel, 129996, 180000);
        Button.commonGap = 0;
        if (Settings.isColor) {
            this.btnToday.setBackColor(UIColors.calendarAction);
            this.btnClear.setBackColor(UIColors.calendarAction);
            this.btnCancel.setBackColor(UIColors.calendarAction);
            this.btnYearPrev.setBackColor(Color.BLACK);
            this.btnYearNext.setBackColor(Color.BLACK);
            this.btnMonthNext.setBackColor(Color.BLACK);
            this.btnMonthPrev.setBackColor(Color.BLACK);
        }
        this.tabOrder = new Vector(new Control[]{this.pbgDays, this.btnToday, this.btnClear, this.btnCancel, this.btnYearPrev, this.btnYearNext, this.btnMonthPrev, this.btnMonthNext});
    }

    public Date getSelectedDate() {
        if (this.day == -1) {
            return null;
        }
        Date date = new Date(this.day, this.month, this.year);
        return date;
    }

    public void onEvent(Event event) {
        switch (event.type) {
            case 100: {
                if (((KeyEvent)event).key != 76000 && ((KeyEvent)event).key != 76001) break;
                this.unpop();
                break;
            }
            case 300: {
                if (event.target == this.btnToday) {
                    this.setSelectedDate(null);
                    this.day = this.sentDay;
                    this.unpop();
                    break;
                }
                if (event.target == this.btnClear) {
                    this.day = -1;
                    this.unpop();
                    break;
                }
                if (event.target == this.btnCancel) {
                    this.canceled = true;
                    this.unpop();
                    break;
                }
                if (event.target == this.pbgDays && this.pbgDays.getSelected() >= 0) {
                    Date date = new Date(Convert.toInt(this.pbgDays.getSelectedCaption()), this.month, this.year);
                    if (!date.wasDateValid) break;
                    this.day = date.getDay();
                    this.unpop();
                    break;
                }
                if (event.target == this.btnMonthNext) {
                    if (++this.month == 13) {
                        this.month = 1;
                        ++this.year;
                    }
                    this.updateDays();
                    break;
                }
                if (event.target == this.btnMonthPrev) {
                    if (--this.month == 0) {
                        --this.year;
                        this.month = 12;
                    }
                    this.updateDays();
                    break;
                }
                if (event.target == this.btnYearNext) {
                    ++this.year;
                    this.updateDays();
                    break;
                }
                if (event.target != this.btnYearPrev) break;
                --this.year;
                this.updateDays();
                break;
            }
        }
    }

    public void onPaint(Graphics g) {
        this.paintTitle(String.valueOf(Date.getMonthName(this.month)) + ' ' + this.year, g);
    }

    protected void onPopup() {
        this.canceled = false;
        this.day = -1;
        this.setTitle(String.valueOf(Date.getMonthName(this.month)) + " " + new Date().getYear());
        if (this.sentDay <= 0) {
            this.setSelectedDate(null);
        }
    }

    public void onUnpop() {
        this.setFocus(this);
    }

    protected void postUnpop() {
        if (!this.canceled) {
            this.postPressedEvent();
        }
    }

    public void setSelectedDate(Date d) {
        if (d == null) {
            d = new Date();
        }
        this.sentMonth = this.month = d.getMonth();
        this.sentYear = this.year = d.getYear();
        this.sentDay = this.day = d.getDay();
        this.updateDays();
    }

    private void updateDays() {
        Date date = new Date(1, this.month, this.year);
        int start = date.getDayOfWeek();
        int end = start + date.getDaysInMonth();
        this.pbgDays.setSelected(-1);
        int d = 1;
        String[] days = this.tempDays;
        int i = 0;
        while (i < 42) {
            this.pbgDays.setColor(i, null, null);
            days[i] = start <= i && i < end ? Convert.toString(d++) : "";
            ++i;
        }
        if (Settings.keyboardFocusTraversable) {
            days[end] = " x";
        }
        if (this.year == this.sentYear && this.month == this.sentMonth) {
            this.pbgDays.setColor(this.sentDay - 1 + start, null, UIColors.calendarAction);
        }
        this.pbgDays.setNames(days);
        this.repaint();
    }
}

