/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Coord;
import waba.fx.Font;
import waba.fx.FontMetrics;
import waba.fx.Graphics;
import waba.fx.ISurface;
import waba.fx.Rect;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.Container;
import waba.ui.Event;
import waba.ui.MainWindow;
import waba.ui.Timer;
import waba.ui.UIColors;
import waba.ui.Window;
import waba.util.Vector;

public class Control
implements ISurface {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Container parent;
    Object hvGrHandle;
    Control next;
    Control prev;
    protected boolean enabled = true;
    protected Font font = MainWindow.defaultFont;
    public FontMetrics fm;
    protected boolean visible = true;
    protected Color foreColor;
    protected Color backColor;
    public int appId;
    public Object appObj;
    public String clearValueStr = "";
    public int clearValueInt = 0;
    public static final int PREFERRED = 100000;
    public static final int LEFT = 110000;
    public static final int CENTER = 120000;
    public static final int RIGHT = 130000;
    public static final int TOP = 140000;
    public static final int BOTTOM = 150000;
    public static final int FILL = 160000;
    public static final int BEFORE = 170000;
    public static final int SAME = 180000;
    public static final int AFTER = 190000;
    public static final int FIT = 200000;
    protected int fmH;
    protected static boolean isHighlighting = true;
    public static int highlightRectsCount = Settings.screenWidth > 200 ? 3 : 2;
    public boolean focusTraversable = true;
    public static boolean uiPalm;
    public static boolean uiCE;
    public static boolean uiFlat;
    public static boolean uiVista;
    protected Color foreDis;
    protected Color backDis;
    protected int x2;
    protected int y2;
    protected boolean focusLess;
    boolean eventsEnabled = true;
    public static final int RANGE = 4000;
    private static Rect cli;
    protected Container asContainer;
    protected Window asWindow;
    private static Coord hCoord;

    static {
        uiCE = true;
        cli = new Rect();
        hCoord = new Coord();
    }

    protected Control() {
        this.fm = this.font.fm;
        this.fmH = this.fm.height;
    }

    public Timer addTimer(int millis) {
        return MainWindow.mainWindowInstance.addTimer(this, millis);
    }

    public void changeHighlighted(Container p, boolean forward) {
        Control c = this.getNextHighlighted(p, forward);
        if (c != null) {
            if (c.asContainer != null && c.asContainer.tabOrder.size() > 0) {
                c.changeHighlighted(c.asContainer, forward);
            } else {
                this.getParentWindow().setHighlighted(c);
            }
        } else if (this.parent != null) {
            this.parent.changeHighlighted(this.parent.parent != null ? this.parent.parent : this.parent, forward);
        } else if (p != this.asWindow) {
            this.changeHighlighted(this.asWindow, forward);
        }
    }

    public void clear() {
    }

    public boolean contains(int x, int y) {
        return this.x <= x && x <= this.x2 && this.y <= y && y <= this.y2;
    }

    public Graphics createGraphics() {
        int x = 0;
        int y = 0;
        Control c = this;
        while (c.asWindow == null) {
            x += c.x;
            y += c.y;
            c = c.parent;
            if (c != null) continue;
            return null;
        }
        Graphics g = new Graphics(this);
        g.translate(x + c.asWindow.x, y + c.asWindow.y);
        g.setFont(this.font);
        return g;
    }

    public void drawHighlight() {
        Window w;
        if (Settings.keyboardFocusTraversable && (w = this.getParentWindow()) != null) {
            Graphics g = w.createGraphics();
            g.setClip(0, 0, w.width, w.height);
            this.translateFromOrigin(hCoord);
            int i = UIColors.highlightColors.length;
            while (i > 0) {
                g.setForeColor(UIColors.highlightColors[i - 1]);
                g.drawRect(Control.hCoord.x - i - 1, Control.hCoord.y - i - 1, this.width + i + i + 2, this.height + i + i + 2);
                --i;
            }
            g.clearClip();
        }
    }

    public Rect getAbsoluteRect() {
        Rect r = this.getRect();
        Container c = this.parent;
        while (c != null) {
            r.x += c.x;
            r.y += c.y;
            c = c.parent;
        }
        return r;
    }

    public Color getBackColor() {
        return this.enabled || this.parent == null ? this.backColor : (this.backColor.equ == Color.WHITE.equ && this.backColor.equ == this.parent.getBackColor().equ ? Color.WHITE : this.backDis);
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return font.fm;
    }

    public Color getForeColor() {
        return this.enabled ? this.foreColor : this.foreDis;
    }

    public Control getNext() {
        return this.next;
    }

    private Control getNextHighlighted(Container p, boolean forward) {
        Control c;
        int inc;
        Vector v = p.tabOrder;
        int idx = v.indexOf(this);
        int last = v.size() - 1;
        if (last == -1) {
            return null;
        }
        if (p == this) {
            idx = forward ? -1 : last + 1;
        } else if (idx == -1) {
            return null;
        }
        int limit = forward ? last : 0;
        int n = inc = forward ? 1 : -1;
        do {
            if (idx == limit) {
                return null;
            }
            c = (Control)v.items[idx += inc];
        } while (!c.visible || !c.enabled || !c.focusTraversable);
        return c;
    }

    public Container getParent() {
        return this.parent;
    }

    /*
     * Unable to fully structure code
     */
    public Window getParentWindow() {
        c = this.parent;
        if (c == null || c.parentWindow == null) ** GOTO lbl5
        return c.parentWindow;
lbl-1000:
        // 1 sources

        {
            c = c.parent;
lbl5:
            // 2 sources

            ** while (c != null && c.asWindow == null)
        }
lbl6:
        // 1 sources

        return c != null ? (Window)c : Window.getTopMost();
    }

    public Coord getPos() {
        return new Coord(this.x, this.y);
    }

    public int getPreferredHeight() {
        return this.fmH;
    }

    public int getPreferredWidth() {
        return 30;
    }

    public Rect getRect() {
        return new Rect(this.x, this.y, this.width, this.height);
    }

    public Coord getSize() {
        return new Coord(this.width, this.height);
    }

    public boolean isDisplayed() {
        Control c = this;
        while (c.asWindow == null) {
            c = c.parent;
            if (c != null) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void onBoundsChanged() {
    }

    protected void onColorsChanged(boolean colorsChanged) {
    }

    public void onEvent(Event event) {
    }

    protected void onFontChanged() {
    }

    public void onPaint(Graphics g) {
    }

    protected void onWindowPaintFinished() {
    }

    public void postEvent(Event event) {
        if (Settings.keyboardFocusTraversable && event.type == 300) {
            (this.asContainer != null ? this.asContainer : this.parent.asContainer).setHighlighting();
        }
        if (!this.enabled || !this.eventsEnabled && event.type != 303) {
            return;
        }
        Control c = this;
        while (c != null) {
            Container cp = c.parent;
            c.onEvent(event);
            if (event.consumed) {
                event.consumed = false;
                break;
            }
            if (cp != c.parent) break;
            c = cp;
        }
    }

    public boolean removeTimer(Timer timer) {
        return MainWindow.mainWindowInstance.removeTimer(timer);
    }

    public void repaint() {
        int x = 0;
        int y = 0;
        Control c = this;
        while (c.asWindow == null) {
            x += c.x;
            y += c.y;
            c = c.parent;
            if (c != null) continue;
            return;
        }
        c.asWindow.damageRect(x, y, this.width, this.height);
    }

    public void repaintNow() {
        if (Window.zStack.indexOf(this.getParentWindow(), 0) >= 0) {
            if (this.asWindow != null) {
                this.repaint();
                this.asWindow._doPaint(0, 0, this.width, this.height);
                Window.updateScreen();
            } else {
                Graphics g;
                if (this.asContainer != null) {
                    this.repaint();
                }
                if ((g = this.createGraphics()) != null) {
                    this.onPaint(g);
                    if (this.asContainer != null) {
                        this.asContainer.paintChildren(g, 0, 0, this.width, this.height);
                    }
                    Window.updateScreen();
                }
            }
        }
    }

    public void requestFocus() {
        this.getParentWindow().setFocus(this);
    }

    public void setBackColor(Color c) {
        this.backColor = c;
        this.backDis = this.enabled ? null : this.backColor.darker();
        this.onColorsChanged(true);
    }

    public void setBackForeColors(Color back, Color fore) {
        this.backColor = back;
        this.foreColor = fore;
        if (this.enabled) {
            this.foreDis = null;
            this.backDis = null;
        } else {
            this.backDis = this.backColor.darker();
            this.foreDis = this.foreColor.brighter();
        }
        this.onColorsChanged(true);
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            if (this.foreDis == null) {
                this.backDis = this.backColor.darker();
                this.foreDis = this.foreColor.brighter();
            }
            this.onColorsChanged(false);
            this.repaint();
        }
    }

    public void setFocusLess(boolean on) {
        Container p = this.parent;
        if (p != null) {
            if (on) {
                p.tabOrder.removeElement(this);
            } else {
                p.tabOrder.addElement(this);
            }
        }
        this.focusLess = on;
        if (this.asContainer != null) {
            Control c = this.asContainer.children;
            while (c != null) {
                if (c.asContainer != null) {
                    c.setFocusLess(on);
                } else {
                    c.focusLess = on;
                }
                c = c.next;
            }
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.fm = font.fm;
        this.fmH = this.fm.height;
        this.onFontChanged();
    }

    public void setForeColor(Color c) {
        this.foreColor = c;
        this.foreDis = this.enabled ? null : this.foreColor.brighter();
        this.onColorsChanged(true);
    }

    public void setRect(int x, int y, int width, int height) {
        this.setRect(x, y, width, height, null);
    }

    public void setRect(int x, int y, int width, int height, Control relative) {
        if (x + y + width + height >= 50000) {
            int lpx = 0;
            int lpy = 0;
            Container parent = this.parent;
            Rect cli = Control.cli;
            if (parent != null) {
                parent.getClientRect(cli);
                lpx = parent.lastX;
                lpy = parent.lastY;
                if (relative != null) {
                    parent.lastX = relative.x;
                    parent.lastY = relative.y;
                    parent.lastW = relative.width;
                    parent.lastH = relative.height;
                } else if (parent.lastX == -999999) {
                    parent.lastX = cli.x;
                    parent.lastY = cli.y;
                }
            } else {
                cli.x = 0;
                cli.y = 0;
                cli.width = Settings.screenWidth;
                cli.height = Settings.screenHeight;
            }
            if (width >= 96000 && width <= 104000) {
                width = this.getPreferredWidth() + (width - 100000);
            } else if (width >= 176000 && width <= 184000 && parent != null) {
                width = parent.lastW + width - 180000;
            }
            if (height >= 96000 && height <= 104000) {
                height = this.getPreferredHeight() + (height - 100000);
            } else if (height >= 176000 && height <= 184000 && parent != null) {
                height = parent.lastH + height - 180000;
            }
            if (x > 50000) {
                if (x >= 186000 && x <= 194000 && parent != null) {
                    x = parent.lastX + parent.lastW + x - 190000;
                } else if (x >= 166000 && x <= 174000 && parent != null) {
                    x = parent.lastX - width + x - 170000;
                } else if (x >= 176000 && x <= 184000 && parent != null) {
                    x = parent.lastX + x - 180000;
                } else if (x >= 106000 && x <= 114000) {
                    x = cli.x + x - 110000;
                } else if (x >= 126000 && x <= 134000) {
                    x = cli.x + cli.width - width + x - 130000;
                } else if (x >= 116000 && x <= 124000) {
                    x = cli.x + (cli.width - width >> 1) + x - 120000;
                }
            }
            if (y > 50000) {
                if (y >= 186000 && y <= 194000 && parent != null) {
                    y = parent.lastY + parent.lastH + y - 190000;
                } else if (y >= 166000 && y <= 174000 && parent != null) {
                    y = parent.lastY - height + y - 170000;
                } else if (y >= 176000 && y <= 184000 && parent != null) {
                    y = parent.lastY + y - 180000;
                } else if (y >= 136000 && y <= 144000) {
                    y = cli.y + y - 140000;
                } else if (y >= 146000 && y <= 154000) {
                    y = cli.y + cli.height - height + y - 150000;
                } else if (y >= 116000 && y <= 124000) {
                    y = cli.y + (cli.height - height >> 1) + y - 120000;
                }
            }
            if (width > 50000) {
                if (width >= 156000 && width <= 164000) {
                    width = cli.width - x + cli.x + width - 160000;
                } else if (width >= 196000 && width <= 204000 && parent != null) {
                    width = lpx - x + width - 200000;
                }
            }
            if (height > 50000) {
                if (height >= 156000 && height <= 164000) {
                    height = cli.height - y + cli.y + height - 160000;
                } else if (height >= 196000 && height <= 204000 && parent != null) {
                    height = lpy - y + height - 200000;
                }
            }
            if (!Settings.onDevice) {
                if (cli.width == 0 || cli.height == 0) {
                    Vm.warning(String.valueOf(String.valueOf(parent)) + " must have its bounds set before calling " + this + ".setRect");
                } else if (x + y + width + height > 50000) {
                    y = 0;
                    x = 0;
                    height = 10;
                    width = 10;
                    Vm.warning("To use AFTER/BEFORE/SAME you must add first the control " + this.toString() + " to the parent container.");
                } else if (x + y < -50000) {
                    if (x < -50000) {
                        Vm.warning("You can't use FILL with BEFORE, CENTER or RIGHT for control " + this.toString());
                    } else {
                        Vm.warning("You can't use FILL with BEFORE, CENTER or BOTTOM for control " + this.toString());
                    }
                } else if (this.asWindow != null && !this.asWindow.highResPrepared) {
                    Vm.warning("This window " + this.toString() + " is not prepared for high resolution devices! Set highResPrepared to true and test it in 320x320 resolution!");
                }
            }
        }
        if (this.asWindow != null && this.fmH > 11 && !this.asWindow.highResPrepared && width <= 160 && height <= 160) {
            float factor = (float)this.fmH / 11.0f;
            width = (int)((float)width * factor);
            height = (int)((float)height * factor);
            x = Settings.screenWidth - width >> 1;
            y = Settings.screenHeight - height >> 1;
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.x2 = x + width - 1;
        this.y2 = y + height - 1;
        if (this.parent != null) {
            this.parent.lastX = x;
            this.parent.lastY = y;
            this.parent.lastW = width;
            this.parent.lastH = height;
        }
        if (this.visible && this.parent != null && this.parent.finishedStart || this.asWindow != null && this.asWindow.finishedStart) {
            this.repaint();
        }
        this.onBoundsChanged();
        if (this.asContainer != null && !this.asContainer.started) {
            this.asContainer.started = true;
            this.asContainer.onStart();
            this.asContainer.finishedStart = true;
        }
    }

    public void setRect(Rect r) {
        this.setRect(r.x, r.y, r.width, r.height, null);
    }

    public void setVisible(boolean visible) {
        if (visible != this.visible) {
            this.visible = visible;
            this.repaint();
            if (this.parent != null && this.parent.parentWindow != null) {
                this.parent.parentWindow.eraseBackgroundNow = true;
            }
        }
    }

    public void translateFromOrigin(Coord z) {
        z.y = 0;
        z.x = 0;
        Control c = this;
        while (c != null) {
            if (c.asWindow != null) break;
            z.x += c.x;
            z.y += c.y;
            c = c.parent;
        }
    }

    public static void uiStyleChanged() {
        uiPalm = Settings.uiStyle == 1;
        uiCE = Settings.uiStyle == 0;
        uiFlat = Settings.uiStyle == 2;
        uiVista = Settings.uiStyle == 3;
    }
}

