/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.Rect;
import waba.fx.Sound;
import waba.sys.Convert;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.Calculator;
import waba.ui.Calendar;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.Keyboard;
import waba.ui.Keypad;
import waba.ui.PenEvent;
import waba.ui.Timer;
import waba.ui.UIColors;
import waba.util.Date;

public class Edit
extends Control {
    private Graphics drawg;
    private Timer blinkTimer;
    private static int[] xMins = new int[]{4, 1, 3, 3};
    static int[] prefHs = new int[]{4, 1, 2, 2};
    private boolean hasFocus;
    private boolean cursorShowing;
    public boolean editable = true;
    public boolean overwrite;
    public int alignment = 110000;
    private Rect clipRect = new Rect();
    private Rect clipRectSave = new Rect();
    private char[] chars = new char[4];
    private byte[] charWidths = new byte[4];
    private int totalCharWidth;
    protected int len;
    protected boolean hasBorder = true;
    private int xMax;
    private int xMin;
    private int gap;
    private Color fColor;
    private Color back0;
    private Color back1;
    private Color[] fourColors = new Color[4];
    private int insertPos;
    private int startSelectPos;
    private int xOffset;
    private boolean wasFocusIn;
    private boolean isCommand;
    private int oldTabIndex = -1;
    private boolean ignoreSelect;
    protected String validChars;
    public static Keyboard keyboard;
    public static Calendar calendar;
    public static Calculator calculator;
    byte mode;
    protected int maxLength;
    public String mask;
    protected byte capitalise;
    public static boolean removeFocusOnAction;
    protected byte kbdType = 1;
    public boolean hasCursorWhenNotEditable = true;
    public boolean autoSelect = Settings.keyboardFocusTraversable;
    public static final byte KBD_NONE = 0;
    public static final byte KBD_DEFAULT = 1;
    public static final byte KBD_KEYBOARD = 2;
    public static final byte KBD_CALCULATOR = 3;
    public static final byte KBD_CALENDAR = 4;
    public static final String numbersSet = "0123456789";
    public static final String currencyCharsSet = "0123456789.+-";
    public static final String dateSet;
    public static final byte NORMAL = 0;
    public static final byte DATE = 1;
    public static final byte CURRENCY = 2;
    public static final byte PASSWORD = 3;
    public static final byte PASSWORD_ALL = 4;
    public static final byte ALL_NORMAL = 0;
    public static final byte ALL_UPPER = 1;
    public static final byte ALL_LOWER = 2;
    protected int pushedInsertPos;
    protected int pushedStartSelectPos;
    protected int pushedxOffset;

    static {
        removeFocusOnAction = true;
        dateSet = numbersSet + Settings.dateSeparator;
    }

    public Edit() {
        this.clearPosState();
    }

    public Edit(String mask) {
        this();
        this.mask = mask;
    }

    protected int charPos2x(int n) {
        if (n > this.len) {
            n = this.len;
        }
        int cx = this.xOffset;
        int i = 0;
        while (i < n) {
            cx += this.charWidths[i];
            ++i;
        }
        return cx;
    }

    public void clear() {
        this.setText(this.clearValueStr);
    }

    private void clearPosState() {
        this.insertPos = 0;
        this.startSelectPos = -1;
        this.xOffset = xMins[Settings.uiStyle];
    }

    private void computeCharWidths(char[] showchars) {
        this.charWidths = new byte[this.len];
        this.totalCharWidth = 0;
        int i = this.len - 1;
        while (i >= 0) {
            int charWidth = this.fm.getCharWidth(showchars[i]);
            this.charWidths[i] = (byte)charWidth;
            this.totalCharWidth += charWidth;
            --i;
        }
    }

    protected void draw(Graphics g, boolean cursorOnly) {
        if (g == null) {
            return;
        }
        int y = this.height - this.fmH - this.gap;
        g.getClip(this.clipRectSave);
        if (!cursorOnly) {
            char[] showchars = this.chars;
            if (this.mode >= 3 && this.chars.length > 0 && this.len > 0) {
                showchars = new char[this.chars.length];
                boolean includeLast = this.mode == 4;
                int n = Math.min(includeLast ? this.len : this.len - 1, this.chars.length);
                int w = this.fm.getCharWidth('*');
                int i = 0;
                while (i < n) {
                    showchars[i] = 42;
                    ++i;
                }
                if (this.charWidths != null) {
                    int i2 = Math.min(this.charWidths.length, n) - 1;
                    while (i2 >= 0) {
                        this.charWidths[i2] = (byte)w;
                        --i2;
                    }
                }
                if (includeLast) {
                    if (this.charWidths != null && this.charWidths.length > n) {
                        this.totalCharWidth = n * w;
                    }
                } else {
                    showchars[n] = this.chars[n];
                    if (this.charWidths != null && this.charWidths.length > n) {
                        this.charWidths[n] = (byte)this.fm.getCharWidth(this.chars[n]);
                        this.totalCharWidth = n * w + this.charWidths[n];
                    }
                }
            }
            if (this.charWidths == null) {
                this.computeCharWidths(showchars);
            }
            this.clipRect.set(0, 0, this.width, this.height);
            g.clip(this.clipRect);
            g.setClip(this.clipRect);
            g.setBackColor(this.back0);
            g.fillRect(this.gap, this.gap, this.width - (this.gap << 1), this.height - (this.gap << 1));
            if (this.len > 0) {
                g.setForeColor(this.fColor);
                int xx = this.xOffset;
                if (!this.hasFocus) {
                    switch (this.alignment) {
                        case 130000: {
                            xx = this.width - this.totalCharWidth - this.xOffset;
                            break;
                        }
                        case 120000: {
                            xx = this.width - this.totalCharWidth >> 1;
                            break;
                        }
                    }
                }
                g.drawText(showchars, 0, this.len, xx, y);
                if (this.startSelectPos != -1) {
                    int sel1 = Math.min(this.startSelectPos, this.insertPos);
                    int sel2 = Math.max(this.startSelectPos, this.insertPos);
                    int sel1X = this.charPos2x(sel1);
                    int sel2X = this.charPos2x(sel2);
                    g.setForeColor(this.back0);
                    g.setBackColor(this.back1);
                    g.eraseRect(sel1X, y, sel2X - sel1X, this.fmH);
                }
            }
            if (this.hasBorder) {
                g.draw3dRect(0, 0, this.width, this.height, (byte)1, false, false, this.fourColors);
            }
        }
        if (this.hasFocus && this.enabled && (this.editable || this.hasCursorWhenNotEditable)) {
            int xx = this.charPos2x(this.insertPos);
            if (this.xMin <= xx && xx <= this.xMax) {
                g.clearClip();
                g.drawCursor(xx - 1, y, 1, this.fmH);
            }
            this.cursorShowing = cursorOnly ? this.cursorShowing ^ true : true;
        } else {
            this.cursorShowing = false;
        }
        g.setClip(this.clipRectSave);
    }

    public int[] getCursorPos() {
        return new int[]{this.startSelectPos, this.insertPos};
    }

    public byte getKeyboardType() {
        return this.kbdType;
    }

    public int getLength() {
        return this.len;
    }

    public int getPreferredHeight() {
        return this.fmH + prefHs[Settings.uiStyle];
    }

    public int getPreferredWidth() {
        return this.mask == null ? Settings.screenWidth >> 2 : (this.mask.length() == 0 ? 160000 : this.fm.getTextWidth(this.mask) + (Control.uiCE ? 10 : (Control.uiFlat || Control.uiVista ? 8 : 4)));
    }

    public String getText() {
        return new String(this.chars, 0, this.len);
    }

    protected boolean isCharValid(char c) {
        return this.validChars == null || this.validChars.indexOf(Convert.toUpperCase(c)) != -1;
    }

    public boolean isEditable() {
        return this.editable;
    }

    protected void onBoundsChanged() {
        this.drawg = null;
        this.xMin = xMins[Settings.uiStyle];
        this.xMax = this.width - this.xMin - 2;
        this.gap = this.hasBorder ? this.xMin >> 1 : 0;
    }

    protected void onColorsChanged(boolean colorsChanged) {
        this.fColor = this.getForeColor();
        Color color = this.back0 = UIColors.sameColors ? this.backColor : this.getBackColor().brighter();
        this.back1 = this.back0.equ != Color.WHITE.equ ? (UIColors.sameColors ? this.getBackColor().darker() : this.backColor) : this.back0.getCursorColor();
        Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.fourColors);
    }

    public void onEvent(Event event) {
        boolean insertChanged;
        if (this.charWidths == null) {
            return;
        }
        if (calendar != null && event.type == 499 && event.target == calendar) {
            Date d = calendar.getSelectedDate();
            if (d != null) {
                this.setText(d.toString());
            } else if (!Edit.calendar.canceled) {
                this.setText("");
            }
            return;
        }
        boolean redraw = false;
        boolean extendSelect = false;
        boolean clearSelect = false;
        if (this.len == 0) {
            this.startSelectPos = 0;
            this.insertPos = 0;
        }
        int newInsertPos = this.insertPos;
        block0 : switch (event.type) {
            case 498: {
                this.drawg = this.createGraphics();
                this.repaint();
                break;
            }
            case 303: {
                if (this.parent != null) {
                    this.draw(this.drawg, true);
                }
                event.consumed = true;
                return;
            }
            case 301: {
                Control.isHighlighting = false;
                this.wasFocusIn = true;
                this.drawg = this.createGraphics();
                this.hasFocus = true;
                redraw = true;
                if (this.blinkTimer == null) {
                    this.blinkTimer = this.addTimer(350);
                }
                if (this.autoSelect && this.len > 0 && !this.ignoreSelect) {
                    this.startSelectPos = this.len;
                    newInsertPos = 0;
                }
                if (!Settings.keypadOnly || this.mode != 2 && this.mode != 1) break;
                Keypad keypad = Keypad.getInstance();
                keypad.setNumberKeys(this.mode == 2 ? ".-" : Convert.toString(Settings.dateSeparator));
                keypad.setKeys(Keypad.numberKeyset);
                break;
            }
            case 302: {
                if (this.cursorShowing) {
                    this.draw(this.drawg, true);
                }
                if (Settings.virtualKeyboard && this.mode != 1 && this.mode != 2) {
                    this.getParentWindow().setStatePosition(10000, 10000);
                }
                this.hasFocus = false;
                this.clearPosState();
                newInsertPos = 0;
                redraw = true;
                if (this.removeTimer(this.blinkTimer)) {
                    this.blinkTimer = null;
                }
                if (!Settings.keypadOnly || this.mode != 2 && this.mode != 1) break;
                Keypad keypad = Keypad.getInstance();
                keypad.setKeys(null);
                keypad.setNumberKeys(null);
                break;
            }
            case 100: {
                int i;
                if (!this.editable) break;
                KeyEvent ke = (KeyEvent)event;
                if (Settings.keyboardFocusTraversable && event.target == this && (ke.isActionKey() || ke.key == 75012)) {
                    if (removeFocusOnAction) {
                        this.parent.requestFocus();
                    }
                    Control.isHighlighting = true;
                    break;
                }
                boolean isPrintable = ke.key < 65536 && (ke.modifiers & 1) == 0 && (ke.modifiers & 2) == 0;
                if (ke.key == 75015) {
                    this.isCommand ^= true;
                    break;
                }
                if ((ke.key == 76000 || ke.key == 76001) && this.popupsHidden()) {
                    this.popupKCC();
                    break;
                }
                boolean isControl = (ke.modifiers & 2) != 0;
                boolean isDelete = ke.key == 75013;
                boolean isBackspace = ke.key == 75011;
                int del1 = -1;
                int del2 = -1;
                int sel1 = this.startSelectPos;
                int sel2 = this.insertPos;
                if (sel1 > sel2) {
                    int temp = sel1;
                    sel1 = sel2;
                    sel2 = temp;
                }
                if (this.isCommand || isControl) {
                    this.isCommand = false;
                    if (isControl) {
                        ke.key += 64;
                        ke.modifiers &= 0xFFFFFFFD;
                    }
                    char key = Convert.toUpperCase((char)ke.key);
                    switch (key) {
                        case ' ': {
                            this.setText("");
                            break;
                        }
                        case 'C': 
                        case 'X': {
                            if (sel1 == -1) break block0;
                            Vm.clipboardCopy(new String(this.chars).substring(sel1, sel2));
                            if (key == 'X') {
                                ke.key = 75011;
                                this.onEvent(ke);
                                break;
                            }
                            Sound.beep();
                            break;
                        }
                        case 'P': 
                        case 'V': {
                            String pasted = Vm.clipboardPaste();
                            if (pasted == null || pasted.length() == 0) {
                                Sound.beep();
                                break;
                            }
                            char[] ch = pasted.toCharArray();
                            int i2 = 0;
                            while (i2 < ch.length) {
                                ke.key = ch[i2];
                                this.onEvent(ke);
                                ++i2;
                            }
                            newInsertPos += ch.length;
                            break;
                        }
                        default: {
                            Sound.beep();
                            break;
                        }
                    }
                    break;
                }
                if (isPrintable) {
                    if (this.capitalise == 1) {
                        ke.key = Convert.toUpperCase((char)ke.key);
                    } else if (this.capitalise == 2) {
                        ke.key = Convert.toLowerCase((char)ke.key);
                    }
                    if (!this.isCharValid((char)ke.key)) {
                        Sound.beep();
                        break;
                    }
                }
                if (sel1 != -1 && (isPrintable || isDelete || isBackspace)) {
                    del1 = sel1;
                    del2 = sel2 - 1;
                } else if (isDelete) {
                    del1 = this.insertPos;
                    del2 = this.insertPos;
                } else if (isBackspace) {
                    del1 = this.insertPos - 1;
                    del2 = this.insertPos - 1;
                }
                if (del1 >= 0 && del2 < this.len) {
                    int deleteCount = del2 - del1 + 1;
                    int numOnRight = this.len - del2 - 1;
                    if (this.cursorShowing) {
                        this.draw(this.drawg, true);
                    }
                    i = del1;
                    while (i <= del2) {
                        this.totalCharWidth -= this.charWidths[i];
                        ++i;
                    }
                    if (numOnRight > 0) {
                        Vm.copyArray(this.chars, del2 + 1, this.chars, del1, numOnRight);
                        Vm.copyArray(this.charWidths, del2 + 1, this.charWidths, del1, numOnRight);
                    }
                    this.len -= deleteCount;
                    newInsertPos = del1;
                    redraw = true;
                    clearSelect = true;
                }
                if (isPrintable) {
                    if (this.maxLength == 0 || this.len < this.maxLength) {
                        if (this.len == this.chars.length) {
                            char[] newChars = new char[this.len + 8];
                            Vm.copyArray(this.chars, 0, newChars, 0, this.len);
                            this.chars = newChars;
                            byte[] newCharWidths = new byte[this.len + 8];
                            Vm.copyArray(this.charWidths, 0, newCharWidths, 0, this.len);
                            this.charWidths = newCharWidths;
                        }
                        char c = (char)ke.key;
                        int charWidth = this.fm.getCharWidth(c);
                        if (!this.overwrite) {
                            if (newInsertPos != this.len) {
                                i = newInsertPos;
                                int l = this.len - newInsertPos;
                                Vm.copyArray(this.chars, i, this.chars, i + 1, l);
                                Vm.copyArray(this.charWidths, i, this.charWidths, i + 1, l);
                            }
                            ++this.len;
                        } else {
                            this.totalCharWidth -= this.charWidths[newInsertPos];
                            if (newInsertPos == this.len) {
                                ++this.len;
                            }
                        }
                        this.chars[newInsertPos] = c;
                        this.charWidths[newInsertPos] = (byte)charWidth;
                        ++newInsertPos;
                        this.totalCharWidth += charWidth;
                        redraw = true;
                        clearSelect = true;
                    } else {
                        Sound.beep();
                    }
                }
                boolean isMove = true;
                switch (ke.key) {
                    case 75002: {
                        newInsertPos = 0;
                        break;
                    }
                    case 75003: {
                        newInsertPos = this.len;
                        break;
                    }
                    case 75004: 
                    case 75006: {
                        --newInsertPos;
                        break;
                    }
                    case 75005: 
                    case 75007: {
                        ++newInsertPos;
                        break;
                    }
                    default: {
                        isMove = false;
                    }
                }
                if (!isMove || newInsertPos == this.insertPos) break;
                if ((ke.modifiers & 4) > 0) {
                    extendSelect = true;
                    break;
                }
                clearSelect = true;
                break;
            }
            case 200: {
                PenEvent pe = (PenEvent)event;
                if (!this.wasFocusIn) {
                    newInsertPos = this.x2charPos(pe.x);
                    if ((pe.modifiers & 4) > 0) {
                        extendSelect = true;
                    } else {
                        clearSelect = true;
                    }
                } else {
                    this.wasFocusIn = false;
                }
                if (!Settings.keypadOnly || !Settings.virtualKeyboard) break;
                this.popupKCC();
                break;
            }
            case 203: {
                PenEvent pe = (PenEvent)event;
                newInsertPos = this.x2charPos(pe.x);
                if (newInsertPos == this.insertPos) break;
                extendSelect = true;
                break;
            }
            case 202: {
                if (this.kbdType == 0 || !Settings.virtualKeyboard || Settings.keypadOnly) break;
                this.popupKCC();
                break;
            }
            default: {
                if (event.type == Keyboard.KEYBOARD_ON_UNPOP) {
                    this.pushPosState();
                    this.ignoreSelect = true;
                } else if (event.type == Keyboard.KEYBOARD_POST_UNPOP) {
                    this.popPosState();
                    if (this.oldTabIndex != -1) {
                        this.parent.tabOrder.removeElement(this);
                        this.parent.tabOrder.insertElementAt(this, this.oldTabIndex);
                        this.oldTabIndex = -1;
                    }
                    Control.isHighlighting = false;
                    this.ignoreSelect = false;
                    this.wasFocusIn = false;
                    this.startSelectPos = -1;
                }
                return;
            }
        }
        if (extendSelect) {
            if (this.startSelectPos == -1) {
                this.startSelectPos = this.insertPos;
            } else if (newInsertPos == this.startSelectPos) {
                this.startSelectPos = -1;
            }
            redraw = true;
        }
        if (this.wasFocusIn && this.startSelectPos != -1 && this.insertPos > this.startSelectPos) {
            redraw = true;
            this.wasFocusIn = false;
        } else if (clearSelect && this.startSelectPos != -1) {
            this.startSelectPos = -1;
            redraw = true;
        }
        if (newInsertPos > this.len) {
            newInsertPos = this.len;
        }
        if (newInsertPos < 0) {
            newInsertPos = 0;
        }
        boolean bl = insertChanged = newInsertPos != this.insertPos;
        if (insertChanged) {
            int x = this.charPos2x(newInsertPos);
            if (this.cursorShowing) {
                this.draw(this.drawg, true);
            }
            if (x - 3 < this.xMin) {
                this.xOffset += this.xMin - x + 20;
                if (this.xOffset > this.xMin) {
                    this.xOffset = this.xMin;
                }
                redraw = true;
            }
            if (x + 3 > this.xMax) {
                this.xOffset -= x - this.xMax + 20;
                if (this.xOffset < this.xMax - this.totalCharWidth) {
                    this.xOffset = this.xMax - this.totalCharWidth;
                }
                redraw = true;
            }
            if (this.totalCharWidth < this.xMax - this.xMin && this.xOffset != this.xMin) {
                this.xOffset = this.xMin;
                redraw = true;
            }
        }
        this.insertPos = newInsertPos;
        if (redraw) {
            this.draw(this.drawg, false);
        } else if (insertChanged) {
            this.draw(this.drawg, true);
        }
        if (event.type == 302) {
            if (this.drawg != null) {
                this.drawg.free();
            }
            this.drawg = null;
        }
    }

    public void onPaint(Graphics g) {
        this.draw(g, false);
    }

    protected void onWindowPaintFinished() {
        if (!this.hasFocus) {
            this.onEvent(new Event(301, this, 0));
        }
    }

    protected void popPosState() {
        if (this.cursorShowing) {
            this.draw(this.drawg, true);
        }
        this.insertPos = Math.min(this.len, this.pushedInsertPos);
        this.startSelectPos = Math.min(this.len, this.pushedStartSelectPos);
        this.xOffset = this.pushedxOffset;
    }

    public void popupKCC() {
        if (!this.popupsHidden()) {
            if (this.kbdType == 0) {
                return;
            }
            if (Settings.keypadOnly && this.kbdType != 4 && this.kbdType != 3) {
                return;
            }
        }
        Sound.beep();
        if (this.cursorShowing) {
            this.draw(this.drawg, true);
        }
        this.getParentWindow().swapFocus(this);
        switch (this.kbdType) {
            case 4: {
                if (calendar == null) {
                    calendar = new Calendar();
                }
                calendar.setSelectedDate(new Date(this.getText()));
                calendar.popupModal();
                break;
            }
            case 3: {
                if (calculator == null) {
                    calculator = new Calculator();
                }
                calculator.popupModal();
                break;
            }
            default: {
                if (Settings.virtualKeyboard && !Settings.keypadOnly) {
                    this.getParentWindow().setStatePosition(0, this.getAbsoluteRect().y < Settings.screenHeight >> 1 ? 10002 : 10001);
                    break;
                }
                if (keyboard == null) {
                    keyboard = new Keyboard();
                }
                this.oldTabIndex = this.parent.tabOrder.indexOf(this);
                this.pushPosState();
                if (this.removeTimer(this.blinkTimer)) {
                    this.blinkTimer = null;
                }
                keyboard.popupModal();
                this.popPosState();
                this.requestFocus();
            }
        }
    }

    private boolean popupsHidden() {
        return !(keyboard != null && keyboard.isVisible() || calendar != null && calendar.isVisible() || calculator != null && calculator.isVisible());
    }

    protected void pushPosState() {
        this.pushedInsertPos = this.insertPos;
        this.pushedStartSelectPos = this.startSelectPos;
        this.pushedxOffset = this.xOffset;
    }

    public void setCapitaliseMode(byte cap) {
        this.capitalise = cap;
    }

    public void setCursorPos(int start, int end) {
        int x;
        this.startSelectPos = start != end ? start : -1;
        this.insertPos = end;
        if (this.charWidths != null && (x = this.charPos2x(end)) + 3 > this.xMax) {
            this.xOffset -= x - this.xMax;
            if (this.xOffset < this.xMax - this.totalCharWidth) {
                this.xOffset = this.xMax - this.totalCharWidth;
            }
        }
        this.repaint();
    }

    public void setEditable(boolean on) {
        this.focusTraversable = this.editable = on;
    }

    public void setKeyboard(byte kbd) {
        this.kbdType = kbd;
        if (kbd == 1) {
            switch (this.mode) {
                case 1: {
                    this.kbdType = (byte)4;
                    break;
                }
                case 2: {
                    this.kbdType = (byte)3;
                    break;
                }
                default: {
                    this.kbdType = (byte)2;
                    break;
                }
            }
        }
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
        if (length != 0 && this.maxLength < this.len) {
            this.len = length;
        }
    }

    public void setMode(byte mode) {
        this.mode = mode;
        switch (mode) {
            case 1: {
                this.setValidChars(dateSet);
                break;
            }
            case 2: {
                this.setValidChars(currencyCharsSet);
                break;
            }
            default: {
                this.setValidChars(null);
            }
        }
        this.setKeyboard((byte)1);
    }

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        this.chars = s.toCharArray();
        this.len = this.chars.length;
        this.computeCharWidths(this.chars);
        this.clearPosState();
        this.repaint();
    }

    public void setValidChars(String validCharsString) {
        this.validChars = validCharsString != null ? validCharsString.toUpperCase() : null;
    }

    protected int x2charPos(int x) {
        int cx = this.xOffset;
        int i = 0;
        while (i < this.len) {
            byte cw = this.charWidths[i];
            if (x <= cx + (cw >> 1)) {
                return i;
            }
            cx += cw;
            ++i;
        }
        return this.len;
    }
}

