/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.Rect;
import waba.sys.Convert;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.Button;
import waba.ui.Check;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.Edit;
import waba.ui.Event;
import waba.ui.GridEvent;
import waba.ui.KeyEvent;
import waba.ui.Keypad;
import waba.ui.ListBox;
import waba.ui.PenEvent;
import waba.ui.PopList;
import waba.ui.ScrollBar;
import waba.ui.ToolTip;
import waba.ui.Window;
import waba.util.Date;
import waba.util.ElementNotFoundError;
import waba.util.IntHashtable;
import waba.util.IntVector;
import waba.util.Vector;

public class Grid
extends Container {
    public static final int VERT_LINE = 1;
    public static final int VERT_DOT = 2;
    public static final int VERT_NONE = 3;
    public static final int ALL_CHECKED = -900;
    public static final int ALL_UNCHECKED = -901;
    public boolean drawCheckBox = true;
    public Color checkColor = Color.BLACK;
    public boolean disableSort;
    public boolean enableColumnResize = true;
    public String[] captions;
    public boolean drawStripes = true;
    public Color firstStripeColor = Color.WHITE;
    public Color secondStripeColor = Color.BRIGHT;
    public Color highlightColor = Color.DARK;
    public Color captionsBackColor = Color.BRIGHT;
    public int verticalLineStyle = 2;
    protected int selectedLine = -1;
    protected int linesPerPage;
    public String oldCellText;
    public boolean canClickSelectAll = true;
    public boolean boldCheck;
    public ToolTip tip;
    public int extraHorizScrollButtonHeight = Settings.screenHeight * 2 / 160;
    private int lastSortCol = -1;
    private boolean ascending = true;
    private DataSource ds;
    private Control[] controls;
    private int[] widths;
    private int[] aligns;
    private int defaultCheckWidth = 25;
    private Vector vItems;
    private IntVector ivChecks;
    private boolean checkEnabled;
    private int itemsCount;
    private int xOffset;
    private int lh;
    private int maxOffset;
    private int resizingLine = -1;
    private int resizingDx;
    private int resizingRealX;
    private int resizingLastX;
    private int[] captionWidths;
    private int gridOffset;
    private IntHashtable ihtLinePoints;
    private static GridEvent ge = new GridEvent();
    private Graphics myg;
    private Color[] fourColors = new Color[4];
    private boolean allChecked;
    private ScrollBar sbVert;
    private Button btnLeft;
    private Button btnRight;
    private Rect rCheck;
    private Rect rBox;
    private Rect rTemp = new Rect();
    private Rect absRect;
    private CellController cc;
    private boolean recomputeDefaultCaptionWidths;
    private Control lastShownControl;
    private int showPlOnNextPenUp = -1;

    public Grid(String[] captions, boolean checkEnabled) {
        this(captions, null, null, checkEnabled);
    }

    public Grid(String[] captions, int[] widths, int[] aligns, boolean checkEnabled) {
        this.captions = captions;
        if (widths == null) {
            this.recomputeDefaultCaptionWidths = true;
            widths = this.computeDefaultCaptionWidhts();
        }
        this.widths = widths;
        if (aligns == null) {
            aligns = new int[widths.length];
            int i = aligns.length - 1;
            while (i >= 0) {
                aligns[i] = 110000;
                --i;
            }
        }
        this.aligns = aligns;
        this.checkEnabled = checkEnabled;
        this.controls = new Control[captions.length + (checkEnabled ? 1 : 0)];
        this.sbVert = new ScrollBar(1);
        this.onFontChanged();
        this.vItems = new Vector(50);
        if (checkEnabled) {
            this.ivChecks = new IntVector(50);
            this.addCheckColumn();
        }
    }

    public void add(String[] item) {
        this.add(item, -1);
    }

    public void add(String[] item, int row) {
        if (this.vItems != null) {
            if (this.checkEnabled) {
                this.ivChecks.insertElementAt(0, row);
            }
            this.vItems.insertElementAt(item, row);
            ++this.itemsCount;
            this.sbVert.setMaximum(this.itemsCount);
        }
    }

    private void addCheckColumn() {
        int n = this.widths.length;
        int[] tmp1 = new int[n + 1];
        tmp1[0] = this.defaultCheckWidth;
        Vm.copyArray(this.widths, 0, tmp1, 1, n);
        this.widths = tmp1;
        String[] tmp2 = new String[n + 1];
        tmp2[0] = " ";
        Vm.copyArray(this.captions, 0, tmp2, 1, n);
        this.captions = tmp2;
        int[] tmp3 = new int[n + 1];
        tmp3[0] = 110000;
        Vm.copyArray(this.aligns, 0, tmp3, 1, n);
        this.aligns = tmp3;
    }

    public void clear() {
        this.vItems = new Vector(50);
        if (this.checkEnabled) {
            this.ivChecks.removeAllElements();
        }
        this.ds = null;
        this.itemsCount = 0;
        this.gridOffset = 0;
        this.selectedLine = -1;
        this.sbVert.setMaximum(0);
        this.repaintAll();
    }

    private int[] computeDefaultCaptionWidhts() {
        int[] widths = this.widths == null ? new int[this.captions.length] : this.widths;
        int i = widths.length - 1;
        while (i >= 0) {
            widths[i] = this.fm.getTextWidth(this.captions[i]);
            --i;
        }
        return widths;
    }

    public boolean del(int row) {
        if (row < 0 || row >= this.itemsCount || this.vItems == null) {
            return false;
        }
        this.vItems.removeElementAt(row);
        if (this.checkEnabled) {
            this.ivChecks.removeElementAt(row);
        }
        --this.itemsCount;
        this.sbVert.setMaximum(this.itemsCount);
        this.sbVert.setValue(0);
        this.gridOffset = 0;
        if (this.itemsCount == 0 && this.selectedLine >= 0) {
            this.selectedLine = -1;
        } else if (this.itemsCount == row && row == this.selectedLine) {
            --this.selectedLine;
        }
        return true;
    }

    private void drawCaptions(Graphics g) {
        String[] data = this.captions;
        int cols = this.captions.length;
        int kx = this.xOffset;
        g.setClip(0, 0, this.width, this.height);
        g.setBackColor(this.captionsBackColor);
        g.fillRect(0, 0, this.width, this.fmH);
        g.drawRect(0, 0, this.width + 1, this.fmH + 1);
        int i = 0;
        while (i < cols) {
            int w = this.widths[i];
            if (w > 0) {
                if (Control.uiVista && this.enabled) {
                    g.fill3dRect(kx, 0, w + 1, this.fmH, this.captionsBackColor, true, false);
                } else {
                    g.fillRect(kx, 0, w + 1, this.fmH);
                }
                if (Control.uiFlat) {
                    g.drawRect(kx, 0, w + 1, this.fmH + 1);
                } else if (!Control.uiPalm) {
                    g.draw3dRect(kx, 0, w + 1, this.fmH, (byte)3, false, false, this.fourColors);
                }
                g.drawLine(i == 0 ? 0 : kx, 0, kx, this.fmH);
                switch (this.verticalLineStyle) {
                    case 2: {
                        g.drawDots(i == 0 ? 0 : kx, this.fmH, kx, this.height - 2);
                        break;
                    }
                    default: {
                        g.drawLine(i == 0 ? 0 : kx, this.fmH, kx, this.height - 2);
                    }
                    case 3: 
                }
                if (i == 0) {
                    if (this.checkEnabled) {
                        if (this.canClickSelectAll) {
                            this.drawCheck(g, 0, this.allChecked);
                        }
                    } else {
                        g.drawText(data[i], kx + 2 + (w - this.captionWidths[i]) / 2, 0);
                    }
                } else {
                    g.drawText(data[i], kx + 2 + (w - this.captionWidths[i]) / 2, 0);
                }
                kx += this.widths[i];
            }
            ++i;
        }
        g.clearClip();
        if (Control.uiPalm) {
            g.drawRect(0, 0, this.width + 1, this.fmH + 1);
        }
    }

    private void drawCheck(Graphics g, int y, boolean checked) {
        Rect r;
        if (this.drawCheckBox) {
            r = this.rBox;
            g.drawRect(this.xOffset + r.x, y + r.y, r.height, r.height);
        }
        if (checked) {
            r = this.rCheck;
            int h = this.fmH + r.height;
            int xx = r.x;
            if (this.boldCheck && !this.drawCheckBox) {
                xx -= 2;
            }
            Color tmp = this.getForeColor();
            g.setForeColor(this.checkColor);
            g.translate(xx, y + r.y);
            Check.paintCheck(g, h, h);
            if (this.boldCheck) {
                g.translate(0, this.drawCheckBox ? -2 : 2);
                Check.paintCheck(g, h, h);
                g.translate(0, this.drawCheckBox ? 2 : -2);
            }
            g.translate(-xx, -(y + r.y));
            g.setForeColor(tmp);
        }
    }

    private void drawCursor(Graphics g, int line, boolean highlight) {
        if (g != null && (line -= this.gridOffset) >= 0 && line < this.linesPerPage) {
            g.clearClip();
            if (this.cc == null) {
                Color on = !this.drawStripes || line % 2 == 0 ? this.firstStripeColor : this.secondStripeColor;
                g.setForeColor(highlight ? on : this.highlightColor);
                g.setBackColor(highlight ? this.highlightColor : on);
                g.eraseRect(1, (line + 1) * this.fmH, this.width - 1, this.fmH);
            } else {
                int li = line + this.gridOffset;
                int i = 0;
                int xx = 1;
                while (i < this.widths.length) {
                    Color h;
                    Color on = this.cc.getBackColor(li, i);
                    if (on != null) {
                        h = on.getCursorColor();
                    } else {
                        h = this.highlightColor;
                        on = !this.drawStripes || line % 2 == 0 ? this.firstStripeColor : this.secondStripeColor;
                    }
                    g.setForeColor(highlight ? on : h);
                    g.setBackColor(highlight ? h : on);
                    g.eraseRect(xx, (line + 1) * this.fmH, this.widths[i], this.fmH);
                    xx += this.widths[i++];
                }
            }
        }
    }

    private void enableButtons() {
        if (this.xOffset < this.maxOffset) {
            this.xOffset = this.maxOffset;
        }
        this.btnLeft.setEnabled(this.enabled && this.xOffset < 0);
        this.btnRight.setEnabled(this.enabled && this.xOffset > this.maxOffset);
    }

    public String getCellText(int row, int col) {
        try {
            return this.getItem(row)[col - (this.checkEnabled ? 1 : 0)];
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getColFromX(int px, boolean doGap) {
        int n = this.widths.length;
        int[] w = this.widths;
        int x1 = this.xOffset;
        int x2 = w[0];
        int i = 0;
        int maxX1 = this.width - this.xOffset;
        while (true) {
            if (w[i] > 0) {
                int gap;
                int n2 = gap = doGap ? w[i] >> 2 : 0;
                if (x1 + gap <= px && px <= x2 - gap) {
                    return i;
                }
            }
            if (++i == n) return -1;
            if (w[i] <= 0) continue;
            x1 = x2;
            x2 += w[i];
            if (x1 > maxX1) return -1;
        }
    }

    private void getColRect(Rect temp, int col, int row, boolean absolute, boolean clip) {
        int x = this.xOffset;
        int n = this.captions.length;
        int i = 0;
        while (i < n) {
            int w = this.widths[i];
            if (i == col) {
                int k;
                int xx = x + 1;
                int ww = w - 1;
                if (ww > this.width) {
                    ww = this.width - 1;
                }
                if (xx < 0 && !clip) {
                    this.xOffset -= xx - 1;
                    xx = 1;
                    this.enableButtons();
                    this.repaintAll();
                }
                if ((k = this.width - (xx + ww)) < 0 && !clip) {
                    this.xOffset += k;
                    xx += k;
                    this.enableButtons();
                    this.repaintAll();
                }
                temp.set(xx, (row + 1) * this.fmH, ww, this.fmH);
                break;
            }
            x += w;
            ++i;
        }
        if (absolute) {
            Container c = this;
            do {
                temp.x += c.x;
                temp.y += c.y;
            } while ((c = c.parent) != null);
        }
    }

    public String getColumnText(int row, int col) {
        return this.getCellText(row, col);
    }

    public String[] getItem(int row) {
        if (row < 0 || row >= this.itemsCount) {
            return null;
        }
        return this.vItems != null ? (String[])this.vItems.items[row] : this.ds.getItems(row, 1)[0];
    }

    public Vector getItemsVector() {
        return this.vItems;
    }

    public int getPreferredHeight() {
        return Settings.screenHeight >> 1;
    }

    public int getPreferredWidth() {
        return Settings.screenWidth >> 1;
    }

    public String[] getSelectedItem() {
        if (this.selectedLine == -1) {
            return null;
        }
        return this.getItem(this.selectedLine);
    }

    public int getSelectedLine() {
        return this.selectedLine;
    }

    public int getSelectedRow() {
        return this.selectedLine;
    }

    private void hideControl() {
        Control c = this.lastShownControl;
        if (c == null) {
            return;
        }
        this.lastShownControl = null;
        int col = c.appId >> 24 & 0x7F;
        int row = c.appId & 0xFFFFFF;
        this.oldCellText = this.getCellText(row, col);
        if (c instanceof Edit) {
            Edit ed = (Edit)c;
            this.repaintAll();
            ed.setVisible(false);
            if (!this.oldCellText.equals(ed.getText())) {
                this.setCellText(row, col, ed.getText());
                this.postGridEvent(col, this.selectedLine, true);
            }
        } else {
            String sel = (String)((PopList)c).lb.getSelectedItem();
            if (sel.length() > 0 && !this.oldCellText.equals(sel)) {
                this.repaintAll();
                this.setCellText(row, col, sel);
                this.postGridEvent(col, this.selectedLine, true);
            }
        }
    }

    public boolean horizontalScroll(boolean toLeft) {
        int newOffset;
        int step = this.width >> 1;
        int n = newOffset = toLeft ? Math.min(this.xOffset + step, 0) : Math.max(this.xOffset - step, this.maxOffset);
        if (newOffset != this.xOffset) {
            this.xOffset = newOffset;
            this.enableButtons();
            this.repaintAll();
            return true;
        }
        return false;
    }

    private void invertAllMarks() {
        this.allChecked ^= true;
        int value = this.allChecked ? 1 : 0;
        int[] items = this.ivChecks.items;
        int i = this.itemsCount - 1;
        while (i >= 0) {
            if (this.cc == null || this.cc.isEnabled(i, 0)) {
                items[i] = value;
            }
            --i;
        }
        this.postGridEvent(0, this.allChecked ? -900 : -901, false);
        this.repaintAll();
    }

    public boolean isChecked(int row) {
        return this.checkEnabled && row >= 0 && this.ivChecks.items[row] == 1;
    }

    protected void onBoundsChanged() {
        this.lh = this.height - this.fmH + 1;
        this.linesPerPage = this.lh / this.fmH;
        if (this.sbVert != null) {
            this.sbVert.setVisibleItems(this.linesPerPage);
        }
        this.height = this.height / this.fmH * this.fmH;
        this.lh = this.height - this.fmH;
        this.absRect = this.getAbsoluteRect();
        if (this.asContainer.finishedStart) {
            int by = this.btnRight.getPreferredHeight() + this.extraHorizScrollButtonHeight << 1;
            this.sbVert.setRect(130000, 0, 100000, this.height - by);
            this.btnLeft.setRect(130000, 190000, 180000, 100000 + this.extraHorizScrollButtonHeight);
            this.btnRight.setRect(130000, 190000, 180000, 100000 + this.extraHorizScrollButtonHeight);
            this.width -= this.sbVert.getPreferredWidth() + (Control.uiPalm ? 1 : 0);
            this.absRect = this.getAbsoluteRect();
            this.setWidths(this.widths);
            this.tip.setRect(this.absRect);
        }
    }

    protected void onColorsChanged(boolean colorsChanged) {
        Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.fourColors);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onEvent(Event e) {
        switch (e.type) {
            case 301: {
                if (e.target instanceof Edit && this.itemsCount > 0 && this.lastShownControl == null) {
                    this.lastShownControl = (Edit)e.target;
                    this.requestFocus();
                    return;
                }
                if (e.target != this || !Settings.keypadOnly) return;
                Keypad.getInstance().setKeys(Keypad.numberKeyset);
                return;
            }
            case 302: {
                if (e.target instanceof Edit && this.itemsCount > 0) {
                    this.hideControl();
                    return;
                }
                if (e.target != this || !Settings.keypadOnly) return;
                Keypad.getInstance().setKeys(null);
                return;
            }
            case 300: {
                int cellw;
                if (e.target instanceof PopList && Settings.keyboardFocusTraversable) {
                    Control.isHighlighting = false;
                    return;
                }
                if (e.target == this.sbVert) {
                    int newOffset = this.sbVert.getValue();
                    if (this.gridOffset == newOffset) return;
                    this.gridOffset = newOffset;
                    this.repaintAll();
                    return;
                }
                if (e.target == this.btnLeft || e.target == this.btnRight) {
                    this.horizontalScroll(e.target == this.btnLeft);
                    return;
                }
                if (e.target != this.tip) return;
                int col = Grid.ge.col;
                if (!this.isDisplayed() || col >= this.itemsCount || col < 0 || col >= this.widths.length || this.selectedLine < 0 || this.controls[col] != null) {
                    this.tip.setText("");
                    return;
                }
                String s = this.getCellText(Grid.ge.row, Grid.ge.col);
                int fmw = this.fm.getTextWidth(s);
                if (fmw <= (cellw = this.widths[col])) {
                    this.tip.setText("");
                    return;
                }
                this.tip.setEnabled(true);
                this.rTemp.set(this.absRect.x, this.absRect.y + (Grid.ge.row - this.gridOffset + 1) * this.fmH, this.absRect.width - 10, this.fmH);
                this.tip.setText(Convert.insertLineBreak(this.rTemp.width, '|', this.fm, s));
                this.tip.setControlRect(this.rTemp);
                return;
            }
            case 200: {
                int line;
                if (e.target != this) return;
                PenEvent pe = (PenEvent)e;
                int px = pe.x - this.xOffset;
                int py = pe.y;
                if (py > this.height) return;
                if (this.lastShownControl != null) {
                    this.hideControl();
                }
                if (this.checkEnabled && this.canClickSelectAll && py <= this.fmH && px <= this.widths[0]) {
                    this.invertAllMarks();
                    return;
                }
                try {
                    line = this.ihtLinePoints.get(px);
                }
                catch (ElementNotFoundError elementNotFoundError) {
                    line = IntHashtable.INVALID;
                }
                if (this.myg == null) {
                    this.myg = this.createGraphics();
                }
                if (line != IntHashtable.INVALID) {
                    this.resizingLine = line & 0xFFFF;
                    this.resizingRealX = line >> 16;
                    this.resizingDx = px - this.resizingRealX;
                    this.resizingLastX = this.xOffset + this.resizingRealX;
                    return;
                }
                if (py < this.fmH && this.itemsCount > 1) {
                    int col = this.getColFromX(px, true);
                    if (this.disableSort || col < (this.checkEnabled ? 1 : 0)) return;
                    this.selectedLine = -1;
                    this.qsort(col);
                    this.repaintAll();
                    return;
                }
                if (py <= this.fmH) return;
                line = py / this.fmH - 1;
                int col = this.getColFromX(px, false);
                if (col < 0) return;
                int newSel = line + this.gridOffset;
                if (this.selectedLine != newSel) {
                    this.setSelectedRow(newSel);
                }
                if (this.checkEnabled && pe.x <= this.widths[0]) {
                    if (this.selectedLine < 0 || this.selectedLine >= this.itemsCount || this.cc != null && !this.cc.isEnabled(this.selectedLine, 0)) return;
                    this.setChecked(this.selectedLine, this.isChecked(this.selectedLine) ^ true);
                    this.postGridEvent(col, this.selectedLine, false);
                    this.repaintAll();
                    return;
                }
                if (this.controls[col] != null && this.selectedLine >= 0) {
                    if (this.controls[col] instanceof PopList) {
                        this.showPlOnNextPenUp = col << 24 | line;
                    } else {
                        this.showControl(line, col);
                    }
                }
                this.postGridEvent(col, this.selectedLine, false);
                return;
            }
            case 203: {
                if (e.target != this || this.resizingLine == -1) return;
                this.myg.drawCursor(this.resizingLastX, this.fmH, 1, this.lh);
                int px = ((PenEvent)e).x;
                this.resizingLastX = px - this.resizingDx;
                this.myg.drawCursor(this.resizingLastX, this.fmH, 1, this.lh);
                return;
            }
            case 202: {
                if (e.target != this) return;
                if (this.resizingLine != -1) {
                    int px = ((PenEvent)e).x;
                    this.myg.drawCursor(this.resizingLastX, this.fmH, 1, this.lh);
                    int dx = px - this.resizingDx - this.resizingRealX - this.xOffset;
                    if (dx == 0 && this.resizingLine == this.widths.length - 1) {
                        dx = this.width >> 3;
                    }
                    int n = this.resizingLine;
                    this.widths[n] = this.widths[n] + dx;
                    this.setWidths(this.widths);
                    this.resizingLine = -1;
                    this.repaintAll();
                    return;
                }
                if (this.showPlOnNextPenUp == -1) return;
                int col = this.showPlOnNextPenUp >> 24 & 0x7F;
                int row = this.showPlOnNextPenUp & 0xFFFFFF;
                this.showPlOnNextPenUp = -1;
                this.showControl(row, col);
                return;
            }
            case 100: {
                KeyEvent ke = (KeyEvent)e;
                int key = ke.key;
                if (Control.isHighlighting || ke.target instanceof Edit) return;
                if (key == 32 && this.checkEnabled && this.canClickSelectAll) {
                    this.invertAllMarks();
                } else if (this.selectedLine >= 0 && key >= 48 && key <= 57) {
                    int col = key - 48;
                    if (this.cc != null && !this.cc.isEnabled(this.selectedLine, col)) return;
                    if (this.checkEnabled && col == 0) {
                        this.setChecked(this.selectedLine, this.isChecked(this.selectedLine) ^ true);
                        this.postGridEvent(this.checkEnabled ? 0 : 1, this.selectedLine, false);
                        this.getParentWindow().repaintNow();
                    } else {
                        if (col >= this.widths.length) return;
                        if (this.controls[col] != null) {
                            this.showControl(this.selectedLine, col);
                        } else {
                            if (Settings.keyboardFocusTraversable) {
                                Graphics g = this.createGraphics();
                                this.getColRect(this.rTemp, col, this.selectedLine, false, true);
                                int i = 0;
                                while (i < 4) {
                                    g.drawCursor(this.rTemp.x, this.rTemp.y, this.rTemp.width, this.rTemp.height);
                                    Vm.sleep(50);
                                    Window.updateScreen();
                                    ++i;
                                }
                            }
                            this.postGridEvent(col, this.selectedLine, false);
                        }
                    }
                } else if (Settings.keyboardFocusTraversable && (ke.isPrevKey() || ke.isNextKey() || ke.isActionKey())) {
                    if (ke.isUpKey()) {
                        if (this.itemsCount == 0) {
                            return;
                        }
                        int line = this.selectedLine;
                        if (--line < 0) {
                            line = this.itemsCount - 1;
                        }
                        this.setSelectedRow(line);
                    } else if (ke.isDownKey()) {
                        if (this.itemsCount == 0) {
                            return;
                        }
                        int line = this.selectedLine;
                        if (++line >= this.itemsCount) {
                            line = 0;
                        }
                        this.setSelectedRow(line);
                    } else if (key == 75012 || ke.isActionKey()) {
                        this.setHighlighting();
                    } else if (key == 75006 || key == 75007) {
                        this.horizontalScroll(key == 75006);
                    }
                } else if (!Settings.keyboardFocusTraversable) {
                    if (ke.isUpKey() && this.itemsCount > this.linesPerPage) {
                        this.sbVert.setValue(Math.max(0, this.sbVert.getValue() - this.linesPerPage));
                        int v = this.sbVert.getValue();
                        if (v == this.gridOffset) return;
                        this.gridOffset = v;
                    } else if (ke.isDownKey() && this.itemsCount > this.linesPerPage) {
                        this.sbVert.setValue(this.sbVert.getValue() + this.linesPerPage);
                        int v = this.sbVert.getValue();
                        if (v == this.gridOffset) return;
                        this.gridOffset = v;
                    } else if (key == 75006) {
                        this.horizontalScroll(true);
                    } else if (key == 75007) {
                        this.horizontalScroll(false);
                    }
                }
                this.repaintAll();
                return;
            }
        }
    }

    protected void onFontChanged() {
        int k = this.fmH;
        this.defaultCheckWidth = 25 * k / 22;
        this.rBox = new Rect(k / 3, k / 3, 0, k / 2);
        this.rCheck = new Rect(1, -2, 0, 1);
        switch (k) {
            case 11: {
                ++this.rCheck.height;
                ++this.rBox.height;
                break;
            }
            case 22: {
                this.rCheck.x = 3;
                break;
            }
        }
        if (this.recomputeDefaultCaptionWidths) {
            this.computeDefaultCaptionWidhts();
        }
    }

    public void onPaint(Graphics g) {
        g.getClip(this.rTemp);
        if (this.rTemp.x != 0) {
            return;
        }
        g.clearClip();
        g.setBackColor(this.getBackColor());
        if (this.drawStripes) {
            this.paintStripes(g);
        } else {
            g.fillRect(0, 0, this.width, this.height);
        }
        g.setForeColor(this.getForeColor());
        this.drawCaptions(g);
        g.setBackColor(this.getBackColor());
        int ty = this.fmH;
        g.drawRect(0, ty, this.width + (Control.uiCE ? 0 : 1), this.height - this.fmH);
        if (this.itemsCount > 0) {
            Object[] items;
            int cols = this.captions.length;
            int base = this.checkEnabled ? 1 : 0;
            int cx = this.xOffset + 2;
            int xx = cx < 0 ? 0 : cx;
            int maxX = this.width;
            boolean checkDrawn = this.checkEnabled ^ true;
            int i0 = Math.max(0, this.gridOffset);
            int rows = Math.min(i0 + this.linesPerPage, this.itemsCount);
            if (this.vItems != null) {
                items = this.vItems.items;
            } else {
                items = this.ds.getItems(i0, rows -= i0);
                i0 = 0;
            }
            CellController cc = this.cc;
            Color cfo = this.getForeColor();
            int j = 0;
            while (j < cols) {
                int w = this.widths[j];
                ty = this.fmH;
                if (w > 0 && cx + w > 0 && cx <= maxX) {
                    Color cb;
                    g.setClip(cx - 1, ty + 1, Math.min(w - 1, this.width - cx + (Control.uiCE ? 0 : 1)), this.fmH * this.linesPerPage);
                    if (checkDrawn) {
                        int align = this.aligns[j];
                        int i = i0;
                        while (i < rows) {
                            String[] line = (String[])items[i];
                            String columnText = line[j - base];
                            int tx = cx + (align == 110000 ? 0 : (align == 120000 ? (w - this.fm.getTextWidth(columnText)) / 2 : w - 3 - this.fm.getTextWidth(columnText)));
                            Color cf = null;
                            if (cc != null) {
                                cb = cc.getBackColor(i, j);
                                if (cb != null) {
                                    g.setBackColor(cb);
                                    g.fillRect(cx - 1, ty, w - 1, this.fmH);
                                }
                                if ((cf = cc.getForeColor(i, j)) != null) {
                                    g.setForeColor(cf);
                                }
                            }
                            g.drawText(columnText, tx, ty);
                            if (cf != null) {
                                g.setForeColor(cfo);
                            }
                            ++i;
                            ty += this.fmH;
                        }
                    } else {
                        int i = i0;
                        while (i < rows) {
                            if (cc != null && (cb = cc.getBackColor(i, 0)) != null) {
                                g.setBackColor(cb);
                                g.fillRect(xx - 1, ty, w - 1, this.fmH);
                            }
                            this.drawCheck(g, ty, this.ivChecks.items[i] == 1);
                            ++i;
                            ty += this.fmH;
                        }
                    }
                }
                checkDrawn = true;
                cx += w;
                ++j;
            }
        }
        g.clearClip();
        if (this.selectedLine != -1) {
            this.drawCursor(g, this.selectedLine, true);
        }
    }

    protected void onStart() {
        this.sbVert.setBackForeColors(this.backColor, this.foreColor);
        if (Settings.keyboardFocusTraversable) {
            this.sbVert.setFocusLess(true);
        }
        int hh = 3 * this.fmH / 11 + ScrollBar.extraArrowSize;
        this.btnRight = Button.createArrowButton((byte)4, hh, this.foreColor);
        this.add(this.btnRight);
        this.btnLeft = Button.createArrowButton((byte)3, hh, this.foreColor);
        this.add(this.btnLeft);
        if (Control.uiPalm) {
            this.btnRight.setBorder((byte)0);
            this.btnLeft.setBorder((byte)0);
        }
        this.btnRight.setBackForeColors(this.backColor, this.foreColor);
        this.btnLeft.setBackForeColors(this.backColor, this.foreColor);
        int by = this.btnRight.getPreferredHeight() + this.extraHorizScrollButtonHeight << 1;
        this.add(this.sbVert);
        this.sbVert.setRect(130000, 0, 100000, this.height - by);
        this.sbVert.setValues(0, this.linesPerPage, 0, this.itemsCount);
        this.sbVert.setLiveScrolling(true);
        this.btnLeft.setRect(130000, 190000, 180000, 100000 + this.extraHorizScrollButtonHeight);
        this.btnRight.setRect(130000, 190000, 180000, 100000 + this.extraHorizScrollButtonHeight);
        this.width -= this.sbVert.getPreferredWidth() + (Control.uiPalm ? 1 : 0);
        this.tabOrder.removeAllElements();
        this.onBoundsChanged();
        this.setWidths(this.widths);
        this.tip = new ToolTip(this, "");
        this.tip.borderColor = Color.BLACK;
    }

    private void paintStripes(Graphics g) {
        int w = this.width - 1;
        int h = this.fmH;
        int c = this.linesPerPage >> 1;
        int dy = this.fmH << 1;
        g.setBackColor(this.firstStripeColor);
        g.fillRect(1, h, w, h * this.linesPerPage);
        g.setBackColor(this.secondStripeColor);
        int y = dy;
        while (c > 0) {
            g.fillRect(1, y, w, h);
            y += dy;
            --c;
        }
    }

    private void postGridEvent(int col, int row, boolean isTextChangedEvent) {
        if (this.cc == null || this.cc.isEnabled(row, col)) {
            ge.touch();
            Grid.ge.target = this;
            Grid.ge.row = row;
            Grid.ge.col = col;
            Grid.ge.checked = this.isChecked(this.selectedLine);
            Grid.ge.type = isTextChangedEvent ? 503 : (col == 0 && this.checkEnabled ? 502 : 501);
            this.postEvent(ge);
        }
    }

    public void qsort(int col) {
        if (col == this.lastSortCol) {
            this.ascending ^= true;
        } else {
            this.ascending = true;
            this.lastSortCol = col;
        }
        if (this.itemsCount > 1 && this.vItems != null) {
            if (this.checkEnabled) {
                --col;
            }
            String s = this.getItem(1)[col];
            int sortType = Convert.detectSortType(s);
            this.qsort(col, 0, this.itemsCount - 1, sortType, this.ascending);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void qsort(int col, int first, int last, int sortType, boolean ascending) {
        if (first >= last) {
            return;
        }
        low = first;
        high = last;
        items = this.vItems.items;
        ints = null;
        if (this.checkEnabled) {
            ints = this.ivChecks.items;
        }
        block0 : switch (sortType) {
            case 2: {
                mid = Convert.toInt(((String[])items[first + last >> 1])[col]);
                while (true) {
                    if (!ascending) ** GOTO lbl22
                    while (high >= low && mid > Convert.toInt(((String[])items[low])[col])) {
                        ++low;
                    }
                    while (high >= low && mid < Convert.toInt(((String[])items[high])[col])) {
                        --high;
                    }
                    ** GOTO lbl26
lbl-1000:
                    // 1 sources

                    {
                        ++low;
lbl22:
                        // 2 sources

                        ** while (high >= low && mid < Convert.toInt((String)((String[])items[low])[col]))
                    }
lbl23:
                    // 2 sources

                    while (high >= low && mid > Convert.toInt(((String[])items[high])[col])) {
                        --high;
                    }
lbl26:
                    // 2 sources

                    if (low > high) break block0;
                    if (ints != null) {
                        t = ints[low];
                        ints[low] = ints[high];
                        ints[high] = t;
                    }
                    temp = items[low];
                    items[low++] = items[high];
                    items[high--] = temp;
                }
            }
            case 3: {
                mid = Convert.toDouble(((String[])items[first + last >> 1])[col]);
                while (true) {
                    if (!ascending) ** GOTO lbl47
                    while (high >= low && mid > Convert.toDouble(((String[])items[low])[col])) {
                        ++low;
                    }
                    while (high >= low && mid < Convert.toDouble(((String[])items[high])[col])) {
                        --high;
                    }
                    ** GOTO lbl51
lbl-1000:
                    // 1 sources

                    {
                        ++low;
lbl47:
                        // 2 sources

                        ** while (high >= low && mid < Convert.toDouble((String)((String[])items[low])[col]))
                    }
lbl48:
                    // 2 sources

                    while (high >= low && mid > Convert.toDouble(((String[])items[high])[col])) {
                        --high;
                    }
lbl51:
                    // 2 sources

                    if (low > high) break block0;
                    if (ints != null) {
                        t = ints[low];
                        ints[low] = ints[high];
                        ints[high] = t;
                    }
                    temp = items[low];
                    items[low++] = items[high];
                    items[high--] = temp;
                }
            }
            case 4: {
                mid = new Date(((String[])items[first + last >> 1])[col]).getDateInt();
                while (true) {
                    if (!ascending) ** GOTO lbl72
                    while (high >= low && mid > new Date(((String[])items[low])[col]).getDateInt()) {
                        ++low;
                    }
                    while (high >= low && mid < new Date(((String[])items[high])[col]).getDateInt()) {
                        --high;
                    }
                    ** GOTO lbl76
lbl-1000:
                    // 1 sources

                    {
                        ++low;
lbl72:
                        // 2 sources

                        ** while (high >= low && mid < new Date((String)((String[])items[low])[col]).getDateInt())
                    }
lbl73:
                    // 2 sources

                    while (high >= low && mid > new Date(((String[])items[high])[col]).getDateInt()) {
                        --high;
                    }
lbl76:
                    // 2 sources

                    if (low > high) break block0;
                    if (ints != null) {
                        t = ints[low];
                        ints[low] = ints[high];
                        ints[high] = t;
                    }
                    temp = items[low];
                    items[low++] = items[high];
                    items[high--] = temp;
                }
            }
            default: {
                mid = ((String[])items[first + last >> 1])[col];
                while (true) {
                    if (!ascending) ** GOTO lbl97
                    while (high >= low && mid.compareTo(((String[])items[low])[col]) > 0) {
                        ++low;
                    }
                    while (high >= low && mid.compareTo(((String[])items[high])[col]) < 0) {
                        --high;
                    }
                    ** GOTO lbl101
lbl-1000:
                    // 1 sources

                    {
                        ++low;
lbl97:
                        // 2 sources

                        ** while (high >= low && mid.compareTo((String)((String[])items[low])[col]) < 0)
                    }
lbl98:
                    // 2 sources

                    while (high >= low && mid.compareTo(((String[])items[high])[col]) > 0) {
                        --high;
                    }
lbl101:
                    // 2 sources

                    if (low > high) break block0;
                    if (ints != null) {
                        t = ints[low];
                        ints[low] = ints[high];
                        ints[high] = t;
                    }
                    temp = items[low];
                    items[low++] = items[high];
                    items[high--] = temp;
                }
            }
        }
        if (first < high) {
            this.qsort(col, first, high, sortType, ascending);
        }
        if (low < last) {
            this.qsort(col, low, last, sortType, ascending);
        }
    }

    private void repaintAll() {
        this.repaint();
        this.sbVert.repaint();
    }

    public void replace(String[] item, int row) {
        if (this.vItems != null && row >= 0 && row < this.itemsCount) {
            Vm.copyArray(item, 0, this.vItems.items[row], 0, item.length);
        }
    }

    public void setCellController(CellController cc) {
        this.cc = cc;
    }

    public void setCellText(int row, int col, String text) {
        block2: {
            try {
                this.getItem((int)row)[col - (this.checkEnabled ? 1 : 0)] = text;
            }
            catch (Exception aioobe) {
                if (Settings.onDevice) break block2;
                Vm.warning("Wrong index! " + row + "x" + col + " - " + aioobe);
            }
        }
    }

    public void setChecked(int row, boolean check) {
        if (this.checkEnabled) {
            this.ivChecks.items[row] = check ? 1 : 0;
        }
    }

    public void setColumnChoices(int col, String[] choices) {
        if (col < 0 || col >= this.captions.length) {
            return;
        }
        if (this.checkEnabled) {
            ++col;
        }
        this.controls[col] = choices == null ? null : new PopList(new ListBox(choices));
    }

    public Edit setColumnEditable(int col, boolean editable) {
        Edit ed;
        if (col < 0 || col >= this.captions.length) {
            return null;
        }
        if (this.checkEnabled) {
            ++col;
        }
        if (!editable) {
            ed = (Edit)this.controls[col];
            this.controls[col] = null;
        } else {
            this.controls[col] = new Edit();
            ed = (Edit)this.controls[col];
            ed.hasBorder = false;
            this.add(ed);
            ed.setVisible(false);
            this.tabOrder.removeAllElements();
        }
        return ed;
    }

    public void setColumnText(int row, int col, String text) {
        this.setCellText(row, col, text);
    }

    public void setDataSource(DataSource ds, int nrItems) {
        this.ds = ds;
        this.vItems = null;
        if (this.checkEnabled) {
            this.ivChecks = new IntVector(nrItems);
        }
        this.itemsCount = nrItems;
        this.sbVert.setMaximum(this.itemsCount);
        this.sbVert.setLiveScrolling(false);
        if (this.gridOffset > this.itemsCount - this.linesPerPage) {
            this.gridOffset = Math.max(0, this.itemsCount - this.linesPerPage);
            this.sbVert.setValue(this.gridOffset);
        }
        this.repaintAll();
    }

    public void setItems(String[][] items) {
        this.ds = null;
        this.vItems = new Vector((Object[])items);
        this.itemsCount = items.length;
        if (this.checkEnabled) {
            this.ivChecks = new IntVector(this.itemsCount);
        }
        this.sbVert.setMaximum(this.itemsCount);
        this.sbVert.setLiveScrolling(true);
        if (this.gridOffset > this.itemsCount - this.linesPerPage) {
            this.gridOffset = Math.max(0, this.itemsCount - this.linesPerPage);
            this.sbVert.setValue(this.gridOffset);
        }
        this.repaintAll();
    }

    public void setSelectedLine(int row) {
        this.setSelectedRow(row);
    }

    public void setSelectedRow(int row) {
        if (this.myg == null) {
            this.myg = this.createGraphics();
        }
        if (this.selectedLine != -1) {
            this.drawCursor(this.myg, this.selectedLine, false);
            this.selectedLine = -1;
        }
        if (row >= 0 && row < this.itemsCount) {
            int l = row - this.gridOffset;
            if (l < 0 || l >= this.linesPerPage) {
                this.sbVert.setValue(l < 0 ? Math.max(row - this.linesPerPage + 1, 0) : row);
                this.gridOffset = this.sbVert.getValue();
            }
            this.drawCursor(this.myg, row, true);
            this.selectedLine = row;
            Control.isHighlighting = false;
        }
    }

    private void setWidths(int[] widths) {
        this.widths = widths;
        int n = widths.length;
        if (this.captionWidths == null) {
            this.captionWidths = new int[n];
        }
        if (this.ihtLinePoints == null) {
            this.ihtLinePoints = new IntHashtable(n * 5);
        } else {
            this.ihtLinePoints.clear();
        }
        int totalW = 0;
        int lastVisibleCol = --n;
        int i = n;
        while (i >= 0) {
            if (widths[i] > 0) {
                lastVisibleCol = i;
                break;
            }
            --i;
        }
        i = 0;
        while (i <= n) {
            if (widths[i] > 10000) {
                throw new RuntimeException("FILL is no longer supported as a column width!");
            }
            if (widths[i] != 0) {
                this.captionWidths[i] = this.fm.getTextWidth(this.captions[i]) + 3;
                int cw = this.captionWidths[i];
                if (widths[i] <= cw) {
                    widths[i] = cw;
                }
                if (i == n && (totalW += widths[i]) < this.width) {
                    int n2 = lastVisibleCol;
                    widths[n2] = widths[n2] + (this.width - totalW);
                    totalW = this.width;
                }
                if ((i != 0 || !this.checkEnabled) && this.enableColumnResize) {
                    int l = totalW << 16 | i;
                    this.ihtLinePoints.put(totalW - 1, l);
                    this.ihtLinePoints.put(totalW, l);
                    this.ihtLinePoints.put(totalW + 1, l);
                }
            }
            ++i;
        }
        this.maxOffset = this.width - totalW;
        if (this.maxOffset > 0) {
            int n3 = lastVisibleCol;
            widths[n3] = widths[n3] + this.maxOffset;
            this.maxOffset = 0;
            this.setWidths(widths);
        }
        this.enableButtons();
    }

    private void showControl(int row, int col) {
        Control c;
        if (this.cc != null && !this.cc.isEnabled(row, col)) {
            return;
        }
        this.lastShownControl = c = this.controls[col];
        this.getColRect(this.rTemp, col, row, c instanceof PopList, false);
        c.setRect(this.rTemp);
        c.appId = col << 24 | this.selectedLine;
        if (c instanceof Edit) {
            Edit ed = (Edit)c;
            ed.setBackColor((this.drawStripes ? ((this.selectedLine & 1) == 0 ? this.firstStripeColor : this.secondStripeColor) : this.backColor).darker());
            ed.setText(this.getCellText(this.selectedLine, col));
            ed.setVisible(true);
            ed.requestFocus();
        } else {
            Object[] newItems;
            PopList pl = (PopList)c;
            Object[] oldItems = null;
            if (this.cc != null && (newItems = this.cc.getChoices(row, col)) != null) {
                oldItems = pl.lb.getItems();
                pl.lb.itemCount = 0;
                pl.lb.add(newItems);
                pl.setRect(this.rTemp);
            }
            pl.lb.select(-1);
            pl.popupBlockingModal();
            this.hideControl();
            if (oldItems != null) {
                pl.lb.itemCount = 0;
                pl.lb.add(oldItems);
                pl.setRect(this.rTemp);
            }
        }
    }

    public int size() {
        return this.itemsCount;
    }

    public static abstract class CellController {
        public abstract Color getBackColor(int var1, int var2);

        public abstract String[] getChoices(int var1, int var2);

        public abstract Color getForeColor(int var1, int var2);

        public abstract boolean isEnabled(int var1, int var2);
    }

    public static interface DataSource {
        public String[][] getItems(int var1, int var2);
    }
}

