/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.FontMetrics;
import waba.sys.Settings;
import waba.ui.Control;
import waba.ui.Edit;
import waba.ui.Event;
import waba.ui.Label;
import waba.ui.PushButtonGroup;
import waba.ui.UIColors;
import waba.ui.Window;

public class InputDialog
extends Window {
    private Label msg;
    private PushButtonGroup btns;
    private Edit ed;
    private int selected = -1;

    public InputDialog(String title, String text, String defaultValue) {
        this(title, text, defaultValue, new String[]{"Ok", "Cancel"});
    }

    public InputDialog(String title, String text, String defaultValue, String[] buttonCaptions) {
        super(title, (byte)2);
        this.highResPrepared = true;
        this.btns = new PushButtonGroup(buttonCaptions, false, -1, 4, 6, 1, false, 1);
        this.msg = new Label(text, 110000);
        this.ed = new Edit("@@@@@@@@@@");
        if (defaultValue != null) {
            this.ed.setText(defaultValue);
        }
        int wb = this.btns.getPreferredWidth();
        int hb = this.btns.getPreferredHeight();
        int wm = Math.min(this.msg.getPreferredWidth() + 1, Settings.screenWidth - 6);
        int hm = this.msg.getPreferredHeight();
        int we = this.ed.getPreferredWidth();
        int he = this.ed.getPreferredHeight();
        FontMetrics fm2 = this.titleFont.fm;
        int captionH = fm2.height + 10;
        int h = captionH + hb + hm + he;
        int w = Math.max(Math.max(Math.max(wb, wm), we), fm2.getTextWidth(title)) + 6;
        w = Math.min(w, Settings.screenWidth);
        this.setRect(120000, 120000, w, h);
        this.add(this.msg);
        this.add(this.btns);
        this.add(this.ed);
        this.msg.setRect(4, 140000, wm, hm);
        this.ed.setRect(120000, 190002, we, he);
        this.btns.setRect(120000, 190002, wb, hb);
        if (Settings.isColor) {
            this.setBackForeColors(UIColors.inputdialogBack, UIColors.inputdialogFore);
            if (this.btns != null) {
                this.btns.setBackColor(UIColors.inputdialogAction);
            }
        }
    }

    private void close() {
        this.selected = this.btns.getSelected();
        this.btns.requestFocus();
        this.btns.setSelected(-1);
        this.unpop();
    }

    public Edit getEdit() {
        return this.ed;
    }

    public int getPressedButtonIndex() {
        return this.selected;
    }

    public String getValue() {
        return this.ed.getText();
    }

    protected void onColorsChanged(boolean colorsChanged) {
        if (colorsChanged) {
            this.msg.setForeColor(this.foreColor);
            this.msg.setBackColor(this.backColor);
        }
    }

    public void onEvent(Event e) {
        switch (e.type) {
            case 300: {
                if (e.target != this.btns || this.btns.getSelected() == -1) break;
                this.close();
                break;
            }
        }
    }

    protected void postPopup() {
        this.ed.requestFocus();
        if (Settings.keyboardFocusTraversable) {
            Control.isHighlighting = false;
        }
    }

    protected void postUnpop() {
        if (Settings.keyboardFocusTraversable) {
            Control.isHighlighting = true;
        }
        if (this.selected != -1) {
            this.postPressedEvent();
        }
    }

    public void setValue(String value) {
        this.ed.setText(value);
    }
}

