/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.Image;
import waba.sys.Settings;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.MainWindow;
import waba.ui.MenuItem;
import waba.ui.PenEvent;
import waba.ui.PopupMenu;
import waba.ui.Window;

public class MenuBar
extends Window {
    protected MenuItem[][] items;
    private int[] xpos;
    private int xmin;
    private int xmax;
    public int gap = 3;
    private int selected = 0;
    private Graphics gr;
    private int menuItemSelected;
    private boolean switching;
    public static final char CHECKED = '!';
    public static final char UNCHECKED = '?';
    public static final char DISABLED = '*';
    private PopupMenu pop;
    private Image wholeScreen;
    private Color eColor;
    private Color dColor;
    private Color bColor;
    private Color cursorColor;
    private Color[] fourColors = new Color[4];
    private Color popFore;
    private Color popBack;
    private Color popCursor;

    public MenuBar(String[][] items) {
        this(MenuBar.strings2items(items));
    }

    public MenuBar(MenuItem[][] items) {
        this.highResPrepared = true;
        this.started = true;
        this.canDrag = false;
        this.setBackColor(Color.WHITE);
        this.dontSaveBehind(false);
        this.borderStyle = (byte)-1;
        this.items = items;
        this.setFont(this.getFont().asBold());
    }

    void close() {
        if (this.wholeScreen != null) {
            MainWindow.myg0.copyScreen(this.wholeScreen, 0, 0, this.wholeScreen.getHeight());
        } else {
            Window.repaintActiveWindows(this.pop != null ? -2 : -1);
        }
        if (this.pop != null) {
            this.pop.unpop();
        }
        this.unpop();
    }

    private void drawCursor(Graphics g, int index, boolean on) {
        Color f = this.cursorColor != null ? this.cursorColor : this.bColor.getCursorColor();
        g.setForeColor(on ? this.bColor : f);
        g.setBackColor(on ? f : this.bColor);
        g.eraseRect(this.xpos[index], 1, this.xpos[index + 1] - this.xpos[index], this.height - 2);
    }

    private int getItemAt(int x) {
        int n = this.xpos.length - 1;
        int i = 0;
        while (i < n) {
            if (this.xpos[i] <= x && x < this.xpos[i + 1] && this.items[i][0].isEnabled) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String[][] getItems() {
        String[][] its = new String[this.items.length][];
        int i = its.length - 1;
        while (i >= 0) {
            its[i] = new String[this.items[i].length];
            int j = its[i].length - 1;
            while (j >= 0) {
                MenuItem mi = this.items[i][j];
                String cap = mi.caption;
                if (mi.isSeparator) {
                    cap = "-";
                } else {
                    if (!mi.isEnabled) {
                        cap = "*" + cap;
                    }
                    if (mi.isCheckable) {
                        cap = String.valueOf(mi.isChecked ? "!" : "?") + cap;
                    }
                }
                its[i][j] = cap;
                --j;
            }
            --i;
        }
        return its;
    }

    public MenuItem[][] getMenuItems() {
        return this.items;
    }

    public int getSelectedMenuItem() {
        return this.menuItemSelected;
    }

    protected boolean handleFocusChangeKeys(KeyEvent ke) {
        if (ke.isActionKey() || ke.isUpKey() || ke.isDownKey()) {
            this.close();
        } else if (ke.key == 75006) {
            this.moveBy(-1);
        } else if (ke.key == 75007 || ke.key == 75010) {
            this.moveBy(1);
        } else {
            return false;
        }
        return true;
    }

    public boolean isCheckable(int menuItem) {
        int col = menuItem / 100;
        int row = menuItem % 100;
        try {
            return this.items[col][row].isCheckable;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isChecked(int menuItem) {
        int col = menuItem / 100;
        int row = menuItem % 100;
        try {
            return this.items[col][row].isChecked;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isEnabled(int menuItem) {
        int col = menuItem / 100;
        int row = menuItem % 100;
        try {
            return this.items[col][row].isEnabled;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void loadBehindLastPopup(int ph) {
        if (this.wholeScreen != null) {
            MainWindow.myg0.copyScreen(this.wholeScreen, this.height, this.height, ph);
        } else {
            Window.repaintActiveWindows(0);
        }
        if (this.borderStyle == -1) {
            this.gr.setForeColor(this.foreColor);
            this.gr.drawLine(2, this.height - 1, this.width - 3, this.height - 1);
            this.gr.setPixel(this.width - 2, this.height - 2);
            this.gr.setForeColor(this.backColor);
            this.gr.setPixel(this.width - 2, this.height - 1);
            this.gr.setPixel(this.width - 1, this.height - 2);
            this.gr.setPixel(this.width - 1, this.height - 1);
        } else {
            this.gr.setForeColor(this.backColor);
            this.gr.drawLine(0, this.height - 1, this.width, this.height - 1);
            this.gr.drawLine(0, this.height - 2, this.width, this.height - 2);
        }
    }

    public void moveBy(int i) {
        int newSelected = i > 0 ? (this.selected + 1) % this.items.length : (this.selected <= 0 ? this.items.length - 1 : this.selected - 1);
        this.switchTo(newSelected);
    }

    protected boolean onClickedOutside(int x, int y) {
        this.close();
        return true;
    }

    protected void onColorsChanged(boolean colorsChanged) {
        this.eColor = this.getForeColor();
        this.dColor = this.eColor.getAlpha() > 128 ? this.eColor.darker() : this.eColor.brighter();
        this.bColor = this.getBackColor();
        if (colorsChanged) {
            Graphics.compute3dColors(true, this.backColor, this.foreColor, this.fourColors);
            if (this.cursorColor == null && Settings.maxColors >= 256) {
                this.cursorColor = Color.getColor(0, 0, 240);
            }
        }
    }

    public void onEvent(Event event) {
        switch (event.type) {
            case 100: {
                if (((KeyEvent)event).key != 75014) break;
                this.close();
                break;
            }
            case 499: {
                if (this.switching || event.target != this.pop) break;
                int row = this.pop.getSelected();
                this.pop = null;
                if (row != -1) {
                    MenuItem mi = this.items[this.selected][row];
                    this.menuItemSelected = this.selected * 100 + row;
                    if (mi.isCheckable) {
                        mi.isChecked ^= true;
                    }
                    this.close();
                    break;
                }
                this.menuItemSelected = -1;
                break;
            }
            case 200: 
            case 203: {
                PenEvent pe = (PenEvent)event;
                if (this.xmin <= pe.x && pe.x <= this.xmax) {
                    int newSelected = this.getItemAt(pe.x);
                    if (newSelected == this.selected) break;
                    this.switchTo(newSelected);
                    break;
                }
                if (this.selected == -1) break;
                this.drawCursor(this.gr, this.selected, false);
                this.selected = -1;
                this.switchTo(this.selected);
                break;
            }
        }
    }

    protected void onFontChanged() {
        this.setRect(0, 0, Settings.screenWidth, this.fmH + 4);
        int n = this.items.length;
        this.xpos = new int[n + 1];
        this.xmin = 4;
        this.xmax = 4;
        this.xpos[0] = 4;
        this.gr = this.createGraphics();
        int temp = (this.gap << 1) - 1;
        int i = 0;
        while (i < n) {
            this.xmax += this.fm.getTextWidth(this.items[i][0].caption) + temp;
            this.xpos[i + 1] = this.xmax;
            ++i;
        }
        --this.xmax;
    }

    public void onPaint(Graphics g) {
        g.setForeColor(this.eColor);
        g.setBackColor(this.bColor);
        if (this.borderStyle == -1) {
            g.draw3dRect(0, 0, this.width, this.height, (byte)5, false, false, this.fourColors);
        } else if (this.borderStyle == 1) {
            g.drawRect(0, 0, this.width, this.height);
        }
        g.setForeColor(this.eColor);
        g.setFont(this.font);
        int i = 0;
        while (i < this.items.length) {
            MenuItem mi = this.items[i][0];
            if (mi.isEnabled) {
                g.drawText(mi.caption, this.xpos[i] + this.gap, 1);
            } else {
                g.setForeColor(this.dColor);
                g.drawText(mi.caption, this.xpos[i] + this.gap, 1);
                g.setForeColor(this.eColor);
            }
            ++i;
        }
        if (this.selected != -1) {
            this.drawCursor(g, this.selected, true);
        }
    }

    protected void onPopup() {
        this.menuItemSelected = -1;
    }

    protected void popupClosed(PopupMenu pop) {
        this.pop = null;
        this.drawCursor(this.gr, this.selected, false);
    }

    protected void postPopup() {
        if (this.selected != -1) {
            this.switchTo(this.selected);
        }
    }

    protected void postUnpop() {
        if (this.menuItemSelected != -1) {
            this.postPressedEvent();
        }
    }

    public void setChecked(int menuItem, boolean check) {
        int col = menuItem / 100;
        int row = menuItem % 100;
        try {
            this.items[col][row].isChecked = check;
        }
        catch (Exception exception) {}
    }

    public void setCursorColor(Color c) {
        this.cursorColor = c;
    }

    public void setEnabled(int menuItem, boolean enable) {
        int col = menuItem / 100;
        int row = menuItem % 100;
        try {
            this.items[col][row].isEnabled = enable;
        }
        catch (Exception exception) {}
    }

    public void setItems(String[][] items) {
        this.items = MenuBar.strings2items(items);
        if (this.xpos != null) {
            this.onFontChanged();
        }
    }

    public void setPopColors(Color back, Color fore, Color cursor) {
        this.popFore = fore;
        this.popBack = back;
        this.popCursor = cursor;
    }

    public void setVisible(boolean b) {
        if (b) {
            try {
                if (this.wholeScreen == null) {
                    this.wholeScreen = new Image(Settings.screenWidth, Settings.screenHeight);
                }
                this.wholeScreen.getGraphics().copyScreen(MainWindow.mainWindowInstance, 0, 0, this.wholeScreen.getHeight());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.wholeScreen = null;
            }
            this.popupModal();
        }
    }

    public static MenuItem[][] strings2items(String[][] items) {
        MenuItem[][] its = new MenuItem[items.length][];
        int i = 0;
        while (i < its.length) {
            its[i] = PopupMenu.strings2items(items[i]);
            ++i;
        }
        return its;
    }

    protected void switchTo(int index) {
        if (this.selected != index) {
            if (this.selected != -1) {
                this.drawCursor(this.gr, this.selected, false);
            }
            this.selected = index;
            if (this.selected != -1) {
                this.drawCursor(this.gr, this.selected, true);
            }
        }
        this.switching = true;
        if (this.pop != null) {
            int ph = this.pop.height;
            this.pop.unpop();
            this.loadBehindLastPopup(ph);
        }
        this.needsPaint = false;
        if (index != -1) {
            this.pop = new PopupMenu(this.xpos[index], this.height - 2, this.items[index]);
            this.pop.setFont(this.font);
            if (this.borderStyle == 0) {
                this.pop.setBorderStyle((byte)0);
            }
            this.pop.setBackForeColors(this.popBack != null ? this.popBack : this.backColor, this.popFore != null ? this.popFore : this.foreColor);
            if (this.popCursor != null) {
                this.pop.setCursorColor(this.popCursor);
            }
            this.pop.dontSaveBehind(false);
            this.pop.popupModal();
        } else {
            this.pop = null;
        }
        this.switching = false;
    }
}

