/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.FontMetrics;
import waba.fx.Graphics;
import waba.fx.Rect;
import waba.fx.Sound;
import waba.sys.Settings;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.Label;
import waba.ui.PenEvent;
import waba.ui.PushButtonGroup;
import waba.ui.Timer;
import waba.ui.UIColors;
import waba.ui.Window;

public class MessageBox
extends Window {
    protected Label msg;
    protected PushButtonGroup btns;
    private int selected = -1;
    private boolean hasScroll;
    protected int xa;
    protected int ya;
    protected int wa;
    protected int ha;
    private Timer unpopTimer;
    private boolean oldHighlighting;

    public MessageBox(String title, String msg) {
        this(title, msg, new String[]{"Ok"}, 4, 6);
    }

    public MessageBox(String title, String text, String[] buttonCaptions) {
        this(title, text, buttonCaptions, 4, 6);
    }

    public MessageBox(String title, String text, String[] buttonCaptions, int gap, int insideGap) {
        super(title, (byte)2);
        this.highResPrepared = true;
        this.ha = 6 * Settings.screenHeight / 160;
        this.wa = this.ha * 2 + 1;
        if (buttonCaptions != null) {
            this.btns = new PushButtonGroup(buttonCaptions, false, -1, gap, insideGap, 1, false, 1);
        }
        this.msg = new Label(text, 120000);
        int wb = this.btns == null ? 0 : this.btns.getPreferredWidth();
        int hb = this.btns == null ? 0 : this.btns.getPreferredHeight();
        int wm = Math.min(this.msg.getPreferredWidth() + 1, Settings.screenWidth - 6);
        int hm = this.msg.getPreferredHeight();
        FontMetrics fm2 = this.titleFont.fm;
        int captionH = fm2.height + 8;
        if (captionH + hb + hm > Settings.screenHeight) {
            if (hb == 0) {
                hb = this.ha;
            }
            hm = Settings.screenHeight - captionH - hb - this.ha;
            this.hasScroll = true;
        }
        int h = captionH + hb + hm;
        int w = Math.max(Math.max(wb, wm), fm2.getTextWidth(title)) + 6;
        w = Math.min(w, Settings.screenWidth);
        this.setRect(120000, 120000, w, h);
        this.add(this.msg);
        if (this.btns != null) {
            this.add(this.btns);
        }
        this.msg.setRect(4, captionH - 6, this.getClientRect().width - 2, hm);
        if (this.btns != null) {
            this.btns.setRect(120000, captionH - 4 + hm, wb, hb);
        }
        Rect r = this.msg.getRect();
        this.xa = r.x + r.width - (this.wa << 1);
        int n = this.ya = this.btns != null ? this.btns.y + (this.btns.height - this.ha) / 2 : r.y2() + 3;
        if (Settings.isColor) {
            this.setBackForeColors(UIColors.messageboxBack, UIColors.messageboxFore);
            if (this.btns != null) {
                this.btns.setBackColor(UIColors.messageboxAction);
            }
        }
    }

    public int getPressedButtonIndex() {
        return this.selected;
    }

    protected void onColorsChanged(boolean colorsChanged) {
        if (colorsChanged) {
            this.msg.setBackForeColors(this.backColor, this.foreColor);
            if (this.btns != null) {
                if (this.backColor.getAlpha() < this.foreColor.getAlpha()) {
                    this.btns.setBackForeColors(this.foreColor, this.backColor);
                } else {
                    this.btns.setBackForeColors(this.backColor, this.foreColor);
                }
            }
        }
    }

    public void onEvent(Event e) {
        switch (e.type) {
            case 303: {
                if (e.target != this) break;
                this.removeTimer(this.unpopTimer);
                if (!this.popped) break;
                this.unpop();
                break;
            }
            case 200: {
                if (!this.hasScroll) break;
                int px = ((PenEvent)e).x;
                int py = ((PenEvent)e).y;
                if (this.ya > py || py > this.ya + this.ha || this.xa > px || px >= this.xa + (this.wa << 1) || !this.msg.scroll((px - this.xa) / this.wa != 0)) break;
                this.repaint();
                Sound.beep();
                break;
            }
            case 100: {
                KeyEvent ke = (KeyEvent)e;
                if (ke.isUpKey()) {
                    this.msg.scroll(false);
                    this.repaint();
                    break;
                }
                if (!ke.isDownKey()) break;
                this.msg.scroll(true);
                this.repaint();
                break;
            }
            case 300: {
                if (e.target != this.btns || (this.selected = this.btns.getSelected()) == -1) break;
                this.btns.setSelected(-1);
                this.unpop();
                break;
            }
        }
    }

    public void onPaint(Graphics g) {
        if (this.hasScroll) {
            g.drawArrow(this.xa, this.ya, this.ha, (byte)1, false, this.msg.canScroll(false), this.foreColor);
            g.drawArrow(this.xa + this.wa, this.ya, this.ha, (byte)2, false, this.msg.canScroll(true), this.foreColor);
        }
    }

    protected void postPopup() {
        if (Settings.keyboardFocusTraversable) {
            if (this.btns != null) {
                this.btns.requestFocus();
                this.btns.setSelected(0);
            }
            this.oldHighlighting = Control.isHighlighting;
            Control.isHighlighting = false;
        }
    }

    protected void postUnpop() {
        if (Settings.keyboardFocusTraversable) {
            Control.isHighlighting = this.oldHighlighting;
        }
        this.postPressedEvent();
    }

    public void setTextAlignment(int align) {
        this.msg.align = align;
    }

    public void setUnpopDelay(int unpopDelay) {
        if (unpopDelay > 0) {
            this.unpopTimer = this.addTimer(unpopDelay);
        }
    }
}

