/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Rect;
import waba.sys.Settings;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Event;
import waba.ui.ListBox;
import waba.ui.Window;

public class PopList
extends Window {
    public ListBox lb;
    public boolean dontHideParent = Control.uiPalm ^ true;
    private ControlEvent ce = new ControlEvent(498, null);
    public boolean fullHeight;
    public boolean fullWidth;
    private int selected;

    public PopList() {
        this(new ListBox());
    }

    public PopList(ListBox lb) {
        this.highResPrepared = true;
        this.started = true;
        this.setDoubleBuffer(true);
        this.lb = lb;
        lb.simpleBorder = true;
        super.add(lb);
        this.ce.target = lb;
        lb.focusTraversable = false;
        this.focusTraversable = false;
    }

    public int getPreferredHeight() {
        return this.lb.getPreferredHeight();
    }

    public int getPreferredWidth() {
        return this.lb.getPreferredWidth();
    }

    protected boolean onClickedOutside(int x, int y) {
        this.unpop();
        return true;
    }

    public void onEvent(Event event) {
        switch (event.type) {
            case 300: {
                if (event.target != this.lb) break;
                this.unpop();
                break;
            }
            case 498: {
                this.lb.onEvent(event);
                break;
            }
        }
    }

    protected void onFontChanged() {
        if (this.lb != null) {
            this.lb.setFont(this.font);
        }
    }

    protected void onPopup() {
        this.selected = this.lb.getSelectedIndex();
        this.lb.onEvent(this.ce);
    }

    protected void postUnpop() {
        if (this.selected != this.lb.getSelectedIndex()) {
            this.postPressedEvent();
        }
    }

    public void setRect(int x, int y, int width, int height) {
        this.setRect(x, y, width, height, null);
    }

    public void setRect(int x, int y, int width, int height, Control relative) {
        if (this.lb.size() > 0) {
            if (this.fullWidth) {
                x = 0;
                width = Settings.screenWidth;
            } else {
                width = Math.min(Math.max(Control.uiFlat ? width : width - 2, this.lb.getPreferredWidth()), Settings.screenWidth - 10);
                if (x + width > Settings.screenWidth) {
                    x = Settings.screenWidth - width;
                }
            }
            int prefH = this.lb.getPreferredHeight();
            int remainsAtBottom = Settings.screenHeight - (y + height);
            int remainsAtTop = y;
            if (prefH <= remainsAtBottom) {
                if (this.dontHideParent) {
                    y += height - 1;
                }
                height = prefH;
            } else if (prefH <= remainsAtTop) {
                y = this.dontHideParent ? (y -= prefH - 1) : (y += height - prefH - 1);
                height = prefH;
            } else if (this.fullHeight) {
                height = Math.min(prefH, (Settings.screenHeight - 6) / this.fmH * this.fmH + 6);
                y = Settings.screenHeight - height >> 1;
            } else if (remainsAtBottom >= remainsAtTop) {
                if (this.dontHideParent) {
                    y += height - 1;
                }
                height = (remainsAtBottom - 6) / this.fmH * this.fmH + 6;
                if (!this.dontHideParent) {
                    height += this.fmH;
                }
            } else {
                height = (remainsAtTop - 6) / this.fmH * this.fmH + 6;
                if (!this.dontHideParent) {
                    height += this.fmH;
                    y += this.fmH;
                }
                y -= height - 1;
            }
        }
        super.setRect(x, y, width, height, null);
        this.lb.setRect(0, 0, width, height);
    }

    public void setRect(Rect r) {
        this.setRect(r.x, r.y, r.width, r.height, null);
    }
}

