/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.sys.Settings;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.MenuBar;
import waba.ui.MenuItem;
import waba.ui.PenEvent;
import waba.ui.Window;

public class PopupMenu
extends Window {
    private MenuItem[] items;
    private int[] ypos;
    private int selected = -1;
    private Graphics gr;
    private int popX;
    private int popY;
    private PenEvent pe = new PenEvent();
    private int lineHeight;
    private Color dColor;
    private Color bColor;
    private Color fColor;
    private Color cursorColor;
    private Color[] fourColors = new Color[4];

    public PopupMenu(int x, int y, String[] items) {
        this(x, y, PopupMenu.strings2items(items));
    }

    public PopupMenu(int x, int y, MenuItem[] items) {
        this.items = items;
        this.highResPrepared = true;
        this.canDrag = false;
        this.popX = x;
        this.popY = y;
        this.setFont(this.getFont().asBold());
        this.setBackColor(Color.WHITE);
        this.borderStyle = (byte)-1;
        this.started = true;
        this.pe.target = this;
        this.pe.type = 200;
    }

    private void drawCursor(Graphics g, int index, boolean on) {
        Color f = this.cursorColor != null ? this.cursorColor : this.bColor.getCursorColor();
        g.setForeColor(on ? this.bColor : f);
        g.setBackColor(on ? f : this.bColor);
        g.eraseRect(1, this.ypos[index - 1], this.width - 3, this.lineHeight);
    }

    private int getItemAt(int y) {
        int i = 1;
        while (i < this.ypos.length) {
            MenuItem mi = this.items[i];
            if (this.ypos[i - 1] <= y && y <= this.ypos[i] && mi.isEnabled && !mi.isSeparator) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private MenuBar getMenuBar() {
        Window w = (Window)Window.zStack.items[Window.zStack.size() - 2];
        if (w instanceof MenuBar) {
            return (MenuBar)w;
        }
        return null;
    }

    public int getSelected() {
        return this.selected;
    }

    public int getYPos(int index) {
        return this.ypos[index];
    }

    protected boolean handleFocusChangeKeys(KeyEvent ke) {
        if (ke.isActionKey()) {
            this.unpop();
        } else if (ke.isUpKey() || ke.isDownKey()) {
            int newSelected = this.selected == -1 ? 0 : this.selected;
            int i = this.items.length;
            while (i > 0) {
                if (ke.isDownKey()) {
                    if (++newSelected == this.items.length) {
                        newSelected = 1;
                    }
                } else if (--newSelected <= 0) {
                    newSelected = this.items.length - 1;
                }
                MenuItem mi = this.items[newSelected];
                if (!mi.isSeparator && mi.isEnabled) {
                    this.setSelected(newSelected);
                    break;
                }
                --i;
            }
        } else if (ke.key == 75006 || ke.key == 75007 || ke.key == 75010) {
            MenuBar mb = this.getMenuBar();
            if (mb != null) {
                mb.moveBy(ke.key == 75006 ? -1 : 1);
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean onClickedOutside(int x, int y) {
        Window w;
        this.selected = -1;
        if (y < this.y && (w = (Window)Window.zStack.items[Window.zStack.size() - 2]) instanceof MenuBar) {
            this.pe.x = x;
            this.pe.y = y;
            w.onEvent(this.pe);
            if (Window.topMost == this) {
                this.requestFocus();
            }
            return true;
        }
        if (x < this.x || x > this.x2 || y > this.y || y < this.y2) {
            this.unpop();
            if (Window.topMost instanceof MenuBar) {
                ((MenuBar)Window.topMost).popupClosed(this);
            }
        }
        return true;
    }

    protected void onColorsChanged(boolean colorsChanged) {
        this.fColor = this.getForeColor();
        this.bColor = this.getBackColor();
        Color color = this.dColor = this.fColor.getAlpha() > 128 ? this.fColor.darker() : this.fColor.brighter();
        if (colorsChanged) {
            Graphics.compute3dColors(true, this.backColor, this.foreColor, this.fourColors);
            if (this.cursorColor == null && Settings.maxColors >= 256) {
                this.cursorColor = Color.getColor(0, 0, 240);
            }
        }
    }

    public void onEvent(Event event) {
        switch (event.type) {
            case 100: {
                Window w;
                if (((KeyEvent)event).key == 75014) {
                    this.unpop();
                }
                if (!((w = Window.topMost) instanceof MenuBar)) break;
                ((MenuBar)w).close();
                break;
            }
            case 200: 
            case 202: 
            case 203: {
                PenEvent pe = (PenEvent)event;
                if (pe.y > 0 && pe.y < this.height) {
                    int newSelected = this.getItemAt(pe.y);
                    if (newSelected != this.selected) {
                        if (this.selected != -1) {
                            this.drawCursor(this.gr, this.selected, false);
                        }
                        this.selected = newSelected;
                        if (this.selected != -1) {
                            this.drawCursor(this.gr, this.selected, true);
                        }
                    }
                    if (event.type != 202 || this.selected == -1) break;
                    this.unpop();
                    break;
                }
                if (this.selected == -1) break;
                this.drawCursor(this.gr, this.selected, false);
                this.selected = -1;
                break;
            }
        }
    }

    protected void onFontChanged() {
        int y;
        int w = 0;
        this.lineHeight = this.fmH + 1;
        int n = this.items.length;
        this.ypos = new int[n];
        boolean haveCheckable = false;
        int i = 1;
        while (i < n) {
            MenuItem mi = this.items[i];
            if (mi.isCheckable) {
                haveCheckable = true;
            }
            w = Math.max(w, this.fm.getTextWidth(mi.caption));
            ++i;
        }
        if (haveCheckable) {
            float factor = (float)this.fmH / 11.0f;
            w += (int)(factor * 8.0f) + 1;
        }
        this.ypos[0] = y = 1;
        int i2 = 1;
        while (i2 < n) {
            this.ypos[i2] = y += this.items[i2].isSeparator ? 1 : this.lineHeight;
            ++i2;
        }
        int screenW = Settings.screenWidth;
        if (this.popX + (w += 6) > screenW) {
            this.popX = screenW - w;
        }
        if (this.popX < 0) {
            this.popX = 0;
        }
        this.setRect(this.popX, this.popY, w, y + 2);
    }

    public void onPaint(Graphics g) {
        g.setForeColor(this.fColor);
        g.setBackColor(this.bColor);
        if (this.borderStyle == -1) {
            g.draw3dRect(0, 0, this.width, this.height, (byte)5, false, true, this.fourColors);
        }
        g.setFont(this.font);
        int i = 1;
        while (i < this.items.length) {
            MenuItem mi = this.items[i];
            if (mi.isSeparator) {
                g.drawDots(0, this.ypos[i - 1], this.width - 3, this.ypos[i - 1]);
            } else {
                if (!mi.isEnabled) {
                    g.setForeColor(this.dColor);
                }
                if (mi.isChecked) {
                    int x = this.width - 9 - this.fmH / 11;
                    int y = this.ypos[i - 1] + 5;
                    int my = 2;
                    int mx = 7;
                    int hh = 2 * this.fmH / 11;
                    if (this.fmH > 11) {
                        x -= hh;
                        y += this.fmH == 14 ? hh - 1 : hh;
                        my += hh >> 1;
                        mx += hh;
                    }
                    int j = 0;
                    while (j < mx) {
                        g.drawLine(x, y, x, y + hh);
                        ++x;
                        y = j < my ? ++y : --y;
                        ++j;
                    }
                }
                g.drawText(mi.caption, 3, this.ypos[i - 1]);
                if (!mi.isEnabled) {
                    g.setForeColor(this.fColor);
                }
            }
            ++i;
        }
        if (this.selected != -1) {
            this.drawCursor(g, this.selected, true);
        }
    }

    protected void onPopup() {
        this.selected = -1;
        if (this.gr != null) {
            this.gr.free();
        }
        this.gr = this.createGraphics();
    }

    protected void postPopup() {
        Control.isHighlighting = Settings.keyboardFocusTraversable;
    }

    protected void postUnpop() {
        if (this.selected != -1) {
            this.postPressedEvent();
        }
    }

    public void setCursorColor(Color c) {
        this.cursorColor = c;
    }

    public int setSelected(int index) {
        if (index <= -1) {
            this.selected = 1;
            index = 1;
        } else if (index == 1000) {
            this.selected = -1;
        } else if (this.selected > 0) {
            this.drawCursor(this.gr, this.selected, false);
            this.selected = index;
            this.drawCursor(this.gr, this.selected, true);
        } else {
            this.selected = index >= 1 ? index : 1;
            this.drawCursor(this.gr, this.selected, true);
        }
        return this.selected;
    }

    public static MenuItem[] strings2items(String[] strings) {
        MenuItem[] mi = new MenuItem[strings.length];
        int i = mi.length - 1;
        while (i > 0) {
            MenuItem m;
            String caption = strings[i];
            switch (caption.charAt(0)) {
                case '*': {
                    m = new MenuItem(caption.substring(1));
                    m.isEnabled = false;
                    break;
                }
                case '!': {
                    m = new MenuItem(caption.substring(1), true);
                    break;
                }
                case '?': {
                    m = new MenuItem(caption.substring(1), false);
                    break;
                }
                case '-': {
                    m = new MenuItem();
                    break;
                }
                default: {
                    m = new MenuItem(caption);
                }
            }
            mi[i] = m;
            --i;
        }
        mi[0] = new MenuItem(strings[0]);
        return mi;
    }
}

