/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.Rect;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.PenEvent;
import waba.ui.Window;

public class PushButtonGroup
extends Control {
    public static final byte NORMAL = 0;
    public static final byte BUTTON = 1;
    public static final byte CHECK = 2;
    protected String[] names;
    private int[] widths;
    private int selectedIndex = -1;
    private int gap;
    private int insideGap;
    private int rows;
    private int cols;
    private boolean atLeastOne;
    private boolean actLikeButton;
    private boolean actLikeCheck;
    private int cellH;
    private int rowH;
    private int lastSel = -1;
    public int maxWidth = -1;
    private boolean simpleBorder = Control.uiPalm || Control.uiFlat;
    private Graphics myg;
    Rect[] rects;
    private int count;
    private boolean allSameWidth;
    private int[] tX;
    private Color dColor;
    private Color fColor;
    private Color[] fourColors = new Color[4];
    private Color userCursorColor;
    private Color[] btnFColors;
    private Color[] btnBColors;
    public boolean[] hidden;

    public PushButtonGroup(String[] names, int gap, int rows) {
        this(names, false, -1, gap, 4, rows, true, 1);
    }

    public PushButtonGroup(String[] names, int gap, int insideGap, int rows) {
        this(names, false, -1, gap, insideGap, rows, false, 1);
    }

    public PushButtonGroup(String[] names, boolean atLeastOne, int selected, int gap, int insideGap, int rows, boolean allSameWidth, byte type) {
        this.names = names;
        this.insideGap = insideGap;
        this.atLeastOne = atLeastOne;
        this.actLikeButton = type == 1;
        this.actLikeCheck = type == 2;
        this.allSameWidth = allSameWidth;
        this.selectedIndex = selected;
        this.gap = gap;
        this.count = names.length;
        this.widths = new int[this.count];
        this.rects = new Rect[this.count];
        this.tX = new int[this.count];
        if (rows < 1) {
            rows = 1;
        }
        this.rows = rows;
        this.cols = this.count / rows;
        if (this.count % this.cols != 0) {
            ++this.rows;
        }
        this.hidden = new boolean[this.count];
        this.onFontChanged();
    }

    public void clear() {
        this.setSelected(this.clearValueInt);
    }

    private void drawCursor(Graphics g, int ind, boolean on) {
        if (Control.uiFlat || Control.uiPalm) {
            Rect r = this.rects[ind];
            if (!(r == null || on && this.hidden[ind])) {
                int k;
                g.setForeColor(on ? this.backColor : this.dColor);
                g.setBackColor(on ? this.dColor : this.backColor);
                int n = k = this.simpleBorder ? 1 : 2;
                if (Control.uiVista) {
                    g.fill3dRect(r.x + k, r.y + k, r.width - (k << 1), r.height - (k << 1), this.backColor, on && !this.actLikeCheck, false);
                } else {
                    g.eraseRect(r.x + k, r.y + k, r.width - (k << 1), r.height - (k << 1));
                }
            }
        } else {
            this.onPaint(g, on ? ind : -1);
        }
    }

    private int findButtonAt(int px, int py) {
        if (px >= 0 && px < this.width && py >= 0 && py < this.height) {
            int s = this.cols * (py / this.rowH);
            int e = Math.min(this.count, s + this.cols);
            int i = s;
            while (i < e) {
                Rect r = this.rects[i];
                if (r != null && !this.hidden[i] && r.contains(px, py)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int getPreferredHeight() {
        return (this.fmH + (this.simpleBorder ? 0 : 2) + this.gap) * this.rows - this.gap;
    }

    public int getPreferredWidth() {
        int w = 0;
        int wc = 0;
        if (this.count == this.rows) {
            int i = this.count - 1;
            while (i >= 0) {
                w = Math.max(w, this.widths[i]);
                --i;
            }
        } else {
            int n = this.count;
            int i = 0;
            while (i < n) {
                wc += (this.maxWidth == -1 ? this.widths[i] : this.maxWidth) + this.gap;
                if (i != 0 && (i + 1) % this.cols == 0) {
                    w = (wc -= this.gap) > w ? wc : w;
                    wc = 0;
                }
                ++i;
            }
            w = wc > w ? wc : w;
        }
        return w;
    }

    public int getSelected() {
        return this.selectedIndex;
    }

    public String getSelectedCaption() {
        return this.selectedIndex == -1 ? null : this.names[this.selectedIndex];
    }

    public void onBoundsChanged() {
        this.rowH = (this.height + this.gap) / this.rows;
        this.cellH = this.rowH - this.gap;
        int g = this.gap >= 0 ? this.gap : 0;
        int desiredW = this.width / this.cols - g;
        int extraGaps = this.width - (desiredW + this.gap) * this.cols + g;
        int i = 0;
        int c = this.cols;
        int x = 0;
        int y = 0;
        while (true) {
            int w;
            int n = !this.allSameWidth ? this.widths[i] : (w = desiredW + (c < extraGaps ? 1 : 0));
            if (this.names[i] != null) {
                this.rects[i] = new Rect(x, y, w, this.cellH);
            }
            this.tX[i] = x + (w - this.widths[i] + this.insideGap >> 1);
            if (++i >= this.count) break;
            if (--c == 0) {
                x = 0;
                y += this.rowH;
                c = this.cols;
                continue;
            }
            x += w + this.gap;
        }
        this.myg = null;
    }

    protected void onColorsChanged(boolean colorsChanged) {
        if (colorsChanged) {
            this.dColor = this.userCursorColor != null ? this.userCursorColor : this.backColor.getCursorColor();
        }
        this.fColor = this.getForeColor();
        Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.fourColors);
    }

    public void onEvent(Event event) {
        if (event.type == 498) {
            if (this.myg != null) {
                this.myg.free();
            }
            this.myg = this.createGraphics();
        } else {
            int sel = 0;
            if (event instanceof PenEvent) {
                sel = this.findButtonAt(((PenEvent)event).x, ((PenEvent)event).y);
            }
            switch (event.type) {
                case 200: 
                case 203: {
                    if (sel == this.selectedIndex || this.atLeastOne && sel == -1) break;
                    this.setSelected(sel);
                    break;
                }
                case 100: {
                    KeyEvent ke = (KeyEvent)event;
                    int key = ke.key;
                    if (key == 48 && !this.atLeastOne) {
                        this.select(-1, true);
                    } else if (key >= 49 && key <= 57 && key - 49 < this.count) {
                        this.select(key - 49, true);
                    } else if (Settings.keyboardFocusTraversable && (ke.isPrevKey() || ke.isNextKey())) {
                        int newIndex = this.selectedIndex;
                        if (newIndex == -1) {
                            key = 75007;
                        }
                        if (ke.isUpKey()) {
                            do {
                                if ((newIndex -= this.cols) >= 0) continue;
                                newIndex = this.count + newIndex;
                            } while (this.names[newIndex] == null || this.names[newIndex].length() == 0);
                        } else if (ke.isDownKey()) {
                            do {
                                if ((newIndex += this.cols) < this.count) continue;
                                newIndex %= this.count;
                            } while (this.names[newIndex] == null || this.names[newIndex].length() == 0);
                        } else if (key == 75007) {
                            while (this.names[newIndex = (newIndex + 1) % this.count] == null || this.names[newIndex].length() == 0) {
                            }
                        } else if (key == 75006) {
                            while (this.names[newIndex = newIndex == 0 ? this.count - 1 : newIndex - 1] == null || this.names[newIndex].length() == 0) {
                            }
                        }
                        if (newIndex != this.selectedIndex) {
                            this.setSelected(newIndex);
                        }
                    }
                    if (!ke.isActionKey()) break;
                }
                case 202: {
                    this.select(sel, false);
                    break;
                }
            }
        }
    }

    protected void onFontChanged() {
        int avg = 0;
        int nullNames = 0;
        this.maxWidth = -1;
        int i = this.count - 1;
        while (i >= 0) {
            if (this.names[i] == null) {
                ++nullNames;
            } else {
                this.widths[i] = this.fm.getTextWidth(this.names[i]) + this.insideGap;
                avg += this.widths[i];
            }
            if (this.allSameWidth) {
                this.maxWidth = Math.max(this.maxWidth, this.widths[i]);
            }
            --i;
        }
        if (nullNames > 0) {
            avg /= this.count - nullNames;
            i = this.count - 1;
            while (i >= 0) {
                if (this.names[i] == null) {
                    this.widths[i] = avg;
                }
                --i;
            }
        }
    }

    public void onPaint(Graphics g) {
        this.onPaint(g, this.selectedIndex);
    }

    private void onPaint(Graphics g, int sel) {
        Rect r;
        boolean drawEachBack;
        int n = this.count;
        int ty = (this.cellH - this.fmH) / 2;
        if (this.myg == null) {
            this.myg = this.createGraphics();
        }
        g.setBackColor(this.backColor);
        g.setForeColor(this.fColor);
        boolean bl = drawEachBack = this.btnBColors != null || Control.uiCE || Control.uiVista && this.enabled || this.gap > 0 && this.parent != null && this.backColor.equ != this.parent.backColor.equ;
        if (!drawEachBack) {
            g.fillRect(0, 0, this.width, this.height);
        }
        int i = 0;
        while (i < n) {
            r = this.rects[i];
            if (r != null && !this.hidden[i]) {
                if (drawEachBack) {
                    Color back = i == sel && this.userCursorColor != null ? this.userCursorColor : (this.btnBColors != null && this.btnBColors[i] != null ? this.btnBColors[i] : this.backColor);
                    if (Control.uiVista) {
                        g.fill3dRect(r.x, r.y, r.width, r.height, back, i == sel, false);
                    } else {
                        g.setBackColor(back);
                        g.fillRect(r.x, r.y, r.width, r.height);
                        g.setBackColor(this.backColor);
                    }
                }
                if (this.simpleBorder) {
                    g.drawRect(r.x, r.y, r.width, r.height);
                } else {
                    g.draw3dRect(r.x, r.y, r.width, r.height, this.actLikeCheck ? (Control.uiCE && i == sel ? (byte)3 : 4) : (Control.uiCE && i == sel ? (byte)2 : 3), false, false, this.fourColors);
                }
            }
            ++i;
        }
        g.setForeColor(this.fColor);
        i = 0;
        while (i < n) {
            r = this.rects[i];
            if (r != null && !this.hidden[i]) {
                boolean useCustomColor = this.btnFColors != null && this.btnFColors[i] != null;
                g.setClip(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
                if (useCustomColor) {
                    g.setForeColor(this.btnFColors[i]);
                }
                if (Control.uiPalm || Control.uiFlat || i != sel) {
                    g.drawText(this.names[i], this.tX[i], r.y + ty);
                } else {
                    g.drawText(this.names[i], this.tX[i] + (Control.uiCE && this.actLikeCheck ? -1 : 1), r.y + ty + (Control.uiCE && this.actLikeCheck ? -1 : 1));
                }
                if (useCustomColor) {
                    g.setForeColor(this.fColor);
                }
            }
            ++i;
        }
        g.clearClip();
        if ((Control.uiFlat || Control.uiPalm) && this.selectedIndex != -1) {
            this.drawCursor(g, this.selectedIndex, true);
        }
    }

    private void select(int sel, boolean selectIt) {
        if (selectIt) {
            this.setSelected(sel);
        }
        if (!this.atLeastOne || sel != -1) {
            this.postEvent(new ControlEvent(300, this));
        }
        if (this.actLikeCheck) {
            if (this.lastSel != this.selectedIndex) {
                this.lastSel = this.selectedIndex;
            } else {
                this.lastSel = -1;
                this.setSelected(-1);
            }
        } else if (this.actLikeButton || sel == -1 && !this.atLeastOne) {
            Vm.sleep(150);
            this.setSelected(-1);
        }
    }

    public void setColor(int index, Color fore, Color back) {
        if (index >= 0 && index < this.count) {
            if (fore != null && this.btnFColors == null) {
                this.btnFColors = new Color[this.count];
            }
            if (back != null && this.btnBColors == null) {
                this.btnBColors = new Color[this.count];
            }
            if (this.btnFColors != null) {
                this.btnFColors[index] = fore;
            }
            if (this.btnBColors != null) {
                this.btnBColors[index] = back;
            }
        }
    }

    public void setCursorColor(Color color) {
        this.userCursorColor = color;
        this.onColorsChanged(true);
    }

    public void setNames(String[] newNames) {
        if (newNames.length == this.names.length) {
            this.names = newNames;
            this.repaint();
        }
    }

    public void setSelected(int ind) {
        int min;
        boolean doRepaint = this.getParentWindow() == Window.getTopMost();
        int n = min = this.atLeastOne ? 0 : -1;
        if ((this.actLikeCheck || this.selectedIndex != ind) && min <= ind && ind < this.count) {
            if (this.myg != null && this.selectedIndex >= 0 && doRepaint) {
                this.drawCursor(this.myg, this.selectedIndex, false);
            }
            this.selectedIndex = ind;
            this.lastSel = -100;
            if (this.myg != null && this.selectedIndex >= 0 && this.names[ind] != null && doRepaint) {
                this.drawCursor(this.myg, ind, true);
            }
        }
    }

    public void setSimpleBorder(boolean simple) {
        this.simpleBorder = simple || Control.uiPalm || Control.uiFlat || Control.uiVista;
    }
}

