/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Font;
import waba.fx.FontMetrics;
import waba.fx.Graphics;
import waba.fx.Image;
import waba.fx.Rect;
import waba.fx.Sound;
import waba.sys.Settings;
import waba.ui.Button;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.PenEvent;
import waba.ui.UIColors;
import waba.ui.Window;

public class TabPanel
extends Container {
    private int activeIndex = -1;
    private String[] strCaptions;
    private Image[] imgCaptions;
    private boolean isTextCaption = true;
    private Container[] panels;
    private int gapL;
    private int gapT;
    private int gapB;
    private int gapR;
    private int count;
    private int tabH;
    private Color captionColor = Color.BLACK;
    private boolean atTop = true;
    private Rect[] rects;
    private Rect[] rSel;
    private Rect[] rNotSel;
    private Color fColor;
    private Color cColor;
    private Color[] panelsColor;
    private Rect clientRect;
    private Button btnLeft;
    private Button btnRight;
    private static final byte FOCUSMODE_OUTSIDE = 0;
    private static final byte FOCUSMODE_CHANGING_TABS = 1;
    private static final byte FOCUSMODE_INSIDE_CONTAINERS = 2;
    private byte focusMode;
    private boolean brightBack;
    public boolean beepOn = true;
    private Font bold;
    private int btnX;
    private Color transpColor;
    private int style = 1;
    public Color activeTabBackColor;
    public boolean useOnTabThePanelsColor = false;
    public int lastActiveTab = -1;
    public static final byte TABS_TOP = 0;
    public static final byte TABS_BOTTOM = 1;

    private TabPanel(int count) {
        this.count = count;
        this.started = true;
        this.panels = new Container[count];
        this.rects = new Rect[count];
        int i = count - 1;
        while (i >= 0) {
            this.rects[i] = new Rect();
            this.panels[i] = new Container();
            --i;
        }
    }

    public TabPanel(String[] strCaptions) {
        this(strCaptions.length);
        this.strCaptions = strCaptions;
        this.onFontChanged();
    }

    public TabPanel(Image[] imgCaptions, Color transparentColor) {
        this(imgCaptions.length);
        this.imgCaptions = imgCaptions;
        if (transparentColor != null) {
            this.transpColor = transparentColor;
            int i = this.count - 1;
            while (i >= 0) {
                imgCaptions[i].setTransparentColor(transparentColor);
                --i;
            }
        }
        this.isTextCaption = false;
        this.onFontChanged();
    }

    private void addArrows() {
        boolean mustScroll;
        boolean bl = mustScroll = this.count > 1 && this.getPreferredWidth() > this.width;
        if (mustScroll) {
            if (this.btnLeft != null) {
                super.remove(this.btnLeft);
                super.remove(this.btnRight);
            }
            int hh = 5 * this.fmH / 11;
            Color c = this.parent != null ? this.parent.backColor : UIColors.controlsBack;
            this.btnRight = Button.createArrowButton((byte)4, hh, this.captionColor);
            this.btnRight.setBackColor(c);
            this.btnRight.setBorder((byte)0);
            this.btnLeft = Button.createArrowButton((byte)3, hh, this.captionColor);
            this.btnLeft.setBackColor(c);
            this.btnLeft.setBorder((byte)0);
            int yy = this.tabH + this.btnRight.getPreferredHeight() >> 1;
            super.add(this.btnRight, 130000, this.atTop ? this.tabH - yy : this.height - yy);
            super.add(this.btnLeft, 169998, 180000);
            this.btnX = this.btnLeft.x - 2;
            this.btnLeft.setEnabled(false);
            this.btnLeft.setFocusLess(true);
            this.btnRight.setFocusLess(true);
        }
    }

    public void changeHighlighted(Container p, boolean forward) {
        Window w = this.getParentWindow();
        switch (this.focusMode) {
            case 0: {
                if (w.getHighlighted() != this) {
                    w.setHighlighted(this);
                    break;
                }
                super.changeHighlighted(p, forward);
                break;
            }
            case 2: {
                this.focusMode = 1;
                w.setHighlighted(this);
                this.repaint();
                this.requestFocus();
                Control.isHighlighting = false;
                break;
            }
            default: {
                super.changeHighlighted(p, forward);
            }
        }
    }

    private void computeTabsRect() {
        int x0 = 1;
        int y0 = this.atTop ? 0 : this.height - this.tabH;
        int n = this.count;
        int i = 0;
        while (i < n) {
            Rect r = this.rects[i];
            Rect r0 = i == this.activeIndex ? this.rSel[i] : this.rNotSel[i];
            r.x = x0;
            r.y = r0.y + y0;
            r.width = r0.width;
            r.height = r0.height;
            x0 += r.width - 1;
            this.rects[i] = r;
            ++i;
        }
    }

    public int getActiveTab() {
        return this.activeIndex;
    }

    public Color getCaptionColor() {
        return this.enabled ? this.captionColor : this.captionColor.brighter();
    }

    public Rect getClientRect() {
        return this.clientRect;
    }

    public void getClientRect(Rect r) {
        r.set(this.clientRect);
    }

    public Container getPanel(int i) {
        return this.panels[i];
    }

    public int getPreferredHeight() {
        return this.tabH;
    }

    public int getPreferredWidth() {
        int sum = 0;
        if (this.count > 0) {
            int maxw = 0;
            int maxi = 0;
            int i = this.count - 1;
            while (i >= 0) {
                int w = this.rSel[i].width;
                if (w > maxw) {
                    maxi = i;
                    maxw = w;
                }
                sum += this.rNotSel[i].width - 1;
                --i;
            }
            sum += maxw - this.rNotSel[maxi].width;
        }
        return sum + 2;
    }

    private void offsetRects(int xOfs) {
        int i = this.count - 1;
        while (i >= 0) {
            this.rects[i].x += xOfs;
            --i;
        }
    }

    protected void onBoundsChanged() {
        this.computeTabsRect();
        int borderGap = this.style == 0 ? 0 : 1;
        int xx = this.gapL + borderGap;
        int yy = (this.atTop ? this.tabH : borderGap) + this.gapT;
        int ww = this.width - this.gapL - this.gapR - (borderGap << 1);
        int hh = this.height - this.gapT - this.gapB - (borderGap << 1) - (this.atTop ? yy : this.tabH);
        this.clientRect = new Rect(xx, yy, ww, hh);
        int i = this.count - 1;
        while (i >= 0) {
            this.panels[i].setRect(xx, yy, ww, hh);
            --i;
        }
        if (this.activeIndex == -1) {
            this.setActiveTab(0);
        }
        this.addArrows();
    }

    protected void onColorsChanged(boolean colorsChanged) {
        if (colorsChanged) {
            this.brightBack = Settings.isColor && this.foreColor.getAlpha() > 128;
        }
        this.fColor = this.enabled || !this.brightBack ? this.getForeColor() : this.foreColor.darker();
        Color color = this.cColor = this.enabled || !this.brightBack ? this.getCaptionColor() : this.captionColor.darker();
        if (this.btnLeft != null) {
            this.addArrows();
        }
    }

    public void onEvent(Event event) {
        if (event.target != this) {
            if (event.type == 300 && (event.target == this.btnLeft || event.target == this.btnRight)) {
                int newIdx = event.target == this.btnLeft ? this.activeIndex - 1 : this.activeIndex + 1;
                this.setActiveTab(newIdx);
            }
            return;
        }
        block0 : switch (event.type) {
            case 301: {
                if (!Settings.keyboardFocusTraversable) break;
                this.focusMode = 1;
                break;
            }
            case 200: {
                PenEvent pe = (PenEvent)event;
                if (this.rects[0].y > pe.y || pe.y > this.rects[0].y2()) break;
                int i = this.count - 1;
                while (i >= 0) {
                    if (this.rects[i].contains(pe.x, pe.y)) {
                        if (i == this.activeIndex) break block0;
                        if (this.beepOn && Settings.onDevice) {
                            Sound.beep();
                        }
                        this.setActiveTab(i);
                        break block0;
                    }
                    --i;
                }
                break;
            }
            case 101: {
                this.focusMode = 1;
                this.repaint();
                break;
            }
            case 100: {
                if (!Settings.keyboardFocusTraversable) break;
                KeyEvent ke = (KeyEvent)event;
                int key = ke.key;
                if (this.focusMode == 1) {
                    if (key == 75006 || key == 75007) {
                        boolean limitsReached;
                        boolean forward = key == 75007;
                        boolean bl = limitsReached = forward && this.activeIndex == this.panels.length - 1 || !forward && this.activeIndex == 0;
                        int nextIdx = limitsReached ? (forward ? 0 : this.panels.length - 1) : (forward ? this.activeIndex + 1 : this.activeIndex - 1);
                        this.setActiveTab(nextIdx);
                    } else if (ke.isUpKey() || ke.isDownKey()) {
                        this.focusMode = (byte)2;
                        this.repaint();
                        this.panels[this.activeIndex].changeHighlighted(this.panels[this.activeIndex], ke.isDownKey());
                        Control.isHighlighting = true;
                    }
                }
                if (!ke.isActionKey()) break;
                this.focusMode = 0;
                Control.isHighlighting = true;
                this.repaint();
                break;
            }
        }
    }

    protected void onFontChanged() {
        boolean isText = this.isTextCaption;
        this.tabH = isText ? this.fmH + 4 : this.imgCaptions[0].getHeight() + 4;
        int y0 = this.atTop ? 2 : 0;
        this.bold = this.font.asBold();
        FontMetrics fmb = this.bold.fm;
        this.rSel = new Rect[this.count];
        this.rNotSel = new Rect[this.count];
        int i = this.count - 1;
        while (i >= 0) {
            int wplain = isText ? this.fm.getTextWidth(this.strCaptions[i]) : this.imgCaptions[i].getWidth();
            int wbold = isText ? fmb.getTextWidth(this.strCaptions[i]) : wplain;
            this.rSel[i] = new Rect(0, 0, wbold + 5, this.tabH);
            this.rNotSel[i] = new Rect(0, y0, wplain + 4, this.tabH - 2);
            --i;
        }
    }

    public void onPaint(Graphics g) {
        Rect r;
        boolean isFlat = Control.uiFlat;
        int n = this.count;
        int y = this.atTop ? this.tabH - 1 : 0;
        int h = this.atTop ? this.height - y : this.height - this.tabH + 1;
        int yl = this.atTop ? y : y + h - 1;
        Color panelColor = this.panelsColor != null ? this.panelsColor[this.activeIndex] : this.panels[this.activeIndex].backColor;
        g.setBackColor(this.parent.backColor);
        if (this.parent.backColor.equ == panelColor.equ) {
            g.fillRect(0, 0, this.width, this.height);
        } else {
            if (this.atTop) {
                g.fillRect(0, 0, this.width, y);
            } else {
                g.fillRect(0, yl, this.width, this.height - yl);
            }
            g.setBackColor(panelColor);
            g.fillRect(0, y, this.width, h);
        }
        g.setForeColor(this.fColor);
        if (this.style != 0) {
            g.drawRect(0, y, this.width, h);
        } else {
            g.drawLine(0, yl, this.width, yl);
        }
        Color back = this.backColor;
        g.setBackColor(this.backColor);
        if (this.btnLeft != null) {
            g.setClip(1, 0, this.btnX, this.height);
        }
        if (this.parent.backColor.equ != this.backColor.equ) {
            int i = 0;
            while (i < n) {
                r = this.rects[i];
                if (this.useOnTabThePanelsColor) {
                    back = this.panelsColor != null ? this.panelsColor[i] : this.panels[i].backColor;
                    g.setBackColor(back);
                }
                if (isFlat) {
                    g.fillRect(r.x, r.y, r.width, r.height);
                } else if (Control.uiVista && this.enabled) {
                    g.fill3dRect(r.x + 1, r.y + 1, r.width - 2, r.height - 2, back, this.atTop, false);
                } else {
                    g.fillHatchedRect(r.x, r.y, r.width, r.height, this.atTop, this.atTop ^ true);
                }
                ++i;
            }
        }
        if (this.activeTabBackColor != null) {
            g.setBackColor(this.activeTabBackColor);
            r = this.rects[this.activeIndex];
            if (isFlat) {
                g.fillRect(r.x, r.y, r.width, r.height);
            } else {
                g.fillHatchedRect(r.x, r.y, r.width, r.height, this.atTop, this.atTop ^ true);
            }
            g.setBackColor(this.backColor);
        }
        g.setForeColor(this.cColor);
        boolean isText = this.isTextCaption;
        if (!isText && this.transpColor != null) {
            g.setDrawOp(6);
            g.setBackColor(this.transpColor);
        }
        int i = 0;
        while (i < n) {
            r = this.rects[i];
            if (isText) {
                if (i != this.activeIndex) {
                    g.drawText(this.strCaptions[i], r.x + 3, r.y + 1);
                } else {
                    g.setFont(this.bold);
                    g.drawText(this.strCaptions[i], r.x + 3, r.y + 1);
                    g.setFont(this.font);
                }
            } else {
                g.drawImage(this.imgCaptions[i], r.x + 3, r.y + 1);
            }
            if (isFlat) {
                g.drawRect(r.x, r.y, r.width, r.height);
            } else {
                g.drawHatchedRect(r.x, r.y, r.width, r.height, this.atTop, this.atTop ^ true);
            }
            ++i;
        }
        if (!isText && this.transpColor != null) {
            g.setBackColor(this.backColor);
            g.setDrawOp(0);
        }
        r = this.rects[this.activeIndex];
        g.setForeColor(this.useOnTabThePanelsColor ? (this.panelsColor != null ? this.panelsColor[this.activeIndex] : this.panels[this.activeIndex].backColor) : this.backColor);
        g.drawLine(r.x, yl, r.x2(), yl);
        g.drawLine(r.x + 1, yl, r.x2() - 1, yl);
        if (Settings.keyboardFocusTraversable && this.focusMode == 1) {
            g.drawDottedCursor(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
            if (Settings.screenWidth == 320) {
                g.drawDottedCursor(r.x + 2, r.y + 2, r.width - 4, r.height - 4);
            }
        }
    }

    private void scrollTab(int toIdx) {
        if (this.btnLeft != null) {
            boolean canGoLeft = toIdx > 0;
            boolean canGoRight = toIdx < this.count - 1;
            this.btnLeft.setEnabled(canGoLeft);
            this.btnRight.setEnabled(canGoRight);
            if (canGoLeft || canGoRight) {
                int xOfs;
                if (toIdx == 0) {
                    xOfs = 0;
                } else {
                    xOfs = 7 * this.fmH / 11;
                    int i = 0;
                    while (i < toIdx) {
                        xOfs -= this.rNotSel[i].width - 1;
                        ++i;
                    }
                }
                this.offsetRects(xOfs);
                if (this.rects[this.count - 1].x2() < this.btnX || toIdx == this.count - 1) {
                    int dif = this.btnX - this.rects[this.count - 1].x2();
                    this.offsetRects(-xOfs);
                    this.offsetRects(xOfs += dif);
                }
                this.repaint();
            }
        }
    }

    public void setActiveTab(int tab) {
        if (tab != this.activeIndex && tab >= 0) {
            boolean firstTabChange;
            boolean bl = firstTabChange = this.activeIndex == -1;
            if (!firstTabChange) {
                this.remove(this.panels[this.activeIndex]);
            }
            this.lastActiveTab = this.activeIndex;
            this.activeIndex = tab;
            this.add(this.panels[this.activeIndex]);
            this.tabOrder.removeAllElements();
            this.computeTabsRect();
            this.scrollTab(this.activeIndex);
            this.repaint();
            if (!firstTabChange) {
                this.postEvent(new ControlEvent(300, this));
            }
        }
    }

    public void setBorderStyle(byte style) {
        this.style = style;
    }

    public void setCaptionColor(Color capColor) {
        this.captionColor = capColor;
        this.onColorsChanged(true);
    }

    public void setGaps(int gapL, int gapR, int gapT, int gapB) {
        this.gapL = gapL;
        this.gapR = gapR;
        this.gapT = gapT;
        this.gapB = gapB;
    }

    public void setHighlighting() {
        Control.isHighlighting = false;
    }

    public void setPanel(int i, Container container) {
        if (this.panels != null && i >= 0 && i < this.panels.length) {
            Container old = this.panels[i];
            this.panels[i] = container;
            if (i == this.activeIndex) {
                this.remove(old);
                this.add(container);
                this.tabOrder.removeAllElements();
                container.requestFocus();
            }
            if (!container.started) {
                Container cp = container.parent;
                container.parent = this;
                container.setRect(this.clientRect);
                container.parent = cp;
                this.panels[i].setBackColor(container.getBackColor());
            }
        }
        if (Settings.keyboardFocusTraversable) {
            this.requestFocus();
        }
    }

    public void setPanelsBackColor(Color[] backColors) {
        if (backColors.length == this.count) {
            this.panelsColor = backColors;
            int i = this.count - 1;
            while (i >= 0) {
                this.panels[i].setBackColor(backColors[i]);
                --i;
            }
        }
    }

    public void setType(byte type) {
        this.atTop = type == 0;
        this.onFontChanged();
    }
}

