/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Coord;
import waba.fx.Graphics;
import waba.fx.Rect;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Event;
import waba.ui.Label;
import waba.ui.Timer;
import waba.ui.UIColors;
import waba.ui.Window;

public class ToolTip
extends Control {
    private Control control;
    private BorderLabel lab;
    private Timer delay;
    private Timer display;
    public static int insideGap = 4;
    public static int distX;
    public static int distY;
    public int millisDelay = 1000;
    public int millisDisplay = 2000;
    public Color borderColor;
    private ControlEvent ce;

    public ToolTip(Control control, String message) {
        this.lab = new BorderLabel(message);
        this.lab.setVisible(false);
        this.control = control;
        this.focusTraversable = false;
        this.added();
        this.lab.setBackForeColors(UIColors.tooltipBack, UIColors.tooltipFore);
        this.ce = new ControlEvent(300, this);
    }

    public void added() {
        Container cont = this.control.getParent();
        if (cont == null) {
            return;
        }
        cont.add(this);
        this.setRect(this.control.getRect());
    }

    private void moved() {
        this.setControlRect(this.control.getAbsoluteRect());
    }

    public void onEvent(Event e) {
        Object old = e.target;
        e.target = this.control;
        this.control.onEvent(e);
        e.target = old;
        switch (e.type) {
            case 200: {
                this.delay = this.addTimer(this.millisDelay);
                break;
            }
            case 202: {
                if (this.lab.isVisible()) {
                    this.lab.setVisible(false);
                    this.parent.repaint();
                }
                if (this.delay == null && this.display == null) break;
                this.removeTimer(this.display);
                this.removeTimer(this.delay);
                this.delay = null;
                this.display = null;
                break;
            }
            case 303: {
                if (this.delay != null && this.delay.triggered) {
                    this.control.onEvent(this.ce);
                    this.removeTimer(this.delay);
                    this.delay = null;
                    if (this.lab.text.length() <= 0) break;
                    this.display = this.addTimer(this.millisDisplay);
                    if (this.lab.getParent() != this.getParentWindow()) {
                        this.moved();
                    }
                    this.lab.setVisible(true);
                    break;
                }
                if (this.display == null || !this.display.triggered) break;
                this.removeTimer(this.display);
                this.display = null;
                this.lab.setVisible(false);
                this.parent.repaint();
                break;
            }
            case 498: {
                this.moved();
                break;
            }
        }
    }

    public void setBackColor(Color c) {
        this.lab.setBackColor(c);
    }

    public void setControlRect(Rect r) {
        int ww = this.lab.getPreferredWidth() + insideGap;
        int hh = this.lab.getPreferredHeight() + insideGap;
        Window w = this.getParentWindow();
        if (w != null && this.lab.getParent() != w) {
            w.add(this.lab);
        }
        Coord size = w.getSize();
        int yy = r.y2() + hh < size.y ? r.y2() + distY : Math.max(0, r.y - hh - distY);
        int xx = r.x + ww + distX > size.x ? size.x - ww - distX : r.x + distX;
        this.lab.setRect(xx, yy, ww, hh);
    }

    public void setForeColor(Color c) {
        this.lab.setForeColor(c);
    }

    public void setText(String newText) {
        if (!newText.equals(this.lab.text)) {
            this.lab.setText(newText);
        }
    }

    class BorderLabel
    extends Label {
        public BorderLabel(String text) {
            super(text, 110000);
        }

        public void onPaint(Graphics g) {
            if (ToolTip.this.display != null) {
                g.setBackColor(this.backColor);
                g.fillRect(0, 0, this.width, this.height);
                int dx = (insideGap >> 1) + 1;
                int dy = (dx >> 1) - 2;
                g.translate(dx, dy);
                super.onPaint(g);
                g.translate(-dx, -dy);
                if (ToolTip.this.borderColor != null) {
                    g.setForeColor(ToolTip.this.borderColor);
                    g.drawRect(0, 0, this.width, this.height);
                }
            }
        }
    }
}

