/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Coord;
import waba.fx.Font;
import waba.fx.FontMetrics;
import waba.fx.Graphics;
import waba.fx.Image;
import waba.fx.Rect;
import waba.fx.Sound;
import waba.fx.SoundClip;
import waba.fx.SoundClipEvent;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.KeyEvent;
import waba.ui.Keypad;
import waba.ui.MainWindow;
import waba.ui.MenuBar;
import waba.ui.NativeMethods4JDK;
import waba.ui.PenEvent;
import waba.ui.PopupMenu;
import waba.util.ElementNotFoundError;
import waba.util.Vector;

public class Window
extends Container {
    protected boolean needsPaint;
    protected String title;
    protected boolean beepIfOut = true;
    protected boolean flicker = true;
    protected static Window topMost;
    protected Font titleFont = MainWindow.defaultFont.asBold();
    protected byte borderStyle = 0;
    protected Control menubar;
    protected boolean canDrag = true;
    public boolean eraseBackgroundNow;
    protected Image imgCovered;
    protected boolean highResPrepared = Settings.platform == null ? false : Settings.platform.startsWith("PalmOS") ^ true;
    private static byte[] borderGaps;
    private static byte[] topBorderGaps;
    private Image imgBuf;
    private Graphics gbuf;
    private Graphics _g;
    private int saveBehindWhenPopup = 1;
    private int paintX;
    private int paintY;
    private int paintWidth;
    private int paintHeight;
    protected Control _focus;
    private boolean doubleBuf;
    private Control focusOnPopup;
    private Graphics gMoving;
    private int xMoving;
    private int yMoving;
    private int xDeltaMoving;
    private int yDeltaMoving;
    private Coord ptMoving;
    private Control tempFocus;
    private FontMetrics fmTitle;
    private Rect rTitle;
    static boolean isntRGB;
    protected Control highlighted;
    boolean popped;
    protected Container mainSwapContainer;
    protected Container lastSwappedContainer;
    public static final byte NO_BORDER = 0;
    public static final byte RECT_BORDER = 1;
    public static final byte ROUND_BORDER = 2;
    public static final byte TAB_BORDER = 3;
    public static final byte TAB_ONLY_BORDER = 4;
    public static final int HIDE_STATE = 1000;
    public static final int VK_HIDE = 10000;
    public static final int VK_TOP = 10001;
    public static final int VK_BOTTOM = 10002;
    public static final int VK_SHOW = 10003;
    public static Vector zStack;
    protected static KeyEvent _keyEvent;
    protected static PenEvent _penEvent;
    protected static ControlEvent _controlEvent;
    boolean resetSipToBottom;
    private static boolean ignoreNextEvent;
    public static int blockingCount;

    static {
        byte[] byArray = new byte[5];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 1;
        borderGaps = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[1] = 2;
        byArray2[2] = 2;
        byArray2[3] = 2;
        byArray2[4] = 2;
        topBorderGaps = byArray2;
        isntRGB = Settings.platform == null ? false : Settings.platform.equals("PalmOS");
        zStack = new Vector(5);
        _keyEvent = new KeyEvent();
        _penEvent = new PenEvent();
        _controlEvent = new ControlEvent();
    }

    public Window() {
        NativeMethods4JDK.windowCreate(this);
        this.x2 = this.x + this.width - 1;
        this.y2 = this.y + this.height - 1;
        this.parentWindow = this;
        this.asWindow = this;
        this.fmTitle = this.titleFont.fm;
        this.focusTraversable = false;
        if (!Settings.onDevice) {
            this.setDoubleBuffer(true);
        }
    }

    public Window(String title, byte borderStyle) {
        this();
        this.title = title != null && title.length() > 0 ? title : null;
        this.borderStyle = borderStyle;
    }

    public void _doPaint() {
        if (this != topMost) {
            topMost._doPaint();
        } else {
            this._doPaint(this.paintX, this.paintY, this.paintWidth, this.paintHeight);
        }
    }

    public void _doPaint(int x, int y, int width, int height) {
        if (x == -5000) {
            x = 0;
            Window.repaintActiveWindows(0);
            if (Settings.platform.equals("PalmOS")) {
                this.repaint();
                ignoreNextEvent = true;
            }
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (this._g == null) {
            this._g = this.createGraphics();
        }
        this._g.translateTo(this.x, this.y);
        if (this.doubleBuf) {
            this.getOffScreen();
            if (this.borderStyle == 2) {
                this.gbuf.copyRect(MainWindow.getMainWindow(), this.x, this.y, this.width, this.height, 0, 0);
            }
        }
        Graphics gg = this.doubleBuf ? this.gbuf : this._g;
        gg.setClip(x, y, width, height);
        gg.setBackColor(this.backColor);
        if (this.eraseBackgroundNow || this.flicker && x == 0 && y == 0 && width == this.width && height == this.height) {
            if (this.borderStyle != 2) {
                gg.fillRect(x, y, width, height);
            }
            this.eraseBackgroundNow = false;
        }
        this.paintTitle(this.title, gg);
        this.onPaint(gg);
        gg.clearClip();
        this.paintChildren(gg, x, y, width, height);
        this._g.setDrawOp(0);
        if (this.doubleBuf) {
            this._g.copyRect(this.imgBuf, x, y, width, height, x, y);
        }
        if (this.needsPaint) {
            if (this.paintX < 0) {
                this.paintX = 0;
            }
            if (this.paintY < 0) {
                this.paintY = 0;
            }
            if (this.paintWidth > this.width) {
                this.paintWidth = this.width;
            }
            if (this.paintHeight > this.height) {
                this.paintHeight = this.height;
            }
            int ax = x + width;
            int ay = y + height;
            int bx = this.paintX + this.paintWidth;
            int by = this.paintY + this.paintHeight;
            if (x <= this.paintX && y <= this.paintY && ax >= bx && ay >= by) {
                this.needsPaint = false;
                this.onWindowPaintFinished();
                if (this._focus != null && this._focus.getParentWindow() == this) {
                    this._focus.onWindowPaintFinished();
                    if (this.highlighted != null) {
                        this.highlighted.drawHighlight();
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void _postEvent(int type, int key, int x, int y, int modifiers, int timeStamp) {
        block45: {
            if (type == -6000) {
                this._g = null;
                MainWindow.myg0 = this.createGraphics();
                n = Window.zStack.size();
                i = 0;
                while (i < n) {
                    w = (Window)Window.zStack.items[i];
                    w.broadcastEvent(new ControlEvent(498, w));
                    ++i;
                }
            }
            if (Window.ignoreNextEvent) {
                Window.ignoreNextEvent = false;
                return;
            }
            if (this != Window.topMost) {
                Window.topMost._postEvent(type, key, x, y, modifiers, timeStamp);
                return;
            }
            if (timeStamp == 0) {
                timeStamp = Vm.getTimeStamp();
            }
            event /* !! */  = null;
            invokeMenu = false;
            isPenEvent = type >= 200 && type <= 203;
            v0 = isKeyEvent = type == 100;
            if (this._focus == null) {
                this._focus = this;
            }
            if (this.gMoving != null || isPenEvent && this.rTitle != null && this.rTitle.contains(x - this.x, y - this.y)) {
                switch (type) {
                    case 200: {
                        if (!this.canDrag) break;
                        this.ptMoving = new Coord(x, y);
                        break;
                    }
                    case 203: {
                        if (this.gMoving == null && this.ptMoving != null && (Math.abs(this.ptMoving.x - x) > 2 || Math.abs(this.ptMoving.y - y) > 2)) {
                            this.requestFocus();
                            this.gMoving = MainWindow.myg0;
                            this.xMoving = this.x;
                            this.yMoving = this.y;
                            this.xDeltaMoving = this.ptMoving.x - this.xMoving;
                            this.yDeltaMoving = this.ptMoving.y - this.yMoving;
                        } else if (this.gMoving != null) {
                            this.gMoving.drawCursorOutline(this.xMoving, this.yMoving, this.width, this.height);
                            this.xMoving = x - this.xDeltaMoving;
                            this.yMoving = y - this.yDeltaMoving;
                        }
                        if (this.gMoving == null) break;
                        this.gMoving.drawCursorOutline(this.xMoving, this.yMoving, this.width, this.height);
                        break;
                    }
                    case 202: {
                        if (this.gMoving == null || this instanceof MainWindow) {
                            invokeMenu = true;
                        } else {
                            this.gMoving.drawCursorOutline(this.xMoving, this.yMoving, this.width, this.height);
                            this.loadBehind(false);
                            this.x = this.xMoving;
                            this.y = this.yMoving;
                            this.x2 = this.x + this.width - 1;
                            this.y2 = this.y + this.height - 1;
                            this.broadcastEvent(new ControlEvent(498, this));
                            this.saveBehind();
                            if (this.doubleBuf) {
                                this.gMoving.copyRect(this.imgBuf, 0, 0, this.width, this.height, this.xMoving, this.yMoving);
                                this.onWindowPaintFinished();
                            } else {
                                this.repaintNow();
                            }
                            this.gMoving = null;
                        }
                        this.ptMoving = null;
                    }
                }
                if (!invokeMenu) {
                    return;
                }
            }
            if (isPenEvent && !this.contains(x, y)) {
                if (!this.onClickedOutside(x, y) && type == 200 && this.beepIfOut) {
                    Sound.beep();
                }
                return;
            }
            if (isKeyEvent) {
                Window._keyEvent.key = key;
                Window._keyEvent.modifiers = modifiers;
                Window._keyEvent.type = 100;
                event /* !! */  = Window._keyEvent;
                if (Vm.actionEqualsMenu && key == 76010 && !Settings.keyboardFocusTraversable) {
                    Window._keyEvent.key = 75014;
                } else if (Settings.keyboardFocusTraversable && (Window._keyEvent.isPrevKey() || Window._keyEvent.isNextKey() || Window._keyEvent.isActionKey())) {
                    if (Control.isHighlighting && this.handleFocusChangeKeys(Window._keyEvent)) {
                        if (Window.topMost.needsPaint) {
                            this._doPaint();
                        }
                        return;
                    }
                } else if (Settings.keypadOnly) {
                    if (this._focus != this.highlighted && this.highlighted != null) {
                        this.highlighted.requestFocus();
                    }
                    if (key >= 97 && key <= 122 || key == 32) {
                        Settings.keypadOnly = false;
                    } else if (key == 35 || key == 42 || key >= 48 && key <= 57) {
                        Keypad.getInstance().handleKey(key);
                        return;
                    }
                }
            }
            if (this.menubar != null && (invokeMenu || isKeyEvent && key == 75014)) {
                this.popupMenuBar();
                return;
            }
            if (this._focus.enabled && this._focus.parent != null) break block45;
            Window._controlEvent.type = 302;
            Window._controlEvent.target = this._focus;
            Window._controlEvent.touch();
            this._focus.postEvent(Window._controlEvent);
            if (this._focus.parent != null) ** GOTO lbl107
            this._focus = this;
            break block45;
lbl-1000:
            // 1 sources

            {
                this._focus = this._focus.parent;
lbl107:
                // 2 sources

                ** while (!this._focus.enabled && this._focus.parent != null)
            }
        }
        if (!isKeyEvent) {
            if (type == 200) {
                c = this.findChild(x - this.x, y - this.y);
                if (c != this._focus) {
                    this.setFocus(c);
                }
                this.tempFocus = c.focusLess != false ? c : null;
            }
            Window._penEvent.type = type;
            Window._penEvent.x = x;
            Window._penEvent.y = y;
            c = this.tempFocus != null ? this.tempFocus : this._focus;
            while (c != null) {
                Window._penEvent.x -= c.x;
                Window._penEvent.y -= c.y;
                c = c.parent;
            }
            Window._penEvent.modifiers = modifiers;
            event /* !! */  = Window._penEvent;
        }
        event /* !! */ .target = this.tempFocus != null ? this.tempFocus : this._focus;
        event /* !! */ .timeStamp = timeStamp;
        if (this.tempFocus != null) {
            this.tempFocus.postEvent(event /* !! */ );
        } else if (this._focus != null) {
            this._focus.postEvent(event /* !! */ );
        }
        if (Window.topMost.needsPaint) {
            this._doPaint();
        }
        if (event /* !! */ .type == 202 && this.tempFocus != null) {
            this.tempFocus = null;
        }
    }

    public void _postSoundEvent(SoundClipEvent event) {
        ((SoundClip)event.target).onEvent(event);
    }

    protected void damageRect(int x, int y, int width, int height) {
        if (this.needsPaint) {
            int ax = x + width;
            int ay = y + height;
            int bx = this.paintX + this.paintWidth;
            int by = this.paintY + this.paintHeight;
            if (this.paintX < x) {
                x = this.paintX;
            }
            if (this.paintY < y) {
                y = this.paintY;
            }
            width = (ax > bx ? ax : bx) - x;
            height = (ay > by ? ay : by) - y;
        }
        this.paintX = x;
        this.paintY = y;
        this.paintWidth = width <= this.width ? width : this.width;
        this.paintHeight = height <= this.height ? height : this.height;
        this.needsPaint = true;
    }

    public static void destroyZStack() {
        zStack.removeAllElements();
    }

    public void dontSaveBehind(boolean repaintOnClose) {
        this.saveBehindWhenPopup = repaintOnClose ? 2 : 0;
    }

    public void drawHighlight() {
    }

    public Rect getClientRect() {
        Rect r = new Rect();
        this.getClientRect(r);
        return r;
    }

    public void getClientRect(Rect r) {
        r.y = 0;
        r.x = 0;
        r.width = this.width;
        r.height = this.height;
        byte my = topBorderGaps[this.borderStyle];
        byte m = borderGaps[this.borderStyle];
        if (this.title != null) {
            int hh = my + this.fmH;
            r.modify(m, hh, -(m << 1), -(hh + m));
        } else {
            r.modify(m, my, -(m << 1), -(m << 1));
        }
    }

    public Control getFocus() {
        return this._focus;
    }

    public Control getHighlighted() {
        return this.highlighted;
    }

    public Image getOffScreen() {
        block2: {
            if (this.imgBuf != null || !this.doubleBuf) break block2;
            try {
                this.imgBuf = new Image(this.width, this.height);
                this.gbuf = this.imgBuf.getGraphics();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.doubleBuf = false;
                this.imgBuf = null;
            }
        }
        return this.imgBuf;
    }

    public int getPreferredHeight() {
        int htitle;
        int n = htitle = this.title == null ? 0 : this.fmTitle.height;
        int hborder = this.borderStyle == 0 ? 0 : (this.borderStyle == 2 ? 4 : 2);
        return htitle + hborder;
    }

    public int getPreferredWidth() {
        int wtitle;
        int n = wtitle = this.title == null ? 0 : this.fmTitle.getTextWidth(this.title);
        int wborder = this.borderStyle == 0 ? 0 : (this.borderStyle == 2 ? 4 : 2);
        return wtitle + wborder;
    }

    public static Window getTopMost() {
        return topMost;
    }

    protected boolean handleFocusChangeKeys(KeyEvent ke) {
        if (Control.isHighlighting) {
            boolean isForward = ke.isNextKey();
            boolean isAction = ke.isActionKey();
            if (isAction && this.highlighted != null) {
                Control.isHighlighting = false;
                this.highlighted.requestFocus();
                Window._keyEvent.type = 101;
                Window._keyEvent.target = this._focus;
                _keyEvent.touch();
                this._focus.onEvent(_keyEvent);
                Window._keyEvent.type = 100;
            } else {
                Container p;
                Control c = this.getHighlighted();
                if (c == null) {
                    p = this;
                    c = p;
                } else {
                    p = c.asContainer != null && c.asContainer.tabOrder.size() > 0 ? c.asContainer : c.parent;
                }
                c.changeHighlighted(p, isForward);
            }
            return true;
        }
        return false;
    }

    public boolean isTopMost() {
        return this == topMost;
    }

    public boolean isVisible() {
        return this == topMost || this.parent != null;
    }

    protected void loadBehind(boolean release) {
        if (this.saveBehindWhenPopup == 2) {
            Window.repaintActiveWindows(release ? 0 : -1);
        } else if (this.saveBehindWhenPopup == 1) {
            if (this.imgCovered != null) {
                MainWindow.myg0.copyRect(this.imgCovered, 0, 0, this.width, this.height, this.x, this.y);
            }
            if (release && this.imgCovered != null) {
                this.imgCovered.free();
                this.imgCovered = null;
            }
        }
    }

    public void makeUnmovable() {
        this.canDrag = false;
    }

    protected boolean onClickedOutside(int x, int y) {
        return false;
    }

    protected void onPopup() {
    }

    protected void onUnpop() {
    }

    protected void paintTitle(String title, Graphics gg) {
        if (title != null || this.borderStyle > 0) {
            if (title == null) {
                title = " ";
            }
            int ww = this.fmTitle.getTextWidth(title);
            int hh = this.fmTitle.height + (this.borderStyle == 2 ? 2 : 0);
            int xx = this.width - ww >> 1;
            int yy = 1;
            Color f = this.getForeColor();
            Color b = this.getBackColor();
            gg.setColors(f);
            if (this.borderStyle != 0) {
                int y0;
                int n = y0 = this.borderStyle == 1 ? 0 : hh;
                if (this.borderStyle != 4 && this.borderStyle != 2) {
                    gg.drawRect(0, y0, this.width, this.height - y0);
                }
                switch (this.borderStyle) {
                    case 3: 
                    case 4: {
                        gg.setForeColor(f);
                        gg.drawLine(1, 0, ww + 2, 0);
                        gg.fillRect(0, 1, ww + 4, hh);
                        gg.fillRect(0, hh, this.width, 2);
                        xx = 3;
                        break;
                    }
                    case 2: {
                        gg.fillRoundRect(0, 0, this.width, this.height, 3);
                        gg.setBackColor(b);
                        gg.fillRect(2, hh, this.width - 4, this.height - hh - 2);
                        gg.setPixel(2, this.height - 3);
                        gg.setPixel(this.width - 3, this.height - 3);
                        break;
                    }
                    default: {
                        gg.fillRect(0, 0, this.width, hh + 2);
                    }
                }
                gg.setForeColor(b);
                gg.setBackColor(f);
            } else {
                gg.setForeColor(f);
                gg.setBackColor(b);
            }
            gg.setFont(this.titleFont);
            gg.drawText(title, xx, yy);
            gg.setFont(this.font);
            if (this.rTitle == null) {
                this.rTitle = new Rect(xx - 2, 0, ww + 4, hh + 1);
            }
        }
    }

    public void popupBlockingModal() {
        topMost.popupBlockingModal(this);
    }

    private void popupBlockingModal(Window newWin) {
        if (!this.started && this instanceof MainWindow) {
            this.started = true;
            this.repaintNow();
        }
        this.popupModal(newWin);
        ++blockingCount;
        do {
            Window.pumpEvents();
        } while (newWin.popped);
        --blockingCount;
    }

    protected void popupMenuBar() {
        if (this.menubar != null) {
            this.menubar.setVisible(true);
        }
    }

    public void popupModal() {
        topMost.popupModal(this);
    }

    private void popupModal(Window newWin) {
        if (this != topMost) {
            topMost.popupModal(newWin);
        } else {
            newWin.popped = true;
            this.focusOnPopup = this._focus;
            if (this.focusOnPopup instanceof PopupMenu || this.focusOnPopup == null || Window._controlEvent.type == 302) {
                this.focusOnPopup = this;
            }
            if (this.needsPaint && this.focusOnPopup.getParentWindow().isVisible() && !(this.focusOnPopup instanceof Window)) {
                this.focusOnPopup.repaintNow();
            }
            if (this.saveBehindWhenPopup == 1) {
                newWin.saveBehind();
            } else {
                newWin.dontSaveBehind(this.saveBehindWhenPopup == 2);
            }
            newWin.onPopup();
            this.eventsEnabled = false;
            topMost = newWin;
            zStack.push(topMost);
            Window.topMost.needsPaint = false;
            this.setFocus(topMost);
            Window.topMost.needsPaint = true;
            Window.topMost.eventsEnabled = true;
            topMost.resetPaintArea();
            topMost._doPaint();
            topMost.postPopup();
            Window.updateScreen();
        }
    }

    protected void postPopup() {
    }

    protected void postPressedEvent() {
        Control c = topMost.getFocus();
        if (c == null) {
            c = topMost;
        }
        Window._controlEvent.type = 300;
        Window._controlEvent.target = this;
        _controlEvent.touch();
        c.postEvent(_controlEvent);
    }

    protected void postUnpop() {
    }

    public static void pumpEvents() {
        NativeMethods4JDK.windowPumpEvents();
    }

    static void repaintActiveWindows(int upTo) {
        int n = zStack.size() + upTo;
        Rect mainWindowRect = MainWindow.mainWindowInstance.getRect();
        int i = n - 1;
        while (i > 0) {
            if (((Window)Window.zStack.items[i]).getRect().equals(mainWindowRect)) break;
            --i;
        }
        while (i < n) {
            ((Window)Window.zStack.items[i++]).repaintNow();
        }
        if (Control.isHighlighting && Window.topMost.highlighted != null) {
            Window.topMost.highlighted.drawHighlight();
        }
    }

    private void resetPaintArea() {
        this.paintY = 0;
        this.paintX = 0;
        this.paintWidth = this.width;
        this.paintHeight = this.height;
    }

    protected void saveBehind() {
        block3: {
            if (this.saveBehindWhenPopup != 1) break block3;
            try {
                if (this.imgCovered == null) {
                    this.imgCovered = new Image(this.width, this.height);
                }
                this.imgCovered.getGraphics().copyRect(MainWindow.mainWindowInstance, this.x, this.y, this.width, this.height, 0, 0);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.saveBehindWhenPopup = 2;
            }
        }
    }

    public void setBorderStyle(byte borderStyle) {
        this.borderStyle = borderStyle;
        this.repaint();
    }

    public void setDoubleBuffer(boolean doubleBuf) {
        if (Settings.platform.equals("Java") || Settings.platform.equals("PalmOS")) {
            this.doubleBuf = doubleBuf;
        }
    }

    public void setFocus(Control c) {
        if (c != null && !c.focusLess && this._focus != c) {
            if (this._focus != null) {
                Window._controlEvent.type = 302;
                Window._controlEvent.target = this._focus;
                _controlEvent.touch();
                this._focus.postEvent(_controlEvent);
            }
            this._focus = c;
            Window._controlEvent.type = 301;
            Window._controlEvent.target = c;
            _controlEvent.touch();
            c.postEvent(_controlEvent);
            this.setHighlighted(this._focus);
        }
    }

    public void setHighlighted(Control c) {
        if (c.focusTraversable && c != this.highlighted && (c.asContainer == null || c.asContainer.tabOrder.size() == 0)) {
            this.highlighted = c;
            this.repaint();
        }
    }

    public void setMenuBar(Control menubar) {
        this.menubar = menubar;
    }

    public void setStatePosition(int x, int y) {
        boolean isVK;
        boolean bl = isVK = x >= 10000 || y >= 10000;
        if (!isVK) {
            if (x < 0 || x > Settings.screenWidth) {
                x = 1000;
            }
            if (y < 0 || y > Settings.screenHeight) {
                y = 1000;
            }
        } else if (x == 10001 || y == 10001) {
            this.resetSipToBottom = true;
        }
        NativeMethods4JDK.windowSetStatePosition(this, isVK ? x : this.x + x, isVK ? y : this.y + y);
    }

    public void setTitle(String title) {
        this.title = title;
        this.rTitle = null;
        this.repaint();
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
        this.fmTitle = titleFont.fm;
    }

    public void swap(Container newContainer) {
        if (this.mainSwapContainer == null) {
            this.mainSwapContainer = newContainer;
        } else {
            Control.isHighlighting = Settings.keyboardFocusTraversable;
        }
        if (this.lastSwappedContainer != null) {
            this.remove(this.lastSwappedContainer);
        }
        if (newContainer == null) {
            newContainer = this.mainSwapContainer;
        }
        this.lastSwappedContainer = newContainer;
        this.add(newContainer);
        if (!newContainer.started) {
            newContainer.setRect(this.getClientRect());
        }
        Container firstTarget = newContainer.tabOrder.size() > 0 ? (Control)newContainer.tabOrder.items[0] : newContainer;
        firstTarget.requestFocus();
        newContainer.repaintNow();
        Window.topMost.focusOnPopup = firstTarget;
        this.highlighted = firstTarget;
    }

    protected void swapFocus(Control c) {
        if (c != this._focus) {
            this._focus = c;
            this.setHighlighted(this._focus);
        }
    }

    public final void unpop() {
        if (zStack.size() == 1) {
            return;
        }
        this.onUnpop();
        this.eventsEnabled = false;
        try {
            zStack.pop();
            topMost = (Window)zStack.peek();
        }
        catch (ElementNotFoundError elementNotFoundError) {
            topMost = null;
        }
        if (topMost != null) {
            this.loadBehind(true);
            Window.topMost.eventsEnabled = true;
            if (Window.topMost.focusOnPopup instanceof MenuBar) {
                Window.topMost.focusOnPopup = topMost;
            }
            if (Window.topMost.focusOnPopup instanceof Window && !Window.topMost.focusOnPopup.asWindow.isVisible()) {
                Window.topMost.focusOnPopup = topMost;
            }
            if (!Window.topMost.focusOnPopup.isDisplayed()) {
                Window.topMost.focusOnPopup = topMost;
            }
            if (!Window.topMost.focusOnPopup.enabled) {
                Window.topMost.focusOnPopup = topMost;
            }
            Window lastTopMost = topMost;
            Window.topMost.focusOnPopup.postEvent(new ControlEvent(499, this));
            if (topMost == lastTopMost) {
                topMost.setFocus(Window.topMost.focusOnPopup);
            }
            this.postUnpop();
            if (this.doubleBuf) {
                if (this.imgBuf != null) {
                    this.imgBuf.free();
                }
                this.imgBuf = null;
                this.gbuf = null;
            }
            this.popped = false;
        }
    }

    public static void updateScreen() {
        NativeMethods4JDK.windowUpdateScreen();
    }

    public void validate() {
        if (this.needsPaint) {
            this._doPaint(this.paintX, this.paintY, this.paintWidth, this.paintHeight);
        }
    }
}

