/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.sys.Convert;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.util.ElementNotFoundError;

public class Vector {
    public Object[] items;
    private int count;

    public Vector() {
        this(8);
    }

    public Vector(int size) {
        this.items = new Object[size == 0 ? 1 : size];
    }

    public Vector(Object[] startingWith) {
        if (startingWith != null) {
            this.items = startingWith;
            this.count = startingWith.length;
        } else {
            this.items = new Object[1];
        }
    }

    public void add(Object obj) {
        this.addElement(obj);
    }

    public void addElement(Object obj) {
        if (this.count < this.items.length) {
            this.items[this.count++] = obj;
        } else {
            this.insertElementAt(obj, this.count);
        }
    }

    public void clear() {
        this.removeAllElements();
    }

    public void del(int index) {
        this.removeElementAt(index);
    }

    public boolean del(Object obj) {
        return this.removeElement(obj);
    }

    public int find(Object obj) {
        return this.indexOf(obj, 0);
    }

    public int find(Object obj, int startIndex) {
        return this.indexOf(obj, startIndex);
    }

    public int getCount() {
        return this.count;
    }

    public int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(Object obj, int startIndex) {
        if (obj != null) {
            Object[] its = this.items;
            int n = this.count;
            int i = startIndex;
            while (i < n) {
                if (obj.equals(its[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void insert(int index, Object obj) {
        this.insertElementAt(obj, index);
    }

    public void insertElementAt(Object obj, int index) {
        if (index < 0 || index > this.count) {
            index = this.count;
        }
        if (this.count == this.items.length) {
            int newSize = this.items.length * 12 / 10 + 1;
            if (Settings.onDevice) {
                if (this.items.length == 16382) {
                    newSize = 20000;
                } else if (newSize > 16382) {
                    newSize = 16382;
                }
            }
            Object[] newItems = new Object[newSize];
            Vm.copyArray(this.items, 0, newItems, 0, this.count);
            this.items = newItems;
        }
        if (index != this.count) {
            Vm.copyArray(this.items, index, this.items, index + 1, this.count - index);
        }
        this.items[index] = obj;
        ++this.count;
    }

    public Object peek() throws ElementNotFoundError {
        if (this.count > 0) {
            return this.items[this.count - 1];
        }
        if (Settings.useExceptions) {
            throw new ElementNotFoundError("Empty stack");
        }
        return null;
    }

    public Object pop() throws ElementNotFoundError {
        if (this.count > 0) {
            Object o = this.items[--this.count];
            this.items[this.count] = null;
            return o;
        }
        if (Settings.useExceptions) {
            throw new ElementNotFoundError("Empty stack");
        }
        return null;
    }

    public void push(Object obj) {
        this.addElement(obj);
    }

    public boolean qsort() {
        if (this.count > 0) {
            Convert.qsort(this.items, 0, this.count - 1);
            return true;
        }
        return false;
    }

    public void removeAllElements() {
        int i = 0;
        while (i < this.count) {
            this.items[i] = null;
            ++i;
        }
        this.count = 0;
    }

    public boolean removeElement(Object obj) {
        int i = this.indexOf(obj, 0);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void removeElementAt(int index) {
        if (index >= 0 && index < this.count) {
            --this.count;
            if (index != this.count) {
                Vm.copyArray(this.items, index + 1, this.items, index, this.count - index);
            }
            this.items[this.count] = null;
        }
    }

    public int size() {
        return this.count;
    }

    public Object[] toObjectArray() {
        if (this.count == 0) {
            return null;
        }
        Object[] objs = this.items[0] instanceof String ? new String[this.count] : new Object[this.count];
        if (this.count > 0) {
            Vm.copyArray(this.items, 0, objs, 0, this.count);
        }
        return objs;
    }
}

