/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.Comparable;
import moio.util.Number;
import waba.sys.Convert;

public final class Double
extends Number
implements Comparable {
    private static final long serialVersionUID = -9172774392245257468L;
    public static final double MAX_VALUE = java.lang.Double.MAX_VALUE;
    public static final double MIN_VALUE = java.lang.Double.MIN_VALUE;
    public static final double NEGATIVE_INFINITY = java.lang.Double.NEGATIVE_INFINITY;
    public static final double POSITIVE_INFINITY = java.lang.Double.POSITIVE_INFINITY;
    public static final double NaN = Convert.longBitsToDouble((long)9221120237041090560L);
    private final double value;

    public Double(double d) {
        this.value = d;
    }

    public Double(String string) {
        this.value = Double.parseDouble(string);
    }

    public static String toString(double d) {
        return d + "";
    }

    public static Double valueOf(String string) {
        return new Double(Double.parseDouble(string));
    }

    public static double parseDouble(String string) {
        return Convert.toDouble((String)string);
    }

    public static boolean isNaN(double d) {
        return Convert.doubleToLongBits((double)d) == 9221120237041090560L;
    }

    public static boolean isInfinite(double d) {
        return d == java.lang.Double.POSITIVE_INFINITY || d == java.lang.Double.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return this.value + "";
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        double d = ((Double)object).value;
        if (this.value == d) {
            return this.value != 0.0 || 1.0 / this.value == 1.0 / d;
        }
        return Double.isNaN(this.value) && Double.isNaN(d);
    }

    public static long doubleToLongBits(double d) {
        return Convert.doubleToLongBits((double)d);
    }

    public static long doubleToRawLongBits(double d) {
        return Convert.doubleToLongBits((double)d);
    }

    public static double longBitsToDouble(long l) {
        return Convert.longBitsToDouble((long)l);
    }

    public int compareTo(Double double_) {
        return Double.compare(this.value, double_.value);
    }

    public int compareTo(Object object) {
        return Double.compare(this.value, ((Double)object).value);
    }

    public static int compare(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.isNaN(d2) ? 0 : 1;
        }
        if (Double.isNaN(d2)) {
            return -1;
        }
        if (d == 0.0 && d2 == 0.0) {
            return (int)(1.0 / d - 1.0 / d2);
        }
        if (d == d2) {
            return 0;
        }
        return d > d2 ? 1 : -1;
    }
}

