/*
 * Decompiled with CFR 0.152.
 */
package bt747.model;

import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747FileName;
import bt747.sys.interfaces.BT747Int;
import gps.BT747Constants;
import gps.connection.GPSrxtx;
import gps.log.GPSFilter;
import gps.log.GPSFilterAdvanced;
import gps.log.GPSRecord;
import gps.log.in.GPSInputConversionFactory;
import gps.log.in.GPSLogConvertInterface;
import gps.log.in.MultiLogConvert;
import gps.log.out.CommonOut;
import gps.log.out.GPSArray;
import gps.log.out.GPSCSVFile;
import gps.log.out.GPSCompoGPSTrkFile;
import gps.log.out.GPSFile;
import gps.log.out.GPSFileConfInterface;
import gps.log.out.GPSFileInterface;
import gps.log.out.GPSGPXFile;
import gps.log.out.GPSGmapsV3HTMLFile;
import gps.log.out.GPSGoogleStaticMapUrl;
import gps.log.out.GPSKMLFile;
import gps.log.out.GPSNMEAFile;
import gps.log.out.GPSPLTFile;
import gps.log.out.GPSPostGISFile;
import gps.log.out.GPSSqlFile;
import gps.log.out.GPSWPTFile;
import gps.mvc.CmdParam;
import gps.mvc.GpsController;
import gps.mvc.GpsModel;
import gps.mvc.MtkController;
import net.sf.bt747.loc.LocationSender;

public class Controller
implements ModelListener {
    private Model m;
    private boolean isStartLogDownloadNeeded = false;
    private GPSLogConvertInterface currentGPSLogConvert;
    private BT747FileName filenameBuilder = null;
    private GPSRecord[] userWayPoints = null;
    private int lastError;
    private String lastErrorInfo = "";
    private LocationSender registeredLocSender = null;

    public void setModel(Model model) {
        if (this.m != null) {
            this.m.removeListener(this);
        }
        this.m = model;
        this.m.addListener(this);
    }

    public Model getModel() {
        return this.m;
    }

    private final GpsController getGpsC() {
        return this.m.gpsC();
    }

    private final GpsModel getGpsOldC() {
        return this.m.gpsM();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modelEvent(ModelEvent modelEvent) {
        switch (modelEvent.getType()) {
            case 266: {
                if (!this.m.getBooleanOpt(64)) return;
                this.startGPSPositionServing();
                return;
            }
            case 267: {
                if (!this.isLocationServingActive()) return;
                this.stopGPSPositionServing();
                return;
            }
            case 274: {
                if (!this.isLocationServingActive()) return;
                this.stopGPSPositionServing();
                return;
            }
            case 28: {
                if (!this.m.mtkModel().isLoggingDisabled()) return;
                this.setAutoLog(true);
                return;
            }
            case 272: {
                this.setMtkDataNeeded(17);
                return;
            }
            case 269: {
                int n = JavaLibBridge.toInt((String)modelEvent.getArg());
                switch (n) {
                    case 51: {
                        this.m.setProtocol(this.m.getIntOpt(51));
                    }
                }
                return;
            }
            case 37: {
                if (!this.isStartLogDownloadNeeded) return;
                switch (((BT747Int)modelEvent.getArg()).getValue()) {
                    case 0: 
                    case 2: {
                        if (!this.m.isAvailable(2) || !this.m.isAvailable(0) || !this.isStartLogDownloadNeeded) return;
                        this.isStartLogDownloadNeeded = false;
                        this.startDefaultDownload();
                    }
                }
            }
        }
    }

    public final void setAutoLog(boolean bl) {
        if (bl) {
            this.gpsCmd(7);
        } else {
            this.gpsCmd(6);
        }
    }

    private final MtkController mtkC() {
        return this.getGpsC().getMtkController();
    }

    public void init() {
        this.getGpsC().setGpsDecode(this.m.getBooleanOpt(41));
        this.getGpsC().setDownloadTimeOut(this.m.getDownloadTimeOut());
        this.mtkC().setLogRequestAhead(this.m.getIntOpt(48));
        int n = this.m.getIntOpt(16);
        if (GPSrxtx.hasDefaultPortInstance()) {
            if (n != 21845) {
                this.m.gpsRxTx().setDefaults(n, this.m.getIntOpt(17));
            }
            if (this.m.getBooleanOpt(19)) {
                this.connectGPS();
            }
        }
    }

    public void gpsCmd(int n) {
        this.getGpsC().cmd(n);
    }

    public void gpsCmd(int n, CmdParam cmdParam) {
        this.getGpsC().cmd(n, cmdParam);
    }

    public final void setOutputFileRelPath(String string) {
        this.setStringOpt(10, string);
    }

    public final void setChunkSize(int n) {
        this.m.setChunkSize(n);
    }

    public final void setDownloadTimeOut(int n) {
        this.m.setDownloadTimeOut(n);
        this.getGpsC().setDownloadTimeOut(n);
    }

    public final void setLogRequestAhead(int n) {
        this.setIntOpt(48, n);
        this.mtkC().setLogRequestAhead(this.m.getIntOpt(48));
    }

    public final GPSFile getOutFileHandler(int n) {
        GPSFile gPSFile = null;
        switch (n) {
            case 1: 
            case 22: {
                gPSFile = new GPSCSVFile();
                break;
            }
            case 7: {
                gPSFile = new GPSCompoGPSTrkFile();
                break;
            }
            case 4: {
                gPSFile = new GPSKMLFile();
                break;
            }
            case 6: {
                gPSFile = new GPSPLTFile();
                break;
            }
            case 21: {
                gPSFile = new GPSWPTFile();
                break;
            }
            case 3: 
            case 14: {
                gPSFile = new GPSGPXFile();
                break;
            }
            case 5: {
                gPSFile = new GPSNMEAFile();
                break;
            }
            case 2: {
                gPSFile = new GPSGmapsV3HTMLFile();
                break;
            }
            case 12: {
                gPSFile = new GPSArray();
                break;
            }
            case 17: {
                gPSFile = new GPSGoogleStaticMapUrl();
                break;
            }
            case 19: {
                gPSFile = new GPSPostGISFile();
                break;
            }
            case 18: {
                gPSFile = new GPSSqlFile();
                break;
            }
            default: {
                this.lastError = -4;
                this.lastErrorInfo = "" + n;
            }
        }
        return gPSFile;
    }

    private void configureGpsFile(GPSFileConfInterface gPSFileConfInterface) {
        if (gPSFileConfInterface != null) {
            if (!(gPSFileConfInterface.getClass() == GPSGPXFile.class && this.m.getBooleanOpt(40) || gPSFileConfInterface.getClass() == GPSNMEAFile.class && this.m.getBooleanOpt(56))) {
                gPSFileConfInterface.setTimeOffset((this.m.getIntOpt(68) - 48) * 900);
            }
            gPSFileConfInterface.setWayPointTimeCorrection(-this.m.getIntOpt(15));
            gPSFileConfInterface.setMaxDiff(this.m.getIntOpt(22));
            gPSFileConfInterface.setOverridePreviousTag(this.m.getBooleanOpt(21));
            gPSFileConfInterface.getParamObject().setBoolParam("add-cond", this.m.getBooleanOpt(2));
            gPSFileConfInterface.setImperial(this.m.getBooleanOpt(3));
            gPSFileConfInterface.setRecordNbrInLogs(this.m.getBooleanOpt(5));
            gPSFileConfInterface.setBadTrackColor(this.m.getStringOpt(44));
            gPSFileConfInterface.setGoodTrackColor(this.m.getStringOpt(43));
            gPSFileConfInterface.getParamObject().setBoolParam("trkcmt", this.m.getBooleanOpt(0));
            gPSFileConfInterface.getParamObject().setBoolParam("waycmt", this.m.getBooleanOpt(97));
            gPSFileConfInterface.setIncludeTrkName(this.m.getBooleanOpt(1));
            gPSFileConfInterface.setFilters(this.getLogFiltersToUse());
            gPSFileConfInterface.setOutputFields(GPSRecord.getLogFormatRecord(this.m.getIntOpt(7)));
            gPSFileConfInterface.setTrackSepTime(this.m.getIntOpt(47) * 60);
            gPSFileConfInterface.setUserWayPointList(this.userWayPoints);
            gPSFileConfInterface.getParamObject().setBoolParam("trk-split-small", this.m.getBooleanOpt(42));
            gPSFileConfInterface.getParamObject().setBoolParam("gpx-link", this.m.getBooleanOpt(49));
            gPSFileConfInterface.getParamObject().setBoolParam("gpx-1_1", this.m.getBooleanOpt(50));
            gPSFileConfInterface.getParamObject().setParam("googlemapkey", this.m.getStringOpt(28));
            gPSFileConfInterface.getParamObject().setIntParam("nmea-out", this.m.getNMEAset());
            gPSFileConfInterface.getParamObject().setParam("osm-login", this.m.getStringOpt(57));
            gPSFileConfInterface.getParamObject().setParam("osm-pass", this.m.getStringOpt(58));
            gPSFileConfInterface.getParamObject().setBoolParam("log-on-trk", this.m.getBooleanOpt(59));
            gPSFileConfInterface.getParamObject().setIntParam("split-d", this.m.getIntOpt(60));
            gPSFileConfInterface.getParamObject().setIntParam("dist-calc", this.m.getIntOpt(85));
            gPSFileConfInterface.getParamObject().setParam("csv-decimal", this.m.getStringOpt(91));
            gPSFileConfInterface.getParamObject().setParam("csv-fieldsep", this.m.getStringOpt(90));
            gPSFileConfInterface.getParamObject().setParam("csv-satsep", this.m.getStringOpt(92));
            gPSFileConfInterface.getParamObject().setBoolParam("create-fields", this.m.getBooleanOpt(93));
            gPSFileConfInterface.getParamObject().setIntParam("pos-digits", this.m.getIntOpt(95));
            gPSFileConfInterface.getParamObject().setIntParam("height-digits", this.m.getIntOpt(96));
            gPSFileConfInterface.getParamObject().setBoolParam("gpxnc", this.m.getBooleanOpt(98));
            gPSFileConfInterface.getParamObject().setBoolParam("gpxns", this.m.getBooleanOpt(99));
            String string = null;
            switch (this.m.getIntOpt(46)) {
                case 0: {
                    string = "clampToGround";
                    break;
                }
                case 1: {
                    string = "relativeToGround";
                    break;
                }
                case 2: {
                    string = "absolute";
                }
            }
            if (string != null) {
                gPSFileConfInterface.getParamObject().setParam("kml-track-altitude", string);
            }
        }
    }

    public String getOutFileExt(int n) {
        String string;
        switch (n) {
            case 1: 
            case 22: {
                string = ".csv";
                break;
            }
            case 7: {
                string = ".TRK";
                break;
            }
            case 4: {
                string = ".kml";
                break;
            }
            case 6: {
                string = ".plt";
                break;
            }
            case 21: {
                string = ".wpt";
                break;
            }
            case 3: 
            case 14: {
                string = ".gpx";
                break;
            }
            case 5: {
                string = ".nmea";
                break;
            }
            case 2: {
                string = ".html";
                break;
            }
            case 17: {
                string = ".txt";
                break;
            }
            case 18: {
                string = ".sql";
                break;
            }
            case 19: {
                string = ".postgissql";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public final int doConvertLog(int n) {
        switch (n) {
            case 6: {
                this.doConvertLog(21, this.getOutFileHandler(21), this.getOutFileExt(21));
                break;
            }
        }
        return this.doConvertLog(n, this.getOutFileHandler(n), this.getOutFileExt(n));
    }

    public int getHeightReference(int n) {
        return BT747Constants.getHeightReference(n);
    }

    public static final void setHeightConversionMode(int n, GPSLogConvertInterface gPSLogConvertInterface, int n2, int n3) {
        switch (n) {
            case 2: {
                if (n2 == 0 && n3 == 1) {
                    gPSLogConvertInterface.setConvertWGS84ToMSL(1);
                    break;
                }
                if (n2 == 1 && n3 == 0) {
                    gPSLogConvertInterface.setConvertWGS84ToMSL(-1);
                    break;
                }
                gPSLogConvertInterface.setConvertWGS84ToMSL(0);
                break;
            }
            case 1: {
                gPSLogConvertInterface.setConvertWGS84ToMSL(-1);
                break;
            }
            case 0: {
                gPSLogConvertInterface.setConvertWGS84ToMSL(0);
                break;
            }
            case 3: {
                gPSLogConvertInterface.setConvertWGS84ToMSL(1);
            }
        }
    }

    public GPSLogConvertInterface getInputConversionInstance(int n) {
        GPSLogConvertInterface gPSLogConvertInterface;
        if (Model.logFiles.size() != 0) {
            MultiLogConvert multiLogConvert = new MultiLogConvert();
            multiLogConvert.setLogFiles(Model.logFiles);
            gPSLogConvertInterface = multiLogConvert;
        } else {
            gPSLogConvertInterface = this.getInputConversionInstance();
        }
        int n2 = this.getHeightReference(n);
        int n3 = this.getHeightReference(gPSLogConvertInterface.getType());
        String string = "";
        int n4 = this.m.getIntOpt(84);
        gPSLogConvertInterface.setHeightConvertMode(n4);
        Controller.setHeightConversionMode(n4, gPSLogConvertInterface, n3, n2);
        gPSLogConvertInterface.setLoggerType(this.m.getIntOpt(23));
        if (Generic.isDebug()) {
            Generic.debug(string);
        }
        return gPSLogConvertInterface;
    }

    public final GPSLogConvertInterface getInputConversionInstance() {
        return GPSInputConversionFactory.getHandler().getInputConversionInstance(this.m.getPath(12), this.m.getIntOpt(23));
    }

    public final GPSFilter[] getLogFiltersToUse() {
        GPSFilter[] gPSFilterArray;
        String string = "";
        string = string + "From:" + CommonOut.getDateTimeStr(this.m.getFilterStartTime()) + "(" + this.m.getFilterStartTime() + ")\n";
        string = string + "To:" + CommonOut.getDateTimeStr(this.m.getFilterEndTime()) + "(" + this.m.getFilterEndTime() + ")\n";
        if (this.m.getBooleanOpt(39)) {
            gPSFilterArray = this.m.getLogFiltersAdv();
            string = string + "Advanced filter:\n";
        } else {
            string = string + "Standard filter:\n";
            gPSFilterArray = this.m.getLogFilters();
        }
        for (int i = 0; i < gPSFilterArray.length; ++i) {
            gPSFilterArray[i].setStartTime(this.m.getFilterStartTime());
            gPSFilterArray[i].setEndTime(this.m.getFilterEndTime());
        }
        string = string + gPSFilterArray[0].toString() + gPSFilterArray[1].toString();
        if (Generic.isDebug()) {
            Generic.debug(string);
        }
        return gPSFilterArray;
    }

    public final int doConvertLog(int n, GPSFileInterface gPSFileInterface, String string) {
        int n2 = 0;
        this.configureGpsFile(gPSFileInterface);
        if (n == 14) {
            gPSFileInterface.getParamObject().setBoolParam("trkcmt", false);
            gPSFileInterface.getParamObject().setBoolParam("waycmt", false);
            gPSFileInterface.setIncludeTrkName(false);
            gPSFileInterface.setOutputFields(GPSRecord.getLogFormatRecord(262173));
        } else if (n == 22) {
            gPSFileInterface.getParamObject().setBoolParam("trkcmt", false);
            gPSFileInterface.getParamObject().setBoolParam("waycmt", false);
            gPSFileInterface.setIncludeTrkName(false);
            gPSFileInterface.setOutputFields(GPSRecord.getLogFormatRecord(-1));
        }
        if (Generic.isDebug()) {
            Generic.debug("Converting with parameters:\n");
        }
        GPSLogConvertInterface gPSLogConvertInterface = this.getInputConversionInstance(n);
        if (gPSFileInterface != null) {
            if (this.filenameBuilder != null) {
                gPSFileInterface.setFilenameBuilder(this.filenameBuilder);
            }
            this.currentGPSLogConvert = gPSLogConvertInterface;
            if (Generic.isDebug()) {
                Generic.debug("");
            }
            gPSFileInterface.initialiseFile(this.m.getPath(-1), string, this.m.getIntOpt(73));
            this.m.logConversionStarted(n);
            try {
                this.lastError = gPSLogConvertInterface.toGPSFile(this.m.getPath(12), gPSFileInterface);
            }
            catch (Throwable throwable) {
                Generic.debug("During conversion", throwable);
            }
            this.currentGPSLogConvert = null;
            this.lastErrorInfo = gPSLogConvertInterface.getErrorInfo();
            n2 = this.lastError;
        }
        this.m.logConversionEnded(n);
        return n2;
    }

    public final void setDownloadMethod(int n) {
        this.m.setDownloadMethod(n);
    }

    public final void cancelGetLog() {
        this.gpsCmd(19);
    }

    public final void startDownload() {
        switch (this.m.getIntOpt(51)) {
            default: {
                this.startDefaultDownload();
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                this.startWPDownload();
            }
            case 4: 
        }
    }

    public final void startDefaultDownload() {
        this.isStartLogDownloadNeeded = false;
        if (!this.m.isAvailable(2) || !this.m.isAvailable(0)) {
            this.isStartLogDownloadNeeded = true;
            this.m.postEvent(39);
            return;
        }
        try {
            int n = this.m.logMemUsed() - 1;
            if (this.m.getDownloadMethod() == 2 || this.m.mtkModel().isInitialLogOverwrite()) {
                if (n < this.m.logMemSize()) {
                    n = this.m.logMemSize() - 1;
                }
            } else {
                n = this.m.logMemUsed() - 1;
            }
            this.mtkC().getLogInit(0, n, this.m.getChunkSize(), this.m.getPath(12), this.m.getDownloadMethod() == 1, this.m.getBooleanOpt(24));
        }
        catch (Exception exception) {
            Generic.debug("StartDefaultDownload", exception);
        }
    }

    public final void replyToOkToOverwrite(boolean bl) throws BT747Exception {
        this.mtkC().replyToOkToOverwrite(bl);
    }

    public final void stopErase() {
        this.getGpsC().stopErase();
    }

    public final void startWPDownload() {
        this.getGpsC().getLog(this.m.getPath(12));
    }

    public final void setLoggingActive(boolean bl) {
        if (bl) {
            this.gpsCmd(4);
        } else {
            this.gpsCmd(5);
        }
        this.getGpsC().reqLogOnOffStatus();
    }

    public final void setMtkDataNeeded(int n) {
        this.getGpsC().setDataNeeded(n);
    }

    public final void setLogOverwrite(boolean bl) {
        this.gpsCmd(15, new CmdParam(bl));
        this.setMtkDataNeeded(18);
    }

    public final void reqDeviceInfo() {
        this.getGpsC().reqDeviceInfo();
    }

    public final void setLogFormat(int n) {
        this.mtkC().setLogFormat(n);
        this.setMtkDataNeeded(3);
    }

    public final void eraseLog() {
        this.getGpsC().eraseLog();
    }

    public final void recoveryEraseLog() {
        this.mtkC().recoveryEraseLog();
    }

    public void connectGPS() {
        this.closeGPS();
        Generic.debug("Freeport is " + this.m.getStringOpt(18));
        if (this.m.getStringOpt(18).length() != 0) {
            this.openFreeTextPort(this.m.getStringOpt(18));
        } else {
            this.m.gpsRxTx().openPort();
            if (this.m.isConnected()) {
                this.performOperationsAfterGPSConnect();
            }
        }
    }

    public void closeGPS() {
        if (this.m.isConnected()) {
            this.m.gpsRxTx().closePort();
        }
        boolean bl = this.m.isConnected();
    }

    public final void setBluetooth() {
        this.closeGPS();
        this.m.gpsRxTx().setBluetoothAndOpen();
        this.performOperationsAfterGPSConnect();
    }

    public final void setPort(int n) {
        this.closeGPS();
        this.m.gpsRxTx().setPortAndOpen(n);
        this.performOperationsAfterGPSConnect();
    }

    public final void setBaudRate(int n) {
        this.m.gpsRxTx().setBaudRate(n);
    }

    public final void openFreeTextPort(String string) {
        this.closeGPS();
        this.m.gpsRxTx().setFreeTextPortAndOpen(string);
        this.performOperationsAfterGPSConnect();
    }

    public void performOperationsAfterGPSConnect() {
        if (this.m.isConnected()) {
            this.setMtkDataNeeded(6);
            this.getGpsC().reqStatus();
            this.setMtkDataNeeded(0);
            this.setMtkDataNeeded(3);
            this.setMtkDataNeeded(6);
            this.getGpsC().initConnection();
            this.setIntOpt(16, this.m.gpsRxTx().getPort());
            this.setIntOpt(17, this.m.gpsRxTx().getSpeed());
            this.setStringOpt(18, this.m.gpsRxTx().getFreeTextPort());
            this.m.postEvent(266);
        }
    }

    public final void setDebugConn(boolean bl) {
        this.m.gpsRxTx().setDebugConn(bl, this.m.getStringOpt(9));
    }

    public void saveSettings() {
    }

    public final void setDebug(boolean bl) {
        Generic.setDebugLevel(bl ? 1 : 0);
    }

    public final void setFlashUserOption(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.mtkC().setFlashUserOption(bl, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
        this.setMtkDataNeeded(26);
    }

    public final void setBTMacAddr(String string) {
        this.mtkC().setBtMacAddr(string);
        this.setMtkDataNeeded(25);
    }

    public final void setHoluxName(String string) {
        this.mtkC().cmd(11, new CmdParam(string));
        this.setMtkDataNeeded(10);
    }

    public final void setNMEAPeriods(int[] nArray) {
        this.mtkC().setNMEAPeriods(nArray);
        this.setMtkDataNeeded(23);
    }

    public final void setNMEADefaultPeriods() {
        this.mtkC().setNMEADefaultPeriods();
    }

    public final void setSBASTestEnabled(boolean bl) {
        this.gpsCmd(16, new CmdParam(bl));
        this.setMtkDataNeeded(19);
    }

    public final void setSBASEnabled(boolean bl) {
        this.gpsCmd(17, new CmdParam(bl));
        this.setMtkDataNeeded(20);
    }

    public final void setDGPSMode(int n) {
        this.mtkC().setDGPSMode(n);
        this.setMtkDataNeeded(24);
    }

    public final void logImmediate(int n) {
        this.mtkC().logImmediate(n);
    }

    public final void setFixInterval(int n) {
        if (n != 0) {
            this.gpsCmd(14, new CmdParam(n));
            this.setMtkDataNeeded(16);
        }
    }

    public final void setLogTimeInterval(int n) {
        this.gpsCmd(8, new CmdParam(n));
    }

    public final void setLogDistanceInterval(int n) {
        this.gpsCmd(9, new CmdParam(n));
    }

    public final void setLogSpeedInterval(int n) {
        this.gpsCmd(10, new CmdParam(n));
    }

    public final boolean isEnableStoreOK() {
        return this.m.mtkModel().isDataOK(991);
    }

    public final void setStats(boolean bl) {
        this.getGpsOldC().setStats(bl);
    }

    public final void setGpsDecode(boolean bl) {
        this.setBooleanOpt(41, bl);
        this.getGpsOldC().setGpsDecode(bl);
    }

    public final void setFilterEndTime(int n) {
        this.m.setFilterEndTime(n);
    }

    public final void setFilterStartTime(int n) {
        this.m.setFilterStartTime(n);
    }

    public final void storeSetting1() {
        this.setIntOpt(30, this.m.getLogTimeInterval());
        this.setIntOpt(32, this.m.getLogDistanceInterval());
        this.setIntOpt(31, this.m.getLogSpeedInterval());
        this.setIntOpt(37, this.m.getLogFormat());
        this.setIntOpt(33, this.m.getLogFixPeriod());
        this.setBooleanOpt(38, this.m.isSBASEnabled());
        this.setIntOpt(34, this.m.getDgpsMode());
        this.setBooleanOpt(35, this.m.isSBASTestEnabled());
        this.setBooleanOpt(36, this.m.isLogFullOverwrite());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 19; ++i) {
            stringBuffer.append(this.m.getNMEAPeriod(i));
        }
        this.setStringOpt(29, stringBuffer.toString());
    }

    public final void restoreSetting1() {
        this.setLogTimeInterval(this.m.getIntOpt(30));
        this.setLogDistanceInterval(this.m.getIntOpt(32));
        this.setLogSpeedInterval(this.m.getIntOpt(31));
        this.setLogFormat(this.m.getIntOpt(37));
        this.setFixInterval(this.m.getIntOpt(33));
        this.setSBASEnabled(this.m.getBooleanOpt(38));
        this.setSBASTestEnabled(this.m.getBooleanOpt(35));
        this.setDGPSMode(this.m.getIntOpt(34));
        this.setLogOverwrite(this.m.getBooleanOpt(36));
        String string = this.m.getStringOpt(29);
        int[] nArray = new int[19];
        for (int i = 0; i < 19; ++i) {
            nArray[i] = string.charAt(i) - 48;
        }
        this.setNMEAPeriods(nArray);
    }

    public final void reqSettingsForStorage() {
        this.setMtkDataNeeded(11);
        this.setMtkDataNeeded(12);
        this.setMtkDataNeeded(13);
        this.setMtkDataNeeded(3);
        this.setMtkDataNeeded(16);
        this.setMtkDataNeeded(20);
        this.setMtkDataNeeded(19);
        this.setMtkDataNeeded(24);
        this.setMtkDataNeeded(18);
        this.setMtkDataNeeded(23);
    }

    public final void setFilters() {
        for (int i = this.m.getLogFiltersAdv().length - 1; i >= 0; --i) {
            GPSFilterAdvanced gPSFilterAdvanced = this.m.getLogFiltersAdv()[i];
            gPSFilterAdvanced.setMinRecCount(this.m.getIntOpt(77));
            gPSFilterAdvanced.setMaxRecCount(this.m.getIntOpt(78));
            gPSFilterAdvanced.setMinSpeed(this.m.getFloatOpt(74));
            gPSFilterAdvanced.setMaxSpeed(this.m.getFloatOpt(75));
            gPSFilterAdvanced.setMinDist(this.m.getFloatOpt(79));
            gPSFilterAdvanced.setMaxDist(this.m.getFloatOpt(83));
            gPSFilterAdvanced.setMaxPDOP((int)(this.m.getFloatOpt(81) * 100.0f));
            gPSFilterAdvanced.setMaxHDOP((int)(this.m.getFloatOpt(82) * 100.0f));
            gPSFilterAdvanced.setMaxVDOP((int)(this.m.getFloatOpt(80) * 100.0f));
            gPSFilterAdvanced.setMinNSAT(this.m.getIntOpt(76));
        }
    }

    public final void setNMEAset(int n) {
        this.m.setNMEAset(n);
    }

    public final int getLastError() {
        return this.lastError;
    }

    public final String getLastErrorInfo() {
        return this.lastErrorInfo;
    }

    public void setBooleanOpt(int n, boolean bl) {
        this.m.setBooleanOpt(n, bl);
    }

    public void setIntOpt(int n, int n2) {
        this.m.setIntOpt(n, n2);
    }

    public void setFloatOpt(int n, float f) {
        this.m.setFloatOpt(n, f);
    }

    public void setStringOpt(int n, String string) {
        this.m.setStringOpt(n, string);
    }

    public boolean isLocationServingActive() {
        return this.registeredLocSender != null;
    }

    public void startGPSPositionServing() {
        if (this.registeredLocSender == null) {
            LocationSender locationSender = this.m.createAndConfigureLocationSender();
            this.getModel().addListener(locationSender);
            this.registeredLocSender = locationSender;
        }
    }

    public void stopGPSPositionServing() {
        if (this.registeredLocSender != null) {
            try {
                this.getModel().removeListener(this.registeredLocSender);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.registeredLocSender = null;
        }
    }
}

