/*
 * Decompiled with CFR 0.152.
 */
package bt747.waba_view;

import bt747.Txt;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.waba_view.AppController;
import waba.ui.Button;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.Label;
import waba.ui.MessageBox;

public final class GPSLogEasy
extends Container
implements ModelListener {
    private Button btSet5Hz;
    private Button btSet2Hz;
    private Button btStore;
    private Button btRestore;
    private Button btHotStart;
    private Button btWarmStart;
    private Button btColdStart;
    private Button btFullColdStart;
    private final Button[] chkRCR = new Button[16];
    private Button btForceErase;
    private Label lbLogUserTxt;
    private final Model m;
    private final AppController c;

    public GPSLogEasy(Model model, AppController appController) {
        this.m = model;
        this.c = appController;
    }

    protected final void onStart() {
        this.btSet5Hz = new Button(Txt.getString(59));
        this.add((Control)this.btSet5Hz, 110000, 190003);
        this.btSet2Hz = new Button(Txt.getString(60));
        this.add((Control)this.btSet2Hz, 130000, 180000);
        this.btStore = new Button(Txt.getString(158));
        this.add((Control)this.btStore, 110000, 190003);
        this.btRestore = new Button(Txt.getString(159));
        this.add((Control)this.btRestore, 130000, 180000);
        this.enableStore();
        this.btHotStart = new Button(Txt.getString(61));
        this.add((Control)this.btHotStart, 110000, 190010);
        this.btWarmStart = new Button(Txt.getString(62));
        this.add((Control)this.btWarmStart, 120000, 180000);
        this.btColdStart = new Button(Txt.getString(63));
        this.add((Control)this.btColdStart, 130000, 180000);
        this.btFullColdStart = new Button(Txt.getString(64));
        this.add((Control)this.btFullColdStart, 110000, 190002);
        this.btForceErase = new Button(Txt.getString(65));
        this.add((Control)this.btForceErase, 130000, 180000);
        this.lbLogUserTxt = new Label(Txt.getString(66));
        this.add((Control)this.lbLogUserTxt, 110000, 190002);
        int n = 110000;
        int n2 = 180000;
        Label label = null;
        for (int i = 0; i < 16; ++i) {
            this.chkRCR[i] = new Button(Txt.getRcrString(i));
            if (i == 0) {
                n = 110000;
            } else if (i % 4 == 0) {
                n = this.getClientRect().width * (i / 4) / 4 + 8;
            }
            if (i % 4 == 0) {
                label = this.lbLogUserTxt;
                n2 = 190006;
            } else {
                n2 = 189999;
            }
            this.add((Control)this.chkRCR[i], n, n2, (Control)label);
            label = this.chkRCR[i];
            this.chkRCR[i].setEnabled(true);
        }
    }

    private void enableStore() {
        this.btStore.setEnabled(this.c.isEnableStoreOK());
        this.btRestore.setEnabled(this.m.isStoredSetting1());
    }

    public final void onEvent(Event event) {
        super.onEvent(event);
        switch (event.type) {
            case 300: {
                event.consumed = true;
                if (event.target == this) {
                    this.c.reqSettingsForStorage();
                    break;
                }
                if (event.target == this.btSet2Hz) {
                    this.c.setFixInterval(500);
                    break;
                }
                if (event.target == this.btSet5Hz) {
                    this.c.setLogTimeInterval(2);
                    this.c.setFixInterval(200);
                    break;
                }
                if (event.target == this.btStore) {
                    this.c.storeSetting1();
                    break;
                }
                if (event.target == this.btRestore) {
                    this.c.restoreSetting1();
                    break;
                }
                if (event.target == this.btHotStart) {
                    this.c.gpsCmd(0);
                    break;
                }
                if (event.target == this.btColdStart) {
                    this.c.gpsCmd(2);
                    break;
                }
                if (event.target == this.btWarmStart) {
                    this.c.gpsCmd(1);
                    break;
                }
                if (event.target == this.btFullColdStart) {
                    String[] stringArray = new String[]{Txt.getString(22), Txt.getString(23)};
                    MessageBox messageBox = new MessageBox(Txt.getString(20), Txt.getString(67), stringArray);
                    messageBox.popupBlockingModal();
                    if (messageBox.getPressedButtonIndex() != 0) break;
                    this.c.gpsCmd(3);
                    break;
                }
                if (event.target == this.btForceErase) {
                    this.c.recoveryErase();
                    break;
                }
                for (int i = 0; i < 16; ++i) {
                    if (event.target != this.chkRCR[i]) continue;
                    this.c.logImmediate(1 << i);
                }
                event.consumed = false;
                break;
            }
        }
    }

    public final void modelEvent(ModelEvent modelEvent) {
        switch (modelEvent.getType()) {
            case 2: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                this.enableStore();
            }
        }
    }
}

