/*
 * Decompiled with CFR 0.152.
 */
package bt747.waba_view;

import bt747.Txt;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.sys.JavaLibBridge;
import bt747.waba_view.AppController;
import bt747.waba_view.ui.FileSelect;
import net.sf.bt747.waba.system.WabaFile;
import waba.sys.Convert;
import waba.sys.Settings;
import waba.ui.Button;
import waba.ui.ComboBox;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.Edit;
import waba.ui.Event;
import waba.ui.Label;
import waba.util.Vector;

public final class GPSLogFile
extends Container
implements ModelListener {
    private final Model m;
    private final AppController c;
    private Edit edBaseDirName;
    private Button btSelectBaseDirName;
    private Edit edLogFileName;
    private Button btSelectLogFileName;
    private Edit edReportBaseName;
    private Edit edChunkSize;
    private Edit edTimeout;
    private ComboBox cbVolumes;
    private ComboBox cblogReqAhead;
    private static final String[] C_LOG_REQ_AHEAD = new String[]{"0", "1", "2", "3", "4", "5"};
    private Button btChangeSettings;
    private Button btDefaultSettings;
    private boolean setting = false;

    public GPSLogFile(AppController appController, Model model) {
        this.c = appController;
        this.m = model;
    }

    protected final void onStart() {
        Label label = new Label(Txt.getString(68));
        this.add((Control)label, 110000, 190000);
        this.btSelectBaseDirName = new Button("+");
        this.add((Control)this.btSelectBaseDirName, 130000, 180000);
        this.edBaseDirName = new Edit("");
        this.add((Control)this.edBaseDirName);
        this.edBaseDirName.setRect(190000, 180000, 160000 - this.btSelectBaseDirName.getSize().width(), 100000, (Control)label);
        label = new Label(Txt.getString(69));
        this.add((Control)label, 110000, 190000);
        this.btSelectLogFileName = new Button("+");
        this.add((Control)this.btSelectLogFileName, 130000, 180000);
        this.edLogFileName = new Edit("");
        this.add((Control)this.edLogFileName);
        this.edLogFileName.setRect(190000, 180000, 160000 - this.btSelectLogFileName.getSize().width(), 100000, (Control)label);
        this.add((Control)new Label(Txt.getString(70)), 110000, 190000);
        this.edReportBaseName = new Edit("");
        this.add((Control)this.edReportBaseName, 190000, 180000);
        this.add((Control)new Label(Txt.getString(71)), 110000, 190000);
        this.edChunkSize = new Edit("");
        this.add((Control)this.edChunkSize, 190000, 180000);
        this.edChunkSize.setValidChars("0123456789");
        this.add((Control)new Label(Txt.getString(72)), 110000, 190000);
        this.cblogReqAhead = new ComboBox((Object[])C_LOG_REQ_AHEAD);
        this.add((Control)this.cblogReqAhead, 190000, 180000);
        int n = this.m.getIntOpt(48);
        if (n > this.cblogReqAhead.size() - 1) {
            n = this.cblogReqAhead.size() - 1;
        }
        this.cblogReqAhead.select(n);
        this.add((Control)new Label(Txt.getString(73)), 110000, 190000);
        this.edTimeout = new Edit("");
        this.add((Control)this.edTimeout, 190000, 180000);
        this.edTimeout.setValidChars("0123456789");
        if (Settings.platform.startsWith("Palm")) {
            Vector vector = new Vector(50);
            int n2 = this.m.getIntOpt(72);
            for (int i = 0; i < 255; ++i) {
                if (!WabaFile.isCardInserted((int)i)) continue;
                vector.addElement((Object)("" + i));
                if (n2 != i) continue;
                n = vector.size() - 1;
            }
            vector.addElement((Object)"-1");
            if (n2 == -1) {
                n = vector.size() - 1;
            }
            this.add((Control)new Label(Txt.getString(74)), 110000, 190000);
            this.cbVolumes = new ComboBox((Object[])((String[])vector.toObjectArray()));
            this.add((Control)this.cbVolumes, 190000, 180000);
            this.cbVolumes.select(n);
        }
        this.btChangeSettings = new Button(Txt.getString(75));
        this.add((Control)this.btChangeSettings, 120000, 190005);
        this.btDefaultSettings = new Button(Txt.getString(76));
        this.add((Control)this.btDefaultSettings, 120000, 190005);
        this.updateValues();
    }

    private final void updateValues() {
        if (!this.setting) {
            this.edBaseDirName.setText(this.m.getStringOpt(9));
            this.edReportBaseName.setText(this.m.getStringOpt(10));
            this.edLogFileName.setText(this.m.getStringOpt(11));
            this.edChunkSize.setText("" + this.m.getChunkSize());
            this.edTimeout.setText("" + this.m.getDownloadTimeOut());
        }
    }

    private final void updateFullPath() {
        this.c.setStringOpt(12, this.m.getStringOpt(9) + "/" + this.m.getStringOpt(11));
    }

    public final void onEvent(Event event) {
        switch (event.type) {
            case 300: {
                if (event.target == this.btChangeSettings) {
                    this.setting = true;
                    this.c.setStringOpt(9, this.edBaseDirName.getText());
                    this.c.setStringOpt(11, this.edLogFileName.getText());
                    this.c.setOutputFileRelPath(this.edReportBaseName.getText());
                    this.updateFullPath();
                    this.c.setChunkSize(JavaLibBridge.toInt(this.edChunkSize.getText()));
                    this.c.setDownloadTimeOut(JavaLibBridge.toInt(this.edTimeout.getText()));
                    if (Settings.platform.startsWith("Palm")) {
                        this.c.setIntOpt(72, JavaLibBridge.toInt((String)this.cbVolumes.getSelectedItem()));
                    }
                    this.c.setLogRequestAhead(JavaLibBridge.toInt((String)this.cblogReqAhead.getSelectedItem()));
                    this.setting = false;
                    this.updateValues();
                    this.c.saveSettings();
                    break;
                }
                if (event.target == this.btSelectBaseDirName) {
                    FileSelect fileSelect = new FileSelect();
                    fileSelect.setDirOnly(true);
                    fileSelect.setPath(this.edBaseDirName.getText());
                    if (Settings.platform.startsWith("Palm")) {
                        fileSelect.setCardSlot(JavaLibBridge.toInt((String)this.cbVolumes.getSelectedItem()));
                    }
                    fileSelect.popupBlockingModal();
                    this.c.setStringOpt(9, fileSelect.getPath());
                    this.updateFullPath();
                    break;
                }
                if (event.target == this.btSelectLogFileName) {
                    FileSelect fileSelect = new FileSelect();
                    fileSelect.setRoot(this.edBaseDirName.getText());
                    fileSelect.setPath(this.edLogFileName.getText());
                    if (Settings.platform.startsWith("Palm")) {
                        fileSelect.setCardSlot(JavaLibBridge.toInt((String)this.cbVolumes.getSelectedItem()));
                    }
                    fileSelect.popupBlockingModal();
                    this.c.setStringOpt(11, fileSelect.getRelPath());
                    this.updateFullPath();
                    break;
                }
                if (event.target != this.btDefaultSettings) break;
                this.m.defaultSettings();
                this.updateValues();
                break;
            }
            case 302: {
                if (event.target == this.edLogFileName) {
                    this.c.setStringOpt(11, this.edLogFileName.getText());
                    this.updateFullPath();
                    break;
                }
                if (event.target == this.edBaseDirName) {
                    this.c.setStringOpt(9, this.edBaseDirName.getText());
                    this.updateFullPath();
                    break;
                }
                if (event.target != this.edReportBaseName) break;
                this.c.setOutputFileRelPath(this.edReportBaseName.getText());
                break;
            }
        }
    }

    public final void modelEvent(ModelEvent modelEvent) {
        switch (modelEvent.getType()) {
            case 269: {
                int n = Convert.toInt((String)((String)modelEvent.getArg()));
                switch (n) {
                    case 9: 
                    case 10: 
                    case 11: {
                        this.updateValues();
                    }
                }
            }
        }
    }
}

