/*
 * Decompiled with CFR 0.152.
 */
package bt747.waba_view;

import bt747.Txt;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.waba_view.AppController;
import bt747.waba_view.MyCheck;
import waba.ui.Button;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.Label;

public final class GPSLogFormat
extends Container
implements ModelListener {
    private final Model m;
    private final AppController c;
    private final MyCheck[] chkLogFmtItems = new MyCheck[21];
    private Button btChangeFormatErase;
    private Button btChangeFormat;
    private Button btErase;
    private Label lbEstNbrRecords;

    public GPSLogFormat(Model model, AppController appController) {
        this.m = model;
        this.c = appController;
    }

    public final void onStart() {
        for (int i = 0; i < 21; ++i) {
            this.chkLogFmtItems[i] = new MyCheck(Txt.getLogFmtItem(i));
            this.add((Control)this.chkLogFmtItems[i], i == 0 ? 110000 : (i == 10 ? this.getClientRect().width / 2 : 180000), i == 0 || i == 10 ? 140000 : 189999);
            this.chkLogFmtItems[i].setEnabled(true);
        }
        this.lbEstNbrRecords = new Label("0000000" + Txt.getString(89));
        this.add((Control)this.lbEstNbrRecords, 110000, 190000);
        this.lbEstNbrRecords.setText("");
        this.btChangeFormatErase = new Button(Txt.getString(90));
        this.add((Control)this.btChangeFormatErase, 110000, 190005);
        this.btChangeFormat = new Button(Txt.getString(91));
        this.add((Control)this.btChangeFormat, 190010, 180000);
        this.btErase = new Button(Txt.getString(92));
        this.add((Control)this.btErase, 130000, 180000);
        this.setLogFormatControls();
    }

    private int getSelectedLogFormat() {
        int n = 1;
        int n2 = 0;
        for (int i = 0; i < 20; ++i) {
            if (this.chkLogFmtItems[i].getChecked()) {
                n2 |= n;
            }
            n <<= 1;
        }
        if (this.chkLogFmtItems[20].getChecked()) {
            n2 |= Integer.MIN_VALUE;
        }
        return n2;
    }

    private void updateLogFormat(int n) {
        int n2 = 1;
        for (int i = 0; i < 20; ++i) {
            this.chkLogFmtItems[i].setChecked((n & n2) != 0);
            n2 <<= 1;
        }
        this.chkLogFmtItems[20].setChecked((n & Integer.MIN_VALUE) != 0);
        this.setLogFormatControls();
    }

    private void setLogFormatControls() {
        boolean bl = this.chkLogFmtItems[13].getChecked();
        this.chkLogFmtItems[14].setEnabled(bl);
        this.chkLogFmtItems[15].setEnabled(bl);
        this.chkLogFmtItems[16].setEnabled(bl);
        this.lbEstNbrRecords.setText(this.m.getEstimatedNbrRecords(this.getSelectedLogFormat()) + Txt.getString(89));
    }

    public final void onEvent(Event event) {
        switch (event.type) {
            case 300: {
                if (event.target == this.btChangeFormatErase) {
                    this.c.changeLogFormatAndErase(this.getSelectedLogFormat());
                    break;
                }
                if (event.target == this.btChangeFormat) {
                    this.c.changeLogFormat(this.getSelectedLogFormat());
                    break;
                }
                if (event.target == this.btErase) {
                    this.c.eraseLogWithDialogs();
                    break;
                }
                if (event.target == this) {
                    this.c.setMtkDataNeeded(3);
                    this.updateLogFormat(this.m.getLogFormat());
                    event.consumed = true;
                    break;
                }
                boolean bl = false;
                for (int i = 0; i < 21; ++i) {
                    if (event.target != this.chkLogFmtItems[i]) continue;
                    bl = true;
                }
                if (!bl) break;
                this.setLogFormatControls();
                break;
            }
        }
    }

    public final void modelEvent(ModelEvent modelEvent) {
        switch (modelEvent.getType()) {
            case 23: {
                this.setLogFormatControls();
                break;
            }
            case 2: {
                this.updateLogFormat(this.m.getLogFormat());
            }
        }
    }
}

