/*
 * Decompiled with CFR 0.152.
 */
package gps;

import bt747.sys.Generic;
import gps.Txt;

public final class BT747Constants {
    public static String[] logFmtItems = Txt.logFmtItems;
    public static final byte[] logFmtByteSizes = new byte[]{4, 2, 8, 8, 4, 4, 4, 2, 4, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 8, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] logFmtByteSizesHolux = new byte[]{4, 2, 4, 4, 3, 4, 4, 2, 4, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final String[] C_STR_RCR = Txt.C_STR_RCR;
    private static final String[] NMEA_STRINGS = new String[]{"GLL", "RMC", "VTG", "GGA", "GSA", "GSV", "GRS", "GST", "?8", "?9", "?10", "?11", "?12", "MALM", "MEPH", "MDGP", "MDBG", "ZDA", "MCHN"};
    private static FlashInfo lastFlashInfo = null;
    private static final int[][] INIT_REFERENCE_LIST = new int[][]{{1, 1}, {7, 0}, {4, 0}, {6, 0}, {3, 0}, {14, 0}, {5, 1}, {2, 0}, {9, 1}, {8, 1}, {10, 0}, {11, 0}, {12, 0}, {13, 1}, {19, 0}, {18, 0}, {20, 0}, {21, 1}, {22, 1}};
    private static final int[] heightReferenceList = new int[22];
    public static final int[] timeZones;

    public static final int logRecordMinSize(int n, int n2) {
        int n3 = 0;
        try {
            int n4 = n;
            int n5 = 0;
            byte[] byArray = BT747Constants.getByteSizes(n2);
            do {
                if ((n4 & 1) != 0) {
                    switch (n5) {
                        case 14: 
                        case 15: 
                        case 16: {
                            break;
                        }
                        default: {
                            n3 += byArray[n5];
                        }
                    }
                }
                ++n5;
            } while ((n4 >>>= 1) != 0);
        }
        catch (Exception exception) {
            Generic.debug("Bad log format", exception);
        }
        return n3;
    }

    public static final int logRecordAndChecksumSize(int n, int n2, int n3) {
        int n4;
        switch (n2) {
            default: {
                n4 = 2;
                break;
            }
            case 4: 
            case 5: {
                n4 = 1;
            }
        }
        return n4 + BT747Constants.logRecordSize(n, n2, n3);
    }

    public static final int logRecordSize(int n, int n2, int n3) {
        int n4 = 0;
        byte[] byArray = BT747Constants.getByteSizes(n2);
        if ((n & 0x2000) != 0) {
            n4 += byArray[13];
            n4 += (n & 0x4000) != 0 ? byArray[14] : 0;
            n4 += (n & 0x8000) != 0 ? byArray[15] : 0;
            n4 += (n & 0x10000) != 0 ? byArray[16] : 0;
            n4 *= n3 - 1;
        }
        return n4 + BT747Constants.logRecordMinSize(n, n2);
    }

    public static final int logRecordMaxSize(int n, int n2) {
        return BT747Constants.logRecordSize(n, n2, 32);
    }

    private static final byte[] getByteSizes(int n) {
        switch (n) {
            default: {
                return logFmtByteSizes;
            }
            case 4: 
            case 5: 
        }
        return logFmtByteSizesHolux;
    }

    public static final int[] logRecordSatOffsetAndSize(int n, int n2) {
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray = BT747Constants.getByteSizes(n2);
        do {
            if ((n3 & 1) != 0) {
                switch (n4) {
                    case 2: 
                    case 3: {
                        n5 += byArray[n4];
                        break;
                    }
                    case 4: {
                        n5 += byArray[n4];
                        break;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        n6 += byArray[n4];
                        break;
                    }
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        break;
                    }
                    default: {
                        n5 += byArray[n4];
                    }
                }
            }
            ++n4;
        } while ((n3 >>>= 1) != 0);
        int[] nArray = new int[]{n5, n6};
        return nArray;
    }

    public static final String modelName(int n, String string) {
        String string2;
        switch (n) {
            case 0: 
            case 1: 
            case 19: 
            case 81: {
                string2 = "iBlue 737/Qstarz 810";
                break;
            }
            case 2: {
                string2 = "Qstarz 815/iBlue 747";
                break;
            }
            case 5: {
                string2 = "Holux M-241/QT-1000P";
                break;
            }
            case 7: {
                string2 = "Just Mobile(r) Bluecard";
                break;
            }
            case 17: 
            case 27: {
                string2 = "iBlue 747";
                break;
            }
            case 29: {
                string2 = "747/Q1000/BGL-32";
                break;
            }
            case 35: 
            case 51: {
                string2 = "Holux M-241";
                break;
            }
            case 53: 
            case 80: {
                string2 = "Holux M1000C";
                break;
            }
            case 305: {
                string2 = "EB-85A";
                break;
            }
            case 5000: {
                string2 = "757/ZI v1";
                break;
            }
            case 8987: {
                string2 = "ML7";
                break;
            }
            case 20994: {
                string2 = "757/ZI v2";
                break;
            }
            case 33536: {
                string2 = "Qstarz BT-1200";
                break;
            }
            default: {
                string2 = "?";
            }
        }
        if (string.length() != 0) {
            if (string.startsWith("TSI_747A+")) {
                string2 = "iBlue 747 A+";
            } else if (string.startsWith("MBT-1100")) {
                string2 = "Royaltek MBT-1100";
            } else if (string.startsWith("TSI747")) {
                string2 = "iBlue 747";
            } else if (string.startsWith("TSI757")) {
                string2 = "iBlue 757";
            } else if (string.startsWith("TSI_821")) {
                string2 = "iBlue 821";
            } else if (string.startsWith("TSI_887")) {
                string2 = "photoMate887";
            } else if (string.equals("QST1000P")) {
                string2 = "Qstarz BT-1000P";
            } else if (string.equals("QST1000")) {
                string2 = "Qstarz BT-1000X";
            } else if (string.equals("QST1300")) {
                string2 = "Qstarz BT-1300";
            } else if (string.equals("GR-245")) {
                string2 = "Holux GPSport 245";
            } else if (string.equals("R150+")) {
                string2 = "NCS-NAVI 150+";
            }
        }
        return string2;
    }

    public static final String getNmeaDescription(int n) {
        return NMEA_STRINGS[n];
    }

    public static final int getFlashSize(int n) {
        FlashInfo flashInfo = BT747Constants.getFlashinfo(n);
        return flashInfo.memSize;
    }

    public static final String getFlashDesc(int n) {
        FlashInfo flashInfo = BT747Constants.getFlashinfo(n);
        return flashInfo.flashDescription;
    }

    private static final FlashInfo getFlashinfo(int n) {
        if (lastFlashInfo != null && BT747Constants.lastFlashInfo.flashID == n) {
            return lastFlashInfo;
        }
        FlashInfo flashInfo = new FlashInfo(n);
        int n2 = 0x200000;
        String string = "(??)";
        int n3 = n >> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        switch (n3) {
            case 194: {
                if (n4 != 32 && n4 != 36) break;
                n2 = 1 << (n >> 8 & 0xFF);
                string = "(MX," + n2 / 0x100000 + "MB)";
                break;
            }
            case 28: {
                if (n4 != 32 && n4 != 49 && n4 != 48) break;
                n2 = 1 << (n >> 8 & 0xFF);
                string = "(EON," + n2 / 0x100000 + "MB)";
                break;
            }
            case 32: {
                if (n4 != 32) break;
                n2 = 1 << (n >> 8 & 0xFF);
                string = "(STM," + n2 / 0x100000 + "MB)";
                break;
            }
        }
        flashInfo.memSize = n2;
        flashInfo.flashDescription = string;
        return flashInfo;
    }

    public static final int getHeightReference(int n) {
        if (n >= 0 && n < heightReferenceList.length) {
            return heightReferenceList[n];
        }
        return 1;
    }

    private static final void initValues() {
        for (int i = 0; i < INIT_REFERENCE_LIST.length; ++i) {
            if (INIT_REFERENCE_LIST[i][0] >= heightReferenceList.length) continue;
            BT747Constants.heightReferenceList[BT747Constants.INIT_REFERENCE_LIST[i][0]] = INIT_REFERENCE_LIST[i][1];
        }
    }

    public static final String[] getUtcStrings(String string) {
        String[] stringArray = new String[timeZones.length];
        for (int i = 0; i < timeZones.length; ++i) {
            int n = timeZones[i] - 48;
            int n2 = n / 4;
            int n3 = n % 4 * 15;
            if (n3 < 0) {
                n3 = -n3;
            }
            String string2 = string;
            if (n2 >= 0) {
                string2 = string2 + "+";
            }
            string2 = string2 + n2;
            if (n3 != 0) {
                string2 = string2 + ":" + n3;
            }
            stringArray[i] = string2;
        }
        return stringArray;
    }

    public static final int getUtcIdx(int n) {
        for (int i = 0; i < timeZones.length; ++i) {
            if (timeZones[i] < n) continue;
            return i;
        }
        return 0;
    }

    static {
        BT747Constants.initValues();
        timeZones = new int[]{0, 4, 8, 10, 12, 16, 20, 24, 28, 30, 32, 34, 36, 40, 44, 48, 52, 56, 60, 62, 64, 66, 68, 70, 71, 72, 74, 76, 80, 83, 84, 86, 88, 90, 92, 94, 96, 99, 100, 104};
    }

    private static class FlashInfo {
        int flashID;
        int memSize;
        String flashDescription;

        public FlashInfo(int n) {
            this.flashID = n;
        }
    }
}

